/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.util;

import com.mybatisflex.core.audit.AuditMessage;
import com.mybatisflex.core.mybatis.TypeHandlerObject;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.DateUtil;
import com.mybatisflex.core.util.EnumWrapper;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.StringJoiner;
import java.util.regex.Matcher;

public class SqlUtil {
    private static final String SQL_ORDER_BY_PATTERN = "[a-zA-Z0-9_\\ \\,\\.]+";
    private static final char[] UN_SAFE_CHARS = "'`\"<>&+=#-;".toCharArray();

    private SqlUtil() {
    }

    public static void keepColumnSafely(String column) {
        if (StringUtil.isBlank(column)) {
            throw new IllegalArgumentException("Column must not be empty");
        }
        column = column.trim();
        int strLen = column.length();
        for (int i = 0; i < strLen; ++i) {
            char ch = column.charAt(i);
            if (Character.isWhitespace(ch)) {
                throw new IllegalArgumentException("Column must not has space char.");
            }
            if (!SqlUtil.isUnSafeChar(ch)) continue;
            throw new IllegalArgumentException("Column has unsafe char: [" + ch + "].");
        }
    }

    public static void keepOrderBySqlSafely(String value) {
        if (!value.matches(SQL_ORDER_BY_PATTERN)) {
            throw new IllegalArgumentException("Order By sql not safe, order by string: " + value);
        }
    }

    private static boolean isUnSafeChar(char ch) {
        for (char c : UN_SAFE_CHARS) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    public static boolean toBool(int result) {
        return result > 0 || result == -2;
    }

    public static boolean toBool(long result) {
        return result > 0L;
    }

    public static boolean toBool(int[] results) {
        for (int result : results) {
            if (!SqlUtil.toBool(result)) continue;
            return true;
        }
        return false;
    }

    public static String replaceSqlParams(String sql, Object[] params) {
        if (params == null || params.length == 0) {
            return sql;
        }
        StringBuilder sqlBuilder = new StringBuilder();
        char quote = '\u0000';
        int index = 0;
        for (int i = 0; i < sql.length(); ++i) {
            char ch = sql.charAt(i);
            if (ch == '\'') {
                if (quote == '\u0000') {
                    quote = ch;
                } else if (quote == '\'') {
                    quote = '\u0000';
                }
            } else if (ch == '\"') {
                if (quote == '\u0000') {
                    quote = ch;
                } else if (quote == '\"') {
                    quote = '\u0000';
                }
            }
            if (quote == '\u0000' && ch == '?' && index < params.length) {
                sqlBuilder.append(SqlUtil.getParamString(params, index++));
                continue;
            }
            sqlBuilder.append(ch);
        }
        return sqlBuilder.toString();
    }

    private static String getParamString(Object[] params, int index) {
        Object value = params[index];
        if (value == null) {
            return "null";
        }
        if (value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        if (ClassUtil.isArray(value.getClass())) {
            StringJoiner joiner = new StringJoiner(",", "[", "]");
            for (int i = 0; i < Array.getLength(value); ++i) {
                joiner.add(String.valueOf(Array.get(value, i)));
            }
            return joiner.toString();
        }
        if (value instanceof TypeHandlerObject) {
            TypeHandlerObject handlerObject = (TypeHandlerObject)value;
            String[] paramArray = new String[1];
            PreparedStatement preparedStatement = SqlUtil.createPreparedStatement(paramArray);
            try {
                handlerObject.setParameter(preparedStatement, 0);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            return paramArray[0];
        }
        if (value.getClass().isEnum()) {
            EnumWrapper ew = EnumWrapper.of(value.getClass());
            Object enumValue = ew.getEnumValue(value);
            return enumValue.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("'");
        if (value instanceof Date) {
            sb.append(DateUtil.toDateTimeString((Date)value));
        } else if (value instanceof LocalDateTime) {
            sb.append(((LocalDateTime)value).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        } else {
            sb.append(value);
        }
        sb.append("'");
        return Matcher.quoteReplacement(sb.toString());
    }

    public static String buildSqlParamPlaceholder(int count) {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < count; ++i) {
            sb.append("?");
            if (i == count - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    private static PreparedStatement createPreparedStatement(String[] params) {
        return (PreparedStatement)Proxy.newProxyInstance(AuditMessage.class.getClassLoader(), new Class[]{PreparedStatement.class}, (proxy, method, args) -> {
            if (args != null && (args.length == 2 || args.length == 3)) {
                params[0] = args[1].toString();
            }
            return null;
        });
    }
}

