/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.util;

import java.util.Arrays;
import java.util.Objects;

public class ArrayUtil {
    private ArrayUtil() {
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !ArrayUtil.isEmpty(array);
    }

    public static <T> T[] concat(T[] first, T[] second) {
        if (first == null && second == null) {
            throw new IllegalArgumentException("not allow first and second are null.");
        }
        if (ArrayUtil.isEmpty(first) && second != null) {
            return second;
        }
        if (ArrayUtil.isEmpty(second)) {
            return first;
        }
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static <T> T[] concat(T[] first, T[] second, T[] third, T[] ... others) {
        T[] results = ArrayUtil.concat(first, second);
        results = ArrayUtil.concat(results, third);
        if (others != null && others.length > 0) {
            for (T[] other : others) {
                results = ArrayUtil.concat(results, other);
            }
        }
        return results;
    }

    @SafeVarargs
    public static <T> T[] append(T[] first, T ... second) {
        if (first == null && second == null) {
            throw new IllegalArgumentException("not allow first and second are null.");
        }
        if (ArrayUtil.isEmpty(first) && second != null) {
            return second;
        }
        if (ArrayUtil.isEmpty(second)) {
            return first;
        }
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static <T> boolean contains(T[] arrays, T object) {
        if (ArrayUtil.isEmpty(arrays)) {
            return false;
        }
        for (T array : arrays) {
            if (!Objects.equals(array, object)) continue;
            return true;
        }
        return false;
    }
}

