/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.table;

import com.mybatisflex.annotation.Column;
import com.mybatisflex.annotation.InsertListener;
import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.annotation.SetListener;
import com.mybatisflex.annotation.UpdateListener;
import com.mybatisflex.core.FlexConsts;
import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.constant.SqlOperator;
import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.dialect.OperateType;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.exception.locale.LocalizedFormats;
import com.mybatisflex.core.logicdelete.LogicDeleteManager;
import com.mybatisflex.core.mybatis.TypeHandlerObject;
import com.mybatisflex.core.optimisticlock.OptimisticLockManager;
import com.mybatisflex.core.query.Brackets;
import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.Join;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryMethods;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.SelectQueryColumn;
import com.mybatisflex.core.query.SelectQueryTable;
import com.mybatisflex.core.query.SqlOperators;
import com.mybatisflex.core.query.UnionWrapper;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.table.BaseReflectorFactory;
import com.mybatisflex.core.table.ColumnInfo;
import com.mybatisflex.core.table.EntityMetaObject;
import com.mybatisflex.core.table.IdInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.tenant.TenantManager;
import com.mybatisflex.core.update.RawValue;
import com.mybatisflex.core.update.UpdateWrapper;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.ConvertUtil;
import com.mybatisflex.core.util.EnumWrapper;
import com.mybatisflex.core.util.FieldWrapper;
import com.mybatisflex.core.util.MapUtil;
import com.mybatisflex.core.util.ObjectUtil;
import com.mybatisflex.core.util.SqlUtil;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.Reflector;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandler;

public class TableInfo {
    private final Map<String, ColumnInfo> columnInfoMapping = new HashMap<String, ColumnInfo>();
    private final Map<String, String> propertyColumnMapping = new LinkedHashMap<String, String>();
    private String schema;
    private boolean camelToUnderline = true;
    private String dataSource;
    private String comment;
    private String tableName;
    private Class<?> entityClass;
    private String logicDeleteColumn;
    private String versionColumn;
    private String tenantIdColumn;
    private Map<String, String> onInsertColumns;
    private String[] allColumns = new String[0];
    private Map<String, String> onUpdateColumns;
    private String[] largeColumns = new String[0];
    private String[] defaultQueryColumns = new String[0];
    private String[] columns = new String[0];
    private List<ColumnInfo> columnInfoList;
    private List<IdInfo> primaryKeyList;
    private String[] primaryColumns = new String[0];
    private final Map<String, QueryColumn> columnQueryMapping = new HashMap<String, QueryColumn>();
    private String[] insertPrimaryKeys;
    private List<InsertListener> onInsertListeners;
    private List<UpdateListener> onUpdateListeners;
    private List<SetListener> onSetListeners;
    private Map<String, Class<?>> associationType;
    private Map<Field, Class<?>> collectionType;
    private final ReflectorFactory reflectorFactory = new BaseReflectorFactory(){

        public Reflector findForClass(Class<?> type) {
            return TableInfo.this.getReflector();
        }
    };
    private Reflector reflector;
    private static final String APPEND_CONDITIONS_FLAG = "appendConditions";
    private static final Map<Class<?>, List<InsertListener>> insertListenerCache = new ConcurrentHashMap();
    private static final Map<Class<?>, List<UpdateListener>> updateListenerCache = new ConcurrentHashMap();
    private static final Map<Class<?>, List<SetListener>> setListenerCache = new ConcurrentHashMap();

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public Map<String, String> getPropertyColumnMapping() {
        return this.propertyColumnMapping;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableNameWithSchema() {
        return StringUtil.buildSchemaWithTable(this.schema, this.tableName);
    }

    public String getWrapSchemaAndTableName(IDialect dialect, OperateType operateType) {
        if (StringUtil.isNotBlank(this.schema)) {
            String table = dialect.getRealTable(this.tableName, operateType);
            return dialect.wrap(dialect.getRealSchema(this.schema, table, operateType)) + "." + dialect.wrap(table);
        }
        return dialect.wrap(dialect.getRealTable(this.tableName, operateType));
    }

    public void setTableName(String tableName) {
        int indexOf = tableName.indexOf(".");
        if (indexOf > 0) {
            if (StringUtil.isBlank(this.schema)) {
                this.schema = tableName.substring(0, indexOf);
                this.tableName = tableName.substring(indexOf + 1);
            } else {
                this.tableName = tableName;
            }
        } else {
            this.tableName = tableName;
        }
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public boolean isCamelToUnderline() {
        return this.camelToUnderline;
    }

    public void setCamelToUnderline(boolean camelToUnderline) {
        this.camelToUnderline = camelToUnderline;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getLogicDeleteColumnOrSkip() {
        return LogicDeleteManager.getLogicDeleteColumn(this.logicDeleteColumn);
    }

    public String getLogicDeleteColumn() {
        return this.logicDeleteColumn;
    }

    public void setLogicDeleteColumn(String logicDeleteColumn) {
        this.logicDeleteColumn = logicDeleteColumn;
    }

    public String getOptimisticLockColumnOrSkip() {
        return OptimisticLockManager.getOptimisticLockColumn(this.versionColumn);
    }

    public String getVersionColumn() {
        return this.versionColumn;
    }

    public void setVersionColumn(String versionColumn) {
        this.versionColumn = versionColumn;
    }

    public String getTenantIdColumn() {
        return this.tenantIdColumn;
    }

    public void setTenantIdColumn(String tenantIdColumn) {
        this.tenantIdColumn = tenantIdColumn;
    }

    public Map<String, String> getOnInsertColumns() {
        return this.onInsertColumns;
    }

    public void setOnInsertColumns(Map<String, String> onInsertColumns) {
        this.onInsertColumns = onInsertColumns;
    }

    public Map<String, String> getOnUpdateColumns() {
        return this.onUpdateColumns;
    }

    public void setOnUpdateColumns(Map<String, String> onUpdateColumns) {
        this.onUpdateColumns = onUpdateColumns;
    }

    public String[] getLargeColumns() {
        return this.largeColumns;
    }

    public void setLargeColumns(String[] largeColumns) {
        this.largeColumns = largeColumns;
    }

    public String[] getDefaultQueryColumns() {
        return this.defaultQueryColumns;
    }

    public void setDefaultQueryColumns(String[] defaultQueryColumns) {
        this.defaultQueryColumns = defaultQueryColumns;
    }

    public String[] getInsertPrimaryKeys() {
        return this.insertPrimaryKeys;
    }

    public void setInsertPrimaryKeys(String[] insertPrimaryKeys) {
        this.insertPrimaryKeys = insertPrimaryKeys;
    }

    public Reflector getReflector() {
        return this.reflector;
    }

    public ReflectorFactory getReflectorFactory() {
        return this.reflectorFactory;
    }

    public void setReflector(Reflector reflector) {
        this.reflector = reflector;
    }

    public String[] getAllColumns() {
        return this.allColumns;
    }

    public void setAllColumns(String[] allColumns) {
        this.allColumns = allColumns;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public void setColumns(String[] columns) {
        this.columns = columns;
    }

    public String[] getPrimaryColumns() {
        return this.primaryColumns;
    }

    public void setPrimaryColumns(String[] primaryColumns) {
        this.primaryColumns = primaryColumns;
    }

    public List<InsertListener> getOnInsertListeners() {
        return this.onInsertListeners;
    }

    public void setOnInsertListeners(List<InsertListener> onInsertListeners) {
        this.onInsertListeners = onInsertListeners;
    }

    public List<UpdateListener> getOnUpdateListeners() {
        return this.onUpdateListeners;
    }

    public void setOnUpdateListeners(List<UpdateListener> onUpdateListeners) {
        this.onUpdateListeners = onUpdateListeners;
    }

    public List<SetListener> getOnSetListeners() {
        return this.onSetListeners;
    }

    public void setOnSetListeners(List<SetListener> onSetListeners) {
        this.onSetListeners = onSetListeners;
    }

    public List<ColumnInfo> getColumnInfoList() {
        return this.columnInfoList;
    }

    public String getColumnByProperty(String property) {
        String column = this.propertyColumnMapping.get(property);
        if (column == null) {
            for (Map.Entry<String, String> entry : this.propertyColumnMapping.entrySet()) {
                if (!property.equalsIgnoreCase(entry.getKey())) continue;
                column = entry.getValue();
                break;
            }
        }
        return StringUtil.isNotBlank(column) ? column : property;
    }

    public Map<String, Class<?>> getAssociationType() {
        return this.associationType;
    }

    public void setAssociationType(Map<String, Class<?>> associationType) {
        this.associationType = associationType;
    }

    public void addAssociationType(String fieldName, Class<?> clazz) {
        if (this.associationType == null) {
            this.associationType = new HashMap();
        }
        this.associationType.put(fieldName, clazz);
    }

    public Map<Field, Class<?>> getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(Map<Field, Class<?>> collectionType) {
        this.collectionType = collectionType;
    }

    public void addCollectionType(Field field, Class<?> genericClass) {
        if (this.collectionType == null) {
            this.collectionType = new HashMap();
        }
        this.collectionType.put(field, genericClass);
    }

    void setColumnInfoList(List<ColumnInfo> columnInfoList) {
        this.columnInfoList = columnInfoList;
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int i = 0; i < columnInfoList.size(); ++i) {
            ColumnInfo columnInfo = columnInfoList.get(i);
            if (columnInfo.isIgnore()) continue;
            columnNames.add(columnInfo.column);
            this.columnInfoMapping.put(columnInfo.column, columnInfo);
            this.propertyColumnMapping.put(columnInfo.property, columnInfo.column);
            String[] alias = columnInfo.getAlias();
            this.columnQueryMapping.put(columnInfo.column, new QueryColumn(this.schema, this.tableName, columnInfo.column, alias != null && alias.length > 0 ? alias[0] : null));
        }
        this.columns = columnNames.toArray(new String[0]);
        this.allColumns = ArrayUtil.concat(this.allColumns, this.columns);
    }

    public List<IdInfo> getPrimaryKeyList() {
        return this.primaryKeyList;
    }

    void setPrimaryKeyList(List<IdInfo> primaryKeyList) {
        this.primaryKeyList = primaryKeyList;
        this.primaryColumns = new String[primaryKeyList.size()];
        ArrayList<String> insertIdFields = new ArrayList<String>();
        for (int i = 0; i < primaryKeyList.size(); ++i) {
            IdInfo idInfo = primaryKeyList.get(i);
            this.primaryColumns[i] = idInfo.getColumn();
            if (idInfo.getKeyType() != KeyType.Auto && idInfo.getBefore() != null && idInfo.getBefore().booleanValue()) {
                insertIdFields.add(idInfo.getColumn());
            }
            this.columnInfoMapping.put(idInfo.column, idInfo);
            this.propertyColumnMapping.put(idInfo.property, idInfo.column);
            String[] alias = idInfo.getAlias();
            this.columnQueryMapping.put(idInfo.column, new QueryColumn(this.schema, this.tableName, idInfo.column, alias != null && alias.length > 0 ? alias[0] : null));
        }
        this.allColumns = ArrayUtil.concat(this.allColumns, this.primaryColumns);
        this.insertPrimaryKeys = insertIdFields.toArray(new String[0]);
    }

    public Object[] buildInsertSqlArgs(Object entity, boolean ignoreNulls) {
        MetaObject metaObject = EntityMetaObject.forObject(entity, this.reflectorFactory);
        String[] insertColumns = this.obtainInsertColumns(entity, ignoreNulls);
        Map<String, RawValue> rawValueMap = this.obtainUpdateRawValueMap(entity);
        ArrayList<Object> values = new ArrayList<Object>();
        for (String insertColumn : insertColumns) {
            if (this.onInsertColumns != null && this.onInsertColumns.containsKey(insertColumn)) continue;
            if (rawValueMap.containsKey(insertColumn)) {
                values.addAll(Arrays.asList(rawValueMap.remove(insertColumn).getParams()));
                continue;
            }
            Object value = this.buildColumnSqlArg(metaObject, insertColumn);
            if (ignoreNulls && value == null) continue;
            values.add(value);
        }
        values.addAll(rawValueMap.values().stream().flatMap(e -> Arrays.stream(e.getParams())).collect(Collectors.toList()));
        return values.toArray();
    }

    public String[] obtainInsertColumns(Object entity, boolean ignoreNulls) {
        if (!ignoreNulls) {
            return ArrayUtil.concat(this.insertPrimaryKeys, this.columns);
        }
        MetaObject metaObject = EntityMetaObject.forObject(entity, this.reflectorFactory);
        ArrayList<String> retColumns = new ArrayList<String>();
        for (String insertColumn : this.allColumns) {
            if (this.onInsertColumns != null && this.onInsertColumns.containsKey(insertColumn)) {
                retColumns.add(insertColumn);
                continue;
            }
            Object value = this.buildColumnSqlArg(metaObject, insertColumn);
            if (value == null) continue;
            retColumns.add(insertColumn);
        }
        return retColumns.toArray(new String[0]);
    }

    public Object[] buildInsertSqlArgsWithPk(Object entity, boolean ignoreNulls) {
        MetaObject metaObject = EntityMetaObject.forObject(entity, this.reflectorFactory);
        String[] insertColumns = this.obtainInsertColumnsWithPk(entity, ignoreNulls);
        ArrayList<Object> values = new ArrayList<Object>(insertColumns.length);
        for (String insertColumn : insertColumns) {
            if (this.onInsertColumns != null && this.onInsertColumns.containsKey(insertColumn)) continue;
            Object value = this.buildColumnSqlArg(metaObject, insertColumn);
            if (ignoreNulls && value == null) continue;
            values.add(value);
        }
        return values.toArray();
    }

    public String[] obtainInsertColumnsWithPk(Object entity, boolean ignoreNulls) {
        Object value;
        if (!ignoreNulls) {
            return this.allColumns;
        }
        MetaObject metaObject = EntityMetaObject.forObject(entity, this.reflectorFactory);
        ArrayList<String> retColumns = new ArrayList<String>();
        for (String primaryKey : this.primaryColumns) {
            value = this.buildColumnSqlArg(metaObject, primaryKey);
            if (value == null) {
                throw new IllegalArgumentException("Entity Primary Key value must not be null.");
            }
            retColumns.add(primaryKey);
        }
        for (String insertColumn : this.columns) {
            if (this.onInsertColumns != null && this.onInsertColumns.containsKey(insertColumn)) {
                retColumns.add(insertColumn);
                continue;
            }
            value = this.buildColumnSqlArg(metaObject, insertColumn);
            if (value == null) continue;
            retColumns.add(insertColumn);
        }
        return retColumns.toArray(new String[0]);
    }

    public Map<String, RawValue> obtainUpdateRawValueMap(Object entity) {
        if (!(entity instanceof UpdateWrapper)) {
            return Collections.emptyMap();
        }
        Map<String, Object> updates = ((UpdateWrapper)entity).getUpdates();
        if (updates.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, RawValue> map = new HashMap<String, RawValue>();
        updates.forEach((key, value) -> {
            if (value instanceof RawValue) {
                String column = this.getColumnByProperty((String)key);
                map.put(column, (RawValue)value);
            }
        });
        return map;
    }

    public Set<String> obtainUpdateColumns(Object entity, boolean ignoreNulls, boolean includePrimary) {
        MetaObject metaObject = EntityMetaObject.forObject(entity, this.reflectorFactory);
        LinkedHashSet<String> columns = new LinkedHashSet<String>();
        if (entity instanceof UpdateWrapper) {
            Map<String, Object> updates = ((UpdateWrapper)entity).getUpdates();
            if (updates.isEmpty()) {
                return Collections.emptySet();
            }
            for (String property : updates.keySet()) {
                String column = this.getColumnByProperty(property);
                if (this.onUpdateColumns != null && this.onUpdateColumns.containsKey(column) || ObjectUtil.equalsAny(column, this.versionColumn, this.tenantIdColumn) || !includePrimary && ArrayUtil.contains(this.primaryColumns, column)) continue;
                columns.add(column);
            }
        } else {
            for (String column : this.columns) {
                if (this.onUpdateColumns != null && this.onUpdateColumns.containsKey(column) || ObjectUtil.equalsAny(column, this.versionColumn, this.tenantIdColumn)) continue;
                Object value = this.buildColumnSqlArg(metaObject, column);
                if (ignoreNulls && value == null) continue;
                columns.add(column);
            }
        }
        return columns;
    }

    public Object[] buildUpdateSqlArgs(Object entity, boolean ignoreNulls, boolean includePrimary) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (entity instanceof UpdateWrapper) {
            Map<String, Object> updates = ((UpdateWrapper)entity).getUpdates();
            if (updates.isEmpty()) {
                return FlexConsts.EMPTY_ARRAY;
            }
            for (String property : updates.keySet()) {
                String column = this.getColumnByProperty(property);
                if (this.onUpdateColumns != null && this.onUpdateColumns.containsKey(column) || ObjectUtil.equalsAny(column, this.versionColumn, this.tenantIdColumn) || !includePrimary && ArrayUtil.contains(this.primaryColumns, column)) continue;
                Object value = updates.get(property);
                if (value instanceof RawValue) {
                    values.addAll(Arrays.asList(((RawValue)value).getParams()));
                    continue;
                }
                if (value != null) {
                    TypeHandler<?> typeHandler;
                    ColumnInfo columnInfo = this.columnInfoMapping.get(column);
                    if (columnInfo != null && (typeHandler = columnInfo.buildTypeHandler(null)) != null) {
                        value = new TypeHandlerObject(typeHandler, value, columnInfo.getJdbcType());
                    }
                    if (value.getClass().isEnum()) {
                        EnumWrapper enumWrapper = EnumWrapper.of(value.getClass());
                        value = enumWrapper.getEnumValue((Enum)value);
                    }
                }
                values.add(value);
            }
        } else {
            MetaObject metaObject = EntityMetaObject.forObject(entity, this.reflectorFactory);
            for (String column : this.columns) {
                if (this.onUpdateColumns != null && this.onUpdateColumns.containsKey(column) || ObjectUtil.equalsAny(column, this.versionColumn, this.tenantIdColumn)) continue;
                Object value = this.buildColumnSqlArg(metaObject, column);
                if (ignoreNulls && value == null) continue;
                values.add(value);
            }
        }
        return values.toArray();
    }

    public Object[] buildPkSqlArgs(Object entity) {
        MetaObject metaObject = EntityMetaObject.forObject(entity, this.reflectorFactory);
        Object[] values = new Object[this.primaryColumns.length];
        for (int i = 0; i < this.primaryColumns.length; ++i) {
            values[i] = this.buildColumnSqlArg(metaObject, this.primaryColumns[i]);
        }
        return values;
    }

    public Object getValue(Object entity, String property) {
        FieldWrapper fieldWrapper = FieldWrapper.of(this.entityClass, property);
        return fieldWrapper.get(entity);
    }

    public Object getPkValue(Object entity) {
        if (this.primaryColumns.length == 1) {
            MetaObject metaObject = EntityMetaObject.forObject(entity, this.reflectorFactory);
            ColumnInfo columnInfo = this.columnInfoMapping.get(this.primaryColumns[0]);
            return this.getPropertyValue(metaObject, columnInfo.property);
        }
        if (this.primaryColumns.length > 1) {
            MetaObject metaObject = EntityMetaObject.forObject(entity, this.reflectorFactory);
            Object[] values = new Object[this.primaryColumns.length];
            for (int i = 0; i < this.primaryColumns.length; ++i) {
                ColumnInfo columnInfo = this.columnInfoMapping.get(this.primaryColumns[i]);
                values[i] = this.getPropertyValue(metaObject, columnInfo.property);
            }
            return values;
        }
        return null;
    }

    public Object[] buildTenantIdArgs() {
        if (StringUtil.isBlank(this.tenantIdColumn)) {
            return null;
        }
        return TenantManager.getTenantIds(this.tableName);
    }

    public String buildTenantCondition(String sql, Object[] tenantIdArgs, IDialect dialect) {
        if (ArrayUtil.isNotEmpty(tenantIdArgs)) {
            if (tenantIdArgs.length == 1) {
                return sql + " AND " + dialect.wrap(this.tenantIdColumn) + " = ? ";
            }
            return sql + " AND " + dialect.wrap(this.tenantIdColumn) + " IN " + SqlUtil.buildSqlParamPlaceholder(tenantIdArgs.length);
        }
        return sql;
    }

    public void buildTenantCondition(StringBuilder sql, Object[] tenantIdArgs, IDialect dialect) {
        if (ArrayUtil.isNotEmpty(tenantIdArgs)) {
            if (tenantIdArgs.length == 1) {
                sql.append(" AND ").append(dialect.wrap(this.tenantIdColumn)).append(" = ? ");
            } else {
                sql.append(" AND ").append(dialect.wrap(this.tenantIdColumn)).append(" IN ").append(SqlUtil.buildSqlParamPlaceholder(tenantIdArgs.length));
            }
        }
    }

    public void buildTenantCondition(QueryWrapper queryWrapper) {
        Object[] tenantIdArgs = this.buildTenantIdArgs();
        if (ArrayUtil.isNotEmpty(tenantIdArgs)) {
            if (tenantIdArgs.length == 1) {
                queryWrapper.where(QueryCondition.create(this.schema, this.tableName, this.tenantIdColumn, " = ", tenantIdArgs[0]));
            } else {
                queryWrapper.where(QueryCondition.create(this.schema, this.tableName, this.tenantIdColumn, " IN ", tenantIdArgs));
            }
        }
    }

    public void appendConditions(Object entity, QueryWrapper queryWrapper) {
        List<UnionWrapper> list;
        List<Join> joins;
        List<QueryTable> queryTables;
        Object appendConditions = CPI.getContext(queryWrapper, APPEND_CONDITIONS_FLAG);
        if (Boolean.TRUE.equals(appendConditions)) {
            return;
        }
        CPI.putContext(queryWrapper, APPEND_CONDITIONS_FLAG, Boolean.TRUE);
        List<QueryColumn> selectColumns = CPI.getSelectColumns(queryWrapper);
        if (selectColumns != null && !selectColumns.isEmpty()) {
            for (QueryColumn queryColumn : selectColumns) {
                if (!(queryColumn instanceof SelectQueryColumn)) continue;
                QueryWrapper selectColumnQueryWrapper = CPI.getQueryWrapper((SelectQueryColumn)queryColumn);
                this.doAppendConditions(entity, selectColumnQueryWrapper);
            }
        }
        if ((queryTables = CPI.getQueryTables(queryWrapper)) != null && !queryTables.isEmpty()) {
            for (QueryTable queryTable : queryTables) {
                if (!(queryTable instanceof SelectQueryTable)) continue;
                QueryWrapper queryWrapper2 = ((SelectQueryTable)queryTable).getQueryWrapper();
                this.doAppendConditions(entity, queryWrapper2);
            }
        }
        if (StringUtil.isNotBlank(this.getOptimisticLockColumnOrSkip()) && entity != null) {
            Object object = this.buildColumnSqlArg(entity, this.versionColumn);
            if (object == null) {
                throw FlexExceptions.wrap(LocalizedFormats.ENTITY_VERSION_NULL, entity);
            }
            queryWrapper.and(QueryCondition.create(this.schema, this.tableName, this.versionColumn, " = ", object));
        }
        if (StringUtil.isNotBlank(this.getLogicDeleteColumnOrSkip())) {
            QueryCondition queryCondition = CPI.getWhereQueryCondition(queryWrapper);
            if (queryCondition != null && !(queryCondition instanceof Brackets)) {
                Brackets wrappedCondition = new Brackets(queryCondition);
                CPI.setWhereQueryCondition(queryWrapper, wrappedCondition);
            }
            String joinTableAlias = (String)CPI.getContext(queryWrapper, "joinTableAlias");
            LogicDeleteManager.getProcessor().buildQueryCondition(queryWrapper, this, joinTableAlias);
        }
        this.buildTenantCondition(queryWrapper);
        List<QueryWrapper> list2 = CPI.getChildSelect(queryWrapper);
        if (CollectionUtil.isNotEmpty(list2)) {
            for (QueryWrapper queryWrapper3 : list2) {
                this.doAppendConditions(entity, queryWrapper3);
            }
        }
        if (CollectionUtil.isNotEmpty(joins = CPI.getJoins(queryWrapper))) {
            for (Join join : joins) {
                TableInfo tableInfo;
                if (!join.checkEffective()) continue;
                QueryTable joinQueryTable = CPI.getJoinQueryTable(join);
                if (joinQueryTable instanceof SelectQueryTable) {
                    QueryWrapper childQuery = ((SelectQueryTable)joinQueryTable).getQueryWrapper();
                    this.doAppendConditions(entity, childQuery);
                    continue;
                }
                String nameWithSchema = joinQueryTable.getNameWithSchema();
                if (!StringUtil.isNotBlank(nameWithSchema) || (tableInfo = TableInfoFactory.ofTableName(nameWithSchema)) == null) continue;
                QueryCondition joinQueryCondition = CPI.getJoinQueryCondition(join);
                QueryWrapper newWrapper = QueryWrapper.create().where(joinQueryCondition);
                CPI.putContext(newWrapper, "joinTableAlias", joinQueryTable.getAlias());
                tableInfo.appendConditions(entity, newWrapper);
                QueryCondition whereQueryCondition = CPI.getWhereQueryCondition(newWrapper);
                CPI.setJoinQueryCondition(join, whereQueryCondition);
            }
        }
        if (CollectionUtil.isNotEmpty(list = CPI.getUnions(queryWrapper))) {
            for (UnionWrapper union : list) {
                QueryWrapper unionQueryWrapper = union.getQueryWrapper();
                this.doAppendConditions(entity, unionQueryWrapper);
            }
        }
    }

    private void doAppendConditions(Object entity, QueryWrapper queryWrapper) {
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        if (queryTables != null && !queryTables.isEmpty()) {
            for (QueryTable queryTable : queryTables) {
                TableInfo tableInfo;
                if (queryTable instanceof SelectQueryTable) {
                    QueryWrapper childQuery = ((SelectQueryTable)queryTable).getQueryWrapper();
                    this.doAppendConditions(entity, childQuery);
                    continue;
                }
                String nameWithSchema = queryTable.getNameWithSchema();
                if (!StringUtil.isNotBlank(nameWithSchema) || (tableInfo = TableInfoFactory.ofTableName(nameWithSchema)) == null) continue;
                tableInfo.appendConditions(entity, queryWrapper);
            }
        }
    }

    public QueryWrapper buildQueryWrapper(Object entity, SqlOperators operators) {
        QueryColumn[] queryColumns = new QueryColumn[this.defaultQueryColumns.length];
        for (int i = 0; i < this.defaultQueryColumns.length; ++i) {
            queryColumns[i] = this.columnQueryMapping.get(this.defaultQueryColumns[i]);
        }
        QueryWrapper queryWrapper = QueryWrapper.create();
        String tableNameWithSchema = this.getTableNameWithSchema();
        queryWrapper.select(queryColumns).from(tableNameWithSchema);
        MetaObject metaObject = EntityMetaObject.forObject(entity, this.reflectorFactory);
        this.propertyColumnMapping.forEach((property, column) -> {
            if (column.equals(this.logicDeleteColumn)) {
                return;
            }
            Object value = metaObject.getValue(property);
            if (value != null && !"".equals(value)) {
                QueryColumn queryColumn = Arrays.stream(queryColumns).filter(e -> e.getName().equals(column)).findFirst().orElse(QueryMethods.column(this.getTableNameWithSchema(), column));
                if (operators != null) {
                    SqlOperator operator = (SqlOperator)((Object)((Object)operators.get(column)));
                    if (operator == null) {
                        operator = SqlOperator.EQUALS;
                    } else if (operator == SqlOperator.IGNORE) {
                        return;
                    }
                    if (operator == SqlOperator.LIKE || operator == SqlOperator.NOT_LIKE) {
                        value = "%" + value + "%";
                    } else if (operator == SqlOperator.LIKE_LEFT || operator == SqlOperator.NOT_LIKE_LEFT) {
                        value = value + "%";
                    } else if (operator == SqlOperator.LIKE_RIGHT || operator == SqlOperator.NOT_LIKE_RIGHT) {
                        value = "%" + value;
                    }
                    queryWrapper.and(QueryCondition.create(queryColumn, operator, this.buildSqlArg((String)column, value)));
                } else {
                    queryWrapper.and(queryColumn.eq(this.buildSqlArg((String)column, value)));
                }
            }
        });
        return queryWrapper;
    }

    private Object buildSqlArg(String column, Object value) {
        ColumnInfo columnInfo = this.columnInfoMapping.get(column);
        if (columnInfo == null) {
            return value;
        }
        TypeHandler<?> typeHandler = columnInfo.buildTypeHandler(null);
        if (typeHandler != null) {
            return new TypeHandlerObject(typeHandler, value, columnInfo.getJdbcType());
        }
        return value;
    }

    public String getKeyProperties() {
        StringJoiner joiner = new StringJoiner(",");
        for (IdInfo value : this.primaryKeyList) {
            joiner.add("$$entity." + value.getProperty());
        }
        return joiner.toString();
    }

    public String getKeyColumns() {
        StringJoiner joiner = new StringJoiner(",");
        for (IdInfo value : this.primaryKeyList) {
            joiner.add(value.getColumn());
        }
        return joiner.toString();
    }

    public List<QueryColumn> getDefaultQueryColumn() {
        return Arrays.stream(this.defaultQueryColumns).map(this.columnQueryMapping::get).collect(Collectors.toList());
    }

    private void getCombinedColumns(List<Class<?>> existedEntities, Class<?> entityClass, List<String> combinedColumns) {
        if (existedEntities.contains(entityClass)) {
            return;
        }
        existedEntities.add(entityClass);
        TableInfo tableInfo = TableInfoFactory.ofEntityClass(entityClass);
        combinedColumns.addAll(Arrays.asList(tableInfo.allColumns));
        if (tableInfo.collectionType != null) {
            tableInfo.collectionType.values().forEach(e -> this.getCombinedColumns(existedEntities, (Class<?>)e, combinedColumns));
        }
        if (tableInfo.associationType != null) {
            tableInfo.associationType.values().forEach(e -> this.getCombinedColumns(existedEntities, (Class<?>)e, combinedColumns));
        }
    }

    public ResultMap buildResultMap(Configuration configuration) {
        ArrayList<String> combinedColumns = new ArrayList<String>();
        this.getCombinedColumns(new ArrayList(), this.entityClass, combinedColumns);
        List<String> existedColumns = combinedColumns.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(e -> ((Long)e.getValue()).intValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
        return this.doBuildResultMap(configuration, new HashSet<String>(), existedColumns, false, this.getTableNameWithSchema());
    }

    private ResultMap doBuildResultMap(Configuration configuration, Set<String> resultMapIds, List<String> existedColumns, boolean isNested, String nestedPrefix) {
        boolean withCircularReference;
        String resultMapId = isNested ? "nested-" + nestedPrefix + ":" + this.entityClass.getName() : this.entityClass.getName();
        boolean bl = withCircularReference = resultMapIds.contains(resultMapId) || resultMapIds.contains(this.entityClass.getName());
        if (withCircularReference) {
            return null;
        }
        resultMapIds.add(resultMapId);
        if (configuration.hasResultMap(resultMapId)) {
            return configuration.getResultMap(resultMapId);
        }
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        for (IdInfo idInfo : this.primaryKeyList) {
            this.doBuildColumnResultMapping(configuration, resultMappings, existedColumns, idInfo, CollectionUtil.newArrayList(ResultFlag.ID), isNested);
        }
        for (ColumnInfo columnInfo : this.columnInfoList) {
            this.doBuildColumnResultMapping(configuration, resultMappings, existedColumns, columnInfo, Collections.emptyList(), isNested);
        }
        if (this.associationType != null) {
            this.associationType.forEach((fieldName, fieldType) -> {
                TableInfo tableInfo = TableInfoFactory.ofEntityClass(fieldType);
                ResultMap nestedResultMap = tableInfo.doBuildResultMap(configuration, resultMapIds, existedColumns, true, nestedPrefix);
                if (nestedResultMap != null) {
                    resultMappings.add(new ResultMapping.Builder(configuration, fieldName).javaType(fieldType).nestedResultMapId(nestedResultMap.getId()).build());
                }
            });
        }
        if (this.collectionType != null) {
            this.collectionType.forEach((field, genericClass) -> {
                if (TableInfoFactory.defaultSupportColumnTypes.contains(genericClass)) {
                    ResultMap nestedResultMap;
                    String columnName = TableInfoFactory.getColumnName(this.camelToUnderline, field, field.getAnnotation(Column.class));
                    ResultMapping resultMapping = new ResultMapping.Builder(configuration, null).column(columnName).typeHandler(configuration.getTypeHandlerRegistry().getTypeHandler(genericClass)).build();
                    String nestedResultMapId = this.entityClass.getName() + "." + field.getName();
                    if (configuration.hasResultMap(nestedResultMapId)) {
                        nestedResultMap = configuration.getResultMap(nestedResultMapId);
                    } else {
                        nestedResultMap = new ResultMap.Builder(configuration, nestedResultMapId, genericClass, Collections.singletonList(resultMapping)).build();
                        configuration.addResultMap(nestedResultMap);
                    }
                    resultMappings.add(new ResultMapping.Builder(configuration, field.getName()).javaType(field.getType()).nestedResultMapId(nestedResultMap.getId()).build());
                } else {
                    TableInfo tableInfo = TableInfoFactory.ofEntityClass(genericClass);
                    ResultMap nestedResultMap = tableInfo.doBuildResultMap(configuration, resultMapIds, existedColumns, true, nestedPrefix);
                    if (nestedResultMap != null) {
                        resultMappings.add(new ResultMapping.Builder(configuration, field.getName()).javaType(field.getType()).nestedResultMapId(nestedResultMap.getId()).build());
                    }
                }
            });
        }
        ResultMap resultMap = new ResultMap.Builder(configuration, resultMapId, this.entityClass, resultMappings).build();
        configuration.addResultMap(resultMap);
        resultMapIds.add(resultMapId);
        return resultMap;
    }

    private void doBuildColumnResultMapping(Configuration configuration, List<ResultMapping> resultMappings, List<String> existedColumns, ColumnInfo columnInfo, List<ResultFlag> flags, boolean isNested) {
        if (!isNested) {
            if (existedColumns.contains(columnInfo.column)) {
                resultMappings.add(new ResultMapping.Builder(configuration, columnInfo.property, this.tableName + "$" + columnInfo.column, columnInfo.propertyType).jdbcType(columnInfo.getJdbcType()).flags(flags).typeHandler(columnInfo.buildTypeHandler(configuration)).build());
            }
            this.buildDefaultResultMapping(configuration, resultMappings, columnInfo, flags);
        } else if (existedColumns.contains(columnInfo.column)) {
            resultMappings.add(new ResultMapping.Builder(configuration, columnInfo.property, this.tableName + "$" + columnInfo.column, columnInfo.propertyType).jdbcType(columnInfo.getJdbcType()).flags(flags).typeHandler(columnInfo.buildTypeHandler(configuration)).build());
        } else {
            this.buildDefaultResultMapping(configuration, resultMappings, columnInfo, flags);
        }
        if (ArrayUtil.isNotEmpty(columnInfo.alias)) {
            for (String alias : columnInfo.alias) {
                resultMappings.add(new ResultMapping.Builder(configuration, columnInfo.property, alias, columnInfo.propertyType).jdbcType(columnInfo.getJdbcType()).flags(flags).typeHandler(columnInfo.buildTypeHandler(configuration)).build());
            }
        }
    }

    private void buildDefaultResultMapping(Configuration configuration, List<ResultMapping> resultMappings, ColumnInfo columnInfo, List<ResultFlag> flags) {
        resultMappings.add(new ResultMapping.Builder(configuration, columnInfo.property, columnInfo.column, columnInfo.propertyType).jdbcType(columnInfo.getJdbcType()).flags(flags).typeHandler(columnInfo.buildTypeHandler(configuration)).build());
        if (!Objects.equals(columnInfo.column, columnInfo.property)) {
            resultMappings.add(new ResultMapping.Builder(configuration, columnInfo.property, columnInfo.property, columnInfo.propertyType).jdbcType(columnInfo.getJdbcType()).flags(flags).typeHandler(columnInfo.buildTypeHandler(configuration)).build());
        }
    }

    private Object buildColumnSqlArg(MetaObject metaObject, String column) {
        TypeHandler<?> typeHandler;
        ColumnInfo columnInfo = this.columnInfoMapping.get(column);
        Object value = this.getPropertyValue(metaObject, columnInfo.property);
        if (value != null && (typeHandler = columnInfo.buildTypeHandler(null)) != null) {
            return new TypeHandlerObject(typeHandler, value, columnInfo.getJdbcType());
        }
        return value;
    }

    public Object buildColumnSqlArg(Object entityObject, String column) {
        MetaObject metaObject = EntityMetaObject.forObject(entityObject, this.reflectorFactory);
        return this.buildColumnSqlArg(metaObject, column);
    }

    public Object getPropertyValue(MetaObject metaObject, String property) {
        if (property != null && metaObject.hasGetter(property)) {
            return metaObject.getValue(property);
        }
        return null;
    }

    public <T> T newInstanceByRow(Row row, int index) {
        Object instance = ClassUtil.newInstance(this.entityClass);
        MetaObject metaObject = EntityMetaObject.forObject(instance, this.reflectorFactory);
        Set rowKeys = row.keySet();
        this.columnInfoMapping.forEach((column, columnInfo) -> {
            if (index <= 0) {
                String replace = column.replace("_", "");
                for (String rowKey : rowKeys) {
                    if (!rowKey.equalsIgnoreCase((String)column) && !rowKey.equalsIgnoreCase(replace)) continue;
                    this.setInstancePropertyValue(row, instance, metaObject, (ColumnInfo)columnInfo, rowKey);
                }
            } else {
                for (int i = index; i >= 0; --i) {
                    String newColumn = i <= 0 ? column : column + "$" + i;
                    boolean fillValue = false;
                    String replace = column.replace("_", "");
                    for (String rowKey : rowKeys) {
                        if (!rowKey.equalsIgnoreCase(newColumn) && !rowKey.equalsIgnoreCase(replace)) continue;
                        this.setInstancePropertyValue(row, instance, metaObject, (ColumnInfo)columnInfo, rowKey);
                        fillValue = true;
                        break;
                    }
                    if (!fillValue) {
                        continue;
                    }
                    break;
                }
            }
        });
        return (T)instance;
    }

    private void setInstancePropertyValue(Row row, Object instance, MetaObject metaObject, ColumnInfo columnInfo, String rowKey) {
        Object rowValue = row.get(rowKey);
        TypeHandler<?> typeHandler = columnInfo.buildTypeHandler(null);
        if (typeHandler != null) {
            try {
                rowValue = typeHandler.getResult(this.getResultSet(rowValue), 0);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (rowValue != null && !metaObject.getSetterType(columnInfo.property).isAssignableFrom(rowValue.getClass())) {
            rowValue = ConvertUtil.convert(rowValue, metaObject.getSetterType(columnInfo.property), true);
        }
        rowValue = this.invokeOnSetListener(instance, columnInfo.property, rowValue);
        metaObject.setValue(columnInfo.property, rowValue);
    }

    private ResultSet getResultSet(Object value) {
        return (ResultSet)Proxy.newProxyInstance(TableInfo.class.getClassLoader(), new Class[]{ResultSet.class}, (proxy, method, args) -> value);
    }

    public void initVersionValueIfNecessary(Object entityObject) {
        if (StringUtil.isBlank(this.versionColumn)) {
            return;
        }
        MetaObject metaObject = EntityMetaObject.forObject(entityObject, this.reflectorFactory);
        Object columnValue = this.getPropertyValue(metaObject, this.columnInfoMapping.get((Object)this.versionColumn).property);
        if (columnValue == null) {
            String name = this.columnInfoMapping.get((Object)this.versionColumn).property;
            Class clazz = metaObject.getSetterType(name);
            metaObject.setValue(name, ConvertUtil.convert(0L, clazz));
        }
    }

    public void initTenantIdIfNecessary(Object entityObject) {
        String property;
        if (StringUtil.isBlank(this.tenantIdColumn)) {
            return;
        }
        MetaObject metaObject = EntityMetaObject.forObject(entityObject, this.reflectorFactory);
        if (metaObject.getValue(property = this.columnInfoMapping.get((Object)this.tenantIdColumn).property) != null) {
            return;
        }
        Object[] tenantIds = TenantManager.getTenantIds(this.tableName);
        if (tenantIds == null || tenantIds.length == 0) {
            return;
        }
        Object tenantId = tenantIds[0];
        if (tenantId != null) {
            Class setterType = metaObject.getSetterType(property);
            metaObject.setValue(property, ConvertUtil.convert(tenantId, setterType));
        }
    }

    public void initLogicDeleteValueIfNecessary(Object entityObject) {
        Object normalValueOfLogicDelete;
        if (StringUtil.isBlank(this.getLogicDeleteColumnOrSkip())) {
            return;
        }
        MetaObject metaObject = EntityMetaObject.forObject(entityObject, this.reflectorFactory);
        ColumnInfo logicDeleteColumn = this.columnInfoMapping.get(this.logicDeleteColumn);
        Object columnValue = this.getPropertyValue(metaObject, logicDeleteColumn.property);
        if (columnValue == null && (normalValueOfLogicDelete = LogicDeleteManager.getProcessor().getLogicNormalValue()) != null) {
            String property = logicDeleteColumn.property;
            Class setterType = metaObject.getSetterType(property);
            metaObject.setValue(property, ConvertUtil.convert(normalValueOfLogicDelete, setterType));
        }
    }

    public void invokeOnInsertListener(Object entity) {
        List listeners = MapUtil.computeIfAbsent(insertListenerCache, this.entityClass, aClass -> {
            List<InsertListener> globalListeners = FlexGlobalConfig.getDefaultConfig().getSupportedInsertListener(this.entityClass);
            List<InsertListener> allListeners = CollectionUtil.merge(this.onInsertListeners, globalListeners);
            Collections.sort(allListeners);
            return allListeners;
        });
        listeners.forEach(insertListener -> insertListener.onInsert(entity));
    }

    public void invokeOnUpdateListener(Object entity) {
        List listeners = MapUtil.computeIfAbsent(updateListenerCache, this.entityClass, aClass -> {
            List<UpdateListener> globalListeners = FlexGlobalConfig.getDefaultConfig().getSupportedUpdateListener(this.entityClass);
            List<UpdateListener> allListeners = CollectionUtil.merge(this.onUpdateListeners, globalListeners);
            Collections.sort(allListeners);
            return allListeners;
        });
        listeners.forEach(insertListener -> insertListener.onUpdate(entity));
    }

    public Object invokeOnSetListener(Object entity, String property, Object value) {
        List listeners = MapUtil.computeIfAbsent(setListenerCache, this.entityClass, aClass -> {
            List<SetListener> globalListeners = FlexGlobalConfig.getDefaultConfig().getSupportedSetListener(this.entityClass);
            List<SetListener> allListeners = CollectionUtil.merge(this.onSetListeners, globalListeners);
            Collections.sort(allListeners);
            return allListeners;
        });
        for (SetListener setListener : listeners) {
            value = setListener.onSet(entity, property, value);
        }
        return value;
    }

    public QueryColumn getQueryColumnByProperty(String property) {
        String column = this.getColumnByProperty(property);
        return this.columnQueryMapping.get(column);
    }
}

