/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.query.HasParamsColumn;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.util.ObjectUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.List;

public class SelectQueryColumn
extends QueryColumn
implements HasParamsColumn {
    private QueryWrapper queryWrapper;

    public SelectQueryColumn(QueryWrapper queryWrapper) {
        this.queryWrapper = queryWrapper;
    }

    public QueryWrapper getQueryWrapper() {
        return this.queryWrapper;
    }

    @Override
    protected String toConditionSql(List<QueryTable> queryTables, IDialect dialect) {
        return dialect.forSelectByQuery(this.queryWrapper);
    }

    @Override
    protected String toSelectSql(List<QueryTable> queryTables, IDialect dialect) {
        String selectSql = dialect.forSelectByQuery(this.queryWrapper);
        if (StringUtil.isNotBlank(selectSql) && StringUtil.isNotBlank(this.alias)) {
            selectSql = WrapperUtil.withAlias(selectSql, this.alias, dialect);
        }
        return selectSql;
    }

    @Override
    public SelectQueryColumn clone() {
        SelectQueryColumn clone = (SelectQueryColumn)super.clone();
        clone.queryWrapper = ObjectUtil.clone(this.queryWrapper);
        return clone;
    }

    @Override
    public Object[] getParamValues() {
        return this.queryWrapper.getAllValueArray();
    }
}

