/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.constant.SqlOperator;
import com.mybatisflex.core.query.QueryCondition;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public class QueryColumnBehavior {
    public static final Predicate<Object> IGNORE_NULL = Objects::isNull;
    public static final Predicate<Object> IGNORE_NONE = o -> Boolean.FALSE;
    public static final Predicate<Object> IGNORE_EMPTY = o -> o == null || "".equals(o);
    public static final Predicate<Object> IGNORE_BLANK = o -> o == null || o.toString().trim().isEmpty();
    public static final Function<? super QueryCondition, ? extends QueryCondition> CONVERT_IN_TO_EQUALS = it -> {
        Object value = it.value;
        if (it.logic.equalsIgnoreCase(" IN ") || it.logic.equalsIgnoreCase(" NOT IN ")) {
            Object firstValue;
            if (value instanceof Iterable) {
                Iterator iter = ((Iterable)value).iterator();
                if (!iter.hasNext()) {
                    return it;
                }
                firstValue = iter.next();
                if (iter.hasNext()) {
                    return it;
                }
            } else if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                if (array.length != 1) {
                    return it;
                }
                firstValue = array[0];
            } else {
                return it;
            }
            SqlOperator operator = it.logic.equalsIgnoreCase(" IN ") ? SqlOperator.EQUALS : SqlOperator.NOT_EQUALS;
            return QueryCondition.create(it.column, operator, firstValue);
        }
        return it;
    };
    public static final Function<? super QueryCondition, ? extends QueryCondition> CONVERT_EQUALS_TO_IS_NULL = it -> it.value == null && it.logic.equalsIgnoreCase(" = ") ? (QueryCondition)it.column.isNull() : it;
    private static Predicate<Object> ignoreFunction = IGNORE_NULL;
    private static Function<? super QueryCondition, ? extends QueryCondition> conditionCaster = Function.identity();
    private static boolean smartConvertInToEquals = false;

    private QueryColumnBehavior() {
    }

    public static Predicate<Object> getIgnoreFunction() {
        return ignoreFunction;
    }

    public static void setIgnoreFunction(Predicate<Object> ignoreFunction) {
        QueryColumnBehavior.ignoreFunction = ignoreFunction;
    }

    public static boolean isSmartConvertInToEquals() {
        return smartConvertInToEquals;
    }

    public static void setSmartConvertInToEquals(boolean smartConvertInToEquals) {
        QueryColumnBehavior.smartConvertInToEquals = smartConvertInToEquals;
    }

    static boolean shouldIgnoreValue(Object value) {
        return ignoreFunction.test(value);
    }

    public static Function<? super QueryCondition, ? extends QueryCondition> getConditionCaster() {
        return smartConvertInToEquals ? CONVERT_IN_TO_EQUALS.andThen(conditionCaster) : conditionCaster;
    }

    public static void setConditionCaster(Function<? super QueryCondition, ? extends QueryCondition> conditionCaster) {
        QueryColumnBehavior.conditionCaster = conditionCaster;
    }

    public static QueryCondition castCondition(QueryCondition condition) {
        return QueryColumnBehavior.getConditionCaster().apply(condition);
    }
}

