/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.FlexConsts;
import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.query.HasParamsColumn;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.SqlUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class FunctionQueryColumn
extends QueryColumn
implements HasParamsColumn {
    protected String fnName;
    protected List<QueryColumn> columns;

    public FunctionQueryColumn(String fnName) {
        SqlUtil.keepColumnSafely(fnName);
        this.fnName = fnName;
        this.columns = new ArrayList<QueryColumn>();
    }

    public FunctionQueryColumn(String fnName, String ... columns) {
        this(fnName);
        for (String column : columns) {
            this.columns.add(new QueryColumn(column));
        }
    }

    public FunctionQueryColumn(String fnName, QueryColumn ... columns) {
        this(fnName);
        this.columns.addAll(Arrays.asList(columns));
    }

    public String getFnName() {
        return this.fnName;
    }

    public void setFnName(String fnName) {
        this.fnName = fnName;
    }

    public List<QueryColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<QueryColumn> columns) {
        this.columns = columns;
    }

    @Override
    public Object[] getParamValues() {
        if (CollectionUtil.isEmpty(this.columns)) {
            return FlexConsts.EMPTY_ARRAY;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        for (QueryColumn queryColumn : this.columns) {
            if (!(queryColumn instanceof HasParamsColumn)) continue;
            Object[] paramValues = ((HasParamsColumn)((Object)queryColumn)).getParamValues();
            params.addAll(Arrays.asList(paramValues));
        }
        return params.toArray();
    }

    @Override
    public String toSelectSql(List<QueryTable> queryTables, IDialect dialect) {
        String sql = this.getSql(queryTables, dialect);
        if (StringUtil.isBlank(this.alias)) {
            return this.fnName + WrapperUtil.withBracket(sql);
        }
        return this.fnName + WrapperUtil.withAlias(sql, this.alias, dialect);
    }

    @Override
    protected String toConditionSql(List<QueryTable> queryTables, IDialect dialect) {
        String sql = this.getSql(queryTables, dialect);
        return this.fnName + WrapperUtil.withBracket(sql);
    }

    private String getSql(List<QueryTable> queryTables, IDialect dialect) {
        if (CollectionUtil.isEmpty(this.columns)) {
            return "";
        }
        String sql = this.columns.stream().filter(Objects::nonNull).map(c -> c.toSelectSql(queryTables, dialect)).collect(Collectors.joining(", "));
        if (StringUtil.isBlank(sql)) {
            return "";
        }
        return sql;
    }

    @Override
    public String toString() {
        return "FunctionQueryColumn{fnName='" + this.fnName + '\'' + ", columns=" + this.columns + '}';
    }

    @Override
    public FunctionQueryColumn clone() {
        FunctionQueryColumn clone = (FunctionQueryColumn)super.clone();
        clone.columns = CollectionUtil.cloneArrayList(this.columns);
        return clone;
    }
}

