/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.dialect.impl;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.dialect.KeywordWrap;
import com.mybatisflex.core.dialect.LimitOffsetProcessor;
import com.mybatisflex.core.dialect.OperateType;
import com.mybatisflex.core.dialect.impl.CommonsDialectImpl;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.exception.locale.LocalizedFormats;
import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.row.RowCPI;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.update.RawValue;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;

public class ClickhouseDialectImpl
extends CommonsDialectImpl {
    public static final String ALTER_TABLE = " ALTER TABLE ";
    public static final String CK_DELETE = " DELETE ";
    public static final String CK_UPDATE = " UPDATE ";

    public ClickhouseDialectImpl(KeywordWrap keywordWrap, LimitOffsetProcessor limitOffsetProcessor) {
        super(keywordWrap, limitOffsetProcessor);
    }

    @Override
    public String forUpdateById(String schema, String tableName, Row row) {
        String table = this.getRealTable(tableName, OperateType.UPDATE);
        StringBuilder sql = new StringBuilder();
        Set<String> modifyAttrs = RowCPI.getModifyAttrs(row);
        Map<String, RawValue> rawValueMap = RowCPI.getRawValueMap(row);
        String[] primaryKeys = RowCPI.obtainsPrimaryKeyStrings(row);
        sql.append(ALTER_TABLE);
        if (StringUtil.isNotBlank(schema)) {
            sql.append(this.wrap(this.getRealSchema(schema, table, OperateType.UPDATE))).append(".");
        }
        sql.append(this.wrap(table)).append(CK_UPDATE);
        int index = 0;
        for (Map.Entry e : row.entrySet()) {
            String colName = (String)e.getKey();
            if (!modifyAttrs.contains(colName) || ArrayUtil.contains(primaryKeys, colName)) continue;
            if (index > 0) {
                sql.append(", ");
            }
            sql.append(this.wrap(colName));
            if (rawValueMap.containsKey(colName)) {
                sql.append(" = ").append(rawValueMap.get(colName).toSql(this));
            } else {
                sql.append(" = ? ");
            }
            ++index;
        }
        sql.append(" WHERE ");
        for (int i = 0; i < primaryKeys.length; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append(this.wrap(primaryKeys[i])).append(" = ? ");
        }
        this.prepareAuth(schema, table, sql, OperateType.UPDATE);
        return sql.toString();
    }

    @Override
    public String forDeleteById(String schema, String tableName, String[] primaryKeys) {
        String table = this.getRealTable(tableName, OperateType.DELETE);
        StringBuilder sql = new StringBuilder();
        sql.append(ALTER_TABLE);
        if (StringUtil.isNotBlank(schema)) {
            sql.append(this.wrap(this.getRealSchema(schema, table, OperateType.DELETE))).append(".");
        }
        sql.append(this.wrap(table));
        sql.append(CK_DELETE);
        sql.append(" WHERE ");
        for (int i = 0; i < primaryKeys.length; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append(this.wrap(primaryKeys[i])).append(" = ? ");
        }
        this.prepareAuth(schema, table, sql, OperateType.DELETE);
        return sql.toString();
    }

    @Override
    public String forUpdateByQuery(QueryWrapper queryWrapper, Row row) {
        this.prepareAuth(queryWrapper, OperateType.UPDATE);
        StringBuilder sql = new StringBuilder();
        Set<String> modifyAttrs = RowCPI.getModifyAttrs(row);
        Map<String, RawValue> rawValueMap = RowCPI.getRawValueMap(row);
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        if (queryTables == null || queryTables.size() != 1) {
            throw FlexExceptions.wrap(LocalizedFormats.UPDATE_ONLY_SUPPORT_1_TABLE, new Object[0]);
        }
        sql.append(ALTER_TABLE);
        QueryTable queryTable = queryTables.get(0);
        sql.append(queryTable.toSql(this, OperateType.UPDATE)).append(CK_UPDATE);
        int index = 0;
        for (String modifyAttr : modifyAttrs) {
            if (index > 0) {
                sql.append(", ");
            }
            sql.append(this.wrap(modifyAttr));
            if (rawValueMap.containsKey(modifyAttr)) {
                sql.append(" = ").append(rawValueMap.get(modifyAttr).toSql(this));
            } else {
                sql.append(" = ? ");
            }
            ++index;
        }
        this.buildJoinSql(sql, queryWrapper, queryTables, OperateType.UPDATE);
        this.buildWhereSql(sql, queryWrapper, queryTables, false);
        this.buildGroupBySql(sql, queryWrapper, queryTables);
        this.buildHavingSql(sql, queryWrapper, queryTables);
        this.buildOrderBySql(sql, queryWrapper, queryTables);
        Long limitRows = CPI.getLimitRows(queryWrapper);
        Long limitOffset = CPI.getLimitOffset(queryWrapper);
        if (limitRows != null || limitOffset != null) {
            sql = this.buildLimitOffsetSql(sql, queryWrapper, limitRows, limitOffset);
        }
        return sql.toString();
    }

    @Override
    public String forDeleteBatchByIds(String schema, String tableName, String[] primaryKeys, Object[] ids) {
        String table = this.getRealTable(tableName, OperateType.DELETE);
        StringBuilder sql = new StringBuilder();
        sql.append(ALTER_TABLE);
        if (StringUtil.isNotBlank(schema)) {
            sql.append(this.wrap(this.getRealSchema(schema, table, OperateType.DELETE))).append(".");
        }
        sql.append(this.wrap(table));
        sql.append(CK_DELETE);
        sql.append(" WHERE ");
        if (primaryKeys.length > 1) {
            for (int i = 0; i < ids.length / primaryKeys.length; ++i) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                sql.append("(");
                for (int j = 0; j < primaryKeys.length; ++j) {
                    if (j > 0) {
                        sql.append(" AND ");
                    }
                    sql.append(this.wrap(primaryKeys[j])).append(" = ? ");
                }
                sql.append(")");
            }
        } else {
            for (int i = 0; i < ids.length; ++i) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                sql.append(this.wrap(primaryKeys[0])).append(" = ? ");
            }
        }
        this.prepareAuth(schema, table, sql, OperateType.DELETE);
        return sql.toString();
    }

    @Override
    public String forDeleteEntityBatchByIds(TableInfo tableInfo, Object[] primaryValues) {
        String logicDeleteColumn = tableInfo.getLogicDeleteColumnOrSkip();
        Object[] tenantIdArgs = tableInfo.buildTenantIdArgs();
        if (StringUtil.isBlank(logicDeleteColumn)) {
            String deleteSQL = this.forDeleteBatchByIds(tableInfo.getSchema(), tableInfo.getTableName(), tableInfo.getPrimaryColumns(), primaryValues);
            if (ArrayUtil.isNotEmpty(tenantIdArgs)) {
                deleteSQL = deleteSQL.replace(" WHERE ", " WHERE (") + ")";
                deleteSQL = tableInfo.buildTenantCondition(deleteSQL, tenantIdArgs, (IDialect)this);
            }
            return deleteSQL;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(ALTER_TABLE);
        sql.append(tableInfo.getWrapSchemaAndTableName(this, OperateType.UPDATE));
        sql.append(CK_UPDATE).append(this.buildLogicDeletedSet(logicDeleteColumn, tableInfo));
        sql.append(" WHERE ");
        sql.append("(");
        String[] primaryKeys = tableInfo.getPrimaryColumns();
        if (primaryKeys.length > 1) {
            for (int i = 0; i < primaryValues.length / primaryKeys.length; ++i) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                sql.append("(");
                for (int j = 0; j < primaryKeys.length; ++j) {
                    if (j > 0) {
                        sql.append(" AND ");
                    }
                    sql.append(this.wrap(primaryKeys[j])).append(" = ? ");
                }
                sql.append(")");
            }
        } else {
            for (int i = 0; i < primaryValues.length; ++i) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                sql.append(this.wrap(primaryKeys[0])).append(" = ? ");
            }
        }
        sql.append(")").append(" AND ").append(this.buildLogicNormalCondition(logicDeleteColumn, tableInfo));
        tableInfo.buildTenantCondition(sql, tenantIdArgs, (IDialect)this);
        this.prepareAuth(tableInfo, sql, OperateType.DELETE);
        return sql.toString();
    }

    @Override
    public String buildDeleteSql(QueryWrapper queryWrapper) {
        List<String> endFragments;
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        List<QueryTable> joinTables = CPI.getJoinTables(queryWrapper);
        List<QueryTable> allTables = CollectionUtil.merge(queryTables, joinTables);
        if (joinTables != null && !joinTables.isEmpty()) {
            throw new IllegalArgumentException("Delete query not support join sql ");
        }
        StringBuilder sqlBuilder = new StringBuilder(ALTER_TABLE);
        String hint = CPI.getHint(queryWrapper);
        if (StringUtil.isNotBlank(hint)) {
            sqlBuilder.append(" ").append(hint).deleteCharAt(sqlBuilder.length() - 1);
        }
        sqlBuilder.append(StringUtil.join(", ", queryTables, queryTable -> queryTable.toSql(this, OperateType.DELETE)));
        sqlBuilder.append(CK_DELETE);
        this.buildWhereSql(sqlBuilder, queryWrapper, allTables, false);
        this.buildGroupBySql(sqlBuilder, queryWrapper, allTables);
        this.buildHavingSql(sqlBuilder, queryWrapper, allTables);
        this.buildOrderBySql(sqlBuilder, queryWrapper, allTables);
        Long limitRows = CPI.getLimitRows(queryWrapper);
        Long limitOffset = CPI.getLimitOffset(queryWrapper);
        if (limitRows != null || limitOffset != null) {
            sqlBuilder = this.buildLimitOffsetSql(sqlBuilder, queryWrapper, limitRows, limitOffset);
        }
        if (CollectionUtil.isNotEmpty(endFragments = CPI.getEndFragments(queryWrapper))) {
            for (String endFragment : endFragments) {
                sqlBuilder.append(" ").append(endFragment);
            }
        }
        return sqlBuilder.toString();
    }

    @Override
    public String forDeleteEntityBatchByQuery(TableInfo tableInfo, QueryWrapper queryWrapper) {
        String logicDeleteColumn = tableInfo.getLogicDeleteColumnOrSkip();
        if (StringUtil.isBlank(logicDeleteColumn)) {
            return this.forDeleteByQuery(queryWrapper);
        }
        this.prepareAuth(queryWrapper, OperateType.DELETE);
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        List<QueryTable> joinTables = CPI.getJoinTables(queryWrapper);
        List<QueryTable> allTables = CollectionUtil.merge(queryTables, joinTables);
        StringBuilder sqlBuilder = new StringBuilder(ALTER_TABLE).append(this.forHint(CPI.getHint(queryWrapper)));
        sqlBuilder.append(tableInfo.getWrapSchemaAndTableName(this, OperateType.DELETE));
        sqlBuilder.append(CK_UPDATE).append(this.buildLogicDeletedSet(logicDeleteColumn, tableInfo));
        this.buildJoinSql(sqlBuilder, queryWrapper, allTables, OperateType.DELETE);
        this.buildWhereSql(sqlBuilder, queryWrapper, allTables, false);
        this.buildGroupBySql(sqlBuilder, queryWrapper, allTables);
        this.buildHavingSql(sqlBuilder, queryWrapper, allTables);
        return sqlBuilder.toString();
    }

    @Override
    public String forUpdateEntity(TableInfo tableInfo, Object entity, boolean ignoreNulls) {
        StringBuilder sql = new StringBuilder();
        Set<String> updateColumns = tableInfo.obtainUpdateColumns(entity, ignoreNulls, false);
        Map<String, RawValue> rawValueMap = tableInfo.obtainUpdateRawValueMap(entity);
        String[] primaryKeys = tableInfo.getPrimaryColumns();
        sql.append(ALTER_TABLE).append(tableInfo.getWrapSchemaAndTableName(this, OperateType.UPDATE)).append(CK_UPDATE);
        StringJoiner stringJoiner = new StringJoiner(", ");
        for (String updateColumn : updateColumns) {
            if (rawValueMap.containsKey(updateColumn)) {
                stringJoiner.add(this.wrap(updateColumn) + " = " + rawValueMap.get(updateColumn).toSql(this));
                continue;
            }
            stringJoiner.add(this.wrap(updateColumn) + " = ? ");
        }
        Map<String, String> onUpdateColumns = tableInfo.getOnUpdateColumns();
        if (onUpdateColumns != null && !onUpdateColumns.isEmpty()) {
            onUpdateColumns.forEach((column, value) -> stringJoiner.add(this.wrap((String)column) + " = " + value));
        }
        String versionColumn = tableInfo.getVersionColumn();
        if (StringUtil.isNotBlank(tableInfo.getOptimisticLockColumnOrSkip())) {
            stringJoiner.add(this.wrap(versionColumn) + " = " + this.wrap(versionColumn) + " + 1 ");
        }
        sql.append(stringJoiner);
        sql.append(" WHERE ");
        for (int i = 0; i < primaryKeys.length; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append(this.wrap(primaryKeys[i])).append(" = ? ");
        }
        String logicDeleteColumn = tableInfo.getLogicDeleteColumnOrSkip();
        if (StringUtil.isNotBlank(logicDeleteColumn)) {
            sql.append(" AND ").append(this.buildLogicNormalCondition(logicDeleteColumn, tableInfo));
        }
        Object[] tenantIdArgs = tableInfo.buildTenantIdArgs();
        tableInfo.buildTenantCondition(sql, tenantIdArgs, (IDialect)this);
        if (StringUtil.isNotBlank(versionColumn)) {
            Object versionValue = tableInfo.buildColumnSqlArg(entity, versionColumn);
            if (versionValue == null) {
                throw FlexExceptions.wrap(LocalizedFormats.ENTITY_VERSION_NULL, entity);
            }
            sql.append(" AND ").append(this.wrap(versionColumn)).append(" = ").append(versionValue);
        }
        this.prepareAuth(tableInfo, sql, OperateType.UPDATE);
        return sql.toString();
    }

    @Override
    public String forUpdateEntityByQuery(TableInfo tableInfo, Object entity, boolean ignoreNulls, QueryWrapper queryWrapper) {
        List<String> endFragments;
        this.prepareAuth(queryWrapper, OperateType.UPDATE);
        StringBuilder sqlBuilder = new StringBuilder();
        Set<String> updateColumns = tableInfo.obtainUpdateColumns(entity, ignoreNulls, true);
        Map<String, RawValue> rawValueMap = tableInfo.obtainUpdateRawValueMap(entity);
        sqlBuilder.append(ALTER_TABLE).append(this.forHint(CPI.getHint(queryWrapper)));
        sqlBuilder.append(tableInfo.getWrapSchemaAndTableName(this, OperateType.UPDATE));
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        this.buildJoinSql(sqlBuilder, queryWrapper, queryTables, OperateType.UPDATE);
        sqlBuilder.append(CK_UPDATE);
        StringJoiner stringJoiner = new StringJoiner(", ");
        for (String modifyAttr : updateColumns) {
            if (rawValueMap.containsKey(modifyAttr)) {
                stringJoiner.add(this.wrap(modifyAttr) + " = " + rawValueMap.get(modifyAttr).toSql(this));
                continue;
            }
            stringJoiner.add(this.wrap(modifyAttr) + " = ? ");
        }
        Map<String, String> onUpdateColumns = tableInfo.getOnUpdateColumns();
        if (onUpdateColumns != null && !onUpdateColumns.isEmpty()) {
            onUpdateColumns.forEach((column, value) -> stringJoiner.add(this.wrap((String)column) + " = " + value));
        }
        String versionColumn = tableInfo.getVersionColumn();
        if (StringUtil.isNotBlank(tableInfo.getOptimisticLockColumnOrSkip())) {
            stringJoiner.add(this.wrap(versionColumn) + " = " + this.wrap(versionColumn) + " + 1 ");
        }
        sqlBuilder.append(stringJoiner);
        this.buildWhereSql(sqlBuilder, queryWrapper, queryTables, false);
        this.buildGroupBySql(sqlBuilder, queryWrapper, queryTables);
        this.buildHavingSql(sqlBuilder, queryWrapper, queryTables);
        this.buildOrderBySql(sqlBuilder, queryWrapper, queryTables);
        Long limitRows = CPI.getLimitRows(queryWrapper);
        Long limitOffset = CPI.getLimitOffset(queryWrapper);
        if (limitRows != null || limitOffset != null) {
            sqlBuilder = this.buildLimitOffsetSql(sqlBuilder, queryWrapper, limitRows, limitOffset);
        }
        if (CollectionUtil.isNotEmpty(endFragments = CPI.getEndFragments(queryWrapper))) {
            for (String endFragment : endFragments) {
                sqlBuilder.append(" ").append(endFragment);
            }
        }
        return sqlBuilder.toString();
    }
}

