/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.dialect;

import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.dialect.DbType;
import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.dialect.KeywordWrap;
import com.mybatisflex.core.dialect.LimitOffsetProcessor;
import com.mybatisflex.core.dialect.impl.ClickhouseDialectImpl;
import com.mybatisflex.core.dialect.impl.CommonsDialectImpl;
import com.mybatisflex.core.dialect.impl.DB2105Dialect;
import com.mybatisflex.core.dialect.impl.DmDialect;
import com.mybatisflex.core.dialect.impl.OracleDialect;
import com.mybatisflex.core.dialect.impl.Sqlserver2005DialectImpl;
import com.mybatisflex.core.dialect.impl.SqlserverDialectImpl;
import com.mybatisflex.core.util.MapUtil;
import com.mybatisflex.core.util.ObjectUtil;
import java.util.EnumMap;
import java.util.Map;

public class DialectFactory {
    private static final Map<DbType, IDialect> dialectMap = new EnumMap<DbType, IDialect>(DbType.class);
    private static final ThreadLocal<DbType> dbTypeThreadLocal = new ThreadLocal();

    private DialectFactory() {
    }

    public static IDialect getDialect() {
        DbType dbType = ObjectUtil.requireNonNullElse(dbTypeThreadLocal.get(), FlexGlobalConfig.getDefaultConfig().getDbType());
        return MapUtil.computeIfAbsent(dialectMap, dbType, DialectFactory::createDialect);
    }

    public static void setHintDbType(DbType dbType) {
        dbTypeThreadLocal.set(dbType);
    }

    public static DbType getHintDbType() {
        return dbTypeThreadLocal.get();
    }

    public static void clearHintDbType() {
        dbTypeThreadLocal.remove();
    }

    public static void registerDialect(DbType dbType, IDialect dialect) {
        dialectMap.put(dbType, dialect);
    }

    private static IDialect createDialect(DbType dbType) {
        switch (dbType) {
            case MYSQL: 
            case H2: 
            case MARIADB: 
            case GBASE: 
            case OSCAR: 
            case XUGU: 
            case OCEAN_BASE: 
            case CUBRID: 
            case GOLDILOCKS: 
            case CSIIDB: 
            case HIVE: 
            case DORIS: {
                return new CommonsDialectImpl(KeywordWrap.BACK_QUOTE, LimitOffsetProcessor.MYSQL);
            }
            case CLICK_HOUSE: {
                return new ClickhouseDialectImpl(KeywordWrap.NONE, LimitOffsetProcessor.MYSQL);
            }
            case GBASE_8S: {
                return new CommonsDialectImpl(KeywordWrap.NONE, LimitOffsetProcessor.MYSQL);
            }
            case DM: {
                return new DmDialect();
            }
            case ORACLE: {
                return new OracleDialect();
            }
            case GAUSS: {
                return new CommonsDialectImpl(KeywordWrap.DOUBLE_QUOTATION, LimitOffsetProcessor.ORACLE);
            }
            case POSTGRE_SQL: 
            case SQLITE: 
            case HSQL: 
            case KINGBASE_ES: 
            case PHOENIX: 
            case SAP_HANA: 
            case IMPALA: 
            case HIGH_GO: 
            case VERTICA: 
            case REDSHIFT: 
            case OPENGAUSS: 
            case UXDB: 
            case LEALONE: {
                return new CommonsDialectImpl(KeywordWrap.DOUBLE_QUOTATION, LimitOffsetProcessor.POSTGRESQL);
            }
            case TDENGINE: {
                return new CommonsDialectImpl(KeywordWrap.BACK_QUOTE, LimitOffsetProcessor.POSTGRESQL);
            }
            case ORACLE_12C: {
                return new OracleDialect(LimitOffsetProcessor.DERBY);
            }
            case FIREBIRD: 
            case DB2: {
                return new CommonsDialectImpl(KeywordWrap.NONE, LimitOffsetProcessor.DERBY);
            }
            case DB2_1005: {
                return new DB2105Dialect(KeywordWrap.NONE, DB2105Dialect.DB2105LimitOffsetProcessor.DB2105);
            }
            case SQLSERVER: {
                return new SqlserverDialectImpl(KeywordWrap.SQUARE_BRACKETS, LimitOffsetProcessor.SQLSERVER);
            }
            case SQLSERVER_2005: {
                return new Sqlserver2005DialectImpl(KeywordWrap.SQUARE_BRACKETS, LimitOffsetProcessor.SQLSERVER_2005);
            }
            case INFORMIX: {
                return new CommonsDialectImpl(KeywordWrap.NONE, LimitOffsetProcessor.INFORMIX);
            }
            case SINODB: {
                return new CommonsDialectImpl(KeywordWrap.DOUBLE_QUOTATION, LimitOffsetProcessor.SINODB);
            }
            case SYBASE: {
                return new CommonsDialectImpl(KeywordWrap.DOUBLE_QUOTATION, LimitOffsetProcessor.SYBASE);
            }
            case TRINO: {
                return new CommonsDialectImpl(KeywordWrap.NONE, LimitOffsetProcessor.SQLSERVER);
            }
        }
        return new CommonsDialectImpl();
    }
}

