/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.query.CaseQueryColumn;
import com.mybatisflex.core.query.CaseSearchQueryColumn;
import com.mybatisflex.core.query.DistinctQueryColumn;
import com.mybatisflex.core.query.FunctionQueryColumn;
import com.mybatisflex.core.query.IfFunctionQueryColumn;
import com.mybatisflex.core.query.OperatorQueryCondition;
import com.mybatisflex.core.query.OperatorSelectCondition;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.RawFragment;
import com.mybatisflex.core.query.RawQueryColumn;
import com.mybatisflex.core.query.SelectQueryColumn;
import com.mybatisflex.core.query.StringFunctionQueryColumn;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.LambdaUtil;
import java.util.ArrayList;

public class QueryMethods {
    private QueryMethods() {
    }

    public static QueryColumn abs(String columnX) {
        return new FunctionQueryColumn("ABS", new String[]{columnX});
    }

    public static QueryColumn abs(QueryColumn columnX) {
        return new FunctionQueryColumn("ABS", columnX);
    }

    public static <T> QueryColumn abs(LambdaGetter<T> columnX) {
        return new FunctionQueryColumn("ABS", LambdaUtil.getQueryColumn(columnX));
    }

    public static QueryColumn ceil(String columnX) {
        return new FunctionQueryColumn("CEIL", new String[]{columnX});
    }

    public static QueryColumn ceil(QueryColumn columnX) {
        return new FunctionQueryColumn("CEIL", columnX);
    }

    public static <T> QueryColumn ceil(LambdaGetter<T> columnX) {
        return new FunctionQueryColumn("CEIL", LambdaUtil.getQueryColumn(columnX));
    }

    public static QueryColumn ceiling(String columnX) {
        return new FunctionQueryColumn("CEILING", new String[]{columnX});
    }

    public static QueryColumn ceiling(QueryColumn columnX) {
        return new FunctionQueryColumn("CEILING", columnX);
    }

    public static <T> QueryColumn ceiling(LambdaGetter<T> columnX) {
        return new FunctionQueryColumn("CEILING", LambdaUtil.getQueryColumn(columnX));
    }

    public static QueryColumn floor(String columnX) {
        return new FunctionQueryColumn("FLOOR", new String[]{columnX});
    }

    public static QueryColumn floor(QueryColumn columnX) {
        return new FunctionQueryColumn("FLOOR", columnX);
    }

    public static <T> QueryColumn floor(LambdaGetter<T> columnX) {
        return new FunctionQueryColumn("FLOOR", LambdaUtil.getQueryColumn(columnX));
    }

    public static QueryColumn rand() {
        return new FunctionQueryColumn("RAND");
    }

    public static QueryColumn rand(String columnX) {
        return new FunctionQueryColumn("RAND", new String[]{columnX});
    }

    public static QueryColumn rand(QueryColumn columnX) {
        return new FunctionQueryColumn("RAND", columnX);
    }

    public static <T> QueryColumn rand(LambdaGetter<T> columnX) {
        return new FunctionQueryColumn("RAND", LambdaUtil.getQueryColumn(columnX));
    }

    public static QueryColumn sign(String columnX) {
        return new FunctionQueryColumn("SIGN", new String[]{columnX});
    }

    public static QueryColumn sign(QueryColumn columnX) {
        return new FunctionQueryColumn("SIGN", columnX);
    }

    public static <T> QueryColumn sign(LambdaGetter<T> columnX) {
        return new FunctionQueryColumn("SIGN", LambdaUtil.getQueryColumn(columnX));
    }

    public static QueryColumn pi() {
        return new FunctionQueryColumn("PI");
    }

    public static QueryColumn truncate(String columnX, String columnY) {
        return new FunctionQueryColumn("TRUNCATE", new String[]{columnX, columnY});
    }

    public static QueryColumn truncate(QueryColumn columnX, QueryColumn columnY) {
        return new FunctionQueryColumn("TRUNCATE", columnX, columnY);
    }

    public static <X, Y> QueryColumn truncate(LambdaGetter<X> columnX, LambdaGetter<Y> columnY) {
        return new FunctionQueryColumn("TRUNCATE", LambdaUtil.getQueryColumn(columnX), LambdaUtil.getQueryColumn(columnY));
    }

    public static QueryColumn truncate(String columnX, Integer y) {
        return new FunctionQueryColumn("TRUNCATE", new QueryColumn(columnX), QueryMethods.number(y));
    }

    public static QueryColumn truncate(QueryColumn columnX, Integer y) {
        return new FunctionQueryColumn("TRUNCATE", columnX, QueryMethods.number(y));
    }

    public static <T> QueryColumn truncate(LambdaGetter<T> columnX, Integer y) {
        return new FunctionQueryColumn("TRUNCATE", LambdaUtil.getQueryColumn(columnX), QueryMethods.number(y));
    }

    public static QueryColumn round(String columnX) {
        return new FunctionQueryColumn("ROUND", new String[]{columnX});
    }

    public static QueryColumn round(QueryColumn columnX) {
        return new FunctionQueryColumn("ROUND", columnX);
    }

    public static <T> QueryColumn round(LambdaGetter<T> columnX) {
        return new FunctionQueryColumn("ROUND", LambdaUtil.getQueryColumn(columnX));
    }

    public static QueryColumn round(String columnX, String columnY) {
        return new FunctionQueryColumn("ROUND", new String[]{columnX, columnY});
    }

    public static QueryColumn round(QueryColumn columnX, QueryColumn columnY) {
        return new FunctionQueryColumn("ROUND", columnX, columnY);
    }

    public static <X, Y> QueryColumn round(LambdaGetter<X> columnX, LambdaGetter<Y> columnY) {
        return new FunctionQueryColumn("ROUND", LambdaUtil.getQueryColumn(columnX), LambdaUtil.getQueryColumn(columnY));
    }

    public static QueryColumn round(String columnX, Integer y) {
        return new FunctionQueryColumn("ROUND", new QueryColumn(columnX), QueryMethods.number(y));
    }

    public static QueryColumn round(QueryColumn columnX, Integer y) {
        return new FunctionQueryColumn("ROUND", columnX, QueryMethods.number(y));
    }

    public static <T> QueryColumn round(LambdaGetter<T> columnX, Integer y) {
        return new FunctionQueryColumn("ROUND", LambdaUtil.getQueryColumn(columnX), QueryMethods.number(y));
    }

    public static QueryColumn pow(String columnX, String columnY) {
        return new FunctionQueryColumn("POW", new String[]{columnX, columnY});
    }

    public static QueryColumn pow(QueryColumn columnX, QueryColumn columnY) {
        return new FunctionQueryColumn("POW", columnX, columnY);
    }

    public static <X, Y> QueryColumn pow(LambdaGetter<X> columnX, LambdaGetter<Y> columnY) {
        return new FunctionQueryColumn("POW", LambdaUtil.getQueryColumn(columnX), LambdaUtil.getQueryColumn(columnY));
    }

    public static QueryColumn pow(String columnX, Integer y) {
        return new FunctionQueryColumn("POW", new QueryColumn(columnX), QueryMethods.number(y));
    }

    public static QueryColumn pow(QueryColumn columnX, Integer y) {
        return new FunctionQueryColumn("POW", columnX, QueryMethods.number(y));
    }

    public static <T> QueryColumn pow(LambdaGetter<T> columnX, Integer y) {
        return new FunctionQueryColumn("POW", LambdaUtil.getQueryColumn(columnX), QueryMethods.number(y));
    }

    public static QueryColumn power(String columnX, String columnY) {
        return new FunctionQueryColumn("POWER", new String[]{columnX, columnY});
    }

    public static QueryColumn power(QueryColumn columnX, QueryColumn columnY) {
        return new FunctionQueryColumn("POWER", columnX, columnY);
    }

    public static <X, Y> QueryColumn power(LambdaGetter<X> columnX, LambdaGetter<Y> columnY) {
        return new FunctionQueryColumn("POWER", LambdaUtil.getQueryColumn(columnX), LambdaUtil.getQueryColumn(columnY));
    }

    public static QueryColumn power(String columnX, Integer y) {
        return new FunctionQueryColumn("POWER", new QueryColumn(columnX), QueryMethods.number(y));
    }

    public static QueryColumn power(QueryColumn columnX, Integer y) {
        return new FunctionQueryColumn("POWER", columnX, QueryMethods.number(y));
    }

    public static <T> QueryColumn power(LambdaGetter<T> columnX, Integer y) {
        return new FunctionQueryColumn("POWER", LambdaUtil.getQueryColumn(columnX), QueryMethods.number(y));
    }

    public static QueryColumn sqrt(String columnX) {
        return new FunctionQueryColumn("SQRT", new String[]{columnX});
    }

    public static QueryColumn sqrt(QueryColumn columnX) {
        return new FunctionQueryColumn("SQRT", columnX);
    }

    public static <T> QueryColumn sqrt(LambdaGetter<T> columnX) {
        return new FunctionQueryColumn("SQRT", LambdaUtil.getQueryColumn(columnX));
    }

    public static QueryColumn exp(String columnX) {
        return new FunctionQueryColumn("EXP", new String[]{columnX});
    }

    public static QueryColumn exp(QueryColumn columnX) {
        return new FunctionQueryColumn("EXP", columnX);
    }

    public static <T> QueryColumn exp(LambdaGetter<T> columnX) {
        return new FunctionQueryColumn("EXP", LambdaUtil.getQueryColumn(columnX));
    }

    public static QueryColumn mod(String columnX, String columnY) {
        return new FunctionQueryColumn("MOD", new String[]{columnX, columnY});
    }

    public static QueryColumn mod(QueryColumn columnX, QueryColumn columnY) {
        return new FunctionQueryColumn("MOD", columnX, columnY);
    }

    public static <X, Y> QueryColumn mod(LambdaGetter<X> columnX, LambdaGetter<Y> columnY) {
        return new FunctionQueryColumn("MOD", LambdaUtil.getQueryColumn(columnX), LambdaUtil.getQueryColumn(columnY));
    }

    public static QueryColumn mod(String columnX, Integer y) {
        return new FunctionQueryColumn("MOD", new QueryColumn(columnX), QueryMethods.number(y));
    }

    public static QueryColumn mod(QueryColumn columnX, Integer y) {
        return new FunctionQueryColumn("MOD", columnX, QueryMethods.number(y));
    }

    public static <T> QueryColumn mod(LambdaGetter<T> columnX, Integer y) {
        return new FunctionQueryColumn("MOD", LambdaUtil.getQueryColumn(columnX), QueryMethods.number(y));
    }

    public static QueryColumn log(String columnX) {
        return new FunctionQueryColumn("LOG", new String[]{columnX});
    }

    public static QueryColumn log(QueryColumn columnX) {
        return new FunctionQueryColumn("LOG", columnX);
    }

    public static <T> QueryColumn log(LambdaGetter<T> columnX) {
        return new FunctionQueryColumn("LOG", LambdaUtil.getQueryColumn(columnX));
    }

    public static QueryColumn log10(String columnX) {
        return new FunctionQueryColumn("LOG10", new String[]{columnX});
    }

    public static QueryColumn log10(QueryColumn columnX) {
        return new FunctionQueryColumn("LOG10", columnX);
    }

    public static <T> QueryColumn log10(LambdaGetter<T> columnX) {
        return new FunctionQueryColumn("LOG10", LambdaUtil.getQueryColumn(columnX));
    }

    public static QueryColumn radians(String columnX) {
        return new FunctionQueryColumn("RADIANS", new String[]{columnX});
    }

    public static QueryColumn radians(QueryColumn columnX) {
        return new FunctionQueryColumn("RADIANS", columnX);
    }

    public static <T> QueryColumn radians(LambdaGetter<T> columnX) {
        return new FunctionQueryColumn("RADIANS", LambdaUtil.getQueryColumn(columnX));
    }

    public static QueryColumn degrees(String columnX) {
        return new FunctionQueryColumn("DEGREES", new String[]{columnX});
    }

    public static QueryColumn degrees(QueryColumn columnX) {
        return new FunctionQueryColumn("DEGREES", columnX);
    }

    public static <T> QueryColumn degrees(LambdaGetter<T> columnX) {
        return new FunctionQueryColumn("DEGREES", LambdaUtil.getQueryColumn(columnX));
    }

    public static QueryColumn sin(String columnX) {
        return new FunctionQueryColumn("SIN", new String[]{columnX});
    }

    public static QueryColumn sin(QueryColumn columnX) {
        return new FunctionQueryColumn("SIN", columnX);
    }

    public static <T> QueryColumn sin(LambdaGetter<T> columnX) {
        return new FunctionQueryColumn("SIN", LambdaUtil.getQueryColumn(columnX));
    }

    public static QueryColumn asin(String columnX) {
        return new FunctionQueryColumn("ASIN", new String[]{columnX});
    }

    public static QueryColumn asin(QueryColumn columnX) {
        return new FunctionQueryColumn("ASIN", columnX);
    }

    public static <T> QueryColumn asin(LambdaGetter<T> columnX) {
        return new FunctionQueryColumn("ASIN", LambdaUtil.getQueryColumn(columnX));
    }

    public static QueryColumn cos(String columnX) {
        return new FunctionQueryColumn("COS", new String[]{columnX});
    }

    public static QueryColumn cos(QueryColumn columnX) {
        return new FunctionQueryColumn("COS", columnX);
    }

    public static <T> QueryColumn cos(LambdaGetter<T> columnX) {
        return new FunctionQueryColumn("COS", LambdaUtil.getQueryColumn(columnX));
    }

    public static QueryColumn acos(String columnX) {
        return new FunctionQueryColumn("ACOS", new String[]{columnX});
    }

    public static QueryColumn acos(QueryColumn columnX) {
        return new FunctionQueryColumn("ACOS", columnX);
    }

    public static <T> QueryColumn acos(LambdaGetter<T> columnX) {
        return new FunctionQueryColumn("ACOS", LambdaUtil.getQueryColumn(columnX));
    }

    public static QueryColumn tan(String columnX) {
        return new FunctionQueryColumn("TAN", new String[]{columnX});
    }

    public static QueryColumn tan(QueryColumn columnX) {
        return new FunctionQueryColumn("TAN", columnX);
    }

    public static <T> QueryColumn tan(LambdaGetter<T> columnX) {
        return new FunctionQueryColumn("TAN", LambdaUtil.getQueryColumn(columnX));
    }

    public static QueryColumn atan(String columnX) {
        return new FunctionQueryColumn("ATAN", new String[]{columnX});
    }

    public static QueryColumn atan(QueryColumn columnX) {
        return new FunctionQueryColumn("ATAN", columnX);
    }

    public static <T> QueryColumn atan(LambdaGetter<T> columnX) {
        return new FunctionQueryColumn("ATAN", LambdaUtil.getQueryColumn(columnX));
    }

    public static QueryColumn cot(String columnX) {
        return new FunctionQueryColumn("COT", new String[]{columnX});
    }

    public static QueryColumn cot(QueryColumn columnX) {
        return new FunctionQueryColumn("COT", columnX);
    }

    public static <T> QueryColumn cot(LambdaGetter<T> columnX) {
        return new FunctionQueryColumn("COT", LambdaUtil.getQueryColumn(columnX));
    }

    public static QueryColumn charLength(String columnS) {
        return new FunctionQueryColumn("CHAR_LENGTH", new String[]{columnS});
    }

    public static QueryColumn charLength(QueryColumn columnS) {
        return new FunctionQueryColumn("CHAR_LENGTH", columnS);
    }

    public static <T> QueryColumn charLength(LambdaGetter<T> columnS) {
        return new FunctionQueryColumn("CHAR_LENGTH", LambdaUtil.getQueryColumn(columnS));
    }

    public static QueryColumn length(String columnS) {
        return new FunctionQueryColumn("LENGTH", new String[]{columnS});
    }

    public static QueryColumn length(QueryColumn columnS) {
        return new FunctionQueryColumn("LENGTH", columnS);
    }

    public static <T> QueryColumn length(LambdaGetter<T> columnS) {
        return new FunctionQueryColumn("LENGTH", LambdaUtil.getQueryColumn(columnS));
    }

    public static QueryColumn concat(String columnS1, String columnS2, String ... columnN) {
        return new FunctionQueryColumn("CONCAT", ArrayUtil.concat(new String[]{columnS1, columnS2}, columnN));
    }

    public static QueryColumn concat(QueryColumn columnS1, QueryColumn columnS2, QueryColumn ... columnN) {
        return new FunctionQueryColumn("CONCAT", ArrayUtil.concat(new QueryColumn[]{columnS1, columnS2}, columnN));
    }

    public static QueryColumn concatWs(String columnX, String columnS1, String columnS2, String ... columnN) {
        return new FunctionQueryColumn("CONCAT_WS", ArrayUtil.concat(new String[]{columnX, columnS1, columnS2}, columnN));
    }

    public static QueryColumn concatWs(QueryColumn columnX, QueryColumn columnS1, QueryColumn columnS2, QueryColumn ... columnN) {
        return new FunctionQueryColumn("CONCAT_WS", ArrayUtil.concat(new QueryColumn[]{columnX, columnS1, columnS2}, columnN));
    }

    public static QueryColumn insert(String columnS1, String columnX, String columnLen, String columnS2) {
        return new FunctionQueryColumn("INSERT", columnS1, columnX, columnLen, columnS2);
    }

    public static QueryColumn insert(QueryColumn columnS1, QueryColumn columnX, QueryColumn columnLen, QueryColumn columnS2) {
        return new FunctionQueryColumn("INSERT", columnS1, columnX, columnLen, columnS2);
    }

    public static QueryColumn upper(String columnS) {
        return new FunctionQueryColumn("UPPER", new String[]{columnS});
    }

    public static QueryColumn upper(QueryColumn columnS) {
        return new FunctionQueryColumn("UPPER", columnS);
    }

    public static <T> QueryColumn upper(LambdaGetter<T> columnS) {
        return new FunctionQueryColumn("UPPER", LambdaUtil.getQueryColumn(columnS));
    }

    public static QueryColumn lower(String columnS) {
        return new FunctionQueryColumn("LOWER", new String[]{columnS});
    }

    public static QueryColumn lower(QueryColumn columnS) {
        return new FunctionQueryColumn("LOWER", columnS);
    }

    public static <T> QueryColumn lower(LambdaGetter<T> columnS) {
        return new FunctionQueryColumn("LOWER", LambdaUtil.getQueryColumn(columnS));
    }

    public static QueryColumn left(String columnS, int length) {
        return new FunctionQueryColumn("LEFT", QueryMethods.string(columnS), QueryMethods.number(length));
    }

    public static QueryColumn left(QueryColumn columnS, int length) {
        return new FunctionQueryColumn("LEFT", columnS, QueryMethods.number(length));
    }

    public static <S, N> QueryColumn left(LambdaGetter<S> columnS, int length) {
        return new FunctionQueryColumn("LEFT", LambdaUtil.getQueryColumn(columnS), QueryMethods.number(length));
    }

    public static QueryColumn right(String columnS, int length) {
        return new FunctionQueryColumn("RIGHT", QueryMethods.string(columnS), QueryMethods.number(length));
    }

    public static QueryColumn right(QueryColumn columnS, int length) {
        return new FunctionQueryColumn("RIGHT", columnS, QueryMethods.number(length));
    }

    public static <S, N> QueryColumn right(LambdaGetter<S> columnS, int length) {
        return new FunctionQueryColumn("RIGHT", LambdaUtil.getQueryColumn(columnS), QueryMethods.number(length));
    }

    public static QueryColumn lpad(String columnS1, String columnLen, String columnS2) {
        return new FunctionQueryColumn("LPAD", new String[]{columnS1, columnLen, columnS2});
    }

    public static QueryColumn lpad(QueryColumn columnS1, QueryColumn columnLen, QueryColumn columnS2) {
        return new FunctionQueryColumn("LPAD", columnS1, columnLen, columnS2);
    }

    public static <S1, L, S2> QueryColumn lpad(LambdaGetter<S1> columnS1, LambdaGetter<L> columnLen, LambdaGetter<S2> columnS2) {
        return new FunctionQueryColumn("LPAD", LambdaUtil.getQueryColumn(columnS1), LambdaUtil.getQueryColumn(columnLen), LambdaUtil.getQueryColumn(columnS2));
    }

    public static QueryColumn rpad(String columnS1, String columnLen, String columnS2) {
        return new FunctionQueryColumn("RPAD", new String[]{columnS1, columnLen, columnS2});
    }

    public static QueryColumn rpad(QueryColumn columnS1, QueryColumn columnLen, QueryColumn columnS2) {
        return new FunctionQueryColumn("RPAD", columnS1, columnLen, columnS2);
    }

    public static <S1, L, S2> QueryColumn rpad(LambdaGetter<S1> columnS1, LambdaGetter<L> columnLen, LambdaGetter<S2> columnS2) {
        return new FunctionQueryColumn("RPAD", LambdaUtil.getQueryColumn(columnS1), LambdaUtil.getQueryColumn(columnLen), LambdaUtil.getQueryColumn(columnS2));
    }

    public static QueryColumn ltrim(String columnS) {
        return new FunctionQueryColumn("LTRIM", new String[]{columnS});
    }

    public static QueryColumn ltrim(QueryColumn columnS) {
        return new FunctionQueryColumn("LTRIM", columnS);
    }

    public static <T> QueryColumn ltrim(LambdaGetter<T> columnS) {
        return new FunctionQueryColumn("LTRIM", LambdaUtil.getQueryColumn(columnS));
    }

    public static QueryColumn rtrim(String columnS) {
        return new FunctionQueryColumn("RTRIM", new String[]{columnS});
    }

    public static QueryColumn rtrim(QueryColumn columnS) {
        return new FunctionQueryColumn("RTRIM", columnS);
    }

    public static <T> QueryColumn rtrim(LambdaGetter<T> columnS) {
        return new FunctionQueryColumn("RTRIM", LambdaUtil.getQueryColumn(columnS));
    }

    public static QueryColumn trim(QueryColumn columnS) {
        return new FunctionQueryColumn("TRIM", columnS);
    }

    public static QueryColumn repeat(String columnS, String columnN) {
        return new FunctionQueryColumn("REPEAT", new String[]{columnS, columnN});
    }

    public static QueryColumn repeat(QueryColumn columnS, QueryColumn columnN) {
        return new FunctionQueryColumn("REPEAT", columnS, columnN);
    }

    public static <S, N> QueryColumn repeat(LambdaGetter<S> columnS, LambdaGetter<N> columnN) {
        return new FunctionQueryColumn("REPEAT", LambdaUtil.getQueryColumn(columnS), LambdaUtil.getQueryColumn(columnN));
    }

    public static QueryColumn repeat(String columnX, Integer n) {
        return new FunctionQueryColumn("REPEAT", new QueryColumn(columnX), QueryMethods.number(n));
    }

    public static QueryColumn repeat(QueryColumn columnX, Integer n) {
        return new FunctionQueryColumn("REPEAT", columnX, QueryMethods.number(n));
    }

    public static <T> QueryColumn repeat(LambdaGetter<T> columnX, Integer n) {
        return new FunctionQueryColumn("REPEAT", LambdaUtil.getQueryColumn(columnX), QueryMethods.number(n));
    }

    public static QueryColumn space(String columnN) {
        return new FunctionQueryColumn("SPACE", new String[]{columnN});
    }

    public static QueryColumn space(QueryColumn columnN) {
        return new FunctionQueryColumn("SPACE", columnN);
    }

    public static <T> QueryColumn space(LambdaGetter<T> columnN) {
        return new FunctionQueryColumn("SPACE", LambdaUtil.getQueryColumn(columnN));
    }

    public static QueryColumn replace(String columnS, String columnS1, String columnS2) {
        return new StringFunctionQueryColumn("REPLACE", new String[]{columnS, columnS1, columnS2});
    }

    public static QueryColumn replace(QueryColumn columnS, QueryColumn columnS1, QueryColumn columnS2) {
        return new FunctionQueryColumn("REPLACE", columnS, columnS1, columnS2);
    }

    public static <S, S1, S2> QueryColumn replace(LambdaGetter<S> columnS, LambdaGetter<S1> columnS1, LambdaGetter<S2> columnS2) {
        return new FunctionQueryColumn("REPLACE", LambdaUtil.getQueryColumn(columnS), LambdaUtil.getQueryColumn(columnS1), LambdaUtil.getQueryColumn(columnS2));
    }

    public static QueryColumn strcmp(String columnS1, String columnS2) {
        return new FunctionQueryColumn("STRCMP", new String[]{columnS1, columnS2});
    }

    public static QueryColumn strcmp(QueryColumn columnS1, QueryColumn columnS2) {
        return new FunctionQueryColumn("STRCMP", columnS1, columnS2);
    }

    public static <S1, S2> QueryColumn strcmp(LambdaGetter<S1> columnS1, LambdaGetter<S2> columnS2) {
        return new FunctionQueryColumn("STRCMP", LambdaUtil.getQueryColumn(columnS1), LambdaUtil.getQueryColumn(columnS2));
    }

    public static QueryColumn substring(String columnS, int position) {
        return new FunctionQueryColumn("SUBSTRING", QueryMethods.string(columnS), QueryMethods.number(position));
    }

    public static QueryColumn substring(QueryColumn columnS, int position) {
        return new FunctionQueryColumn("SUBSTRING", columnS, QueryMethods.number(position));
    }

    public static <S, N, L> QueryColumn substring(LambdaGetter<S> columnS, int position) {
        return new FunctionQueryColumn("SUBSTRING", LambdaUtil.getQueryColumn(columnS), QueryMethods.number(position));
    }

    public static QueryColumn substring(String columnS, int position, int length) {
        return new FunctionQueryColumn("SUBSTRING", QueryMethods.string(columnS), QueryMethods.number(position), QueryMethods.number(length));
    }

    public static QueryColumn substring(QueryColumn columnS, int position, int length) {
        return new FunctionQueryColumn("SUBSTRING", columnS, QueryMethods.number(position), QueryMethods.number(length));
    }

    public static <S, N, L> QueryColumn substring(LambdaGetter<S> columnS, int position, int length) {
        return new FunctionQueryColumn("SUBSTRING", LambdaUtil.getQueryColumn(columnS), QueryMethods.number(position), QueryMethods.number(length));
    }

    public static QueryColumn instr(String columnS, String columnS1) {
        return new FunctionQueryColumn("INSTR", new String[]{columnS, columnS1});
    }

    public static QueryColumn instr(QueryColumn columnS, QueryColumn columnS1) {
        return new FunctionQueryColumn("INSTR", columnS, columnS1);
    }

    public static <S, S1> QueryColumn instr(LambdaGetter<S> columnS, LambdaGetter<S1> columnS1) {
        return new FunctionQueryColumn("INSTR", LambdaUtil.getQueryColumn(columnS), LambdaUtil.getQueryColumn(columnS1));
    }

    public static QueryColumn reverse(String columnS) {
        return new FunctionQueryColumn("REVERSE", new String[]{columnS});
    }

    public static QueryColumn reverse(QueryColumn columnS) {
        return new FunctionQueryColumn("REVERSE", columnS);
    }

    public static <T> QueryColumn reverse(LambdaGetter<T> columnS) {
        return new FunctionQueryColumn("REVERSE", LambdaUtil.getQueryColumn(columnS));
    }

    public static QueryColumn elt(String columnN, String columnS1, String ... columnSn) {
        return new FunctionQueryColumn("ELT", ArrayUtil.concat(new String[]{columnN, columnS1}, columnSn));
    }

    public static QueryColumn elt(QueryColumn columnN, QueryColumn columnS1, QueryColumn ... columnSn) {
        return new FunctionQueryColumn("ELT", ArrayUtil.concat(new QueryColumn[]{columnN, columnS1}, columnSn));
    }

    public static QueryColumn field(String columnS, String columnS1, String ... columnSn) {
        return new FunctionQueryColumn("FIELD", ArrayUtil.concat(new String[]{columnS, columnS1}, columnSn));
    }

    public static QueryColumn field(QueryColumn columnS, QueryColumn columnS1, QueryColumn ... columnSn) {
        return new FunctionQueryColumn("FIELD", ArrayUtil.concat(new QueryColumn[]{columnS, columnS1}, columnSn));
    }

    public static QueryColumn findInSet(String columnS1, String columnS2) {
        return new FunctionQueryColumn("FIND_IN_SET", new String[]{columnS1, columnS2});
    }

    public static QueryColumn findInSet(QueryColumn columnS1, QueryColumn columnS2) {
        return new FunctionQueryColumn("FIND_IN_SET", columnS1, columnS2);
    }

    public static <S1, S2> QueryColumn findInSet(LambdaGetter<S1> columnS1, LambdaGetter<S2> columnS2) {
        return new FunctionQueryColumn("FIND_IN_SET", LambdaUtil.getQueryColumn(columnS1), LambdaUtil.getQueryColumn(columnS2));
    }

    public static QueryColumn curDate() {
        return new FunctionQueryColumn("CURDATE");
    }

    public static QueryColumn currentDate() {
        return new FunctionQueryColumn("CURRENT_DATE");
    }

    public static QueryColumn curTime() {
        return new FunctionQueryColumn("CURTIME");
    }

    public static QueryColumn currentTime() {
        return new FunctionQueryColumn("CURRENT_TIME");
    }

    public static QueryColumn now() {
        return new FunctionQueryColumn("NOW");
    }

    public static QueryColumn currentTimestamp() {
        return new FunctionQueryColumn("CURRENT_TIMESTAMP");
    }

    public static QueryColumn localTime() {
        return new FunctionQueryColumn("LOCALTIME");
    }

    public static QueryColumn sysDate() {
        return new FunctionQueryColumn("SYSDATE");
    }

    public static QueryColumn localTimestamp() {
        return new FunctionQueryColumn("LOCALTIMESTAMP");
    }

    public static QueryColumn unixTimestamp() {
        return new FunctionQueryColumn("UNIX_TIMESTAMP");
    }

    public static QueryColumn unixTimestamp(String columnD) {
        return new FunctionQueryColumn("UNIX_TIMESTAMP", new String[]{columnD});
    }

    public static QueryColumn unixTimestamp(QueryColumn columnD) {
        return new FunctionQueryColumn("UNIX_TIMESTAMP", columnD);
    }

    public static <T> QueryColumn unixTimestamp(LambdaGetter<T> columnD) {
        return new FunctionQueryColumn("UNIX_TIMESTAMP", LambdaUtil.getQueryColumn(columnD));
    }

    public static QueryColumn fromUnixTime(String columnD) {
        return new FunctionQueryColumn("FROM_UNIXTIME", new String[]{columnD});
    }

    public static QueryColumn fromUnixTime(QueryColumn columnD) {
        return new FunctionQueryColumn("FROM_UNIXTIME", columnD);
    }

    public static <T> QueryColumn fromUnixTime(LambdaGetter<T> columnD) {
        return new FunctionQueryColumn("FROM_UNIXTIME", LambdaUtil.getQueryColumn(columnD));
    }

    public static QueryColumn utcDate() {
        return new FunctionQueryColumn("UTC_DATE");
    }

    public static QueryColumn utcTime() {
        return new FunctionQueryColumn("UTC_TIME");
    }

    public static QueryColumn month(String columnD) {
        return new FunctionQueryColumn("MONTH", new String[]{columnD});
    }

    public static QueryColumn month(QueryColumn columnD) {
        return new FunctionQueryColumn("MONTH", columnD);
    }

    public static <T> QueryColumn month(LambdaGetter<T> columnD) {
        return new FunctionQueryColumn("MONTH", LambdaUtil.getQueryColumn(columnD));
    }

    public static QueryColumn monthName(String columnD) {
        return new FunctionQueryColumn("MONTHNAME", new String[]{columnD});
    }

    public static QueryColumn monthName(QueryColumn columnD) {
        return new FunctionQueryColumn("MONTHNAME", columnD);
    }

    public static <T> QueryColumn monthName(LambdaGetter<T> columnD) {
        return new FunctionQueryColumn("MONTHNAME", LambdaUtil.getQueryColumn(columnD));
    }

    public static QueryColumn dayName(String columnD) {
        return new FunctionQueryColumn("DAYNAME", new String[]{columnD});
    }

    public static QueryColumn dayName(QueryColumn columnD) {
        return new FunctionQueryColumn("DAYNAME", columnD);
    }

    public static <T> QueryColumn dayName(LambdaGetter<T> columnD) {
        return new FunctionQueryColumn("DAYNAME", LambdaUtil.getQueryColumn(columnD));
    }

    public static QueryColumn dayOfWeek(String columnD) {
        return new FunctionQueryColumn("DAYOFWEEK", new String[]{columnD});
    }

    public static QueryColumn dayOfWeek(QueryColumn columnD) {
        return new FunctionQueryColumn("DAYOFWEEK", columnD);
    }

    public static <T> QueryColumn dayOfWeek(LambdaGetter<T> columnD) {
        return new FunctionQueryColumn("DAYOFWEEK", LambdaUtil.getQueryColumn(columnD));
    }

    public static QueryColumn weekday(String columnD) {
        return new FunctionQueryColumn("WEEKDAY", new String[]{columnD});
    }

    public static QueryColumn weekday(QueryColumn columnD) {
        return new FunctionQueryColumn("WEEKDAY", columnD);
    }

    public static <T> QueryColumn weekday(LambdaGetter<T> columnD) {
        return new FunctionQueryColumn("WEEKDAY", LambdaUtil.getQueryColumn(columnD));
    }

    public static QueryColumn week(String columnD) {
        return new FunctionQueryColumn("WEEK", new String[]{columnD});
    }

    public static QueryColumn week(QueryColumn columnD) {
        return new FunctionQueryColumn("WEEK", columnD);
    }

    public static <T> QueryColumn week(LambdaGetter<T> columnD) {
        return new FunctionQueryColumn("WEEK", LambdaUtil.getQueryColumn(columnD));
    }

    public static QueryColumn weekOfYear(String columnD) {
        return new FunctionQueryColumn("WEEKOFYEAR", new String[]{columnD});
    }

    public static QueryColumn weekOfYear(QueryColumn columnD) {
        return new FunctionQueryColumn("WEEKOFYEAR", columnD);
    }

    public static <T> QueryColumn weekOfYear(LambdaGetter<T> columnD) {
        return new FunctionQueryColumn("WEEKOFYEAR", LambdaUtil.getQueryColumn(columnD));
    }

    public static QueryColumn dayOfYear(String columnD) {
        return new FunctionQueryColumn("DAYOFYEAR", new String[]{columnD});
    }

    public static QueryColumn dayOfYear(QueryColumn columnD) {
        return new FunctionQueryColumn("DAYOFYEAR", columnD);
    }

    public static <T> QueryColumn dayOfYear(LambdaGetter<T> columnD) {
        return new FunctionQueryColumn("DAYOFYEAR", LambdaUtil.getQueryColumn(columnD));
    }

    public static QueryColumn dayOfMonth(String columnD) {
        return new FunctionQueryColumn("DAYOFMONTH", new String[]{columnD});
    }

    public static QueryColumn dayOfMonth(QueryColumn columnD) {
        return new FunctionQueryColumn("DAYOFMONTH", columnD);
    }

    public static <T> QueryColumn dayOfMonth(LambdaGetter<T> columnD) {
        return new FunctionQueryColumn("DAYOFMONTH", LambdaUtil.getQueryColumn(columnD));
    }

    public static QueryColumn year(String columnD) {
        return new FunctionQueryColumn("YEAR", new String[]{columnD});
    }

    public static QueryColumn year(QueryColumn columnD) {
        return new FunctionQueryColumn("YEAR", columnD);
    }

    public static <T> QueryColumn year(LambdaGetter<T> columnD) {
        return new FunctionQueryColumn("YEAR", LambdaUtil.getQueryColumn(columnD));
    }

    public static FunctionQueryColumn day(String columnD) {
        return new FunctionQueryColumn("DAY", new String[]{columnD});
    }

    public static FunctionQueryColumn day(QueryColumn columnD) {
        return new FunctionQueryColumn("DAY", columnD);
    }

    public static <T> FunctionQueryColumn day(LambdaGetter<T> columnD) {
        return new FunctionQueryColumn("DAY", LambdaUtil.getQueryColumn(columnD));
    }

    public static QueryColumn quarter(String columnD) {
        return new FunctionQueryColumn("QUARTER", new String[]{columnD});
    }

    public static QueryColumn quarter(QueryColumn columnD) {
        return new FunctionQueryColumn("QUARTER", columnD);
    }

    public static <T> QueryColumn quarter(LambdaGetter<T> columnD) {
        return new FunctionQueryColumn("QUARTER", LambdaUtil.getQueryColumn(columnD));
    }

    public static QueryColumn hour(String columnT) {
        return new FunctionQueryColumn("HOUR", new String[]{columnT});
    }

    public static QueryColumn hour(QueryColumn columnT) {
        return new FunctionQueryColumn("HOUR", columnT);
    }

    public static <T> QueryColumn hour(LambdaGetter<T> columnT) {
        return new FunctionQueryColumn("HOUR", LambdaUtil.getQueryColumn(columnT));
    }

    public static QueryColumn minute(String columnT) {
        return new FunctionQueryColumn("MINUTE", new String[]{columnT});
    }

    public static QueryColumn minute(QueryColumn columnT) {
        return new FunctionQueryColumn("MINUTE", columnT);
    }

    public static <T> QueryColumn minute(LambdaGetter<T> columnT) {
        return new FunctionQueryColumn("MINUTE", LambdaUtil.getQueryColumn(columnT));
    }

    public static QueryColumn second(String columnT) {
        return new FunctionQueryColumn("SECOND", new String[]{columnT});
    }

    public static QueryColumn second(QueryColumn columnT) {
        return new FunctionQueryColumn("SECOND", columnT);
    }

    public static <T> QueryColumn second(LambdaGetter<T> columnT) {
        return new FunctionQueryColumn("SECOND", LambdaUtil.getQueryColumn(columnT));
    }

    public static QueryColumn timeToSec(String columnT) {
        return new FunctionQueryColumn("TIME_TO_SEC", new String[]{columnT});
    }

    public static QueryColumn timeToSec(QueryColumn columnT) {
        return new FunctionQueryColumn("TIME_TO_SEC", columnT);
    }

    public static <T> QueryColumn timeToSec(LambdaGetter<T> columnT) {
        return new FunctionQueryColumn("TIME_TO_SEC", LambdaUtil.getQueryColumn(columnT));
    }

    public static QueryColumn secToTime(String columnS) {
        return new FunctionQueryColumn("SEC_TO_TIME", new String[]{columnS});
    }

    public static QueryColumn secToTime(QueryColumn columnS) {
        return new FunctionQueryColumn("SEC_TO_TIME", columnS);
    }

    public static <T> QueryColumn secToTime(LambdaGetter<T> columnS) {
        return new FunctionQueryColumn("SEC_TO_TIME", LambdaUtil.getQueryColumn(columnS));
    }

    public static QueryColumn toDays(String columnD) {
        return new FunctionQueryColumn("TO_DAYS", new String[]{columnD});
    }

    public static QueryColumn toDays(QueryColumn columnD) {
        return new FunctionQueryColumn("TO_DAYS", columnD);
    }

    public static <T> QueryColumn toDays(LambdaGetter<T> columnD) {
        return new FunctionQueryColumn("TO_DAYS", LambdaUtil.getQueryColumn(columnD));
    }

    public static QueryColumn fromDays(String columnD) {
        return new FunctionQueryColumn("FROM_DAYS", new String[]{columnD});
    }

    public static QueryColumn fromDays(QueryColumn columnD) {
        return new FunctionQueryColumn("FROM_DAYS", columnD);
    }

    public static <T> QueryColumn fromDays(LambdaGetter<T> columnD) {
        return new FunctionQueryColumn("FROM_DAYS", LambdaUtil.getQueryColumn(columnD));
    }

    public static QueryColumn dateDiff(String columnD1, String columnD2) {
        return new FunctionQueryColumn("DATEDIFF", new String[]{columnD1, columnD2});
    }

    public static QueryColumn dateDiff(QueryColumn columnD1, QueryColumn columnD2) {
        return new FunctionQueryColumn("DATEDIFF", columnD1, columnD2);
    }

    public static <D1, D2> QueryColumn dateDiff(LambdaGetter<D1> columnD1, LambdaGetter<D2> columnD2) {
        return new FunctionQueryColumn("DATEDIFF", LambdaUtil.getQueryColumn(columnD1), LambdaUtil.getQueryColumn(columnD2));
    }

    public static QueryColumn addDate(String columnD, String columnN) {
        return new FunctionQueryColumn("ADDDATE", new String[]{columnD, columnN});
    }

    public static QueryColumn addDate(QueryColumn columnD, QueryColumn columnN) {
        return new FunctionQueryColumn("ADDDATE", columnD, columnN);
    }

    public static <D, N> QueryColumn addDate(LambdaGetter<D> columnD, LambdaGetter<N> columnN) {
        return new FunctionQueryColumn("ADDDATE", LambdaUtil.getQueryColumn(columnD), LambdaUtil.getQueryColumn(columnN));
    }

    public static QueryColumn subDate(String columnD, String columnN) {
        return new FunctionQueryColumn("SUBDATE", new String[]{columnD, columnN});
    }

    public static QueryColumn subDate(QueryColumn columnD, QueryColumn columnN) {
        return new FunctionQueryColumn("SUBDATE", columnD, columnN);
    }

    public static <D, N> QueryColumn subDate(LambdaGetter<D> columnD, LambdaGetter<N> columnN) {
        return new FunctionQueryColumn("SUBDATE", LambdaUtil.getQueryColumn(columnD), LambdaUtil.getQueryColumn(columnN));
    }

    public static QueryColumn addTime(String columnT, String columnN) {
        return new FunctionQueryColumn("ADDTIME", new String[]{columnT, columnN});
    }

    public static QueryColumn addTime(QueryColumn columnT, QueryColumn columnN) {
        return new FunctionQueryColumn("ADDTIME", columnT, columnN);
    }

    public static <T, N> QueryColumn addTime(LambdaGetter<T> columnT, LambdaGetter<N> columnN) {
        return new FunctionQueryColumn("ADDTIME", LambdaUtil.getQueryColumn(columnT), LambdaUtil.getQueryColumn(columnN));
    }

    public static QueryColumn subTime(String columnT, String columnN) {
        return new FunctionQueryColumn("SUBTIME", new String[]{columnT, columnN});
    }

    public static QueryColumn subTime(QueryColumn columnT, QueryColumn columnN) {
        return new FunctionQueryColumn("SUBTIME", columnT, columnN);
    }

    public static <T, N> QueryColumn subTime(LambdaGetter<T> columnT, LambdaGetter<N> columnN) {
        return new FunctionQueryColumn("SUBTIME", LambdaUtil.getQueryColumn(columnT), LambdaUtil.getQueryColumn(columnN));
    }

    public static QueryColumn dateFormat(String columnD, String format) {
        return new FunctionQueryColumn("DATE_FORMAT", QueryMethods.string(columnD), QueryMethods.string(format));
    }

    public static QueryColumn dateFormat(QueryColumn columnD, String format) {
        return new FunctionQueryColumn("DATE_FORMAT", columnD, QueryMethods.string(format));
    }

    public static <D, F> QueryColumn dateFormat(LambdaGetter<D> columnD, String format) {
        return new FunctionQueryColumn("DATE_FORMAT", LambdaUtil.getQueryColumn(columnD), QueryMethods.string(format));
    }

    public static QueryColumn timeFormat(String columnT, String columnF) {
        return new FunctionQueryColumn("TIME_FORMAT", new String[]{columnT, columnF});
    }

    public static QueryColumn timeFormat(QueryColumn columnT, QueryColumn columnF) {
        return new FunctionQueryColumn("TIME_FORMAT", columnT, columnF);
    }

    public static <T, F> QueryColumn timeFormat(LambdaGetter<T> columnT, LambdaGetter<F> columnF) {
        return new FunctionQueryColumn("TIME_FORMAT", LambdaUtil.getQueryColumn(columnT), LambdaUtil.getQueryColumn(columnF));
    }

    public static QueryColumn getFormat(String columnType, String columnS) {
        return new FunctionQueryColumn("GET_FORMAT", new String[]{columnType, columnS});
    }

    public static QueryColumn getFormat(QueryColumn columnType, QueryColumn columnS) {
        return new FunctionQueryColumn("GET_FORMAT", columnType, columnS);
    }

    public static <T, S> QueryColumn getFormat(LambdaGetter<T> columnType, LambdaGetter<S> columnS) {
        return new FunctionQueryColumn("GET_FORMAT", LambdaUtil.getQueryColumn(columnType), LambdaUtil.getQueryColumn(columnS));
    }

    public static QueryColumn version() {
        return new FunctionQueryColumn("VERSION");
    }

    public static QueryColumn connectionId() {
        return new FunctionQueryColumn("CONNECTION_ID");
    }

    public static QueryColumn database() {
        return new FunctionQueryColumn("DATABASE");
    }

    public static QueryColumn schema() {
        return new FunctionQueryColumn("SCHEMA");
    }

    public static QueryColumn user() {
        return new FunctionQueryColumn("USER");
    }

    public static QueryColumn charset(String columnStr) {
        return new FunctionQueryColumn("CHARSET", new String[]{columnStr});
    }

    public static QueryColumn charset(QueryColumn columnStr) {
        return new FunctionQueryColumn("CHARSET", columnStr);
    }

    public static <T> QueryColumn charset(LambdaGetter<T> columnStr) {
        return new FunctionQueryColumn("CHARSET", LambdaUtil.getQueryColumn(columnStr));
    }

    public static QueryColumn collation(String columnStr) {
        return new FunctionQueryColumn("COLLATION", new String[]{columnStr});
    }

    public static QueryColumn collation(QueryColumn columnStr) {
        return new FunctionQueryColumn("COLLATION", columnStr);
    }

    public static <T> QueryColumn collation(LambdaGetter<T> columnStr) {
        return new FunctionQueryColumn("COLLATION", LambdaUtil.getQueryColumn(columnStr));
    }

    public static QueryColumn lastInsertId() {
        return new FunctionQueryColumn("LAST_INSERT_ID");
    }

    public static QueryColumn password(String columnStr) {
        return new FunctionQueryColumn("PASSWORD", new String[]{columnStr});
    }

    public static QueryColumn password(QueryColumn columnStr) {
        return new FunctionQueryColumn("PASSWORD", columnStr);
    }

    public static <T> QueryColumn password(LambdaGetter<T> columnStr) {
        return new FunctionQueryColumn("PASSWORD", LambdaUtil.getQueryColumn(columnStr));
    }

    public static QueryColumn md5(String columnStr) {
        return new FunctionQueryColumn("MD5", new String[]{columnStr});
    }

    public static QueryColumn md5(QueryColumn columnStr) {
        return new FunctionQueryColumn("MD5", columnStr);
    }

    public static <T> QueryColumn md5(LambdaGetter<T> columnStr) {
        return new FunctionQueryColumn("MD5", LambdaUtil.getQueryColumn(columnStr));
    }

    public static QueryColumn encode(String columnStr, String columnPswdStr) {
        return new FunctionQueryColumn("ENCODE", new String[]{columnStr, columnPswdStr});
    }

    public static QueryColumn encode(QueryColumn columnStr, QueryColumn columnPswdStr) {
        return new FunctionQueryColumn("ENCODE", columnStr, columnPswdStr);
    }

    public static <S, P> QueryColumn encode(LambdaGetter<S> columnStr, LambdaGetter<P> columnPswdStr) {
        return new FunctionQueryColumn("ENCODE", LambdaUtil.getQueryColumn(columnStr), LambdaUtil.getQueryColumn(columnPswdStr));
    }

    public static QueryColumn decode(String columnCryptStr, String columnPswdStr) {
        return new FunctionQueryColumn("DECODE", new String[]{columnCryptStr, columnPswdStr});
    }

    public static QueryColumn decode(QueryColumn columnCryptStr, QueryColumn columnPswdStr) {
        return new FunctionQueryColumn("DECODE", columnCryptStr, columnPswdStr);
    }

    public static <C, P> QueryColumn decode(LambdaGetter<C> columnCryptStr, LambdaGetter<P> columnPswdStr) {
        return new FunctionQueryColumn("DECODE", LambdaUtil.getQueryColumn(columnCryptStr), LambdaUtil.getQueryColumn(columnPswdStr));
    }

    public static QueryColumn format(String columnX, String columnN) {
        return new FunctionQueryColumn("FORMAT", new String[]{columnX, columnN});
    }

    public static QueryColumn format(QueryColumn columnX, QueryColumn columnN) {
        return new FunctionQueryColumn("FORMAT", columnX, columnN);
    }

    public static <X, N> QueryColumn format(LambdaGetter<X> columnX, LambdaGetter<N> columnN) {
        return new FunctionQueryColumn("FORMAT", LambdaUtil.getQueryColumn(columnX), LambdaUtil.getQueryColumn(columnN));
    }

    public static QueryColumn ascii(String columnS) {
        return new FunctionQueryColumn("ASCII", new String[]{columnS});
    }

    public static QueryColumn ascii(QueryColumn columnS) {
        return new FunctionQueryColumn("ASCII", columnS);
    }

    public static <T> QueryColumn ascii(LambdaGetter<T> columnS) {
        return new FunctionQueryColumn("ASCII", LambdaUtil.getQueryColumn(columnS));
    }

    public static QueryColumn bin(String columnX) {
        return new FunctionQueryColumn("BIN", new String[]{columnX});
    }

    public static QueryColumn bin(QueryColumn columnX) {
        return new FunctionQueryColumn("BIN", columnX);
    }

    public static <T> QueryColumn bin(LambdaGetter<T> columnX) {
        return new FunctionQueryColumn("BIN", LambdaUtil.getQueryColumn(columnX));
    }

    public static QueryColumn hex(String columnX) {
        return new FunctionQueryColumn("HEX", new String[]{columnX});
    }

    public static QueryColumn hex(QueryColumn columnX) {
        return new FunctionQueryColumn("HEX", columnX);
    }

    public static <T> QueryColumn hex(LambdaGetter<T> columnX) {
        return new FunctionQueryColumn("HEX", LambdaUtil.getQueryColumn(columnX));
    }

    public static QueryColumn oct(String columnX) {
        return new FunctionQueryColumn("OCT", new String[]{columnX});
    }

    public static QueryColumn oct(QueryColumn columnX) {
        return new FunctionQueryColumn("OCT", columnX);
    }

    public static <T> QueryColumn oct(LambdaGetter<T> columnX) {
        return new FunctionQueryColumn("OCT", LambdaUtil.getQueryColumn(columnX));
    }

    public static QueryColumn conv(String columnX, String columnF1, String columnF2) {
        return new FunctionQueryColumn("CONV", new String[]{columnX, columnF1, columnF2});
    }

    public static QueryColumn conv(QueryColumn columnX, QueryColumn columnF1, QueryColumn columnF2) {
        return new FunctionQueryColumn("CONV", columnX, columnF1, columnF2);
    }

    public static <X, F1, F2> QueryColumn conv(LambdaGetter<X> columnX, LambdaGetter<F1> columnF1, LambdaGetter<F2> columnF2) {
        return new FunctionQueryColumn("CONV", LambdaUtil.getQueryColumn(columnX), LambdaUtil.getQueryColumn(columnF1), LambdaUtil.getQueryColumn(columnF2));
    }

    public static QueryColumn inetAton(String columnIP) {
        return new FunctionQueryColumn("INET_ATON", new String[]{columnIP});
    }

    public static QueryColumn inetAton(QueryColumn columnIP) {
        return new FunctionQueryColumn("INET_ATON", columnIP);
    }

    public static <T> QueryColumn inetAton(LambdaGetter<T> columnIP) {
        return new FunctionQueryColumn("INET_ATON", LambdaUtil.getQueryColumn(columnIP));
    }

    public static QueryColumn inetNtoa(String columnN) {
        return new FunctionQueryColumn("INET_NTOA", new String[]{columnN});
    }

    public static QueryColumn inetNtoa(QueryColumn columnN) {
        return new FunctionQueryColumn("INET_NTOA", columnN);
    }

    public static <T> QueryColumn inetNtoa(LambdaGetter<T> columnN) {
        return new FunctionQueryColumn("INET_NTOA", LambdaUtil.getQueryColumn(columnN));
    }

    public static FunctionQueryColumn max(String column) {
        return new FunctionQueryColumn("MAX", new String[]{column});
    }

    public static FunctionQueryColumn max(QueryColumn column) {
        return new FunctionQueryColumn("MAX", column);
    }

    public static <T> FunctionQueryColumn max(LambdaGetter<T> column) {
        return new FunctionQueryColumn("MAX", LambdaUtil.getQueryColumn(column));
    }

    public static FunctionQueryColumn min(String column) {
        return new FunctionQueryColumn("MIN", new String[]{column});
    }

    public static FunctionQueryColumn min(QueryColumn column) {
        return new FunctionQueryColumn("MIN", column);
    }

    public static <T> FunctionQueryColumn min(LambdaGetter<T> column) {
        return new FunctionQueryColumn("MIN", LambdaUtil.getQueryColumn(column));
    }

    public static FunctionQueryColumn avg(String column) {
        return new FunctionQueryColumn("AVG", new String[]{column});
    }

    public static FunctionQueryColumn avg(QueryColumn column) {
        return new FunctionQueryColumn("AVG", column);
    }

    public static <T> FunctionQueryColumn avg(LambdaGetter<T> column) {
        return new FunctionQueryColumn("AVG", LambdaUtil.getQueryColumn(column));
    }

    public static FunctionQueryColumn sum(String column) {
        return new FunctionQueryColumn("SUM", new String[]{column});
    }

    public static FunctionQueryColumn sum(QueryColumn column) {
        return new FunctionQueryColumn("SUM", column);
    }

    public static <T> FunctionQueryColumn sum(LambdaGetter<T> column) {
        return new FunctionQueryColumn("SUM", LambdaUtil.getQueryColumn(column));
    }

    public static FunctionQueryColumn count() {
        return new FunctionQueryColumn("COUNT", new RawQueryColumn((Object)"*", new Object[0]));
    }

    public static FunctionQueryColumn count(String column) {
        return new FunctionQueryColumn("COUNT", new String[]{column});
    }

    public static FunctionQueryColumn count(QueryColumn column) {
        return new FunctionQueryColumn("COUNT", column);
    }

    public static <T> FunctionQueryColumn count(LambdaGetter<T> column) {
        return new FunctionQueryColumn("COUNT", LambdaUtil.getQueryColumn(column));
    }

    public static DistinctQueryColumn distinct(QueryColumn ... columns) {
        return new DistinctQueryColumn(columns);
    }

    public static CaseQueryColumn.Builder case_() {
        return new CaseQueryColumn.Builder();
    }

    public static CaseSearchQueryColumn.Builder case_(QueryColumn column) {
        return new CaseSearchQueryColumn.Builder(column);
    }

    public static StringFunctionQueryColumn convert(String ... params) {
        return new StringFunctionQueryColumn("CONVERT", params);
    }

    public static QueryColumn true_() {
        return new RawQueryColumn((Object)"TRUE", new Object[0]);
    }

    public static QueryColumn false_() {
        return new RawQueryColumn((Object)"FALSE", new Object[0]);
    }

    public static QueryColumn null_() {
        return new RawQueryColumn((Object)"NULL", new Object[0]);
    }

    public static QueryColumn number(Number n) {
        return new RawQueryColumn(n, new Object[0]);
    }

    public static QueryColumn string(String s) {
        return new RawQueryColumn((Object)("'" + s + "'"), new Object[0]);
    }

    public static QueryColumn column(String column, Object ... params) {
        return new RawQueryColumn((Object)column, params);
    }

    public static QueryColumn column(String table, String column) {
        return new QueryColumn(table, column);
    }

    public static QueryColumn column(String schema, String table, String column) {
        return new QueryColumn(schema, table, column);
    }

    public static <T> QueryColumn column(LambdaGetter<T> column) {
        return LambdaUtil.getQueryColumn(column);
    }

    public static QueryColumn column(QueryWrapper queryWrapper) {
        return new SelectQueryColumn(queryWrapper);
    }

    public static QueryColumn allColumns() {
        return QueryMethods.column("*", new Object[0]);
    }

    public static Iterable<QueryColumn> allColumns(Class<?> ... classes) {
        ArrayList<QueryColumn> queryColumns = new ArrayList<QueryColumn>(classes.length);
        for (Class<?> aClass : classes) {
            TableInfo tableInfo = TableInfoFactory.ofEntityClass(aClass);
            QueryTable queryTable = new QueryTable(tableInfo.getSchema(), tableInfo.getTableName());
            queryColumns.add(new QueryColumn(queryTable, "*"));
        }
        return queryColumns;
    }

    public static Iterable<QueryColumn> defaultColumns(Class<?> ... classes) {
        ArrayList<QueryColumn> queryColumns = new ArrayList<QueryColumn>();
        for (Class<?> aClass : classes) {
            TableInfo tableInfo = TableInfoFactory.ofEntityClass(aClass);
            queryColumns.addAll(tableInfo.getDefaultQueryColumn());
        }
        return queryColumns;
    }

    public static QueryColumn if_(QueryCondition condition, String trueColumn, String falseColumn) {
        return new IfFunctionQueryColumn(condition, new QueryColumn(trueColumn), new QueryColumn(falseColumn));
    }

    public static QueryColumn if_(QueryCondition condition, QueryColumn trueColumn, QueryColumn falseColumn) {
        return new IfFunctionQueryColumn(condition, trueColumn, falseColumn);
    }

    public static <T, F> QueryColumn if_(QueryCondition condition, LambdaGetter<T> trueColumn, LambdaGetter<F> falseColumn) {
        return new IfFunctionQueryColumn(condition, LambdaUtil.getQueryColumn(trueColumn), LambdaUtil.getQueryColumn(falseColumn));
    }

    public static QueryColumn ifNull(String nullColumn, String elseColumn) {
        return new FunctionQueryColumn("IFNULL", new QueryColumn(nullColumn), new QueryColumn(elseColumn));
    }

    public static QueryColumn ifNull(QueryColumn nullColumn, QueryColumn elseColumn) {
        return new FunctionQueryColumn("IFNULL", nullColumn, elseColumn);
    }

    public static <N, E> QueryColumn ifNull(LambdaGetter<N> nullColumn, LambdaGetter<E> elseColumn) {
        return new FunctionQueryColumn("IFNULL", LambdaUtil.getQueryColumn(nullColumn), LambdaUtil.getQueryColumn(elseColumn));
    }

    public static <N> QueryColumn ifNull(LambdaGetter<N> nullColumn, QueryColumn elseColumn) {
        return QueryMethods.ifNull(LambdaUtil.getQueryColumn(nullColumn), elseColumn);
    }

    public static <N> QueryColumn ifNull(LambdaGetter<N> nullColumn, String elseColumn) {
        return QueryMethods.ifNull(nullColumn, new QueryColumn(elseColumn));
    }

    public static QueryCondition exists(QueryWrapper queryWrapper) {
        return new OperatorSelectCondition("EXISTS ", queryWrapper);
    }

    public static QueryCondition notExists(QueryWrapper queryWrapper) {
        return new OperatorSelectCondition("NOT EXISTS ", queryWrapper);
    }

    public static QueryCondition not(QueryCondition childCondition) {
        return new OperatorQueryCondition("NOT ", childCondition);
    }

    public static QueryCondition noCondition() {
        return QueryCondition.createEmpty();
    }

    public static QueryWrapper select(QueryColumn ... queryColumns) {
        return QueryMethods.newWrapper().select(queryColumns);
    }

    public static QueryWrapper union(QueryWrapper queryWrapper) {
        return QueryMethods.newWrapper().union(queryWrapper);
    }

    public static QueryWrapper selectOne() {
        return QueryMethods.select(QueryMethods.column("1", new Object[0]));
    }

    public static QueryWrapper selectCount() {
        return QueryMethods.select(QueryMethods.count());
    }

    public static QueryWrapper selectCountOne() {
        return QueryMethods.select(QueryMethods.count("1"));
    }

    private static QueryWrapper newWrapper() {
        return new QueryWrapper();
    }

    public static QueryCondition raw(String raw) {
        return new RawFragment(raw);
    }

    public static QueryCondition raw(String raw, Object ... params) {
        return new RawFragment(raw, params);
    }

    public static QueryColumn groupConcat(QueryColumn columnX) {
        return new FunctionQueryColumn("GROUP_CONCAT", columnX);
    }
}

