/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.transaction;

import com.mybatisflex.core.transaction.Propagation;
import com.mybatisflex.core.transaction.TransactionContext;
import com.mybatisflex.core.transaction.TransactionException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class TransactionalManager {
    private static final Log log = LogFactory.getLog(TransactionalManager.class);
    private static final ThreadLocal<Map<String, Map<String, Connection>>> CONNECTION_HOLDER = ThreadLocal.withInitial(ConcurrentHashMap::new);

    private TransactionalManager() {
    }

    public static void hold(String xid, String ds, Connection connection) {
        Map<String, Map<String, Connection>> holdMap = CONNECTION_HOLDER.get();
        Map<String, Connection> connMap = holdMap.get(xid);
        if (connMap == null) {
            connMap = new ConcurrentHashMap<String, Connection>();
            holdMap.put(xid, connMap);
        }
        if (connMap.containsKey(ds)) {
            return;
        }
        connMap.put(ds, connection);
    }

    public static <T> T exec(Supplier<T> supplier, Propagation propagation, boolean withResult) {
        String currentXID = TransactionContext.getXID();
        try {
            switch (propagation) {
                case REQUIRED: {
                    if (currentXID != null) {
                        T t = supplier.get();
                        return t;
                    }
                    T t = TransactionalManager.execNewTransactional(supplier, withResult);
                    return t;
                }
                case SUPPORTS: {
                    T t = supplier.get();
                    return t;
                }
                case MANDATORY: {
                    if (currentXID != null) {
                        T t = supplier.get();
                        return t;
                    }
                    throw new TransactionException("No existing transaction found for transaction marked with propagation 'mandatory'");
                }
                case REQUIRES_NEW: {
                    T t = TransactionalManager.execNewTransactional(supplier, withResult);
                    return t;
                }
                case NOT_SUPPORTED: {
                    if (currentXID != null) {
                        TransactionContext.release();
                    }
                    T t = supplier.get();
                    return t;
                }
                case NEVER: {
                    if (currentXID != null) {
                        throw new TransactionException("Existing transaction found for transaction marked with propagation 'never'");
                    }
                    T t = supplier.get();
                    return t;
                }
            }
            throw new TransactionException("Transaction manager does not allow nested transactions");
        }
        finally {
            if (currentXID != null) {
                TransactionContext.holdXID(currentXID);
            }
        }
    }

    private static <T> T execNewTransactional(Supplier<T> supplier, boolean withResult) {
        String xid = TransactionalManager.startTransactional();
        T result = null;
        boolean isRollback = false;
        try {
            result = supplier.get();
        }
        catch (Throwable e) {
            isRollback = true;
            TransactionalManager.rollback(xid);
            throw new TransactionException(e.getMessage(), e);
        }
        finally {
            if (!isRollback) {
                if (!withResult) {
                    if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
                        TransactionalManager.commit(xid);
                    } else {
                        TransactionalManager.rollback(xid);
                    }
                } else {
                    TransactionalManager.commit(xid);
                }
            }
        }
        return result;
    }

    public static Connection getConnection(String xid, String ds) {
        Map<String, Connection> connections = CONNECTION_HOLDER.get().get(xid);
        return connections == null || connections.isEmpty() ? null : connections.get(ds);
    }

    public static String startTransactional() {
        String xid = UUID.randomUUID().toString();
        TransactionContext.holdXID(xid);
        return xid;
    }

    public static void commit(String xid) {
        TransactionalManager.release(xid, true);
    }

    public static void rollback(String xid) {
        TransactionalManager.release(xid, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void release(String xid, boolean commit) {
        TransactionContext.release();
        Throwable exception = null;
        Map<String, Map<String, Connection>> holdMap = CONNECTION_HOLDER.get();
        try {
            if (holdMap.isEmpty()) {
                return;
            }
            Map<String, Connection> connections = holdMap.get(xid);
            for (Connection conn : connections.values()) {
                try {
                    if (commit) {
                        conn.commit();
                        continue;
                    }
                    conn.rollback();
                }
                catch (SQLException e) {
                    exception = e;
                }
                finally {
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        finally {
            holdMap.remove(xid);
            if (holdMap.isEmpty()) {
                CONNECTION_HOLDER.remove();
            }
            if (exception != null) {
                log.error("TransactionalManager.release() is error. cause: " + exception.getMessage(), exception);
            }
        }
    }
}

