/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.service;

import com.mybatisflex.core.BaseMapper;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.row.Db;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.SqlUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

public interface IService<T> {
    public static final int DEFAULT_BATCH_SIZE = 1000;

    public BaseMapper<T> getMapper();

    default public boolean save(T entity) {
        return SqlUtil.toBool(this.getMapper().insertSelective(entity));
    }

    default public boolean saveOrUpdate(T entity) {
        return SqlUtil.toBool(this.getMapper().insertOrUpdate(entity));
    }

    default public boolean saveBatch(Collection<T> entities) {
        return this.saveBatch(entities, 1000);
    }

    default public boolean saveBatch(Collection<T> entities, int batchSize) {
        return SqlUtil.toBool(this.getMapper().insertBatch(CollectionUtil.toList(entities), batchSize));
    }

    default public boolean remove(QueryWrapper query) {
        return SqlUtil.toBool(this.getMapper().deleteByQuery(query));
    }

    default public boolean remove(QueryCondition condition) {
        return this.remove(this.query().where(condition));
    }

    default public boolean removeById(Serializable id) {
        return SqlUtil.toBool(this.getMapper().deleteById(id));
    }

    default public boolean removeByIds(Collection<? extends Serializable> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return false;
        }
        return SqlUtil.toBool(this.getMapper().deleteBatchByIds(ids));
    }

    default public boolean removeByMap(Map<String, Object> query) {
        if (query == null || query.isEmpty()) {
            throw FlexExceptions.wrap("deleteByMap is not allow empty map.", new Object[0]);
        }
        return this.remove(this.query().where(query));
    }

    default public boolean updateById(T entity) {
        return this.updateById(entity, true);
    }

    default public boolean updateById(T entity, boolean ignoreNulls) {
        return SqlUtil.toBool(this.getMapper().update(entity, ignoreNulls));
    }

    default public boolean update(T entity, Map<String, Object> query) {
        return this.update(entity, this.query().where(query));
    }

    default public boolean update(T entity, QueryWrapper query) {
        return SqlUtil.toBool(this.getMapper().updateByQuery(entity, query));
    }

    default public boolean update(T entity, QueryCondition condition) {
        return this.update(entity, this.query().where(condition));
    }

    default public boolean updateBatch(Collection<T> entities) {
        return this.updateBatch(entities, 1000);
    }

    default public boolean updateBatch(Collection<T> entities, int batchSize) {
        return Db.tx(() -> {
            List entityList = CollectionUtil.toList(entities);
            Class<?> usefulClass = ClassUtil.getUsefulClass(this.getMapper().getClass());
            return SqlUtil.toBool(Arrays.stream(Db.executeBatch(entityList.size(), batchSize, usefulClass, (mapper, index) -> mapper.update(entityList.get((int)index)))).sum());
        });
    }

    default public T getById(Serializable id) {
        return this.getMapper().selectOneById(id);
    }

    default public Optional<T> getByIdOpt(Serializable id) {
        return Optional.ofNullable(this.getById(id));
    }

    default public T getOne(QueryWrapper query) {
        return this.getMapper().selectOneByQuery(query);
    }

    default public Optional<T> getOneOpt(QueryWrapper query) {
        return Optional.ofNullable(this.getOne(query));
    }

    default public <R> R getOneAs(QueryWrapper query, Class<R> asType) {
        return this.getMapper().selectOneByQueryAs(query, asType);
    }

    default public <R> Optional<R> getOneAsOpt(QueryWrapper query, Class<R> asType) {
        return Optional.ofNullable(this.getOneAs(query, asType));
    }

    default public T getOne(QueryCondition condition) {
        return this.getOne(this.query().where(condition));
    }

    default public Optional<T> getOneOpt(QueryCondition condition) {
        return Optional.ofNullable(this.getOne(condition));
    }

    default public List<T> list() {
        return this.list(this.query());
    }

    default public List<T> list(QueryWrapper query) {
        return this.getMapper().selectListByQuery(query);
    }

    default public List<T> list(QueryCondition condition) {
        return this.list(this.query().where(condition));
    }

    default public <R> List<R> listAs(QueryWrapper query, Class<R> asType) {
        return this.getMapper().selectListByQueryAs(query, asType);
    }

    default public List<T> listByIds(Collection<? extends Serializable> ids) {
        return this.getMapper().selectListByIds(ids);
    }

    default public List<T> listByMap(Map<String, Object> query) {
        return this.list(this.query().where(query));
    }

    default public boolean exists(QueryWrapper query) {
        return SqlUtil.toBool(this.count(query));
    }

    default public boolean exists(QueryCondition condition) {
        return SqlUtil.toBool(this.count(condition));
    }

    default public long count() {
        return this.count(this.query());
    }

    default public long count(QueryWrapper query) {
        return this.getMapper().selectCountByQuery(query);
    }

    default public long count(QueryCondition condition) {
        return this.count(this.query().where(condition));
    }

    default public Page<T> page(Page<T> page) {
        return this.page(page, this.query());
    }

    default public Page<T> page(Page<T> page, QueryWrapper query) {
        return this.pageAs(page, query, null);
    }

    default public Page<T> page(Page<T> page, QueryCondition condition) {
        return this.page(page, this.query().where(condition));
    }

    default public <R> Page<R> pageAs(Page<R> page, QueryWrapper query, Class<R> asType) {
        return this.getMapper().paginateAs(page, query, asType, new Consumer[0]);
    }

    default public QueryWrapper query() {
        return QueryWrapper.create();
    }
}

