/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.FlexConsts;
import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.query.CloneSupport;
import com.mybatisflex.core.query.HasParamsColumn;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.ObjectUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class CaseQueryColumn
extends QueryColumn
implements HasParamsColumn {
    private List<When> whens;
    private Object elseValue;

    void addWhen(When when) {
        if (this.whens == null) {
            this.whens = new ArrayList<When>();
        }
        this.whens.add(when);
    }

    @Override
    String toSelectSql(List<QueryTable> queryTables, IDialect dialect) {
        String sql = this.buildSql(queryTables, dialect);
        if (StringUtil.isNotBlank(this.alias)) {
            return WrapperUtil.withAlias(sql, dialect.wrap(this.alias), dialect);
        }
        return sql;
    }

    @Override
    public CaseQueryColumn clone() {
        CaseQueryColumn clone = (CaseQueryColumn)super.clone();
        clone.whens = CollectionUtil.cloneArrayList(this.whens);
        clone.elseValue = ObjectUtil.cloneObject(this.elseValue);
        return clone;
    }

    @Override
    String toConditionSql(List<QueryTable> queryTables, IDialect dialect) {
        return WrapperUtil.withBracket(this.buildSql(queryTables, dialect));
    }

    private String buildSql(List<QueryTable> queryTables, IDialect dialect) {
        StringBuilder sql = new StringBuilder("CASE");
        for (When when : this.whens) {
            sql.append(" WHEN ").append(when.whenCondition.toSql(queryTables, dialect));
            sql.append(" THEN ").append(WrapperUtil.buildValue(when.thenValue));
        }
        if (this.elseValue != null) {
            sql.append(" ELSE ").append(WrapperUtil.buildValue(this.elseValue));
        }
        sql.append(" END");
        return sql.toString();
    }

    @Override
    public QueryColumn as(String alias) {
        this.alias = alias;
        return this;
    }

    @Override
    public Object[] getParamValues() {
        Object[] values = FlexConsts.EMPTY_ARRAY;
        for (When when : this.whens) {
            values = ArrayUtil.concat(values, WrapperUtil.getValues(when.whenCondition));
        }
        if (this.elseValue instanceof HasParamsColumn) {
            values = ArrayUtil.concat(values, ((HasParamsColumn)this.elseValue).getParamValues());
        }
        return values;
    }

    public static class Builder {
        private CaseQueryColumn caseQueryColumn = new CaseQueryColumn();
        private When lastWhen;

        public Then when(QueryCondition condition) {
            this.lastWhen = new When(condition);
            return new Then(this);
        }

        public Builder else_(Object elseValue) {
            this.caseQueryColumn.elseValue = elseValue;
            return this;
        }

        public CaseQueryColumn end() {
            return this.caseQueryColumn;
        }

        public static class Then {
            private Builder builder;

            public Then(Builder builder) {
                this.builder = builder;
            }

            public Builder then(Object thenValue) {
                this.builder.lastWhen.setThenValue(thenValue);
                this.builder.caseQueryColumn.addWhen(this.builder.lastWhen);
                return this.builder;
            }
        }
    }

    public static class When
    implements CloneSupport<When> {
        private QueryCondition whenCondition;
        private Object thenValue;

        public When(QueryCondition whenCondition) {
            this.whenCondition = whenCondition;
        }

        public void setThenValue(Object thenValue) {
            this.thenValue = thenValue;
        }

        @Override
        public When clone() {
            try {
                When clone = (When)super.clone();
                clone.whenCondition = ObjectUtil.clone(this.whenCondition);
                clone.thenValue = ObjectUtil.cloneObject(this.thenValue);
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw FlexExceptions.wrap(e);
            }
        }
    }
}

