/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.logicdelete;

import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.logicdelete.LogicDeleteProcessor;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.table.TableInfo;

public class DefaultLogicDeleteProcessorImpl
implements LogicDeleteProcessor {
    @Override
    public String buildLogicNormalCondition(String logicColumn, IDialect dialect) {
        return dialect.wrap(logicColumn) + " = " + this.getLogicNormalValue();
    }

    @Override
    public String buildLogicDeletedSet(String logicColumn, IDialect dialect) {
        return dialect.wrap(logicColumn) + " = " + this.getLogicDeletedValue();
    }

    @Override
    public void buildQueryCondition(QueryWrapper queryWrapper, TableInfo tableInfo) {
        queryWrapper.and(QueryCondition.create(tableInfo.getSchema(), tableInfo.getTableName(), tableInfo.getLogicDeleteColumn(), " = ", FlexGlobalConfig.getDefaultConfig().getNormalValueOfLogicDelete()));
    }

    protected Object getLogicNormalValue() {
        Object normalValueOfLogicDelete = FlexGlobalConfig.getDefaultConfig().getNormalValueOfLogicDelete();
        if (normalValueOfLogicDelete instanceof Number || normalValueOfLogicDelete instanceof Boolean) {
            return normalValueOfLogicDelete;
        }
        return "'" + normalValueOfLogicDelete + "'";
    }

    protected Object getLogicDeletedValue() {
        Object deletedValueOfLogicDelete = FlexGlobalConfig.getDefaultConfig().getDeletedValueOfLogicDelete();
        if (deletedValueOfLogicDelete instanceof Number || deletedValueOfLogicDelete instanceof Boolean) {
            return deletedValueOfLogicDelete;
        }
        return "'" + deletedValueOfLogicDelete + "'";
    }
}

