/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batch.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.batch.PrivateEndpointConnectionUpdateHeaders;
import com.microsoft.azure.management.batch.implementation.BatchManagementClientImpl;
import com.microsoft.azure.management.batch.implementation.PageImpl;
import com.microsoft.azure.management.batch.implementation.PrivateEndpointConnectionInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class PrivateEndpointConnectionsInner {
    private PrivateEndpointConnectionsService service;
    private BatchManagementClientImpl client;

    public PrivateEndpointConnectionsInner(Retrofit retrofit, BatchManagementClientImpl client) {
        this.service = (PrivateEndpointConnectionsService)retrofit.create(PrivateEndpointConnectionsService.class);
        this.client = client;
    }

    public PagedList<PrivateEndpointConnectionInner> listByBatchAccount(String resourceGroupName, String accountName) {
        ServiceResponse response = (ServiceResponse)this.listByBatchAccountSinglePageAsync(resourceGroupName, accountName).toBlocking().single();
        return new PagedList<PrivateEndpointConnectionInner>((Page)response.body()){

            public Page<PrivateEndpointConnectionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PrivateEndpointConnectionsInner.this.listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PrivateEndpointConnectionInner>> listByBatchAccountAsync(String resourceGroupName, String accountName, ListOperationCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByBatchAccountSinglePageAsync(resourceGroupName, accountName), (Func1)new Func1<String, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(String nextPageLink) {
                return PrivateEndpointConnectionsInner.this.listByBatchAccountNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PrivateEndpointConnectionInner>> listByBatchAccountAsync(String resourceGroupName, String accountName) {
        return this.listByBatchAccountWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Page<PrivateEndpointConnectionInner>>(){

            public Page<PrivateEndpointConnectionInner> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listByBatchAccountWithServiceResponseAsync(String resourceGroupName, String accountName) {
        return this.listByBatchAccountSinglePageAsync(resourceGroupName, accountName).concatMap((Func1)new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PrivateEndpointConnectionsInner.this.listByBatchAccountNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listByBatchAccountSinglePageAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        return this.service.listByBatchAccount(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), maxresults, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PrivateEndpointConnectionsInner.this.listByBatchAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<PrivateEndpointConnectionInner> listByBatchAccount(String resourceGroupName, String accountName, Integer maxresults) {
        ServiceResponse response = (ServiceResponse)this.listByBatchAccountSinglePageAsync(resourceGroupName, accountName, maxresults).toBlocking().single();
        return new PagedList<PrivateEndpointConnectionInner>((Page)response.body()){

            public Page<PrivateEndpointConnectionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PrivateEndpointConnectionsInner.this.listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PrivateEndpointConnectionInner>> listByBatchAccountAsync(String resourceGroupName, String accountName, Integer maxresults, ListOperationCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByBatchAccountSinglePageAsync(resourceGroupName, accountName, maxresults), (Func1)new Func1<String, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(String nextPageLink) {
                return PrivateEndpointConnectionsInner.this.listByBatchAccountNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PrivateEndpointConnectionInner>> listByBatchAccountAsync(String resourceGroupName, String accountName, Integer maxresults) {
        return this.listByBatchAccountWithServiceResponseAsync(resourceGroupName, accountName, maxresults).map((Func1)new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Page<PrivateEndpointConnectionInner>>(){

            public Page<PrivateEndpointConnectionInner> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listByBatchAccountWithServiceResponseAsync(String resourceGroupName, String accountName, Integer maxresults) {
        return this.listByBatchAccountSinglePageAsync(resourceGroupName, accountName, maxresults).concatMap((Func1)new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PrivateEndpointConnectionsInner.this.listByBatchAccountNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listByBatchAccountSinglePageAsync(String resourceGroupName, String accountName, Integer maxresults) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByBatchAccount(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), maxresults, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PrivateEndpointConnectionsInner.this.listByBatchAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PrivateEndpointConnectionInner>> listByBatchAccountDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PrivateEndpointConnectionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PrivateEndpointConnectionInner get(String resourceGroupName, String accountName, String privateEndpointConnectionName) {
        return (PrivateEndpointConnectionInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName).toBlocking().single()).body());
    }

    public ServiceFuture<PrivateEndpointConnectionInner> getAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, ServiceCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName), serviceCallback);
    }

    public Observable<PrivateEndpointConnectionInner> getAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName) {
        return this.getWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName).map((Func1)new Func1<ServiceResponse<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner>(){

            public PrivateEndpointConnectionInner call(ServiceResponse<PrivateEndpointConnectionInner> response) {
                return (PrivateEndpointConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PrivateEndpointConnectionInner>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (privateEndpointConnectionName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(this.client.subscriptionId(), resourceGroupName, accountName, privateEndpointConnectionName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateEndpointConnectionInner>>>(){

            public Observable<ServiceResponse<PrivateEndpointConnectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateEndpointConnectionsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PrivateEndpointConnectionInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PrivateEndpointConnectionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PrivateEndpointConnectionInner update(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters) {
        return (PrivateEndpointConnectionInner)((Object)((ServiceResponseWithHeaders)this.updateWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<PrivateEndpointConnectionInner> updateAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, ServiceCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName, parameters), serviceCallback);
    }

    public Observable<PrivateEndpointConnectionInner> updateAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName, parameters).map((Func1)new Func1<ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders>, PrivateEndpointConnectionInner>(){

            public PrivateEndpointConnectionInner call(ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders> response) {
                return (PrivateEndpointConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (privateEndpointConnectionName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String ifMatch = null;
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, accountName, privateEndpointConnectionName, this.client.apiVersion(), parameters, ifMatch, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultWithHeadersAsync(observable, new TypeToken<PrivateEndpointConnectionInner>(){}.getType(), PrivateEndpointConnectionUpdateHeaders.class);
    }

    public PrivateEndpointConnectionInner update(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, String ifMatch) {
        return (PrivateEndpointConnectionInner)((Object)((ServiceResponseWithHeaders)this.updateWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName, parameters, ifMatch).toBlocking().last()).body());
    }

    public ServiceFuture<PrivateEndpointConnectionInner> updateAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, String ifMatch, ServiceCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName, parameters, ifMatch), serviceCallback);
    }

    public Observable<PrivateEndpointConnectionInner> updateAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, String ifMatch) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName, parameters, ifMatch).map((Func1)new Func1<ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders>, PrivateEndpointConnectionInner>(){

            public PrivateEndpointConnectionInner call(ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders> response) {
                return (PrivateEndpointConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, String ifMatch) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (privateEndpointConnectionName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, accountName, privateEndpointConnectionName, this.client.apiVersion(), parameters, ifMatch, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultWithHeadersAsync(observable, new TypeToken<PrivateEndpointConnectionInner>(){}.getType(), PrivateEndpointConnectionUpdateHeaders.class);
    }

    public PrivateEndpointConnectionInner beginUpdate(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters) {
        return (PrivateEndpointConnectionInner)((Object)((ServiceResponseWithHeaders)this.beginUpdateWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<PrivateEndpointConnectionInner> beginUpdateAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, ServiceCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName, parameters), serviceCallback);
    }

    public Observable<PrivateEndpointConnectionInner> beginUpdateAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName, parameters).map((Func1)new Func1<ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders>, PrivateEndpointConnectionInner>(){

            public PrivateEndpointConnectionInner call(ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders> response) {
                return (PrivateEndpointConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (privateEndpointConnectionName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String ifMatch = null;
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, accountName, privateEndpointConnectionName, this.client.apiVersion(), parameters, ifMatch, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PrivateEndpointConnectionsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PrivateEndpointConnectionInner beginUpdate(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, String ifMatch) {
        return (PrivateEndpointConnectionInner)((Object)((ServiceResponseWithHeaders)this.beginUpdateWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName, parameters, ifMatch).toBlocking().single()).body());
    }

    public ServiceFuture<PrivateEndpointConnectionInner> beginUpdateAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, String ifMatch, ServiceCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName, parameters, ifMatch), serviceCallback);
    }

    public Observable<PrivateEndpointConnectionInner> beginUpdateAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, String ifMatch) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName, parameters, ifMatch).map((Func1)new Func1<ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders>, PrivateEndpointConnectionInner>(){

            public PrivateEndpointConnectionInner call(ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders> response) {
                return (PrivateEndpointConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, String ifMatch) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (privateEndpointConnectionName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, accountName, privateEndpointConnectionName, this.client.apiVersion(), parameters, ifMatch, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PrivateEndpointConnectionsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PrivateEndpointConnectionInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).buildWithHeaders(response, PrivateEndpointConnectionUpdateHeaders.class);
    }

    public PagedList<PrivateEndpointConnectionInner> listByBatchAccountNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PrivateEndpointConnectionInner>((Page)response.body()){

            public Page<PrivateEndpointConnectionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PrivateEndpointConnectionsInner.this.listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PrivateEndpointConnectionInner>> listByBatchAccountNextAsync(String nextPageLink, ServiceFuture<List<PrivateEndpointConnectionInner>> serviceFuture, ListOperationCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByBatchAccountNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(String nextPageLink) {
                return PrivateEndpointConnectionsInner.this.listByBatchAccountNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PrivateEndpointConnectionInner>> listByBatchAccountNextAsync(String nextPageLink) {
        return this.listByBatchAccountNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Page<PrivateEndpointConnectionInner>>(){

            public Page<PrivateEndpointConnectionInner> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listByBatchAccountNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByBatchAccountNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PrivateEndpointConnectionsInner.this.listByBatchAccountNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listByBatchAccountNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByBatchAccountNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PrivateEndpointConnectionsInner.this.listByBatchAccountNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PrivateEndpointConnectionInner>> listByBatchAccountNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PrivateEndpointConnectionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface PrivateEndpointConnectionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.PrivateEndpointConnections listByBatchAccount"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/privateEndpointConnections")
        public Observable<Response<ResponseBody>> listByBatchAccount(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Query(value="maxresults") Integer var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.PrivateEndpointConnections get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/privateEndpointConnections/{privateEndpointConnectionName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="privateEndpointConnectionName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.PrivateEndpointConnections update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/privateEndpointConnections/{privateEndpointConnectionName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="privateEndpointConnectionName") String var4, @Query(value="api-version") String var5, @Body PrivateEndpointConnectionInner var6, @Header(value="If-Match") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.PrivateEndpointConnections beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/privateEndpointConnections/{privateEndpointConnectionName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="privateEndpointConnectionName") String var4, @Query(value="api-version") String var5, @Body PrivateEndpointConnectionInner var6, @Header(value="If-Match") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.PrivateEndpointConnections listByBatchAccountNext"})
        @GET
        public Observable<Response<ResponseBody>> listByBatchAccountNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

