/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batch.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.batch.CertificateCancelDeletionHeaders;
import com.microsoft.azure.management.batch.CertificateCreateHeaders;
import com.microsoft.azure.management.batch.CertificateCreateOrUpdateParameters;
import com.microsoft.azure.management.batch.CertificateDeleteHeaders;
import com.microsoft.azure.management.batch.CertificateGetHeaders;
import com.microsoft.azure.management.batch.CertificateUpdateHeaders;
import com.microsoft.azure.management.batch.implementation.BatchManagementClientImpl;
import com.microsoft.azure.management.batch.implementation.CertificateInner;
import com.microsoft.azure.management.batch.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class CertificatesInner {
    private CertificatesService service;
    private BatchManagementClientImpl client;

    public CertificatesInner(Retrofit retrofit, BatchManagementClientImpl client) {
        this.service = (CertificatesService)retrofit.create(CertificatesService.class);
        this.client = client;
    }

    public PagedList<CertificateInner> listByBatchAccount(String resourceGroupName, String accountName) {
        ServiceResponse response = (ServiceResponse)this.listByBatchAccountSinglePageAsync(resourceGroupName, accountName).toBlocking().single();
        return new PagedList<CertificateInner>((Page)response.body()){

            public Page<CertificateInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CertificatesInner.this.listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<CertificateInner>> listByBatchAccountAsync(String resourceGroupName, String accountName, ListOperationCallback<CertificateInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByBatchAccountSinglePageAsync(resourceGroupName, accountName), (Func1)new Func1<String, Observable<ServiceResponse<Page<CertificateInner>>>>(){

            public Observable<ServiceResponse<Page<CertificateInner>>> call(String nextPageLink) {
                return CertificatesInner.this.listByBatchAccountNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<CertificateInner>> listByBatchAccountAsync(String resourceGroupName, String accountName) {
        return this.listByBatchAccountWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Page<CertificateInner>>, Page<CertificateInner>>(){

            public Page<CertificateInner> call(ServiceResponse<Page<CertificateInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateInner>>> listByBatchAccountWithServiceResponseAsync(String resourceGroupName, String accountName) {
        return this.listByBatchAccountSinglePageAsync(resourceGroupName, accountName).concatMap((Func1)new Func1<ServiceResponse<Page<CertificateInner>>, Observable<ServiceResponse<Page<CertificateInner>>>>(){

            public Observable<ServiceResponse<Page<CertificateInner>>> call(ServiceResponse<Page<CertificateInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CertificatesInner.this.listByBatchAccountNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateInner>>> listByBatchAccountSinglePageAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        String select = null;
        String filter = null;
        return this.service.listByBatchAccount(resourceGroupName, accountName, this.client.subscriptionId(), maxresults, select, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CertificateInner>>>>(){

            public Observable<ServiceResponse<Page<CertificateInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CertificatesInner.this.listByBatchAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<CertificateInner> listByBatchAccount(String resourceGroupName, String accountName, Integer maxresults, String select, String filter) {
        ServiceResponse response = (ServiceResponse)this.listByBatchAccountSinglePageAsync(resourceGroupName, accountName, maxresults, select, filter).toBlocking().single();
        return new PagedList<CertificateInner>((Page)response.body()){

            public Page<CertificateInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CertificatesInner.this.listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<CertificateInner>> listByBatchAccountAsync(String resourceGroupName, String accountName, Integer maxresults, String select, String filter, ListOperationCallback<CertificateInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByBatchAccountSinglePageAsync(resourceGroupName, accountName, maxresults, select, filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<CertificateInner>>>>(){

            public Observable<ServiceResponse<Page<CertificateInner>>> call(String nextPageLink) {
                return CertificatesInner.this.listByBatchAccountNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<CertificateInner>> listByBatchAccountAsync(String resourceGroupName, String accountName, Integer maxresults, String select, String filter) {
        return this.listByBatchAccountWithServiceResponseAsync(resourceGroupName, accountName, maxresults, select, filter).map((Func1)new Func1<ServiceResponse<Page<CertificateInner>>, Page<CertificateInner>>(){

            public Page<CertificateInner> call(ServiceResponse<Page<CertificateInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateInner>>> listByBatchAccountWithServiceResponseAsync(String resourceGroupName, String accountName, Integer maxresults, String select, String filter) {
        return this.listByBatchAccountSinglePageAsync(resourceGroupName, accountName, maxresults, select, filter).concatMap((Func1)new Func1<ServiceResponse<Page<CertificateInner>>, Observable<ServiceResponse<Page<CertificateInner>>>>(){

            public Observable<ServiceResponse<Page<CertificateInner>>> call(ServiceResponse<Page<CertificateInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CertificatesInner.this.listByBatchAccountNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateInner>>> listByBatchAccountSinglePageAsync(String resourceGroupName, String accountName, Integer maxresults, String select, String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByBatchAccount(resourceGroupName, accountName, this.client.subscriptionId(), maxresults, select, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CertificateInner>>>>(){

            public Observable<ServiceResponse<Page<CertificateInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CertificatesInner.this.listByBatchAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CertificateInner>> listByBatchAccountDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CertificateInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public CertificateInner create(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters) {
        return (CertificateInner)((Object)((ServiceResponseWithHeaders)this.createWithServiceResponseAsync(resourceGroupName, accountName, certificateName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<CertificateInner> createAsync(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters, ServiceCallback<CertificateInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.createWithServiceResponseAsync(resourceGroupName, accountName, certificateName, parameters), serviceCallback);
    }

    public Observable<CertificateInner> createAsync(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, accountName, certificateName, parameters).map((Func1)new Func1<ServiceResponseWithHeaders<CertificateInner, CertificateCreateHeaders>, CertificateInner>(){

            public CertificateInner call(ServiceResponseWithHeaders<CertificateInner, CertificateCreateHeaders> response) {
                return (CertificateInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<CertificateInner, CertificateCreateHeaders>> createWithServiceResponseAsync(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.service.create(resourceGroupName, accountName, certificateName, this.client.subscriptionId(), parameters, ifMatch, ifNoneMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<CertificateInner, CertificateCreateHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<CertificateInner, CertificateCreateHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = CertificatesInner.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public CertificateInner create(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters, String ifMatch, String ifNoneMatch) {
        return (CertificateInner)((Object)((ServiceResponseWithHeaders)this.createWithServiceResponseAsync(resourceGroupName, accountName, certificateName, parameters, ifMatch, ifNoneMatch).toBlocking().single()).body());
    }

    public ServiceFuture<CertificateInner> createAsync(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters, String ifMatch, String ifNoneMatch, ServiceCallback<CertificateInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.createWithServiceResponseAsync(resourceGroupName, accountName, certificateName, parameters, ifMatch, ifNoneMatch), serviceCallback);
    }

    public Observable<CertificateInner> createAsync(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters, String ifMatch, String ifNoneMatch) {
        return this.createWithServiceResponseAsync(resourceGroupName, accountName, certificateName, parameters, ifMatch, ifNoneMatch).map((Func1)new Func1<ServiceResponseWithHeaders<CertificateInner, CertificateCreateHeaders>, CertificateInner>(){

            public CertificateInner call(ServiceResponseWithHeaders<CertificateInner, CertificateCreateHeaders> response) {
                return (CertificateInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<CertificateInner, CertificateCreateHeaders>> createWithServiceResponseAsync(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters, String ifMatch, String ifNoneMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        return this.service.create(resourceGroupName, accountName, certificateName, this.client.subscriptionId(), parameters, ifMatch, ifNoneMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<CertificateInner, CertificateCreateHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<CertificateInner, CertificateCreateHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = CertificatesInner.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<CertificateInner, CertificateCreateHeaders> createDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CertificateInner>(){}.getType()).registerError(CloudException.class).buildWithHeaders(response, CertificateCreateHeaders.class);
    }

    public CertificateInner update(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters) {
        return (CertificateInner)((Object)((ServiceResponseWithHeaders)this.updateWithServiceResponseAsync(resourceGroupName, accountName, certificateName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<CertificateInner> updateAsync(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters, ServiceCallback<CertificateInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName, certificateName, parameters), serviceCallback);
    }

    public Observable<CertificateInner> updateAsync(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, certificateName, parameters).map((Func1)new Func1<ServiceResponseWithHeaders<CertificateInner, CertificateUpdateHeaders>, CertificateInner>(){

            public CertificateInner call(ServiceResponseWithHeaders<CertificateInner, CertificateUpdateHeaders> response) {
                return (CertificateInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<CertificateInner, CertificateUpdateHeaders>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String ifMatch = null;
        return this.service.update(resourceGroupName, accountName, certificateName, this.client.subscriptionId(), parameters, ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<CertificateInner, CertificateUpdateHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<CertificateInner, CertificateUpdateHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = CertificatesInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public CertificateInner update(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters, String ifMatch) {
        return (CertificateInner)((Object)((ServiceResponseWithHeaders)this.updateWithServiceResponseAsync(resourceGroupName, accountName, certificateName, parameters, ifMatch).toBlocking().single()).body());
    }

    public ServiceFuture<CertificateInner> updateAsync(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters, String ifMatch, ServiceCallback<CertificateInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName, certificateName, parameters, ifMatch), serviceCallback);
    }

    public Observable<CertificateInner> updateAsync(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters, String ifMatch) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, certificateName, parameters, ifMatch).map((Func1)new Func1<ServiceResponseWithHeaders<CertificateInner, CertificateUpdateHeaders>, CertificateInner>(){

            public CertificateInner call(ServiceResponseWithHeaders<CertificateInner, CertificateUpdateHeaders> response) {
                return (CertificateInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<CertificateInner, CertificateUpdateHeaders>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters, String ifMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        return this.service.update(resourceGroupName, accountName, certificateName, this.client.subscriptionId(), parameters, ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<CertificateInner, CertificateUpdateHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<CertificateInner, CertificateUpdateHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = CertificatesInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<CertificateInner, CertificateUpdateHeaders> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CertificateInner>(){}.getType()).registerError(CloudException.class).buildWithHeaders(response, CertificateUpdateHeaders.class);
    }

    public void delete(String resourceGroupName, String accountName, String certificateName) {
        ((ServiceResponseWithHeaders)this.deleteWithServiceResponseAsync(resourceGroupName, accountName, certificateName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, String certificateName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.deleteWithServiceResponseAsync(resourceGroupName, accountName, certificateName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String accountName, String certificateName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, accountName, certificateName).map((Func1)new Func1<ServiceResponseWithHeaders<Void, CertificateDeleteHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, CertificateDeleteHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Void, CertificateDeleteHeaders>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName, String certificateName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, accountName, certificateName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultWithHeadersAsync(observable, new TypeToken<Void>(){}.getType(), CertificateDeleteHeaders.class);
    }

    public void beginDelete(String resourceGroupName, String accountName, String certificateName) {
        ((ServiceResponseWithHeaders)this.beginDeleteWithServiceResponseAsync(resourceGroupName, accountName, certificateName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String accountName, String certificateName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, accountName, certificateName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String accountName, String certificateName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, accountName, certificateName).map((Func1)new Func1<ServiceResponseWithHeaders<Void, CertificateDeleteHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, CertificateDeleteHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Void, CertificateDeleteHeaders>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String accountName, String certificateName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, accountName, certificateName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, CertificateDeleteHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, CertificateDeleteHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = CertificatesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, CertificateDeleteHeaders> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).buildWithHeaders(response, CertificateDeleteHeaders.class);
    }

    public CertificateInner get(String resourceGroupName, String accountName, String certificateName) {
        return (CertificateInner)((Object)((ServiceResponseWithHeaders)this.getWithServiceResponseAsync(resourceGroupName, accountName, certificateName).toBlocking().single()).body());
    }

    public ServiceFuture<CertificateInner> getAsync(String resourceGroupName, String accountName, String certificateName, ServiceCallback<CertificateInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getWithServiceResponseAsync(resourceGroupName, accountName, certificateName), serviceCallback);
    }

    public Observable<CertificateInner> getAsync(String resourceGroupName, String accountName, String certificateName) {
        return this.getWithServiceResponseAsync(resourceGroupName, accountName, certificateName).map((Func1)new Func1<ServiceResponseWithHeaders<CertificateInner, CertificateGetHeaders>, CertificateInner>(){

            public CertificateInner call(ServiceResponseWithHeaders<CertificateInner, CertificateGetHeaders> response) {
                return (CertificateInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<CertificateInner, CertificateGetHeaders>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String certificateName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, accountName, certificateName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<CertificateInner, CertificateGetHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<CertificateInner, CertificateGetHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = CertificatesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<CertificateInner, CertificateGetHeaders> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CertificateInner>(){}.getType()).registerError(CloudException.class).buildWithHeaders(response, CertificateGetHeaders.class);
    }

    public CertificateInner cancelDeletion(String resourceGroupName, String accountName, String certificateName) {
        return (CertificateInner)((Object)((ServiceResponseWithHeaders)this.cancelDeletionWithServiceResponseAsync(resourceGroupName, accountName, certificateName).toBlocking().single()).body());
    }

    public ServiceFuture<CertificateInner> cancelDeletionAsync(String resourceGroupName, String accountName, String certificateName, ServiceCallback<CertificateInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.cancelDeletionWithServiceResponseAsync(resourceGroupName, accountName, certificateName), serviceCallback);
    }

    public Observable<CertificateInner> cancelDeletionAsync(String resourceGroupName, String accountName, String certificateName) {
        return this.cancelDeletionWithServiceResponseAsync(resourceGroupName, accountName, certificateName).map((Func1)new Func1<ServiceResponseWithHeaders<CertificateInner, CertificateCancelDeletionHeaders>, CertificateInner>(){

            public CertificateInner call(ServiceResponseWithHeaders<CertificateInner, CertificateCancelDeletionHeaders> response) {
                return (CertificateInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<CertificateInner, CertificateCancelDeletionHeaders>> cancelDeletionWithServiceResponseAsync(String resourceGroupName, String accountName, String certificateName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.cancelDeletion(resourceGroupName, accountName, certificateName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<CertificateInner, CertificateCancelDeletionHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<CertificateInner, CertificateCancelDeletionHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = CertificatesInner.this.cancelDeletionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<CertificateInner, CertificateCancelDeletionHeaders> cancelDeletionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CertificateInner>(){}.getType()).registerError(CloudException.class).buildWithHeaders(response, CertificateCancelDeletionHeaders.class);
    }

    public PagedList<CertificateInner> listByBatchAccountNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<CertificateInner>((Page)response.body()){

            public Page<CertificateInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CertificatesInner.this.listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<CertificateInner>> listByBatchAccountNextAsync(String nextPageLink, ServiceFuture<List<CertificateInner>> serviceFuture, ListOperationCallback<CertificateInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByBatchAccountNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<CertificateInner>>>>(){

            public Observable<ServiceResponse<Page<CertificateInner>>> call(String nextPageLink) {
                return CertificatesInner.this.listByBatchAccountNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<CertificateInner>> listByBatchAccountNextAsync(String nextPageLink) {
        return this.listByBatchAccountNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<CertificateInner>>, Page<CertificateInner>>(){

            public Page<CertificateInner> call(ServiceResponse<Page<CertificateInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateInner>>> listByBatchAccountNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByBatchAccountNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<CertificateInner>>, Observable<ServiceResponse<Page<CertificateInner>>>>(){

            public Observable<ServiceResponse<Page<CertificateInner>>> call(ServiceResponse<Page<CertificateInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CertificatesInner.this.listByBatchAccountNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateInner>>> listByBatchAccountNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByBatchAccountNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CertificateInner>>>>(){

            public Observable<ServiceResponse<Page<CertificateInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CertificatesInner.this.listByBatchAccountNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CertificateInner>> listByBatchAccountNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CertificateInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface CertificatesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Certificates listByBatchAccount"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/certificates")
        public Observable<Response<ResponseBody>> listByBatchAccount(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="maxresults") Integer var4, @Query(value="$select") String var5, @Query(value="$filter") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Certificates create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/certificates/{certificateName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="certificateName") String var3, @Path(value="subscriptionId") String var4, @Body CertificateCreateOrUpdateParameters var5, @Header(value="If-Match") String var6, @Header(value="If-None-Match") String var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Certificates update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/certificates/{certificateName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="certificateName") String var3, @Path(value="subscriptionId") String var4, @Body CertificateCreateOrUpdateParameters var5, @Header(value="If-Match") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Certificates delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/certificates/{certificateName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="certificateName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Certificates beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/certificates/{certificateName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="certificateName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Certificates get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/certificates/{certificateName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="certificateName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Certificates cancelDeletion"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/certificates/{certificateName}/cancelDelete")
        public Observable<Response<ResponseBody>> cancelDeletion(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="certificateName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Certificates listByBatchAccountNext"})
        @GET
        public Observable<Response<ResponseBody>> listByBatchAccountNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

