/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_CONTEXT_DATA;
import tss.tpm.TPM_HANDLE;

public class TPMS_CONTEXT
extends TpmStructure {
    public long sequence;
    public TPM_HANDLE savedHandle;
    public TPM_HANDLE hierarchy;
    public TPMS_CONTEXT_DATA contextBlob;

    public TPMS_CONTEXT() {
        this.savedHandle = new TPM_HANDLE();
        this.hierarchy = new TPM_HANDLE();
    }

    public TPMS_CONTEXT(long _sequence, TPM_HANDLE _savedHandle, TPM_HANDLE _hierarchy, TPMS_CONTEXT_DATA _contextBlob) {
        this.sequence = _sequence;
        this.savedHandle = _savedHandle;
        this.hierarchy = _hierarchy;
        this.contextBlob = _contextBlob;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeInt64(this.sequence);
        this.savedHandle.toTpm(buf);
        this.hierarchy.toTpm(buf);
        buf.writeSizedObj(this.contextBlob);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.sequence = buf.readInt64();
        this.savedHandle = TPM_HANDLE.fromTpm(buf);
        this.hierarchy = TPM_HANDLE.fromTpm(buf);
        this.contextBlob = buf.createSizedObj(TPMS_CONTEXT_DATA.class);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPMS_CONTEXT fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPMS_CONTEXT.class);
    }

    public static TPMS_CONTEXT fromTpm(byte[] byteBuf) {
        return TPMS_CONTEXT.fromBytes(byteBuf);
    }

    public static TPMS_CONTEXT fromTpm(TpmBuffer buf) {
        return buf.createObj(TPMS_CONTEXT.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_CONTEXT");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "long", "sequence", this.sequence);
        _p.add(d, "TPM_HANDLE", "savedHandle", this.savedHandle);
        _p.add(d, "TPM_HANDLE", "hierarchy", this.hierarchy);
        _p.add(d, "TPMS_CONTEXT_DATA", "contextBlob", this.contextBlob);
    }
}

