/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_ATTEST;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_ST;

public class TPMS_COMMAND_AUDIT_INFO
extends TpmStructure
implements TPMU_ATTEST {
    public long auditCounter;
    public TPM_ALG_ID digestAlg;
    public byte[] auditDigest;
    public byte[] commandDigest;

    public TPMS_COMMAND_AUDIT_INFO() {
        this.digestAlg = TPM_ALG_ID.NULL;
    }

    public TPMS_COMMAND_AUDIT_INFO(long _auditCounter, TPM_ALG_ID _digestAlg, byte[] _auditDigest, byte[] _commandDigest) {
        this.auditCounter = _auditCounter;
        this.digestAlg = _digestAlg;
        this.auditDigest = _auditDigest;
        this.commandDigest = _commandDigest;
    }

    @Override
    public TPM_ST GetUnionSelector() {
        return TPM_ST.ATTEST_COMMAND_AUDIT;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeInt64(this.auditCounter);
        this.digestAlg.toTpm(buf);
        buf.writeSizedByteBuf(this.auditDigest);
        buf.writeSizedByteBuf(this.commandDigest);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.auditCounter = buf.readInt64();
        this.digestAlg = TPM_ALG_ID.fromTpm(buf);
        this.auditDigest = buf.readSizedByteBuf();
        this.commandDigest = buf.readSizedByteBuf();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPMS_COMMAND_AUDIT_INFO fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPMS_COMMAND_AUDIT_INFO.class);
    }

    public static TPMS_COMMAND_AUDIT_INFO fromTpm(byte[] byteBuf) {
        return TPMS_COMMAND_AUDIT_INFO.fromBytes(byteBuf);
    }

    public static TPMS_COMMAND_AUDIT_INFO fromTpm(TpmBuffer buf) {
        return buf.createObj(TPMS_COMMAND_AUDIT_INFO.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_COMMAND_AUDIT_INFO");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "long", "auditCounter", this.auditCounter);
        _p.add(d, "TPM_ALG_ID", "digestAlg", this.digestAlg);
        _p.add(d, "byte[]", "auditDigest", this.auditDigest);
        _p.add(d, "byte[]", "commandDigest", this.commandDigest);
    }
}

