/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPMT_SYM_DEF;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;
import tss.tpm.TPM_SE;

public class TPM2_StartAuthSession_REQUEST
extends ReqStructure {
    public TPM_HANDLE tpmKey;
    public TPM_HANDLE bind;
    public byte[] nonceCaller;
    public byte[] encryptedSalt;
    public TPM_SE sessionType;
    public TPMT_SYM_DEF symmetric;
    public TPM_ALG_ID authHash;

    public TPM2_StartAuthSession_REQUEST() {
        this.tpmKey = new TPM_HANDLE();
        this.bind = new TPM_HANDLE();
        this.authHash = TPM_ALG_ID.NULL;
    }

    public TPM2_StartAuthSession_REQUEST(TPM_HANDLE _tpmKey, TPM_HANDLE _bind, byte[] _nonceCaller, byte[] _encryptedSalt, TPM_SE _sessionType, TPMT_SYM_DEF _symmetric, TPM_ALG_ID _authHash) {
        this.tpmKey = _tpmKey;
        this.bind = _bind;
        this.nonceCaller = _nonceCaller;
        this.encryptedSalt = _encryptedSalt;
        this.sessionType = _sessionType;
        this.symmetric = _symmetric;
        this.authHash = _authHash;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedByteBuf(this.nonceCaller);
        buf.writeSizedByteBuf(this.encryptedSalt);
        this.sessionType.toTpm(buf);
        this.symmetric.toTpm(buf);
        this.authHash.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.nonceCaller = buf.readSizedByteBuf();
        this.encryptedSalt = buf.readSizedByteBuf();
        this.sessionType = TPM_SE.fromTpm(buf);
        this.symmetric = TPMT_SYM_DEF.fromTpm(buf);
        this.authHash = TPM_ALG_ID.fromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_StartAuthSession_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_StartAuthSession_REQUEST.class);
    }

    public static TPM2_StartAuthSession_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_StartAuthSession_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_StartAuthSession_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_StartAuthSession_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_StartAuthSession_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "tpmKey", this.tpmKey);
        _p.add(d, "TPM_HANDLE", "bind", this.bind);
        _p.add(d, "byte[]", "nonceCaller", this.nonceCaller);
        _p.add(d, "byte[]", "encryptedSalt", this.encryptedSalt);
        _p.add(d, "TPM_SE", "sessionType", this.sessionType);
        _p.add(d, "TPMT_SYM_DEF", "symmetric", this.symmetric);
        _p.add(d, "TPM_ALG_ID", "authHash", this.authHash);
    }

    @Override
    public int numHandles() {
        return 2;
    }

    @Override
    public int numAuthHandles() {
        return 0;
    }

    @Override
    public TPM_HANDLE[] getHandles() {
        return new TPM_HANDLE[]{this.tpmKey, this.bind};
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

