/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_SIGNATURE;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;
import tss.tpm.UnionFactory;

public class TPM2_PolicySigned_REQUEST
extends ReqStructure {
    public TPM_HANDLE authObject;
    public TPM_HANDLE policySession;
    public byte[] nonceTPM;
    public byte[] cpHashA;
    public byte[] policyRef;
    public int expiration;
    public TPMU_SIGNATURE auth;

    public TPM_ALG_ID authSigAlg() {
        return this.auth != null ? this.auth.GetUnionSelector() : TPM_ALG_ID.NULL;
    }

    public TPM2_PolicySigned_REQUEST() {
        this.authObject = new TPM_HANDLE();
        this.policySession = new TPM_HANDLE();
    }

    public TPM2_PolicySigned_REQUEST(TPM_HANDLE _authObject, TPM_HANDLE _policySession, byte[] _nonceTPM, byte[] _cpHashA, byte[] _policyRef, int _expiration, TPMU_SIGNATURE _auth) {
        this.authObject = _authObject;
        this.policySession = _policySession;
        this.nonceTPM = _nonceTPM;
        this.cpHashA = _cpHashA;
        this.policyRef = _policyRef;
        this.expiration = _expiration;
        this.auth = _auth;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedByteBuf(this.nonceTPM);
        buf.writeSizedByteBuf(this.cpHashA);
        buf.writeSizedByteBuf(this.policyRef);
        buf.writeInt(this.expiration);
        buf.writeShort(this.auth.GetUnionSelector());
        this.auth.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.nonceTPM = buf.readSizedByteBuf();
        this.cpHashA = buf.readSizedByteBuf();
        this.policyRef = buf.readSizedByteBuf();
        this.expiration = buf.readInt();
        TPM_ALG_ID authSigAlg = TPM_ALG_ID.fromTpm(buf);
        this.auth = (TPMU_SIGNATURE)UnionFactory.create("TPMU_SIGNATURE", authSigAlg);
        this.auth.initFromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_PolicySigned_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_PolicySigned_REQUEST.class);
    }

    public static TPM2_PolicySigned_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_PolicySigned_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_PolicySigned_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_PolicySigned_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_PolicySigned_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "authObject", this.authObject);
        _p.add(d, "TPM_HANDLE", "policySession", this.policySession);
        _p.add(d, "byte[]", "nonceTPM", this.nonceTPM);
        _p.add(d, "byte[]", "cpHashA", this.cpHashA);
        _p.add(d, "byte[]", "policyRef", this.policyRef);
        _p.add(d, "int", "expiration", this.expiration);
        _p.add(d, "TPMU_SIGNATURE", "auth", this.auth);
    }

    @Override
    public int numHandles() {
        return 2;
    }

    @Override
    public int numAuthHandles() {
        return 0;
    }

    @Override
    public TPM_HANDLE[] getHandles() {
        return new TPM_HANDLE[]{this.authObject, this.policySession};
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

