/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;

public class TPM2_MAC_REQUEST
extends ReqStructure {
    public TPM_HANDLE handle;
    public byte[] buffer;
    public TPM_ALG_ID inScheme;

    public TPM2_MAC_REQUEST() {
        this.handle = new TPM_HANDLE();
        this.inScheme = TPM_ALG_ID.NULL;
    }

    public TPM2_MAC_REQUEST(TPM_HANDLE _handle, byte[] _buffer, TPM_ALG_ID _inScheme) {
        this.handle = _handle;
        this.buffer = _buffer;
        this.inScheme = _inScheme;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedByteBuf(this.buffer);
        this.inScheme.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.buffer = buf.readSizedByteBuf();
        this.inScheme = TPM_ALG_ID.fromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_MAC_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_MAC_REQUEST.class);
    }

    public static TPM2_MAC_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_MAC_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_MAC_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_MAC_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_MAC_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "handle", this.handle);
        _p.add(d, "byte[]", "buffer", this.buffer);
        _p.add(d, "TPM_ALG_ID", "inScheme", this.inScheme);
    }

    @Override
    public int numHandles() {
        return 1;
    }

    @Override
    public int numAuthHandles() {
        return 1;
    }

    @Override
    public TPM_HANDLE[] getHandles() {
        return new TPM_HANDLE[]{this.handle};
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

