/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPM2B_PRIVATE;
import tss.tpm.TPMT_PUBLIC;
import tss.tpm.TPM_HANDLE;

public class TPM2_Load_REQUEST
extends ReqStructure {
    public TPM_HANDLE parentHandle;
    public TPM2B_PRIVATE inPrivate;
    public TPMT_PUBLIC inPublic;

    public TPM2_Load_REQUEST() {
        this.parentHandle = new TPM_HANDLE();
    }

    public TPM2_Load_REQUEST(TPM_HANDLE _parentHandle, TPM2B_PRIVATE _inPrivate, TPMT_PUBLIC _inPublic) {
        this.parentHandle = _parentHandle;
        this.inPrivate = _inPrivate;
        this.inPublic = _inPublic;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        this.inPrivate.toTpm(buf);
        buf.writeSizedObj(this.inPublic);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.inPrivate = TPM2B_PRIVATE.fromTpm(buf);
        this.inPublic = buf.createSizedObj(TPMT_PUBLIC.class);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_Load_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_Load_REQUEST.class);
    }

    public static TPM2_Load_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_Load_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_Load_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_Load_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_Load_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "parentHandle", this.parentHandle);
        _p.add(d, "TPM2B_PRIVATE", "inPrivate", this.inPrivate);
        _p.add(d, "TPMT_PUBLIC", "inPublic", this.inPublic);
    }

    @Override
    public int numHandles() {
        return 1;
    }

    @Override
    public int numAuthHandles() {
        return 1;
    }

    @Override
    public TPM_HANDLE[] getHandles() {
        return new TPM_HANDLE[]{this.parentHandle};
    }
}

