/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_SIG_SCHEME;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;
import tss.tpm.UnionFactory;

public class TPM2_GetCommandAuditDigest_REQUEST
extends ReqStructure {
    public TPM_HANDLE privacyHandle;
    public TPM_HANDLE signHandle;
    public byte[] qualifyingData;
    public TPMU_SIG_SCHEME inScheme;

    public TPM_ALG_ID inSchemeScheme() {
        return this.inScheme != null ? this.inScheme.GetUnionSelector() : TPM_ALG_ID.NULL;
    }

    public TPM2_GetCommandAuditDigest_REQUEST() {
        this.privacyHandle = new TPM_HANDLE();
        this.signHandle = new TPM_HANDLE();
    }

    public TPM2_GetCommandAuditDigest_REQUEST(TPM_HANDLE _privacyHandle, TPM_HANDLE _signHandle, byte[] _qualifyingData, TPMU_SIG_SCHEME _inScheme) {
        this.privacyHandle = _privacyHandle;
        this.signHandle = _signHandle;
        this.qualifyingData = _qualifyingData;
        this.inScheme = _inScheme;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedByteBuf(this.qualifyingData);
        buf.writeShort(this.inScheme.GetUnionSelector());
        this.inScheme.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.qualifyingData = buf.readSizedByteBuf();
        TPM_ALG_ID inSchemeScheme = TPM_ALG_ID.fromTpm(buf);
        this.inScheme = (TPMU_SIG_SCHEME)UnionFactory.create("TPMU_SIG_SCHEME", inSchemeScheme);
        this.inScheme.initFromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_GetCommandAuditDigest_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_GetCommandAuditDigest_REQUEST.class);
    }

    public static TPM2_GetCommandAuditDigest_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_GetCommandAuditDigest_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_GetCommandAuditDigest_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_GetCommandAuditDigest_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_GetCommandAuditDigest_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "privacyHandle", this.privacyHandle);
        _p.add(d, "TPM_HANDLE", "signHandle", this.signHandle);
        _p.add(d, "byte[]", "qualifyingData", this.qualifyingData);
        _p.add(d, "TPMU_SIG_SCHEME", "inScheme", this.inScheme);
    }

    @Override
    public int numHandles() {
        return 2;
    }

    @Override
    public int numAuthHandles() {
        return 2;
    }

    @Override
    public TPM_HANDLE[] getHandles() {
        return new TPM_HANDLE[]{this.privacyHandle, this.signHandle};
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

