/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_SIGNATURE;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;
import tss.tpm.UnionFactory;

public class TPM2_FieldUpgradeStart_REQUEST
extends ReqStructure {
    public TPM_HANDLE authorization;
    public TPM_HANDLE keyHandle;
    public byte[] fuDigest;
    public TPMU_SIGNATURE manifestSignature;

    public TPM_ALG_ID manifestSignatureSigAlg() {
        return this.manifestSignature != null ? this.manifestSignature.GetUnionSelector() : TPM_ALG_ID.NULL;
    }

    public TPM2_FieldUpgradeStart_REQUEST() {
        this.authorization = new TPM_HANDLE();
        this.keyHandle = new TPM_HANDLE();
    }

    public TPM2_FieldUpgradeStart_REQUEST(TPM_HANDLE _authorization, TPM_HANDLE _keyHandle, byte[] _fuDigest, TPMU_SIGNATURE _manifestSignature) {
        this.authorization = _authorization;
        this.keyHandle = _keyHandle;
        this.fuDigest = _fuDigest;
        this.manifestSignature = _manifestSignature;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedByteBuf(this.fuDigest);
        buf.writeShort(this.manifestSignature.GetUnionSelector());
        this.manifestSignature.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.fuDigest = buf.readSizedByteBuf();
        TPM_ALG_ID manifestSignatureSigAlg = TPM_ALG_ID.fromTpm(buf);
        this.manifestSignature = (TPMU_SIGNATURE)UnionFactory.create("TPMU_SIGNATURE", manifestSignatureSigAlg);
        this.manifestSignature.initFromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_FieldUpgradeStart_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_FieldUpgradeStart_REQUEST.class);
    }

    public static TPM2_FieldUpgradeStart_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_FieldUpgradeStart_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_FieldUpgradeStart_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_FieldUpgradeStart_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_FieldUpgradeStart_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "authorization", this.authorization);
        _p.add(d, "TPM_HANDLE", "keyHandle", this.keyHandle);
        _p.add(d, "byte[]", "fuDigest", this.fuDigest);
        _p.add(d, "TPMU_SIGNATURE", "manifestSignature", this.manifestSignature);
    }

    @Override
    public int numHandles() {
        return 2;
    }

    @Override
    public int numAuthHandles() {
        return 1;
    }

    @Override
    public TPM_HANDLE[] getHandles() {
        return new TPM_HANDLE[]{this.authorization, this.keyHandle};
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

