/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_ECC_POINT;
import tss.tpm.TPMU_KDF_SCHEME;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;
import tss.tpm.UnionFactory;

public class TPM2_ECC_Decrypt_REQUEST
extends ReqStructure {
    public TPM_HANDLE keyHandle;
    public TPMS_ECC_POINT C1;
    public byte[] C2;
    public byte[] C3;
    public TPMU_KDF_SCHEME inScheme;

    public TPM_ALG_ID inSchemeScheme() {
        return this.inScheme != null ? this.inScheme.GetUnionSelector() : TPM_ALG_ID.NULL;
    }

    public TPM2_ECC_Decrypt_REQUEST() {
        this.keyHandle = new TPM_HANDLE();
    }

    public TPM2_ECC_Decrypt_REQUEST(TPM_HANDLE _keyHandle, TPMS_ECC_POINT _C1, byte[] _C2, byte[] _C3, TPMU_KDF_SCHEME _inScheme) {
        this.keyHandle = _keyHandle;
        this.C1 = _C1;
        this.C2 = _C2;
        this.C3 = _C3;
        this.inScheme = _inScheme;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedObj(this.C1);
        buf.writeSizedByteBuf(this.C2);
        buf.writeSizedByteBuf(this.C3);
        buf.writeShort(this.inScheme.GetUnionSelector());
        this.inScheme.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.C1 = buf.createSizedObj(TPMS_ECC_POINT.class);
        this.C2 = buf.readSizedByteBuf();
        this.C3 = buf.readSizedByteBuf();
        TPM_ALG_ID inSchemeScheme = TPM_ALG_ID.fromTpm(buf);
        this.inScheme = (TPMU_KDF_SCHEME)UnionFactory.create("TPMU_KDF_SCHEME", inSchemeScheme);
        this.inScheme.initFromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_ECC_Decrypt_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_ECC_Decrypt_REQUEST.class);
    }

    public static TPM2_ECC_Decrypt_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_ECC_Decrypt_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_ECC_Decrypt_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_ECC_Decrypt_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_ECC_Decrypt_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "keyHandle", this.keyHandle);
        _p.add(d, "TPMS_ECC_POINT", "C1", this.C1);
        _p.add(d, "byte[]", "C2", this.C2);
        _p.add(d, "byte[]", "C3", this.C3);
        _p.add(d, "TPMU_KDF_SCHEME", "inScheme", this.inScheme);
    }

    @Override
    public int numHandles() {
        return 1;
    }

    @Override
    public int numAuthHandles() {
        return 1;
    }

    @Override
    public TPM_HANDLE[] getHandles() {
        return new TPM_HANDLE[]{this.keyHandle};
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

