/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.ReqStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPMT_TK_CREATION;
import tss.tpm.TPMU_SIG_SCHEME;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;
import tss.tpm.UnionFactory;

public class TPM2_CertifyCreation_REQUEST
extends ReqStructure {
    public TPM_HANDLE signHandle;
    public TPM_HANDLE objectHandle;
    public byte[] qualifyingData;
    public byte[] creationHash;
    public TPMU_SIG_SCHEME inScheme;
    public TPMT_TK_CREATION creationTicket;

    public TPM_ALG_ID inSchemeScheme() {
        return this.inScheme != null ? this.inScheme.GetUnionSelector() : TPM_ALG_ID.NULL;
    }

    public TPM2_CertifyCreation_REQUEST() {
        this.signHandle = new TPM_HANDLE();
        this.objectHandle = new TPM_HANDLE();
    }

    public TPM2_CertifyCreation_REQUEST(TPM_HANDLE _signHandle, TPM_HANDLE _objectHandle, byte[] _qualifyingData, byte[] _creationHash, TPMU_SIG_SCHEME _inScheme, TPMT_TK_CREATION _creationTicket) {
        this.signHandle = _signHandle;
        this.objectHandle = _objectHandle;
        this.qualifyingData = _qualifyingData;
        this.creationHash = _creationHash;
        this.inScheme = _inScheme;
        this.creationTicket = _creationTicket;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedByteBuf(this.qualifyingData);
        buf.writeSizedByteBuf(this.creationHash);
        buf.writeShort(this.inScheme.GetUnionSelector());
        this.inScheme.toTpm(buf);
        this.creationTicket.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.qualifyingData = buf.readSizedByteBuf();
        this.creationHash = buf.readSizedByteBuf();
        TPM_ALG_ID inSchemeScheme = TPM_ALG_ID.fromTpm(buf);
        this.inScheme = (TPMU_SIG_SCHEME)UnionFactory.create("TPMU_SIG_SCHEME", inSchemeScheme);
        this.inScheme.initFromTpm(buf);
        this.creationTicket = TPMT_TK_CREATION.fromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TPM2_CertifyCreation_REQUEST fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TPM2_CertifyCreation_REQUEST.class);
    }

    public static TPM2_CertifyCreation_REQUEST fromTpm(byte[] byteBuf) {
        return TPM2_CertifyCreation_REQUEST.fromBytes(byteBuf);
    }

    public static TPM2_CertifyCreation_REQUEST fromTpm(TpmBuffer buf) {
        return buf.createObj(TPM2_CertifyCreation_REQUEST.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_CertifyCreation_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "signHandle", this.signHandle);
        _p.add(d, "TPM_HANDLE", "objectHandle", this.objectHandle);
        _p.add(d, "byte[]", "qualifyingData", this.qualifyingData);
        _p.add(d, "byte[]", "creationHash", this.creationHash);
        _p.add(d, "TPMU_SIG_SCHEME", "inScheme", this.inScheme);
        _p.add(d, "TPMT_TK_CREATION", "creationTicket", this.creationTicket);
    }

    @Override
    public int numHandles() {
        return 2;
    }

    @Override
    public int numAuthHandles() {
        return 1;
    }

    @Override
    public TPM_HANDLE[] getHandles() {
        return new TPM_HANDLE[]{this.signHandle, this.objectHandle};
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

