/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMA_SESSION;

public class SessionOut
extends TpmStructure {
    public byte[] nonceTpm;
    public TPMA_SESSION attributes;
    public byte[] auth;

    public SessionOut() {
    }

    public SessionOut(byte[] _nonceTpm, TPMA_SESSION _attributes, byte[] _auth) {
        this.nonceTpm = _nonceTpm;
        this.attributes = _attributes;
        this.auth = _auth;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedByteBuf(this.nonceTpm);
        this.attributes.toTpm(buf);
        buf.writeSizedByteBuf(this.auth);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.nonceTpm = buf.readSizedByteBuf();
        this.attributes = TPMA_SESSION.fromTpm(buf);
        this.auth = buf.readSizedByteBuf();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static SessionOut fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(SessionOut.class);
    }

    public static SessionOut fromTpm(byte[] byteBuf) {
        return SessionOut.fromBytes(byteBuf);
    }

    public static SessionOut fromTpm(TpmBuffer buf) {
        return buf.createObj(SessionOut.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("SessionOut");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte[]", "nonceTpm", this.nonceTpm);
        _p.add(d, "TPMA_SESSION", "attributes", this.attributes);
        _p.add(d, "byte[]", "auth", this.auth);
    }
}

