/*
 * Decompiled with CFR 0.152.
 */
package tss;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallLibrary;
import java.util.Arrays;
import java.util.List;
import tss.TpmDevice;
import tss.TpmException;
import tss.tpm.TPM_RC;

public class TpmDeviceTbs
extends TpmDevice {
    int tbsHandle = -1;
    byte[] lastTpmResponse = null;

    @Override
    public boolean connect() {
        this.tbsHandle = -1;
        TBSLibrary.TBS_CONTEXT_PARAMS2 parms = new TBSLibrary.TBS_CONTEXT_PARAMS2();
        parms.version = 2;
        parms.params = 4;
        IntByReference handleRef = new IntByReference();
        handleRef.setValue(333);
        int res = TBSLibrary.INSTANCE.Tbsi_Context_Create(parms, handleRef);
        if (res != 0) {
            System.err.println("TSS.Java; Tbsi_Context_Create failed with error:" + new TPM_RC(res).toStringVerbose());
            return false;
        }
        this.tbsHandle = handleRef.getValue();
        return true;
    }

    @Override
    public void close() {
        TBSLibrary.INSTANCE.Tbsip_Context_Close(this.tbsHandle);
    }

    @Override
    public void dispatchCommand(byte[] command) {
        Memory buf = new Memory(4096L);
        PointerByReference response = new PointerByReference();
        response.setPointer((Pointer)buf);
        IntByReference responseLen = new IntByReference();
        responseLen.setValue(4096);
        int res = TBSLibrary.INSTANCE.Tbsip_Submit_Command(this.tbsHandle, 0, 0, command, command.length, response, responseLen);
        if (res != 0) {
            throw new TpmException("Tbsip_Submit_Command failed.  Error code is:" + Integer.toHexString(res));
        }
        int numBytesReturned = responseLen.getValue();
        this.lastTpmResponse = new byte[numBytesReturned];
        buf.read(0L, this.lastTpmResponse, 0, numBytesReturned);
    }

    @Override
    public byte[] getResponse() {
        if (this.lastTpmResponse == null) {
            throw new TpmException("No previous TPM command, or TPM command failed");
        }
        byte[] ret = (byte[])this.lastTpmResponse.clone();
        this.lastTpmResponse = null;
        return ret;
    }

    @Override
    public boolean responseReady() {
        return true;
    }

    public static interface TBSLibrary
    extends StdCallLibrary {
        public static final TBSLibrary INSTANCE = (TBSLibrary)Native.loadLibrary((String)"TBS", TBSLibrary.class);

        public int Tbsi_Context_Create(TBS_CONTEXT_PARAMS2 var1, IntByReference var2);

        public int Tbsip_Context_Close(int var1);

        public int Tbsip_Submit_Command(int var1, int var2, int var3, byte[] var4, int var5, PointerByReference var6, IntByReference var7);

        public static class TBS_CONTEXT_PARAMS2
        extends Structure {
            public int version;
            public int params;

            protected List<String> getFieldOrder() {
                return Arrays.asList("version", "params");
            }
        }
    }
}

