/*
 * Decompiled with CFR 0.152.
 */
package tss;

import java.io.Closeable;

public abstract class TpmDevice
implements Closeable {
    protected int TpmInfo = 0;
    protected final int TpmPlatformAvailable = 1;
    protected final int TpmUsesTrm = 2;
    protected final int TpmInRawMode = 4;
    protected final int TpmSupportsPP = 8;
    protected final int TpmNoPowerCtl = 16;
    protected final int TpmNoLocalityCtl = 32;
    protected final int TpmSocketConn = 4096;
    protected final int TpmTbsConn = 8192;
    protected final int TpmLinuxOldUserModeTrm = 16384;
    protected final int TpmTctiConn = 32768;

    static void throwUnsupported(String meth) {
        throw new UnsupportedOperationException("TpmDevice." + meth + "() is not implemented on this TPM device");
    }

    public abstract boolean connect();

    @Override
    public abstract void close();

    public abstract void dispatchCommand(byte[] var1);

    public abstract byte[] getResponse();

    public abstract boolean responseReady();

    public void powerCtl(boolean on) {
        TpmDevice.throwUnsupported("powerCtl");
    }

    public void assertPhysicalPresence(boolean on) {
        TpmDevice.throwUnsupported("assertPhysicalPresence");
    }

    public void setLocality(int locality) {
        TpmDevice.throwUnsupported("setLocality");
    }

    public boolean platformAvailable() {
        return (this.TpmInfo & 1) != 0;
    }

    public boolean powerCtlAvailable() {
        return (this.TpmInfo & 0x10) == 0;
    }

    public boolean localityCtlAvailable() {
        return (this.TpmInfo & 0x20) == 0;
    }

    public boolean implementsPhysicalPresence() {
        return (this.TpmInfo & 8) != 0;
    }

    public void powerOn() {
        this.powerCtl(true);
    }

    public void powerOff() {
        this.powerCtl(false);
    }

    public void powerCycle() {
        this.powerCtl(false);
        this.powerCtl(true);
    }

    public void ppOn() {
        this.assertPhysicalPresence(true);
    }

    public void ppOff() {
        this.assertPhysicalPresence(false);
    }
}

