/*
 * Decompiled with CFR 0.152.
 */
package tss;

import tss.TpmBase;
import tss.tpm.AC_GetCapabilityResponse;
import tss.tpm.AC_SendResponse;
import tss.tpm.ActivateCredentialResponse;
import tss.tpm.CertifyCreationResponse;
import tss.tpm.CertifyResponse;
import tss.tpm.CertifyX509Response;
import tss.tpm.CommitResponse;
import tss.tpm.ContextLoadResponse;
import tss.tpm.ContextSaveResponse;
import tss.tpm.CreateLoadedResponse;
import tss.tpm.CreatePrimaryResponse;
import tss.tpm.CreateResponse;
import tss.tpm.DuplicateResponse;
import tss.tpm.ECC_DecryptResponse;
import tss.tpm.ECC_EncryptResponse;
import tss.tpm.ECC_ParametersResponse;
import tss.tpm.ECDH_KeyGenResponse;
import tss.tpm.ECDH_ZGenResponse;
import tss.tpm.EC_EphemeralResponse;
import tss.tpm.EncryptDecrypt2Response;
import tss.tpm.EncryptDecryptResponse;
import tss.tpm.EventSequenceCompleteResponse;
import tss.tpm.FieldUpgradeDataResponse;
import tss.tpm.FirmwareReadResponse;
import tss.tpm.GetCapabilityResponse;
import tss.tpm.GetCommandAuditDigestResponse;
import tss.tpm.GetRandomResponse;
import tss.tpm.GetSessionAuditDigestResponse;
import tss.tpm.GetTestResultResponse;
import tss.tpm.GetTimeResponse;
import tss.tpm.HMACResponse;
import tss.tpm.HMAC_StartResponse;
import tss.tpm.HashResponse;
import tss.tpm.HashSequenceStartResponse;
import tss.tpm.ImportResponse;
import tss.tpm.IncrementalSelfTestResponse;
import tss.tpm.LoadExternalResponse;
import tss.tpm.LoadResponse;
import tss.tpm.MACResponse;
import tss.tpm.MAC_StartResponse;
import tss.tpm.MakeCredentialResponse;
import tss.tpm.NV_CertifyResponse;
import tss.tpm.NV_ReadPublicResponse;
import tss.tpm.NV_ReadResponse;
import tss.tpm.ObjectChangeAuthResponse;
import tss.tpm.PCR_AllocateResponse;
import tss.tpm.PCR_EventResponse;
import tss.tpm.PCR_ReadResponse;
import tss.tpm.PolicyGetDigestResponse;
import tss.tpm.PolicySecretResponse;
import tss.tpm.PolicySignedResponse;
import tss.tpm.QuoteResponse;
import tss.tpm.RSA_DecryptResponse;
import tss.tpm.RSA_EncryptResponse;
import tss.tpm.ReadClockResponse;
import tss.tpm.ReadPublicResponse;
import tss.tpm.RewrapResponse;
import tss.tpm.SequenceCompleteResponse;
import tss.tpm.SignResponse;
import tss.tpm.StartAuthSessionResponse;
import tss.tpm.TPM2B_DIGEST;
import tss.tpm.TPM2B_PRIVATE;
import tss.tpm.TPM2_ACT_SetTimeout_REQUEST;
import tss.tpm.TPM2_AC_GetCapability_REQUEST;
import tss.tpm.TPM2_AC_Send_REQUEST;
import tss.tpm.TPM2_ActivateCredential_REQUEST;
import tss.tpm.TPM2_CertifyCreation_REQUEST;
import tss.tpm.TPM2_CertifyX509_REQUEST;
import tss.tpm.TPM2_Certify_REQUEST;
import tss.tpm.TPM2_ChangeEPS_REQUEST;
import tss.tpm.TPM2_ChangePPS_REQUEST;
import tss.tpm.TPM2_ClearControl_REQUEST;
import tss.tpm.TPM2_Clear_REQUEST;
import tss.tpm.TPM2_ClockRateAdjust_REQUEST;
import tss.tpm.TPM2_ClockSet_REQUEST;
import tss.tpm.TPM2_Commit_REQUEST;
import tss.tpm.TPM2_ContextLoad_REQUEST;
import tss.tpm.TPM2_ContextSave_REQUEST;
import tss.tpm.TPM2_CreateLoaded_REQUEST;
import tss.tpm.TPM2_CreatePrimary_REQUEST;
import tss.tpm.TPM2_Create_REQUEST;
import tss.tpm.TPM2_DictionaryAttackLockReset_REQUEST;
import tss.tpm.TPM2_DictionaryAttackParameters_REQUEST;
import tss.tpm.TPM2_Duplicate_REQUEST;
import tss.tpm.TPM2_ECC_Decrypt_REQUEST;
import tss.tpm.TPM2_ECC_Encrypt_REQUEST;
import tss.tpm.TPM2_ECC_Parameters_REQUEST;
import tss.tpm.TPM2_ECDH_KeyGen_REQUEST;
import tss.tpm.TPM2_ECDH_ZGen_REQUEST;
import tss.tpm.TPM2_EC_Ephemeral_REQUEST;
import tss.tpm.TPM2_EncryptDecrypt2_REQUEST;
import tss.tpm.TPM2_EncryptDecrypt_REQUEST;
import tss.tpm.TPM2_EventSequenceComplete_REQUEST;
import tss.tpm.TPM2_EvictControl_REQUEST;
import tss.tpm.TPM2_FieldUpgradeData_REQUEST;
import tss.tpm.TPM2_FieldUpgradeStart_REQUEST;
import tss.tpm.TPM2_FirmwareRead_REQUEST;
import tss.tpm.TPM2_FlushContext_REQUEST;
import tss.tpm.TPM2_GetCapability_REQUEST;
import tss.tpm.TPM2_GetCommandAuditDigest_REQUEST;
import tss.tpm.TPM2_GetRandom_REQUEST;
import tss.tpm.TPM2_GetSessionAuditDigest_REQUEST;
import tss.tpm.TPM2_GetTestResult_REQUEST;
import tss.tpm.TPM2_GetTime_REQUEST;
import tss.tpm.TPM2_HMAC_REQUEST;
import tss.tpm.TPM2_HMAC_Start_REQUEST;
import tss.tpm.TPM2_HashSequenceStart_REQUEST;
import tss.tpm.TPM2_Hash_REQUEST;
import tss.tpm.TPM2_HierarchyChangeAuth_REQUEST;
import tss.tpm.TPM2_HierarchyControl_REQUEST;
import tss.tpm.TPM2_Import_REQUEST;
import tss.tpm.TPM2_IncrementalSelfTest_REQUEST;
import tss.tpm.TPM2_LoadExternal_REQUEST;
import tss.tpm.TPM2_Load_REQUEST;
import tss.tpm.TPM2_MAC_REQUEST;
import tss.tpm.TPM2_MAC_Start_REQUEST;
import tss.tpm.TPM2_MakeCredential_REQUEST;
import tss.tpm.TPM2_NV_Certify_REQUEST;
import tss.tpm.TPM2_NV_ChangeAuth_REQUEST;
import tss.tpm.TPM2_NV_DefineSpace_REQUEST;
import tss.tpm.TPM2_NV_Extend_REQUEST;
import tss.tpm.TPM2_NV_GlobalWriteLock_REQUEST;
import tss.tpm.TPM2_NV_Increment_REQUEST;
import tss.tpm.TPM2_NV_ReadLock_REQUEST;
import tss.tpm.TPM2_NV_ReadPublic_REQUEST;
import tss.tpm.TPM2_NV_Read_REQUEST;
import tss.tpm.TPM2_NV_SetBits_REQUEST;
import tss.tpm.TPM2_NV_UndefineSpaceSpecial_REQUEST;
import tss.tpm.TPM2_NV_UndefineSpace_REQUEST;
import tss.tpm.TPM2_NV_WriteLock_REQUEST;
import tss.tpm.TPM2_NV_Write_REQUEST;
import tss.tpm.TPM2_ObjectChangeAuth_REQUEST;
import tss.tpm.TPM2_PCR_Allocate_REQUEST;
import tss.tpm.TPM2_PCR_Event_REQUEST;
import tss.tpm.TPM2_PCR_Extend_REQUEST;
import tss.tpm.TPM2_PCR_Read_REQUEST;
import tss.tpm.TPM2_PCR_Reset_REQUEST;
import tss.tpm.TPM2_PCR_SetAuthPolicy_REQUEST;
import tss.tpm.TPM2_PCR_SetAuthValue_REQUEST;
import tss.tpm.TPM2_PP_Commands_REQUEST;
import tss.tpm.TPM2_PolicyAuthValue_REQUEST;
import tss.tpm.TPM2_PolicyAuthorizeNV_REQUEST;
import tss.tpm.TPM2_PolicyAuthorize_REQUEST;
import tss.tpm.TPM2_PolicyCommandCode_REQUEST;
import tss.tpm.TPM2_PolicyCounterTimer_REQUEST;
import tss.tpm.TPM2_PolicyCpHash_REQUEST;
import tss.tpm.TPM2_PolicyDuplicationSelect_REQUEST;
import tss.tpm.TPM2_PolicyGetDigest_REQUEST;
import tss.tpm.TPM2_PolicyLocality_REQUEST;
import tss.tpm.TPM2_PolicyNV_REQUEST;
import tss.tpm.TPM2_PolicyNameHash_REQUEST;
import tss.tpm.TPM2_PolicyNvWritten_REQUEST;
import tss.tpm.TPM2_PolicyOR_REQUEST;
import tss.tpm.TPM2_PolicyPCR_REQUEST;
import tss.tpm.TPM2_PolicyPassword_REQUEST;
import tss.tpm.TPM2_PolicyPhysicalPresence_REQUEST;
import tss.tpm.TPM2_PolicyRestart_REQUEST;
import tss.tpm.TPM2_PolicySecret_REQUEST;
import tss.tpm.TPM2_PolicySigned_REQUEST;
import tss.tpm.TPM2_PolicyTemplate_REQUEST;
import tss.tpm.TPM2_PolicyTicket_REQUEST;
import tss.tpm.TPM2_Policy_AC_SendSelect_REQUEST;
import tss.tpm.TPM2_Quote_REQUEST;
import tss.tpm.TPM2_RSA_Decrypt_REQUEST;
import tss.tpm.TPM2_RSA_Encrypt_REQUEST;
import tss.tpm.TPM2_ReadClock_REQUEST;
import tss.tpm.TPM2_ReadPublic_REQUEST;
import tss.tpm.TPM2_Rewrap_REQUEST;
import tss.tpm.TPM2_SelfTest_REQUEST;
import tss.tpm.TPM2_SequenceComplete_REQUEST;
import tss.tpm.TPM2_SequenceUpdate_REQUEST;
import tss.tpm.TPM2_SetAlgorithmSet_REQUEST;
import tss.tpm.TPM2_SetCommandCodeAuditStatus_REQUEST;
import tss.tpm.TPM2_SetPrimaryPolicy_REQUEST;
import tss.tpm.TPM2_Shutdown_REQUEST;
import tss.tpm.TPM2_Sign_REQUEST;
import tss.tpm.TPM2_StartAuthSession_REQUEST;
import tss.tpm.TPM2_Startup_REQUEST;
import tss.tpm.TPM2_StirRandom_REQUEST;
import tss.tpm.TPM2_TestParms_REQUEST;
import tss.tpm.TPM2_Unseal_REQUEST;
import tss.tpm.TPM2_Vendor_TCG_Test_REQUEST;
import tss.tpm.TPM2_VerifySignature_REQUEST;
import tss.tpm.TPM2_ZGen_2Phase_REQUEST;
import tss.tpm.TPMA_LOCALITY;
import tss.tpm.TPMS_AC_OUTPUT;
import tss.tpm.TPMS_ALGORITHM_DETAIL_ECC;
import tss.tpm.TPMS_CONTEXT;
import tss.tpm.TPMS_ECC_POINT;
import tss.tpm.TPMS_ID_OBJECT;
import tss.tpm.TPMS_NV_PUBLIC;
import tss.tpm.TPMS_PCR_SELECTION;
import tss.tpm.TPMS_SENSITIVE_CREATE;
import tss.tpm.TPMS_TIME_INFO;
import tss.tpm.TPMT_HA;
import tss.tpm.TPMT_PUBLIC;
import tss.tpm.TPMT_SENSITIVE;
import tss.tpm.TPMT_SYM_DEF;
import tss.tpm.TPMT_SYM_DEF_OBJECT;
import tss.tpm.TPMT_TK_AUTH;
import tss.tpm.TPMT_TK_CREATION;
import tss.tpm.TPMT_TK_HASHCHECK;
import tss.tpm.TPMT_TK_VERIFIED;
import tss.tpm.TPMU_ASYM_SCHEME;
import tss.tpm.TPMU_KDF_SCHEME;
import tss.tpm.TPMU_PUBLIC_PARMS;
import tss.tpm.TPMU_SIGNATURE;
import tss.tpm.TPMU_SIG_SCHEME;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_AT;
import tss.tpm.TPM_CAP;
import tss.tpm.TPM_CC;
import tss.tpm.TPM_CLOCK_ADJUST;
import tss.tpm.TPM_ECC_CURVE;
import tss.tpm.TPM_EO;
import tss.tpm.TPM_HANDLE;
import tss.tpm.TPM_SE;
import tss.tpm.TPM_SU;
import tss.tpm.UnsealResponse;
import tss.tpm.Vendor_TCG_TestResponse;
import tss.tpm.VerifySignatureResponse;
import tss.tpm.ZGen_2PhaseResponse;

public class Tpm
extends TpmBase {
    public void Startup(TPM_SU startupType) {
        TPM2_Startup_REQUEST req = new TPM2_Startup_REQUEST(startupType);
        this.DispatchCommand(TPM_CC.Startup, req, null);
    }

    public void Shutdown(TPM_SU shutdownType) {
        TPM2_Shutdown_REQUEST req = new TPM2_Shutdown_REQUEST(shutdownType);
        this.DispatchCommand(TPM_CC.Shutdown, req, null);
    }

    public void SelfTest(byte fullTest) {
        TPM2_SelfTest_REQUEST req = new TPM2_SelfTest_REQUEST(fullTest);
        this.DispatchCommand(TPM_CC.SelfTest, req, null);
    }

    public TPM_ALG_ID[] IncrementalSelfTest(TPM_ALG_ID[] toTest) {
        TPM2_IncrementalSelfTest_REQUEST req = new TPM2_IncrementalSelfTest_REQUEST(toTest);
        IncrementalSelfTestResponse resp = new IncrementalSelfTestResponse();
        this.DispatchCommand(TPM_CC.IncrementalSelfTest, req, resp);
        return resp.toDoList;
    }

    public GetTestResultResponse GetTestResult() {
        TPM2_GetTestResult_REQUEST req = new TPM2_GetTestResult_REQUEST();
        GetTestResultResponse resp = new GetTestResultResponse();
        this.DispatchCommand(TPM_CC.GetTestResult, req, resp);
        return resp;
    }

    public StartAuthSessionResponse StartAuthSession(TPM_HANDLE tpmKey, TPM_HANDLE bind, byte[] nonceCaller, byte[] encryptedSalt, TPM_SE sessionType, TPMT_SYM_DEF symmetric, TPM_ALG_ID authHash) {
        TPM2_StartAuthSession_REQUEST req = new TPM2_StartAuthSession_REQUEST(tpmKey, bind, nonceCaller, encryptedSalt, sessionType, symmetric, authHash);
        StartAuthSessionResponse resp = new StartAuthSessionResponse();
        this.DispatchCommand(TPM_CC.StartAuthSession, req, resp);
        return resp;
    }

    public void PolicyRestart(TPM_HANDLE sessionHandle) {
        TPM2_PolicyRestart_REQUEST req = new TPM2_PolicyRestart_REQUEST(sessionHandle);
        this.DispatchCommand(TPM_CC.PolicyRestart, req, null);
    }

    public CreateResponse Create(TPM_HANDLE parentHandle, TPMS_SENSITIVE_CREATE inSensitive, TPMT_PUBLIC inPublic, byte[] outsideInfo, TPMS_PCR_SELECTION[] creationPCR) {
        TPM2_Create_REQUEST req = new TPM2_Create_REQUEST(parentHandle, inSensitive, inPublic, outsideInfo, creationPCR);
        CreateResponse resp = new CreateResponse();
        this.DispatchCommand(TPM_CC.Create, req, resp);
        return resp;
    }

    public TPM_HANDLE Load(TPM_HANDLE parentHandle, TPM2B_PRIVATE inPrivate, TPMT_PUBLIC inPublic) {
        TPM2_Load_REQUEST req = new TPM2_Load_REQUEST(parentHandle, inPrivate, inPublic);
        LoadResponse resp = new LoadResponse();
        this.DispatchCommand(TPM_CC.Load, req, resp);
        return resp.handle;
    }

    public TPM_HANDLE LoadExternal(TPMT_SENSITIVE inPrivate, TPMT_PUBLIC inPublic, TPM_HANDLE hierarchy) {
        TPM2_LoadExternal_REQUEST req = new TPM2_LoadExternal_REQUEST(inPrivate, inPublic, hierarchy);
        LoadExternalResponse resp = new LoadExternalResponse();
        this.DispatchCommand(TPM_CC.LoadExternal, req, resp);
        return resp.handle;
    }

    public ReadPublicResponse ReadPublic(TPM_HANDLE objectHandle) {
        TPM2_ReadPublic_REQUEST req = new TPM2_ReadPublic_REQUEST(objectHandle);
        ReadPublicResponse resp = new ReadPublicResponse();
        this.DispatchCommand(TPM_CC.ReadPublic, req, resp);
        return resp;
    }

    public byte[] ActivateCredential(TPM_HANDLE activateHandle, TPM_HANDLE keyHandle, TPMS_ID_OBJECT credentialBlob, byte[] secret) {
        TPM2_ActivateCredential_REQUEST req = new TPM2_ActivateCredential_REQUEST(activateHandle, keyHandle, credentialBlob, secret);
        ActivateCredentialResponse resp = new ActivateCredentialResponse();
        this.DispatchCommand(TPM_CC.ActivateCredential, req, resp);
        return resp.certInfo;
    }

    public MakeCredentialResponse MakeCredential(TPM_HANDLE handle, byte[] credential, byte[] objectName) {
        TPM2_MakeCredential_REQUEST req = new TPM2_MakeCredential_REQUEST(handle, credential, objectName);
        MakeCredentialResponse resp = new MakeCredentialResponse();
        this.DispatchCommand(TPM_CC.MakeCredential, req, resp);
        return resp;
    }

    public byte[] Unseal(TPM_HANDLE itemHandle) {
        TPM2_Unseal_REQUEST req = new TPM2_Unseal_REQUEST(itemHandle);
        UnsealResponse resp = new UnsealResponse();
        this.DispatchCommand(TPM_CC.Unseal, req, resp);
        return resp.outData;
    }

    public TPM2B_PRIVATE ObjectChangeAuth(TPM_HANDLE objectHandle, TPM_HANDLE parentHandle, byte[] newAuth) {
        TPM2_ObjectChangeAuth_REQUEST req = new TPM2_ObjectChangeAuth_REQUEST(objectHandle, parentHandle, newAuth);
        ObjectChangeAuthResponse resp = new ObjectChangeAuthResponse();
        this.DispatchCommand(TPM_CC.ObjectChangeAuth, req, resp);
        return resp.outPrivate;
    }

    public CreateLoadedResponse CreateLoaded(TPM_HANDLE parentHandle, TPMS_SENSITIVE_CREATE inSensitive, byte[] inPublic) {
        TPM2_CreateLoaded_REQUEST req = new TPM2_CreateLoaded_REQUEST(parentHandle, inSensitive, inPublic);
        CreateLoadedResponse resp = new CreateLoadedResponse();
        this.DispatchCommand(TPM_CC.CreateLoaded, req, resp);
        return resp;
    }

    public DuplicateResponse Duplicate(TPM_HANDLE objectHandle, TPM_HANDLE newParentHandle, byte[] encryptionKeyIn, TPMT_SYM_DEF_OBJECT symmetricAlg) {
        TPM2_Duplicate_REQUEST req = new TPM2_Duplicate_REQUEST(objectHandle, newParentHandle, encryptionKeyIn, symmetricAlg);
        DuplicateResponse resp = new DuplicateResponse();
        this.DispatchCommand(TPM_CC.Duplicate, req, resp);
        return resp;
    }

    public RewrapResponse Rewrap(TPM_HANDLE oldParent, TPM_HANDLE newParent, TPM2B_PRIVATE inDuplicate, byte[] name, byte[] inSymSeed) {
        TPM2_Rewrap_REQUEST req = new TPM2_Rewrap_REQUEST(oldParent, newParent, inDuplicate, name, inSymSeed);
        RewrapResponse resp = new RewrapResponse();
        this.DispatchCommand(TPM_CC.Rewrap, req, resp);
        return resp;
    }

    public TPM2B_PRIVATE Import(TPM_HANDLE parentHandle, byte[] encryptionKey, TPMT_PUBLIC objectPublic, TPM2B_PRIVATE duplicate, byte[] inSymSeed, TPMT_SYM_DEF_OBJECT symmetricAlg) {
        TPM2_Import_REQUEST req = new TPM2_Import_REQUEST(parentHandle, encryptionKey, objectPublic, duplicate, inSymSeed, symmetricAlg);
        ImportResponse resp = new ImportResponse();
        this.DispatchCommand(TPM_CC.Import, req, resp);
        return resp.outPrivate;
    }

    public byte[] RSA_Encrypt(TPM_HANDLE keyHandle, byte[] message, TPMU_ASYM_SCHEME inScheme, byte[] label) {
        TPM2_RSA_Encrypt_REQUEST req = new TPM2_RSA_Encrypt_REQUEST(keyHandle, message, inScheme, label);
        RSA_EncryptResponse resp = new RSA_EncryptResponse();
        this.DispatchCommand(TPM_CC.RSA_Encrypt, req, resp);
        return resp.outData;
    }

    public byte[] RSA_Decrypt(TPM_HANDLE keyHandle, byte[] cipherText, TPMU_ASYM_SCHEME inScheme, byte[] label) {
        TPM2_RSA_Decrypt_REQUEST req = new TPM2_RSA_Decrypt_REQUEST(keyHandle, cipherText, inScheme, label);
        RSA_DecryptResponse resp = new RSA_DecryptResponse();
        this.DispatchCommand(TPM_CC.RSA_Decrypt, req, resp);
        return resp.message;
    }

    public ECDH_KeyGenResponse ECDH_KeyGen(TPM_HANDLE keyHandle) {
        TPM2_ECDH_KeyGen_REQUEST req = new TPM2_ECDH_KeyGen_REQUEST(keyHandle);
        ECDH_KeyGenResponse resp = new ECDH_KeyGenResponse();
        this.DispatchCommand(TPM_CC.ECDH_KeyGen, req, resp);
        return resp;
    }

    public TPMS_ECC_POINT ECDH_ZGen(TPM_HANDLE keyHandle, TPMS_ECC_POINT inPoint) {
        TPM2_ECDH_ZGen_REQUEST req = new TPM2_ECDH_ZGen_REQUEST(keyHandle, inPoint);
        ECDH_ZGenResponse resp = new ECDH_ZGenResponse();
        this.DispatchCommand(TPM_CC.ECDH_ZGen, req, resp);
        return resp.outPoint;
    }

    public TPMS_ALGORITHM_DETAIL_ECC ECC_Parameters(TPM_ECC_CURVE curveID) {
        TPM2_ECC_Parameters_REQUEST req = new TPM2_ECC_Parameters_REQUEST(curveID);
        ECC_ParametersResponse resp = new ECC_ParametersResponse();
        this.DispatchCommand(TPM_CC.ECC_Parameters, req, resp);
        return resp.parameters;
    }

    public ZGen_2PhaseResponse ZGen_2Phase(TPM_HANDLE keyA, TPMS_ECC_POINT inQsB, TPMS_ECC_POINT inQeB, TPM_ALG_ID inScheme, int counter) {
        TPM2_ZGen_2Phase_REQUEST req = new TPM2_ZGen_2Phase_REQUEST(keyA, inQsB, inQeB, inScheme, counter);
        ZGen_2PhaseResponse resp = new ZGen_2PhaseResponse();
        this.DispatchCommand(TPM_CC.ZGen_2Phase, req, resp);
        return resp;
    }

    public ECC_EncryptResponse ECC_Encrypt(TPM_HANDLE keyHandle, byte[] plainText, TPMU_KDF_SCHEME inScheme) {
        TPM2_ECC_Encrypt_REQUEST req = new TPM2_ECC_Encrypt_REQUEST(keyHandle, plainText, inScheme);
        ECC_EncryptResponse resp = new ECC_EncryptResponse();
        this.DispatchCommand(TPM_CC.ECC_Encrypt, req, resp);
        return resp;
    }

    public byte[] ECC_Decrypt(TPM_HANDLE keyHandle, TPMS_ECC_POINT C1, byte[] C2, byte[] C3, TPMU_KDF_SCHEME inScheme) {
        TPM2_ECC_Decrypt_REQUEST req = new TPM2_ECC_Decrypt_REQUEST(keyHandle, C1, C2, C3, inScheme);
        ECC_DecryptResponse resp = new ECC_DecryptResponse();
        this.DispatchCommand(TPM_CC.ECC_Decrypt, req, resp);
        return resp.plainText;
    }

    public EncryptDecryptResponse EncryptDecrypt(TPM_HANDLE keyHandle, byte decrypt, TPM_ALG_ID mode, byte[] ivIn, byte[] inData) {
        TPM2_EncryptDecrypt_REQUEST req = new TPM2_EncryptDecrypt_REQUEST(keyHandle, decrypt, mode, ivIn, inData);
        EncryptDecryptResponse resp = new EncryptDecryptResponse();
        this.DispatchCommand(TPM_CC.EncryptDecrypt, req, resp);
        return resp;
    }

    public EncryptDecrypt2Response EncryptDecrypt2(TPM_HANDLE keyHandle, byte[] inData, byte decrypt, TPM_ALG_ID mode, byte[] ivIn) {
        TPM2_EncryptDecrypt2_REQUEST req = new TPM2_EncryptDecrypt2_REQUEST(keyHandle, inData, decrypt, mode, ivIn);
        EncryptDecrypt2Response resp = new EncryptDecrypt2Response();
        this.DispatchCommand(TPM_CC.EncryptDecrypt2, req, resp);
        return resp;
    }

    public HashResponse Hash(byte[] data, TPM_ALG_ID hashAlg, TPM_HANDLE hierarchy) {
        TPM2_Hash_REQUEST req = new TPM2_Hash_REQUEST(data, hashAlg, hierarchy);
        HashResponse resp = new HashResponse();
        this.DispatchCommand(TPM_CC.Hash, req, resp);
        return resp;
    }

    public byte[] HMAC(TPM_HANDLE handle, byte[] buffer, TPM_ALG_ID hashAlg) {
        TPM2_HMAC_REQUEST req = new TPM2_HMAC_REQUEST(handle, buffer, hashAlg);
        HMACResponse resp = new HMACResponse();
        this.DispatchCommand(TPM_CC.HMAC, req, resp);
        return resp.outHMAC;
    }

    public byte[] MAC(TPM_HANDLE handle, byte[] buffer, TPM_ALG_ID inScheme) {
        TPM2_MAC_REQUEST req = new TPM2_MAC_REQUEST(handle, buffer, inScheme);
        MACResponse resp = new MACResponse();
        this.DispatchCommand(TPM_CC.MAC, req, resp);
        return resp.outMAC;
    }

    public byte[] GetRandom(int bytesRequested) {
        TPM2_GetRandom_REQUEST req = new TPM2_GetRandom_REQUEST(bytesRequested);
        GetRandomResponse resp = new GetRandomResponse();
        this.DispatchCommand(TPM_CC.GetRandom, req, resp);
        return resp.randomBytes;
    }

    public void StirRandom(byte[] inData) {
        TPM2_StirRandom_REQUEST req = new TPM2_StirRandom_REQUEST(inData);
        this.DispatchCommand(TPM_CC.StirRandom, req, null);
    }

    public TPM_HANDLE HMAC_Start(TPM_HANDLE handle, byte[] auth, TPM_ALG_ID hashAlg) {
        TPM2_HMAC_Start_REQUEST req = new TPM2_HMAC_Start_REQUEST(handle, auth, hashAlg);
        HMAC_StartResponse resp = new HMAC_StartResponse();
        this.DispatchCommand(TPM_CC.HMAC_Start, req, resp);
        return resp.handle;
    }

    public TPM_HANDLE MAC_Start(TPM_HANDLE handle, byte[] auth, TPM_ALG_ID inScheme) {
        TPM2_MAC_Start_REQUEST req = new TPM2_MAC_Start_REQUEST(handle, auth, inScheme);
        MAC_StartResponse resp = new MAC_StartResponse();
        this.DispatchCommand(TPM_CC.MAC_Start, req, resp);
        return resp.handle;
    }

    public TPM_HANDLE HashSequenceStart(byte[] auth, TPM_ALG_ID hashAlg) {
        TPM2_HashSequenceStart_REQUEST req = new TPM2_HashSequenceStart_REQUEST(auth, hashAlg);
        HashSequenceStartResponse resp = new HashSequenceStartResponse();
        this.DispatchCommand(TPM_CC.HashSequenceStart, req, resp);
        return resp.handle;
    }

    public void SequenceUpdate(TPM_HANDLE sequenceHandle, byte[] buffer) {
        TPM2_SequenceUpdate_REQUEST req = new TPM2_SequenceUpdate_REQUEST(sequenceHandle, buffer);
        this.DispatchCommand(TPM_CC.SequenceUpdate, req, null);
    }

    public SequenceCompleteResponse SequenceComplete(TPM_HANDLE sequenceHandle, byte[] buffer, TPM_HANDLE hierarchy) {
        TPM2_SequenceComplete_REQUEST req = new TPM2_SequenceComplete_REQUEST(sequenceHandle, buffer, hierarchy);
        SequenceCompleteResponse resp = new SequenceCompleteResponse();
        this.DispatchCommand(TPM_CC.SequenceComplete, req, resp);
        return resp;
    }

    public TPMT_HA[] EventSequenceComplete(TPM_HANDLE pcrHandle, TPM_HANDLE sequenceHandle, byte[] buffer) {
        TPM2_EventSequenceComplete_REQUEST req = new TPM2_EventSequenceComplete_REQUEST(pcrHandle, sequenceHandle, buffer);
        EventSequenceCompleteResponse resp = new EventSequenceCompleteResponse();
        this.DispatchCommand(TPM_CC.EventSequenceComplete, req, resp);
        return resp.results;
    }

    public CertifyResponse Certify(TPM_HANDLE objectHandle, TPM_HANDLE signHandle, byte[] qualifyingData, TPMU_SIG_SCHEME inScheme) {
        TPM2_Certify_REQUEST req = new TPM2_Certify_REQUEST(objectHandle, signHandle, qualifyingData, inScheme);
        CertifyResponse resp = new CertifyResponse();
        this.DispatchCommand(TPM_CC.Certify, req, resp);
        return resp;
    }

    public CertifyCreationResponse CertifyCreation(TPM_HANDLE signHandle, TPM_HANDLE objectHandle, byte[] qualifyingData, byte[] creationHash, TPMU_SIG_SCHEME inScheme, TPMT_TK_CREATION creationTicket) {
        TPM2_CertifyCreation_REQUEST req = new TPM2_CertifyCreation_REQUEST(signHandle, objectHandle, qualifyingData, creationHash, inScheme, creationTicket);
        CertifyCreationResponse resp = new CertifyCreationResponse();
        this.DispatchCommand(TPM_CC.CertifyCreation, req, resp);
        return resp;
    }

    public QuoteResponse Quote(TPM_HANDLE signHandle, byte[] qualifyingData, TPMU_SIG_SCHEME inScheme, TPMS_PCR_SELECTION[] PCRselect) {
        TPM2_Quote_REQUEST req = new TPM2_Quote_REQUEST(signHandle, qualifyingData, inScheme, PCRselect);
        QuoteResponse resp = new QuoteResponse();
        this.DispatchCommand(TPM_CC.Quote, req, resp);
        return resp;
    }

    public GetSessionAuditDigestResponse GetSessionAuditDigest(TPM_HANDLE privacyAdminHandle, TPM_HANDLE signHandle, TPM_HANDLE sessionHandle, byte[] qualifyingData, TPMU_SIG_SCHEME inScheme) {
        TPM2_GetSessionAuditDigest_REQUEST req = new TPM2_GetSessionAuditDigest_REQUEST(privacyAdminHandle, signHandle, sessionHandle, qualifyingData, inScheme);
        GetSessionAuditDigestResponse resp = new GetSessionAuditDigestResponse();
        this.DispatchCommand(TPM_CC.GetSessionAuditDigest, req, resp);
        return resp;
    }

    public GetCommandAuditDigestResponse GetCommandAuditDigest(TPM_HANDLE privacyHandle, TPM_HANDLE signHandle, byte[] qualifyingData, TPMU_SIG_SCHEME inScheme) {
        TPM2_GetCommandAuditDigest_REQUEST req = new TPM2_GetCommandAuditDigest_REQUEST(privacyHandle, signHandle, qualifyingData, inScheme);
        GetCommandAuditDigestResponse resp = new GetCommandAuditDigestResponse();
        this.DispatchCommand(TPM_CC.GetCommandAuditDigest, req, resp);
        return resp;
    }

    public GetTimeResponse GetTime(TPM_HANDLE privacyAdminHandle, TPM_HANDLE signHandle, byte[] qualifyingData, TPMU_SIG_SCHEME inScheme) {
        TPM2_GetTime_REQUEST req = new TPM2_GetTime_REQUEST(privacyAdminHandle, signHandle, qualifyingData, inScheme);
        GetTimeResponse resp = new GetTimeResponse();
        this.DispatchCommand(TPM_CC.GetTime, req, resp);
        return resp;
    }

    public CertifyX509Response CertifyX509(TPM_HANDLE objectHandle, TPM_HANDLE signHandle, byte[] reserved, TPMU_SIG_SCHEME inScheme, byte[] partialCertificate) {
        TPM2_CertifyX509_REQUEST req = new TPM2_CertifyX509_REQUEST(objectHandle, signHandle, reserved, inScheme, partialCertificate);
        CertifyX509Response resp = new CertifyX509Response();
        this.DispatchCommand(TPM_CC.CertifyX509, req, resp);
        return resp;
    }

    public CommitResponse Commit(TPM_HANDLE signHandle, TPMS_ECC_POINT P1, byte[] s2, byte[] y2) {
        TPM2_Commit_REQUEST req = new TPM2_Commit_REQUEST(signHandle, P1, s2, y2);
        CommitResponse resp = new CommitResponse();
        this.DispatchCommand(TPM_CC.Commit, req, resp);
        return resp;
    }

    public EC_EphemeralResponse EC_Ephemeral(TPM_ECC_CURVE curveID) {
        TPM2_EC_Ephemeral_REQUEST req = new TPM2_EC_Ephemeral_REQUEST(curveID);
        EC_EphemeralResponse resp = new EC_EphemeralResponse();
        this.DispatchCommand(TPM_CC.EC_Ephemeral, req, resp);
        return resp;
    }

    public TPMT_TK_VERIFIED VerifySignature(TPM_HANDLE keyHandle, byte[] digest, TPMU_SIGNATURE signature) {
        TPM2_VerifySignature_REQUEST req = new TPM2_VerifySignature_REQUEST(keyHandle, digest, signature);
        VerifySignatureResponse resp = new VerifySignatureResponse();
        this.DispatchCommand(TPM_CC.VerifySignature, req, resp);
        return resp.validation;
    }

    public TPMU_SIGNATURE Sign(TPM_HANDLE keyHandle, byte[] digest, TPMU_SIG_SCHEME inScheme, TPMT_TK_HASHCHECK validation) {
        TPM2_Sign_REQUEST req = new TPM2_Sign_REQUEST(keyHandle, digest, inScheme, validation);
        SignResponse resp = new SignResponse();
        this.DispatchCommand(TPM_CC.Sign, req, resp);
        return resp.signature;
    }

    public void SetCommandCodeAuditStatus(TPM_HANDLE auth, TPM_ALG_ID auditAlg, TPM_CC[] setList, TPM_CC[] clearList) {
        TPM2_SetCommandCodeAuditStatus_REQUEST req = new TPM2_SetCommandCodeAuditStatus_REQUEST(auth, auditAlg, setList, clearList);
        this.DispatchCommand(TPM_CC.SetCommandCodeAuditStatus, req, null);
    }

    public void PCR_Extend(TPM_HANDLE pcrHandle, TPMT_HA[] digests) {
        TPM2_PCR_Extend_REQUEST req = new TPM2_PCR_Extend_REQUEST(pcrHandle, digests);
        this.DispatchCommand(TPM_CC.PCR_Extend, req, null);
    }

    public TPMT_HA[] PCR_Event(TPM_HANDLE pcrHandle, byte[] eventData) {
        TPM2_PCR_Event_REQUEST req = new TPM2_PCR_Event_REQUEST(pcrHandle, eventData);
        PCR_EventResponse resp = new PCR_EventResponse();
        this.DispatchCommand(TPM_CC.PCR_Event, req, resp);
        return resp.digests;
    }

    public PCR_ReadResponse PCR_Read(TPMS_PCR_SELECTION[] pcrSelectionIn) {
        TPM2_PCR_Read_REQUEST req = new TPM2_PCR_Read_REQUEST(pcrSelectionIn);
        PCR_ReadResponse resp = new PCR_ReadResponse();
        this.DispatchCommand(TPM_CC.PCR_Read, req, resp);
        return resp;
    }

    public PCR_AllocateResponse PCR_Allocate(TPM_HANDLE authHandle, TPMS_PCR_SELECTION[] pcrAllocation) {
        TPM2_PCR_Allocate_REQUEST req = new TPM2_PCR_Allocate_REQUEST(authHandle, pcrAllocation);
        PCR_AllocateResponse resp = new PCR_AllocateResponse();
        this.DispatchCommand(TPM_CC.PCR_Allocate, req, resp);
        return resp;
    }

    public void PCR_SetAuthPolicy(TPM_HANDLE authHandle, byte[] authPolicy, TPM_ALG_ID hashAlg, TPM_HANDLE pcrNum) {
        TPM2_PCR_SetAuthPolicy_REQUEST req = new TPM2_PCR_SetAuthPolicy_REQUEST(authHandle, authPolicy, hashAlg, pcrNum);
        this.DispatchCommand(TPM_CC.PCR_SetAuthPolicy, req, null);
    }

    public void PCR_SetAuthValue(TPM_HANDLE pcrHandle, byte[] auth) {
        TPM2_PCR_SetAuthValue_REQUEST req = new TPM2_PCR_SetAuthValue_REQUEST(pcrHandle, auth);
        this.DispatchCommand(TPM_CC.PCR_SetAuthValue, req, null);
    }

    public void PCR_Reset(TPM_HANDLE pcrHandle) {
        TPM2_PCR_Reset_REQUEST req = new TPM2_PCR_Reset_REQUEST(pcrHandle);
        this.DispatchCommand(TPM_CC.PCR_Reset, req, null);
    }

    public PolicySignedResponse PolicySigned(TPM_HANDLE authObject, TPM_HANDLE policySession, byte[] nonceTPM, byte[] cpHashA, byte[] policyRef, int expiration, TPMU_SIGNATURE auth) {
        TPM2_PolicySigned_REQUEST req = new TPM2_PolicySigned_REQUEST(authObject, policySession, nonceTPM, cpHashA, policyRef, expiration, auth);
        PolicySignedResponse resp = new PolicySignedResponse();
        this.DispatchCommand(TPM_CC.PolicySigned, req, resp);
        return resp;
    }

    public PolicySecretResponse PolicySecret(TPM_HANDLE authHandle, TPM_HANDLE policySession, byte[] nonceTPM, byte[] cpHashA, byte[] policyRef, int expiration) {
        TPM2_PolicySecret_REQUEST req = new TPM2_PolicySecret_REQUEST(authHandle, policySession, nonceTPM, cpHashA, policyRef, expiration);
        PolicySecretResponse resp = new PolicySecretResponse();
        this.DispatchCommand(TPM_CC.PolicySecret, req, resp);
        return resp;
    }

    public void PolicyTicket(TPM_HANDLE policySession, byte[] timeout, byte[] cpHashA, byte[] policyRef, byte[] authName, TPMT_TK_AUTH ticket) {
        TPM2_PolicyTicket_REQUEST req = new TPM2_PolicyTicket_REQUEST(policySession, timeout, cpHashA, policyRef, authName, ticket);
        this.DispatchCommand(TPM_CC.PolicyTicket, req, null);
    }

    public void PolicyOR(TPM_HANDLE policySession, TPM2B_DIGEST[] pHashList) {
        TPM2_PolicyOR_REQUEST req = new TPM2_PolicyOR_REQUEST(policySession, pHashList);
        this.DispatchCommand(TPM_CC.PolicyOR, req, null);
    }

    public void PolicyPCR(TPM_HANDLE policySession, byte[] pcrDigest, TPMS_PCR_SELECTION[] pcrs) {
        TPM2_PolicyPCR_REQUEST req = new TPM2_PolicyPCR_REQUEST(policySession, pcrDigest, pcrs);
        this.DispatchCommand(TPM_CC.PolicyPCR, req, null);
    }

    public void PolicyLocality(TPM_HANDLE policySession, TPMA_LOCALITY locality) {
        TPM2_PolicyLocality_REQUEST req = new TPM2_PolicyLocality_REQUEST(policySession, locality);
        this.DispatchCommand(TPM_CC.PolicyLocality, req, null);
    }

    public void PolicyNV(TPM_HANDLE authHandle, TPM_HANDLE nvIndex, TPM_HANDLE policySession, byte[] operandB, int offset, TPM_EO operation) {
        TPM2_PolicyNV_REQUEST req = new TPM2_PolicyNV_REQUEST(authHandle, nvIndex, policySession, operandB, offset, operation);
        this.DispatchCommand(TPM_CC.PolicyNV, req, null);
    }

    public void PolicyCounterTimer(TPM_HANDLE policySession, byte[] operandB, int offset, TPM_EO operation) {
        TPM2_PolicyCounterTimer_REQUEST req = new TPM2_PolicyCounterTimer_REQUEST(policySession, operandB, offset, operation);
        this.DispatchCommand(TPM_CC.PolicyCounterTimer, req, null);
    }

    public void PolicyCommandCode(TPM_HANDLE policySession, TPM_CC code) {
        TPM2_PolicyCommandCode_REQUEST req = new TPM2_PolicyCommandCode_REQUEST(policySession, code);
        this.DispatchCommand(TPM_CC.PolicyCommandCode, req, null);
    }

    public void PolicyPhysicalPresence(TPM_HANDLE policySession) {
        TPM2_PolicyPhysicalPresence_REQUEST req = new TPM2_PolicyPhysicalPresence_REQUEST(policySession);
        this.DispatchCommand(TPM_CC.PolicyPhysicalPresence, req, null);
    }

    public void PolicyCpHash(TPM_HANDLE policySession, byte[] cpHashA) {
        TPM2_PolicyCpHash_REQUEST req = new TPM2_PolicyCpHash_REQUEST(policySession, cpHashA);
        this.DispatchCommand(TPM_CC.PolicyCpHash, req, null);
    }

    public void PolicyNameHash(TPM_HANDLE policySession, byte[] nameHash) {
        TPM2_PolicyNameHash_REQUEST req = new TPM2_PolicyNameHash_REQUEST(policySession, nameHash);
        this.DispatchCommand(TPM_CC.PolicyNameHash, req, null);
    }

    public void PolicyDuplicationSelect(TPM_HANDLE policySession, byte[] objectName, byte[] newParentName, byte includeObject) {
        TPM2_PolicyDuplicationSelect_REQUEST req = new TPM2_PolicyDuplicationSelect_REQUEST(policySession, objectName, newParentName, includeObject);
        this.DispatchCommand(TPM_CC.PolicyDuplicationSelect, req, null);
    }

    public void PolicyAuthorize(TPM_HANDLE policySession, byte[] approvedPolicy, byte[] policyRef, byte[] keySign, TPMT_TK_VERIFIED checkTicket) {
        TPM2_PolicyAuthorize_REQUEST req = new TPM2_PolicyAuthorize_REQUEST(policySession, approvedPolicy, policyRef, keySign, checkTicket);
        this.DispatchCommand(TPM_CC.PolicyAuthorize, req, null);
    }

    public void PolicyAuthValue(TPM_HANDLE policySession) {
        TPM2_PolicyAuthValue_REQUEST req = new TPM2_PolicyAuthValue_REQUEST(policySession);
        this.DispatchCommand(TPM_CC.PolicyAuthValue, req, null);
    }

    public void PolicyPassword(TPM_HANDLE policySession) {
        TPM2_PolicyPassword_REQUEST req = new TPM2_PolicyPassword_REQUEST(policySession);
        this.DispatchCommand(TPM_CC.PolicyPassword, req, null);
    }

    public byte[] PolicyGetDigest(TPM_HANDLE policySession) {
        TPM2_PolicyGetDigest_REQUEST req = new TPM2_PolicyGetDigest_REQUEST(policySession);
        PolicyGetDigestResponse resp = new PolicyGetDigestResponse();
        this.DispatchCommand(TPM_CC.PolicyGetDigest, req, resp);
        return resp.policyDigest;
    }

    public void PolicyNvWritten(TPM_HANDLE policySession, byte writtenSet) {
        TPM2_PolicyNvWritten_REQUEST req = new TPM2_PolicyNvWritten_REQUEST(policySession, writtenSet);
        this.DispatchCommand(TPM_CC.PolicyNvWritten, req, null);
    }

    public void PolicyTemplate(TPM_HANDLE policySession, byte[] templateHash) {
        TPM2_PolicyTemplate_REQUEST req = new TPM2_PolicyTemplate_REQUEST(policySession, templateHash);
        this.DispatchCommand(TPM_CC.PolicyTemplate, req, null);
    }

    public void PolicyAuthorizeNV(TPM_HANDLE authHandle, TPM_HANDLE nvIndex, TPM_HANDLE policySession) {
        TPM2_PolicyAuthorizeNV_REQUEST req = new TPM2_PolicyAuthorizeNV_REQUEST(authHandle, nvIndex, policySession);
        this.DispatchCommand(TPM_CC.PolicyAuthorizeNV, req, null);
    }

    public CreatePrimaryResponse CreatePrimary(TPM_HANDLE primaryHandle, TPMS_SENSITIVE_CREATE inSensitive, TPMT_PUBLIC inPublic, byte[] outsideInfo, TPMS_PCR_SELECTION[] creationPCR) {
        TPM2_CreatePrimary_REQUEST req = new TPM2_CreatePrimary_REQUEST(primaryHandle, inSensitive, inPublic, outsideInfo, creationPCR);
        CreatePrimaryResponse resp = new CreatePrimaryResponse();
        this.DispatchCommand(TPM_CC.CreatePrimary, req, resp);
        return resp;
    }

    public void HierarchyControl(TPM_HANDLE authHandle, TPM_HANDLE enable, byte state) {
        TPM2_HierarchyControl_REQUEST req = new TPM2_HierarchyControl_REQUEST(authHandle, enable, state);
        this.DispatchCommand(TPM_CC.HierarchyControl, req, null);
    }

    public void SetPrimaryPolicy(TPM_HANDLE authHandle, byte[] authPolicy, TPM_ALG_ID hashAlg) {
        TPM2_SetPrimaryPolicy_REQUEST req = new TPM2_SetPrimaryPolicy_REQUEST(authHandle, authPolicy, hashAlg);
        this.DispatchCommand(TPM_CC.SetPrimaryPolicy, req, null);
    }

    public void ChangePPS(TPM_HANDLE authHandle) {
        TPM2_ChangePPS_REQUEST req = new TPM2_ChangePPS_REQUEST(authHandle);
        this.DispatchCommand(TPM_CC.ChangePPS, req, null);
    }

    public void ChangeEPS(TPM_HANDLE authHandle) {
        TPM2_ChangeEPS_REQUEST req = new TPM2_ChangeEPS_REQUEST(authHandle);
        this.DispatchCommand(TPM_CC.ChangeEPS, req, null);
    }

    public void Clear(TPM_HANDLE authHandle) {
        TPM2_Clear_REQUEST req = new TPM2_Clear_REQUEST(authHandle);
        this.DispatchCommand(TPM_CC.Clear, req, null);
    }

    public void ClearControl(TPM_HANDLE auth, byte disable) {
        TPM2_ClearControl_REQUEST req = new TPM2_ClearControl_REQUEST(auth, disable);
        this.DispatchCommand(TPM_CC.ClearControl, req, null);
    }

    public void HierarchyChangeAuth(TPM_HANDLE authHandle, byte[] newAuth) {
        TPM2_HierarchyChangeAuth_REQUEST req = new TPM2_HierarchyChangeAuth_REQUEST(authHandle, newAuth);
        this.DispatchCommand(TPM_CC.HierarchyChangeAuth, req, null);
    }

    public void DictionaryAttackLockReset(TPM_HANDLE lockHandle) {
        TPM2_DictionaryAttackLockReset_REQUEST req = new TPM2_DictionaryAttackLockReset_REQUEST(lockHandle);
        this.DispatchCommand(TPM_CC.DictionaryAttackLockReset, req, null);
    }

    public void DictionaryAttackParameters(TPM_HANDLE lockHandle, int newMaxTries, int newRecoveryTime, int lockoutRecovery) {
        TPM2_DictionaryAttackParameters_REQUEST req = new TPM2_DictionaryAttackParameters_REQUEST(lockHandle, newMaxTries, newRecoveryTime, lockoutRecovery);
        this.DispatchCommand(TPM_CC.DictionaryAttackParameters, req, null);
    }

    public void PP_Commands(TPM_HANDLE auth, TPM_CC[] setList, TPM_CC[] clearList) {
        TPM2_PP_Commands_REQUEST req = new TPM2_PP_Commands_REQUEST(auth, setList, clearList);
        this.DispatchCommand(TPM_CC.PP_Commands, req, null);
    }

    public void SetAlgorithmSet(TPM_HANDLE authHandle, int algorithmSet) {
        TPM2_SetAlgorithmSet_REQUEST req = new TPM2_SetAlgorithmSet_REQUEST(authHandle, algorithmSet);
        this.DispatchCommand(TPM_CC.SetAlgorithmSet, req, null);
    }

    public void FieldUpgradeStart(TPM_HANDLE authorization, TPM_HANDLE keyHandle, byte[] fuDigest, TPMU_SIGNATURE manifestSignature) {
        TPM2_FieldUpgradeStart_REQUEST req = new TPM2_FieldUpgradeStart_REQUEST(authorization, keyHandle, fuDigest, manifestSignature);
        this.DispatchCommand(TPM_CC.FieldUpgradeStart, req, null);
    }

    public FieldUpgradeDataResponse FieldUpgradeData(byte[] fuData) {
        TPM2_FieldUpgradeData_REQUEST req = new TPM2_FieldUpgradeData_REQUEST(fuData);
        FieldUpgradeDataResponse resp = new FieldUpgradeDataResponse();
        this.DispatchCommand(TPM_CC.FieldUpgradeData, req, resp);
        return resp;
    }

    public byte[] FirmwareRead(int sequenceNumber) {
        TPM2_FirmwareRead_REQUEST req = new TPM2_FirmwareRead_REQUEST(sequenceNumber);
        FirmwareReadResponse resp = new FirmwareReadResponse();
        this.DispatchCommand(TPM_CC.FirmwareRead, req, resp);
        return resp.fuData;
    }

    public TPMS_CONTEXT ContextSave(TPM_HANDLE saveHandle) {
        TPM2_ContextSave_REQUEST req = new TPM2_ContextSave_REQUEST(saveHandle);
        ContextSaveResponse resp = new ContextSaveResponse();
        this.DispatchCommand(TPM_CC.ContextSave, req, resp);
        return resp.context;
    }

    public TPM_HANDLE ContextLoad(TPMS_CONTEXT context) {
        TPM2_ContextLoad_REQUEST req = new TPM2_ContextLoad_REQUEST(context);
        ContextLoadResponse resp = new ContextLoadResponse();
        this.DispatchCommand(TPM_CC.ContextLoad, req, resp);
        return resp.handle;
    }

    public void FlushContext(TPM_HANDLE flushHandle) {
        TPM2_FlushContext_REQUEST req = new TPM2_FlushContext_REQUEST(flushHandle);
        this.DispatchCommand(TPM_CC.FlushContext, req, null);
    }

    public void EvictControl(TPM_HANDLE auth, TPM_HANDLE objectHandle, TPM_HANDLE persistentHandle) {
        TPM2_EvictControl_REQUEST req = new TPM2_EvictControl_REQUEST(auth, objectHandle, persistentHandle);
        this.DispatchCommand(TPM_CC.EvictControl, req, null);
    }

    public TPMS_TIME_INFO ReadClock() {
        TPM2_ReadClock_REQUEST req = new TPM2_ReadClock_REQUEST();
        ReadClockResponse resp = new ReadClockResponse();
        this.DispatchCommand(TPM_CC.ReadClock, req, resp);
        return resp.currentTime;
    }

    public void ClockSet(TPM_HANDLE auth, long newTime) {
        TPM2_ClockSet_REQUEST req = new TPM2_ClockSet_REQUEST(auth, newTime);
        this.DispatchCommand(TPM_CC.ClockSet, req, null);
    }

    public void ClockRateAdjust(TPM_HANDLE auth, TPM_CLOCK_ADJUST rateAdjust) {
        TPM2_ClockRateAdjust_REQUEST req = new TPM2_ClockRateAdjust_REQUEST(auth, rateAdjust);
        this.DispatchCommand(TPM_CC.ClockRateAdjust, req, null);
    }

    public GetCapabilityResponse GetCapability(TPM_CAP capability, int property, int propertyCount) {
        TPM2_GetCapability_REQUEST req = new TPM2_GetCapability_REQUEST(capability, property, propertyCount);
        GetCapabilityResponse resp = new GetCapabilityResponse();
        this.DispatchCommand(TPM_CC.GetCapability, req, resp);
        return resp;
    }

    public void TestParms(TPMU_PUBLIC_PARMS parameters) {
        TPM2_TestParms_REQUEST req = new TPM2_TestParms_REQUEST(parameters);
        this.DispatchCommand(TPM_CC.TestParms, req, null);
    }

    public void NV_DefineSpace(TPM_HANDLE authHandle, byte[] auth, TPMS_NV_PUBLIC publicInfo) {
        TPM2_NV_DefineSpace_REQUEST req = new TPM2_NV_DefineSpace_REQUEST(authHandle, auth, publicInfo);
        this.DispatchCommand(TPM_CC.NV_DefineSpace, req, null);
    }

    public void NV_UndefineSpace(TPM_HANDLE authHandle, TPM_HANDLE nvIndex) {
        TPM2_NV_UndefineSpace_REQUEST req = new TPM2_NV_UndefineSpace_REQUEST(authHandle, nvIndex);
        this.DispatchCommand(TPM_CC.NV_UndefineSpace, req, null);
    }

    public void NV_UndefineSpaceSpecial(TPM_HANDLE nvIndex, TPM_HANDLE platform) {
        TPM2_NV_UndefineSpaceSpecial_REQUEST req = new TPM2_NV_UndefineSpaceSpecial_REQUEST(nvIndex, platform);
        this.DispatchCommand(TPM_CC.NV_UndefineSpaceSpecial, req, null);
    }

    public NV_ReadPublicResponse NV_ReadPublic(TPM_HANDLE nvIndex) {
        TPM2_NV_ReadPublic_REQUEST req = new TPM2_NV_ReadPublic_REQUEST(nvIndex);
        NV_ReadPublicResponse resp = new NV_ReadPublicResponse();
        this.DispatchCommand(TPM_CC.NV_ReadPublic, req, resp);
        return resp;
    }

    public void NV_Write(TPM_HANDLE authHandle, TPM_HANDLE nvIndex, byte[] data, int offset) {
        TPM2_NV_Write_REQUEST req = new TPM2_NV_Write_REQUEST(authHandle, nvIndex, data, offset);
        this.DispatchCommand(TPM_CC.NV_Write, req, null);
    }

    public void NV_Increment(TPM_HANDLE authHandle, TPM_HANDLE nvIndex) {
        TPM2_NV_Increment_REQUEST req = new TPM2_NV_Increment_REQUEST(authHandle, nvIndex);
        this.DispatchCommand(TPM_CC.NV_Increment, req, null);
    }

    public void NV_Extend(TPM_HANDLE authHandle, TPM_HANDLE nvIndex, byte[] data) {
        TPM2_NV_Extend_REQUEST req = new TPM2_NV_Extend_REQUEST(authHandle, nvIndex, data);
        this.DispatchCommand(TPM_CC.NV_Extend, req, null);
    }

    public void NV_SetBits(TPM_HANDLE authHandle, TPM_HANDLE nvIndex, long bits) {
        TPM2_NV_SetBits_REQUEST req = new TPM2_NV_SetBits_REQUEST(authHandle, nvIndex, bits);
        this.DispatchCommand(TPM_CC.NV_SetBits, req, null);
    }

    public void NV_WriteLock(TPM_HANDLE authHandle, TPM_HANDLE nvIndex) {
        TPM2_NV_WriteLock_REQUEST req = new TPM2_NV_WriteLock_REQUEST(authHandle, nvIndex);
        this.DispatchCommand(TPM_CC.NV_WriteLock, req, null);
    }

    public void NV_GlobalWriteLock(TPM_HANDLE authHandle) {
        TPM2_NV_GlobalWriteLock_REQUEST req = new TPM2_NV_GlobalWriteLock_REQUEST(authHandle);
        this.DispatchCommand(TPM_CC.NV_GlobalWriteLock, req, null);
    }

    public byte[] NV_Read(TPM_HANDLE authHandle, TPM_HANDLE nvIndex, int size, int offset) {
        TPM2_NV_Read_REQUEST req = new TPM2_NV_Read_REQUEST(authHandle, nvIndex, size, offset);
        NV_ReadResponse resp = new NV_ReadResponse();
        this.DispatchCommand(TPM_CC.NV_Read, req, resp);
        return resp.data;
    }

    public void NV_ReadLock(TPM_HANDLE authHandle, TPM_HANDLE nvIndex) {
        TPM2_NV_ReadLock_REQUEST req = new TPM2_NV_ReadLock_REQUEST(authHandle, nvIndex);
        this.DispatchCommand(TPM_CC.NV_ReadLock, req, null);
    }

    public void NV_ChangeAuth(TPM_HANDLE nvIndex, byte[] newAuth) {
        TPM2_NV_ChangeAuth_REQUEST req = new TPM2_NV_ChangeAuth_REQUEST(nvIndex, newAuth);
        this.DispatchCommand(TPM_CC.NV_ChangeAuth, req, null);
    }

    public NV_CertifyResponse NV_Certify(TPM_HANDLE signHandle, TPM_HANDLE authHandle, TPM_HANDLE nvIndex, byte[] qualifyingData, TPMU_SIG_SCHEME inScheme, int size, int offset) {
        TPM2_NV_Certify_REQUEST req = new TPM2_NV_Certify_REQUEST(signHandle, authHandle, nvIndex, qualifyingData, inScheme, size, offset);
        NV_CertifyResponse resp = new NV_CertifyResponse();
        this.DispatchCommand(TPM_CC.NV_Certify, req, resp);
        return resp;
    }

    public AC_GetCapabilityResponse AC_GetCapability(TPM_HANDLE ac, TPM_AT capability, int count) {
        TPM2_AC_GetCapability_REQUEST req = new TPM2_AC_GetCapability_REQUEST(ac, capability, count);
        AC_GetCapabilityResponse resp = new AC_GetCapabilityResponse();
        this.DispatchCommand(TPM_CC.AC_GetCapability, req, resp);
        return resp;
    }

    public TPMS_AC_OUTPUT AC_Send(TPM_HANDLE sendObject, TPM_HANDLE authHandle, TPM_HANDLE ac, byte[] acDataIn) {
        TPM2_AC_Send_REQUEST req = new TPM2_AC_Send_REQUEST(sendObject, authHandle, ac, acDataIn);
        AC_SendResponse resp = new AC_SendResponse();
        this.DispatchCommand(TPM_CC.AC_Send, req, resp);
        return resp.acDataOut;
    }

    public void Policy_AC_SendSelect(TPM_HANDLE policySession, byte[] objectName, byte[] authHandleName, byte[] acName, byte includeObject) {
        TPM2_Policy_AC_SendSelect_REQUEST req = new TPM2_Policy_AC_SendSelect_REQUEST(policySession, objectName, authHandleName, acName, includeObject);
        this.DispatchCommand(TPM_CC.Policy_AC_SendSelect, req, null);
    }

    public void ACT_SetTimeout(TPM_HANDLE actHandle, int startTimeout) {
        TPM2_ACT_SetTimeout_REQUEST req = new TPM2_ACT_SetTimeout_REQUEST(actHandle, startTimeout);
        this.DispatchCommand(TPM_CC.ACT_SetTimeout, req, null);
    }

    public byte[] Vendor_TCG_Test(byte[] inputData) {
        TPM2_Vendor_TCG_Test_REQUEST req = new TPM2_Vendor_TCG_Test_REQUEST(inputData);
        Vendor_TCG_TestResponse resp = new Vendor_TCG_TestResponse();
        this.DispatchCommand(TPM_CC.Vendor_TCG_Test, req, resp);
        return resp.outputData;
    }
}

