/*
 * Decompiled with CFR 0.152.
 */
package tss;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Random;
import tss.TpmBuffer;
import tss.TpmStructure;
import tss.tpm.TPM2B_DATA;

public class Helpers {
    static Random rand;

    public static byte[] hostToNet(long x) {
        byte[] bufx = new byte[8];
        ByteBuffer buf = ByteBuffer.wrap(bufx);
        return buf.putLong(x).array();
    }

    public static byte[] hostToNet(int x) {
        byte[] bufx = new byte[4];
        ByteBuffer buf = ByteBuffer.wrap(bufx);
        return buf.putInt(x).array();
    }

    public static byte[] hostToNet(short x) {
        byte[] bufx = new byte[2];
        ByteBuffer buf = ByteBuffer.wrap(bufx);
        return buf.putShort(x).array();
    }

    public static int netToHost(byte[] x) {
        ByteBuffer b = ByteBuffer.wrap(x);
        int val = b.getInt();
        return val;
    }

    public static String toHex(byte[] x) {
        int count = 0;
        StringBuilder sb = new StringBuilder(x.length * 2);
        byte[] byArray = x;
        int n = x.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format("%02x", b));
            if (count++ % 4 == 3) {
                sb.append(" ");
            }
            ++n2;
        }
        sb.append("(" + x.length + " bytes)");
        return sb.toString();
    }

    public static byte[] fromHex(String _s) {
        String s = _s.replace(" ", "");
        if ((s = s.replace("_", "")).length() % 2 != 0) {
            throw new RuntimeException("string must have an even number of characters");
        }
        byte[] x = new byte[s.length() / 2];
        int j = 0;
        while (j < s.length()) {
            x[j / 2] = (byte)((Character.digit(s.charAt(j), 16) << 4) + Character.digit(s.charAt(j + 1), 16));
            j += 2;
        }
        return x;
    }

    public static String toHex(byte[] x, int start, int len) {
        StringBuilder sb = new StringBuilder(len * 2);
        int j = start;
        while (j < start + len) {
            sb.append(String.format("%02x", x[j]));
            ++j;
        }
        return sb.toString();
    }

    public static byte[] RandomBytes(int numBytes) {
        if (rand == null) {
            rand = new Random();
        }
        byte[] res = new byte[numBytes];
        rand.nextBytes(res);
        return res;
    }

    public static String arrayToString(Object arrX) {
        if (arrX instanceof byte[]) {
            byte[] arr = (byte[])arrX;
            return Helpers.toHex(arr);
        }
        assert (false);
        return "";
    }

    public static byte[] concatenate(byte[][] a) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[][] byArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] b = byArray[n2];
            os.write(b, 0, b.length);
            ++n2;
        }
        return os.toByteArray();
    }

    public static byte[] concatenate(byte[] a, byte[] b) {
        return Helpers.concatenate(new byte[][]{a, b});
    }

    public static byte[] concatenate(byte[] a, byte[] b, byte[] c) {
        return Helpers.concatenate(new byte[][]{a, b, c});
    }

    private static byte[] shiftRightInternal(byte[] x, int numBits) {
        if (numBits > 7) {
            throw new RuntimeException("ShiftRightInternal: Can only shift up to 7 bits");
        }
        int numCarryBits = 8 - numBits;
        byte[] y = new byte[x.length];
        int j = x.length - 1;
        while (j >= 0) {
            y[j] = (byte)(x[j] >> numBits);
            if (j != 0) {
                int n = j;
                y[n] = (byte)(y[n] | (byte)(x[j - 1] << numCarryBits));
            }
            --j;
        }
        return y;
    }

    public static byte[] shiftRight(byte[] x, int numBits) {
        byte[] y = new byte[x.length - numBits / 8];
        int j = 0;
        while (j < y.length) {
            y[j] = x[j];
            ++j;
        }
        return Helpers.shiftRightInternal(y, numBits % 8);
    }

    public static boolean arraysAreEqual(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int j = 0;
        while (j < a.length) {
            if (a[j] != b[j]) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public static boolean arraysAreEqual(TpmStructure[] a, TpmStructure[] b) {
        if (a.length != b.length) {
            return false;
        }
        TpmBuffer bufA = new TpmBuffer();
        TpmBuffer bufB = new TpmBuffer();
        bufA.writeObjArr(a);
        bufB.writeObjArr(b);
        return Helpers.arraysAreEqual(bufA.trim(), bufB.trim());
    }

    public static byte[] byteArrayToLenPrependedByteArray(byte[] x) {
        return new TPM2B_DATA(x).toBytes();
    }

    public static byte[] clone(byte[] in) {
        return (byte[])in.clone();
    }

    @SafeVarargs
    public static <T> boolean isOneOf(T val, T ... values) {
        if (values == null) {
            return val == null;
        }
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T v = TArray[n2];
            if (val == v) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

