/*
 * Decompiled with CFR 0.152.
 */
package com.metaweb.lessen.tokens;

public class Token {
    public final Type type;
    public final int start;
    public final int end;
    public final String text;

    public static String typeToString(Type type) {
        switch (type) {
            case Invalid: {
                return "invalid";
            }
            case Whitespace: {
                return "whitespace";
            }
            case Comment: {
                return "comment";
            }
            case Delimiter: {
                return "delimiter";
            }
            case Operator: {
                return "operator";
            }
            case CDataOpen: {
                return "cdata-open";
            }
            case CDataClose: {
                return "cdata-close";
            }
            case Identifier: {
                return "identifier";
            }
            case AtIdentifier: {
                return "@identifier";
            }
            case HashName: {
                return "#name";
            }
            case Function: {
                return "function";
            }
            case Variable: {
                return "variable";
            }
            case String: {
                return "string";
            }
            case Uri: {
                return "uri";
            }
            case Number: {
                return "number";
            }
            case Percentage: {
                return "percentage";
            }
            case Dimension: {
                return "dimension";
            }
            case UnicodeRange: {
                return "unicode-range";
            }
            case Color: {
                return "color";
            }
        }
        return "unknown";
    }

    public Token(Type type, int start, int end, String text) {
        this.type = type;
        this.start = start;
        this.end = end;
        this.text = text;
    }

    public String toString() {
        if (this.type == Type.Whitespace) {
            return Token.typeToString(this.type);
        }
        return Token.typeToString(this.type) + ": " + this.text;
    }

    public String getCleanText() {
        return this.text;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        Invalid,
        Whitespace,
        Comment,
        Delimiter,
        Operator,
        CDataOpen,
        CDataClose,
        Identifier,
        AtIdentifier,
        HashName,
        Function,
        Variable,
        String,
        Uri,
        Number,
        Percentage,
        Dimension,
        UnicodeRange,
        Color;

    }
}

