/*
 * Decompiled with CFR 0.152.
 */
package com.metaweb.lessen.tokens;

import com.metaweb.lessen.tokens.Color;
import com.metaweb.lessen.tokens.Token;
import java.util.HashMap;
import java.util.Map;

public class OneTokenColor
extends Color {
    protected int _r;
    protected int _g;
    protected int _b;
    protected int _a;
    protected static Map<String, int[]> s_colorMap = new HashMap<String, int[]>();

    public OneTokenColor(int start, int end, String text, int r, int g, int b, int a) {
        super(start, end, text);
        this._r = r;
        this._g = g;
        this._b = b;
        this._a = a;
    }

    public int getR() {
        return this._r;
    }

    public int getG() {
        return this._g;
    }

    public int getB() {
        return this._b;
    }

    public int getA() {
        return this._a;
    }

    protected static int charToColorComponent(char c) {
        int n = OneTokenColor.charToNumber(c);
        return n * 16 + n;
    }

    protected static int twoCharsToColorComponent(String s) {
        return OneTokenColor.charToNumber(s.charAt(0)) * 16 + OneTokenColor.charToNumber(s.charAt(1));
    }

    protected static int charToNumber(char c) {
        int n = 0;
        if (c >= '0' && c <= '9') {
            n = c - 48;
        } else if (c >= 'a' && c <= 'f') {
            n = c - 97;
        } else if (c >= 'A' && c <= 'F') {
            n = c - 97;
        }
        return n;
    }

    public static Color tokenToColor(Token token) {
        String s;
        if (token.type == Token.Type.Identifier) {
            int[] c = s_colorMap.get(token.text.toLowerCase());
            if (c != null) {
                return new OneTokenColor(token.start, token.end, token.text, c[0], c[1], c[2], -1);
            }
        } else if (token.type == Token.Type.HashName && ((s = token.text).length() == 4 || s.length() == 5 || s.length() == 7 || s.length() == 9)) {
            int a;
            int b;
            int g;
            int r;
            for (int i = 1; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (Character.isDigit(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
                return null;
            }
            if ((s = s.substring(1)).length() < 6) {
                r = OneTokenColor.charToColorComponent(s.charAt(0));
                g = OneTokenColor.charToColorComponent(s.charAt(1));
                b = OneTokenColor.charToColorComponent(s.charAt(2));
                a = s.length() > 3 ? OneTokenColor.charToColorComponent(s.charAt(3)) : -1;
            } else {
                r = OneTokenColor.twoCharsToColorComponent(s.substring(0, 2));
                g = OneTokenColor.twoCharsToColorComponent(s.substring(2, 4));
                b = OneTokenColor.twoCharsToColorComponent(s.substring(4, 6));
                a = s.length() > 7 ? OneTokenColor.twoCharsToColorComponent(s.substring(6, 8)) : -1;
            }
            return new OneTokenColor(token.start, token.end, token.text, r, g, b, a);
        }
        return null;
    }

    static {
        s_colorMap.put("AliceBlue".toLowerCase(), new int[]{240, 248, 255});
        s_colorMap.put("AntiqueWhite".toLowerCase(), new int[]{250, 235, 215});
        s_colorMap.put("Aqua".toLowerCase(), new int[]{0, 255, 255});
        s_colorMap.put("Aquamarine".toLowerCase(), new int[]{127, 255, 212});
        s_colorMap.put("Azure".toLowerCase(), new int[]{240, 255, 255});
        s_colorMap.put("Beige".toLowerCase(), new int[]{245, 245, 220});
        s_colorMap.put("Bisque".toLowerCase(), new int[]{255, 228, 196});
        s_colorMap.put("Black".toLowerCase(), new int[]{0, 0, 0});
        s_colorMap.put("BlanchedAlmond".toLowerCase(), new int[]{255, 235, 205});
        s_colorMap.put("Blue".toLowerCase(), new int[]{0, 0, 255});
        s_colorMap.put("BlueViolet".toLowerCase(), new int[]{138, 43, 226});
        s_colorMap.put("Brown".toLowerCase(), new int[]{165, 42, 42});
        s_colorMap.put("BurlyWood".toLowerCase(), new int[]{222, 184, 135});
        s_colorMap.put("CadetBlue".toLowerCase(), new int[]{95, 158, 160});
        s_colorMap.put("Chartreuse".toLowerCase(), new int[]{127, 255, 0});
        s_colorMap.put("Chocolate".toLowerCase(), new int[]{210, 105, 30});
        s_colorMap.put("Coral".toLowerCase(), new int[]{255, 127, 80});
        s_colorMap.put("CornflowerBlue".toLowerCase(), new int[]{100, 149, 237});
        s_colorMap.put("Cornsilk".toLowerCase(), new int[]{255, 248, 220});
        s_colorMap.put("Crimson".toLowerCase(), new int[]{220, 20, 60});
        s_colorMap.put("Cyan".toLowerCase(), new int[]{0, 255, 255});
        s_colorMap.put("DarkBlue".toLowerCase(), new int[]{0, 0, 139});
        s_colorMap.put("DarkCyan".toLowerCase(), new int[]{0, 139, 139});
        s_colorMap.put("DarkGoldenRod".toLowerCase(), new int[]{184, 134, 11});
        s_colorMap.put("DarkGray".toLowerCase(), new int[]{169, 169, 169});
        s_colorMap.put("DarkGreen".toLowerCase(), new int[]{0, 100, 0});
        s_colorMap.put("DarkKhaki".toLowerCase(), new int[]{189, 183, 107});
        s_colorMap.put("DarkMagenta".toLowerCase(), new int[]{139, 0, 139});
        s_colorMap.put("DarkOliveGreen".toLowerCase(), new int[]{85, 107, 47});
        s_colorMap.put("Darkorange".toLowerCase(), new int[]{255, 140, 0});
        s_colorMap.put("DarkOrchid".toLowerCase(), new int[]{153, 50, 204});
        s_colorMap.put("DarkRed".toLowerCase(), new int[]{139, 0, 0});
        s_colorMap.put("DarkSalmon".toLowerCase(), new int[]{233, 150, 122});
        s_colorMap.put("DarkSeaGreen".toLowerCase(), new int[]{143, 188, 143});
        s_colorMap.put("DarkSlateBlue".toLowerCase(), new int[]{72, 61, 139});
        s_colorMap.put("DarkSlateGray".toLowerCase(), new int[]{47, 79, 79});
        s_colorMap.put("DarkTurquoise".toLowerCase(), new int[]{0, 206, 209});
        s_colorMap.put("DarkViolet".toLowerCase(), new int[]{148, 0, 211});
        s_colorMap.put("DeepPink".toLowerCase(), new int[]{255, 20, 147});
        s_colorMap.put("DeepSkyBlue".toLowerCase(), new int[]{0, 191, 255});
        s_colorMap.put("DimGray".toLowerCase(), new int[]{105, 105, 105});
        s_colorMap.put("DodgerBlue".toLowerCase(), new int[]{30, 144, 255});
        s_colorMap.put("FireBrick".toLowerCase(), new int[]{178, 34, 34});
        s_colorMap.put("FloralWhite".toLowerCase(), new int[]{255, 250, 240});
        s_colorMap.put("ForestGreen".toLowerCase(), new int[]{34, 139, 34});
        s_colorMap.put("Fuchsia".toLowerCase(), new int[]{255, 0, 255});
        s_colorMap.put("Gainsboro".toLowerCase(), new int[]{220, 220, 220});
        s_colorMap.put("GhostWhite".toLowerCase(), new int[]{248, 248, 255});
        s_colorMap.put("Gold".toLowerCase(), new int[]{255, 215, 0});
        s_colorMap.put("GoldenRod".toLowerCase(), new int[]{218, 165, 32});
        s_colorMap.put("Gray".toLowerCase(), new int[]{128, 128, 128});
        s_colorMap.put("Green".toLowerCase(), new int[]{0, 128, 0});
        s_colorMap.put("GreenYellow".toLowerCase(), new int[]{173, 255, 47});
        s_colorMap.put("HoneyDew".toLowerCase(), new int[]{240, 255, 240});
        s_colorMap.put("HotPink".toLowerCase(), new int[]{255, 105, 180});
        s_colorMap.put("IndianRed ".toLowerCase(), new int[]{205, 92, 92});
        s_colorMap.put("Indigo ".toLowerCase(), new int[]{75, 0, 130});
        s_colorMap.put("Ivory".toLowerCase(), new int[]{255, 255, 240});
        s_colorMap.put("Khaki".toLowerCase(), new int[]{240, 230, 140});
        s_colorMap.put("Lavender".toLowerCase(), new int[]{230, 230, 250});
        s_colorMap.put("LavenderBlush".toLowerCase(), new int[]{255, 240, 245});
        s_colorMap.put("LawnGreen".toLowerCase(), new int[]{124, 252, 0});
        s_colorMap.put("LemonChiffon".toLowerCase(), new int[]{255, 250, 205});
        s_colorMap.put("LightBlue".toLowerCase(), new int[]{173, 216, 230});
        s_colorMap.put("LightCoral".toLowerCase(), new int[]{240, 128, 128});
        s_colorMap.put("LightCyan".toLowerCase(), new int[]{224, 255, 255});
        s_colorMap.put("LightGoldenRodYellow".toLowerCase(), new int[]{250, 250, 210});
        s_colorMap.put("LightGrey".toLowerCase(), new int[]{211, 211, 211});
        s_colorMap.put("LightGreen".toLowerCase(), new int[]{144, 238, 144});
        s_colorMap.put("LightPink".toLowerCase(), new int[]{255, 182, 193});
        s_colorMap.put("LightSalmon".toLowerCase(), new int[]{255, 160, 122});
        s_colorMap.put("LightSeaGreen".toLowerCase(), new int[]{32, 178, 170});
        s_colorMap.put("LightSkyBlue".toLowerCase(), new int[]{135, 206, 250});
        s_colorMap.put("LightSlateGray".toLowerCase(), new int[]{119, 136, 153});
        s_colorMap.put("LightSteelBlue".toLowerCase(), new int[]{176, 196, 222});
        s_colorMap.put("LightYellow".toLowerCase(), new int[]{255, 255, 224});
        s_colorMap.put("Lime".toLowerCase(), new int[]{0, 255, 0});
        s_colorMap.put("LimeGreen".toLowerCase(), new int[]{50, 205, 50});
        s_colorMap.put("Linen".toLowerCase(), new int[]{250, 240, 230});
        s_colorMap.put("Magenta".toLowerCase(), new int[]{255, 0, 255});
        s_colorMap.put("Maroon".toLowerCase(), new int[]{128, 0, 0});
        s_colorMap.put("MediumAquaMarine".toLowerCase(), new int[]{102, 205, 170});
        s_colorMap.put("MediumBlue".toLowerCase(), new int[]{0, 0, 205});
        s_colorMap.put("MediumOrchid".toLowerCase(), new int[]{186, 85, 211});
        s_colorMap.put("MediumPurple".toLowerCase(), new int[]{147, 112, 216});
        s_colorMap.put("MediumSeaGreen".toLowerCase(), new int[]{60, 179, 113});
        s_colorMap.put("MediumSlateBlue".toLowerCase(), new int[]{123, 104, 238});
        s_colorMap.put("MediumSpringGreen".toLowerCase(), new int[]{0, 250, 154});
        s_colorMap.put("MediumTurquoise".toLowerCase(), new int[]{72, 209, 204});
        s_colorMap.put("MediumVioletRed".toLowerCase(), new int[]{199, 21, 133});
        s_colorMap.put("MidnightBlue".toLowerCase(), new int[]{25, 25, 112});
        s_colorMap.put("MintCream".toLowerCase(), new int[]{245, 255, 250});
        s_colorMap.put("MistyRose".toLowerCase(), new int[]{255, 228, 225});
        s_colorMap.put("Moccasin".toLowerCase(), new int[]{255, 228, 181});
        s_colorMap.put("NavajoWhite".toLowerCase(), new int[]{255, 222, 173});
        s_colorMap.put("Navy".toLowerCase(), new int[]{0, 0, 128});
        s_colorMap.put("OldLace".toLowerCase(), new int[]{253, 245, 230});
        s_colorMap.put("Olive".toLowerCase(), new int[]{128, 128, 0});
        s_colorMap.put("OliveDrab".toLowerCase(), new int[]{107, 142, 35});
        s_colorMap.put("Orange".toLowerCase(), new int[]{255, 165, 0});
        s_colorMap.put("OrangeRed".toLowerCase(), new int[]{255, 69, 0});
        s_colorMap.put("Orchid".toLowerCase(), new int[]{218, 112, 214});
        s_colorMap.put("PaleGoldenRod".toLowerCase(), new int[]{238, 232, 170});
        s_colorMap.put("PaleGreen".toLowerCase(), new int[]{152, 251, 152});
        s_colorMap.put("PaleTurquoise".toLowerCase(), new int[]{175, 238, 238});
        s_colorMap.put("PaleVioletRed".toLowerCase(), new int[]{216, 112, 147});
        s_colorMap.put("PapayaWhip".toLowerCase(), new int[]{255, 239, 213});
        s_colorMap.put("PeachPuff".toLowerCase(), new int[]{255, 218, 185});
        s_colorMap.put("Peru".toLowerCase(), new int[]{205, 133, 63});
        s_colorMap.put("Pink".toLowerCase(), new int[]{255, 192, 203});
        s_colorMap.put("Plum".toLowerCase(), new int[]{221, 160, 221});
        s_colorMap.put("PowderBlue".toLowerCase(), new int[]{176, 224, 230});
        s_colorMap.put("Purple".toLowerCase(), new int[]{128, 0, 128});
        s_colorMap.put("Red".toLowerCase(), new int[]{255, 0, 0});
        s_colorMap.put("RosyBrown".toLowerCase(), new int[]{188, 143, 143});
        s_colorMap.put("RoyalBlue".toLowerCase(), new int[]{65, 105, 225});
        s_colorMap.put("SaddleBrown".toLowerCase(), new int[]{139, 69, 19});
        s_colorMap.put("Salmon".toLowerCase(), new int[]{250, 128, 114});
        s_colorMap.put("SandyBrown".toLowerCase(), new int[]{244, 164, 96});
        s_colorMap.put("SeaGreen".toLowerCase(), new int[]{46, 139, 87});
        s_colorMap.put("SeaShell".toLowerCase(), new int[]{255, 245, 238});
        s_colorMap.put("Sienna".toLowerCase(), new int[]{160, 82, 45});
        s_colorMap.put("Silver".toLowerCase(), new int[]{192, 192, 192});
        s_colorMap.put("SkyBlue".toLowerCase(), new int[]{135, 206, 235});
        s_colorMap.put("SlateBlue".toLowerCase(), new int[]{106, 90, 205});
        s_colorMap.put("SlateGray".toLowerCase(), new int[]{112, 128, 144});
        s_colorMap.put("Snow".toLowerCase(), new int[]{255, 250, 250});
        s_colorMap.put("SpringGreen".toLowerCase(), new int[]{0, 255, 127});
        s_colorMap.put("SteelBlue".toLowerCase(), new int[]{70, 130, 180});
        s_colorMap.put("Tan".toLowerCase(), new int[]{210, 180, 140});
        s_colorMap.put("Teal".toLowerCase(), new int[]{0, 128, 128});
        s_colorMap.put("Thistle".toLowerCase(), new int[]{216, 191, 216});
        s_colorMap.put("Tomato".toLowerCase(), new int[]{255, 99, 71});
        s_colorMap.put("Turquoise".toLowerCase(), new int[]{64, 224, 208});
        s_colorMap.put("Violet".toLowerCase(), new int[]{238, 130, 238});
        s_colorMap.put("Wheat".toLowerCase(), new int[]{245, 222, 179});
        s_colorMap.put("White".toLowerCase(), new int[]{255, 255, 255});
        s_colorMap.put("WhiteSmoke".toLowerCase(), new int[]{245, 245, 245});
        s_colorMap.put("Yellow".toLowerCase(), new int[]{255, 255, 0});
        s_colorMap.put("YellowGreen".toLowerCase(), new int[]{154, 205, 50});
    }
}

