/*
 * Decompiled with CFR 0.152.
 */
package com.metaweb.lessen.tokens;

import com.metaweb.lessen.expr.OperatorCall;
import com.metaweb.lessen.tokens.Color;
import com.metaweb.lessen.tokens.NumericToken;
import com.metaweb.lessen.tokens.Token;

public class ComponentColor
extends Color {
    protected NumericToken _r;
    protected NumericToken _g;
    protected NumericToken _b;
    protected NumericToken _a;

    public ComponentColor(int start, int end, String text, NumericToken r, NumericToken g, NumericToken b, NumericToken a) {
        super(start, end, text);
        this._r = r;
        this._g = g;
        this._b = b;
        this._a = a;
    }

    public int getA() {
        return this.tokenToInt(this._a);
    }

    public int getB() {
        return this.tokenToInt(this._b);
    }

    public int getG() {
        return this.tokenToInt(this._g);
    }

    public int getR() {
        return this.tokenToInt(this._r);
    }

    protected int tokenToInt(NumericToken t) {
        if (t == null) {
            return -1;
        }
        if (t.type == Token.Type.Percentage) {
            return t.n.intValue() * 255 / 100;
        }
        if (t.n.doubleValue() > 1.0) {
            return t.n.intValue();
        }
        return (int)(255.0 * t.n.doubleValue());
    }

    public Color performOperation(String op, Color color) {
        if (color instanceof ComponentColor && (op.endsWith("+") || op.equals("-"))) {
            ComponentColor color2 = (ComponentColor)color;
            NumericToken r = this.limit(this.performNumericOperation(op, this._r, color2._r));
            NumericToken g = this.limit(this.performNumericOperation(op, this._g, color2._g));
            NumericToken b = this.limit(this.performNumericOperation(op, this._b, color2._b));
            NumericToken a = this.limit(this.performNumericOperation(op, this._a, color2._a));
            return this.createColor(r, g, b, a);
        }
        return super.performOperation(op, color);
    }

    public Color performOperation(String op, Number n) {
        if (op.equals("*") || op.equals("/")) {
            double d = n.doubleValue();
            NumericToken r = this.limit(this.performNumericOperation(op, this._r, d));
            NumericToken g = this.limit(this.performNumericOperation(op, this._g, d));
            NumericToken b = this.limit(this.performNumericOperation(op, this._b, d));
            NumericToken a = this.limit(this.performNumericOperation(op, this._a, d));
            return this.createColor(r, g, b, a);
        }
        return super.performOperation(op, n);
    }

    protected NumericToken performNumericOperation(String op, NumericToken tLeft, NumericToken tRight) {
        if (tLeft == null) {
            return tRight;
        }
        if (tRight == null) {
            return tLeft;
        }
        return OperatorCall.performNumericOperation(op, tLeft, tRight);
    }

    protected NumericToken performNumericOperation(String op, NumericToken leftT, double d) {
        if (leftT != null) {
            return OperatorCall.performNumericOperation(op, leftT, d);
        }
        return null;
    }

    protected ComponentColor createColor(NumericToken r, NumericToken g, NumericToken b, NumericToken a) {
        StringBuffer sb = new StringBuffer();
        sb.append(a != null ? "rgba(" : "rgb(");
        sb.append(r != null ? r.getCleanText() : "ERROR");
        sb.append(", ");
        sb.append(g != null ? g.getCleanText() : "ERROR");
        sb.append(", ");
        sb.append(b != null ? b.getCleanText() : "ERROR");
        if (a != null) {
            sb.append(", ");
            sb.append(a.getCleanText());
        }
        sb.append(")");
        return new ComponentColor(this.start, this.end, sb.toString(), r, g, b, a);
    }

    protected NumericToken limit(NumericToken t) {
        if (t != null) {
            double d = t.n.doubleValue();
            if (t.type == Token.Type.Percentage) {
                if (d < 0.0 || d > 100.0) {
                    return OperatorCall.makePercentageToken(t, Math.max(0.0, Math.min(100.0, d)));
                }
            } else if (d < 0.0 || d > 255.0) {
                return OperatorCall.makeNumberToken(t, Math.max(0.0, Math.min(255.0, d)));
            }
        }
        return t;
    }
}

