/*
 * Decompiled with CFR 0.152.
 */
package com.metaweb.lessen;

import com.metaweb.lessen.ResourceFinder;
import com.metaweb.lessen.Utilities;
import com.metaweb.lessen.tokenizers.Tokenizer;
import java.io.File;
import java.io.FileNotFoundException;

public class FileResourceFinder
implements ResourceFinder {
    protected final File _dir;

    public FileResourceFinder(File file) {
        this._dir = file.isDirectory() ? file : file.getParentFile();
    }

    public Tokenizer open(String where) {
        File file = new File(this._dir, where);
        try {
            return Utilities.open(file);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public ResourceFinder rebase(String where) {
        return new FileResourceFinder(new File(this._dir, where));
    }
}

