/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzR0;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzVOH;
import com.aspose.words.net.System.Data.zzXNS;
import com.aspose.words.net.System.Data.zzYUy;
import com.aspose.words.net.System.Data.zzqi;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzkn;
    private final DataColumnCollection zzXBk;
    private final ConstraintCollection zz4n;
    private final zzXNS zzW8k;
    private ResultSet zzWhu;
    private String zzs;
    private DataSet zzJw;
    private String zzZsS;
    private UniqueConstraint zzXza;
    private boolean zzYoz;
    private final List<DataTableEventListener> zzkf;
    private final Set<DataRow> zzrz;
    private DataRelationCollection zzWjo;

    public DataTable() {
        this.zzkn = new DataRowCollection(this);
        this.zzXBk = new DataColumnCollection(this);
        this.zz4n = new ConstraintCollection(this);
        this.zzW8k = new zzXNS(this);
        this.zzZsS = "";
        this.zzYoz = true;
        this.zzkf = new ArrayList<DataTableEventListener>();
        this.zzrz = new HashSet<DataRow>();
        this.zzWjo = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzkn = new DataRowCollection(this);
        this.zzXBk = new DataColumnCollection(this);
        this.zz4n = new ConstraintCollection(this);
        this.zzW8k = new zzXNS(this);
        this.zzZsS = "";
        this.zzYoz = true;
        this.zzkf = new ArrayList<DataTableEventListener>();
        this.zzrz = new HashSet<DataRow>();
        this.zzWjo = new DataRelationCollection();
        this.zzs = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzVOH.zzXWJ(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzkn = new DataRowCollection(this);
        this.zzXBk = new DataColumnCollection(this);
        this.zz4n = new ConstraintCollection(this);
        this.zzW8k = new zzXNS(this);
        this.zzZsS = "";
        this.zzYoz = true;
        this.zzkf = new ArrayList<DataTableEventListener>();
        this.zzrz = new HashSet<DataRow>();
        this.zzWjo = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzWhu = resultSet;
        this.zzs = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzWhu != null) {
            if (this.zzWhu.getStatement() != null) {
                this.zzWhu.getStatement().getConnection().close();
            }
            this.zzWhu = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzs;
    }

    public void setTableName(String tableName) {
        this.zzs = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzXBk.getCount();
    }

    public String getColumnName(int index) {
        return this.zzXBk.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzWhu;
    }

    public DataSet getDataSet() {
        return this.zzJw;
    }

    final void zzuE(DataSet dataSet) {
        this.zzJw = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzJw.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzWjo.add(dataRelation);
        }
        return this.zzWjo;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzJw.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzkn;
    }

    public DataColumnCollection getColumns() {
        return this.zzXBk;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zz4n;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzXza == null) {
            return new DataColumn[0];
        }
        return this.zzXza.getColumns();
    }

    final void zzXNS(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzXza != null) {
                this.zzXza.zzWz5(false);
                this.getConstraints().remove(this.zzXza);
                this.zzXza = null;
            }
            return;
        }
        if (this.zzXza != null && DataColumn.areColumnSetsTheSame(value, this.zzXza.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzXWJ(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzXza != null) {
            this.zzXza.zzWz5(false);
            this.getConstraints().remove(this.zzXza);
            this.zzXza = null;
        }
        UniqueConstraint.zzXWJ(this.getConstraints(), uniqueConstraint);
        this.zzXza = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzZsS;
    }

    public void setNamespace(String namespace) {
        this.zzZsS = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzYoz;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzYoz = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzrz.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzVOH.zzXWJ(this.getResultSet(), this);
            zzVOH.zzVOH(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzR0.zzuE(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzVOH.zzWOu(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzkf.contains(listener)) {
            this.zzkf.add(listener);
        }
    }

    public void removeEventListener(zzYUy listener) {
        if (this.zzkf.contains(listener)) {
            this.zzkf.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzkf.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzrz.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzkf) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzrz.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzkf) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzrz.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzkf) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzkf) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzkf) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzqi zzXWJ(zzVOH[] zzVOHArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzVOHArray.length];
        for (int i = 0; i < zzVOHArray.length; ++i) {
            dataColumnArray[i] = zzVOHArray[i].zz6a();
        }
        DataTable dataTable = this;
        zzqi zzqi2 = dataTable.zzW8k.zzuE(dataColumnArray);
        if (zzqi2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzqi2;
    }

    final zzXNS zzYEk() {
        return this.zzW8k;
    }

    final Set<DataRow> zzvT() {
        return this.zzrz;
    }
}

