/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zz5v;
import com.aspose.words.internal.zzO8;
import com.aspose.words.internal.zzWb2;
import com.aspose.words.internal.zzX0;
import com.aspose.words.internal.zzX8q;
import com.aspose.words.internal.zzX9K;
import com.aspose.words.internal.zzXGa;
import com.aspose.words.internal.zzYqf;
import com.aspose.words.internal.zzZ97;
import java.security.InvalidAlgorithmParameterException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

final class zzY0T
extends CertPathValidatorSpi {
    private final Provider zzWkS;

    zzY0T(Provider provider) {
        this.zzWkS = provider;
    }

    @Override
    public final CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters params) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        HashSet hashSet;
        int n;
        zzWb2 zzWb22;
        PublicKey publicKey;
        X500Principal x500Principal;
        TrustAnchor trustAnchor;
        zz5v zz5v2;
        if (params instanceof zz5v) {
            zz5v2 = (zz5v)params;
        } else if (params instanceof zzXGa) {
            zz5v2 = ((zzXGa)params).zzS0();
        } else if (params instanceof PKIXParameters) {
            zz5v2 = new zz5v.zzXWJ((PKIXParameters)params).zzZzM();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be " + PKIXParameters.class.getName() + " or " + zz5v.class.getName() + " instance.");
        }
        if (zz5v2.zzYvf() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for certification path validation.");
        }
        List<? extends Certificate> list = certPath.getCertificates();
        int n2 = list.size();
        if (list.isEmpty()) {
            throw new CertPathValidatorException("Certification path is empty.", null, certPath, -1);
        }
        Set set = zz5v2.zzYm9();
        try {
            List<? extends Certificate> list2 = list;
            trustAnchor = zzZ97.zzXWJ((X509Certificate)list2.get(list2.size() - 1), zz5v2.zzYvf(), zz5v2.zzX0u());
        }
        catch (zzX0 zzX02) {
            throw new CertPathValidatorException(zzX02.getMessage(), (Throwable)zzX02, certPath, list.size() - 1);
        }
        if (trustAnchor == null) {
            throw new CertPathValidatorException("Trust anchor for certification path not found.", null, certPath, -1);
        }
        zz5v2 = new zz5v.zzXWJ(zz5v2).zzXWJ(trustAnchor).zzZzM();
        List[] listArray = new ArrayList[n2 + 1];
        for (int i = 0; i < listArray.length; ++i) {
            listArray[i] = new ArrayList();
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("2.5.29.32.0");
        zzX8q zzX8q2 = new zzX8q(new ArrayList(), 0, hashSet2, null, new HashSet(), "2.5.29.32.0", false);
        listArray[0].add(zzX8q2);
        zzO8 zzO82 = new zzO8();
        HashSet hashSet3 = new HashSet();
        int n3 = zz5v2.zzZFx() ? 0 : n2 + 1;
        int n4 = zz5v2.zzWOF() ? 0 : n2 + 1;
        int n5 = zz5v2.zzYA9() ? 0 : n2 + 1;
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        try {
            if (x509Certificate != null) {
                x500Principal = zzZ97.zzVOH(x509Certificate);
                publicKey = x509Certificate.getPublicKey();
            } else {
                x500Principal = new X500Principal(trustAnchor.getCAName());
                publicKey = trustAnchor.getCAPublicKey();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("Subject of trust anchor could not be (re)encoded.", (Throwable)illegalArgumentException, certPath, -1);
        }
        try {
            zzWb22 = zzZ97.zzXWJ(publicKey);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw new CertPathValidatorException("Algorithm identifier of public key of trust anchor could not be read.", (Throwable)certPathValidatorException, certPath, -1);
        }
        zzWb22.zzZ6Z();
        zzWb22.zzWMM();
        int n6 = n2;
        if (zz5v2.zzZqI() != null && !zz5v2.zzZqI().match((X509Certificate)list.get(0))) {
            throw new CertPathValidatorException("Target certificate in certification path does not match targetConstraints.", null, certPath, 0);
        }
        List list3 = zz5v2.zzYcf();
        Iterator iterator = list3.iterator();
        while (iterator.hasNext()) {
            ((PKIXCertPathChecker)iterator.next()).init(false);
        }
        X509Certificate x509Certificate2 = null;
        for (n = list.size() - 1; n >= 0; --n) {
            boolean bl;
            int n7 = n2 - n;
            x509Certificate2 = (X509Certificate)list.get(n);
            boolean bl2 = bl = n == list.size() - 1;
            if (x509Certificate2 == null) {
                throw new CertPathValidatorException("NULL certificate found", null, certPath, n);
            }
            zzYqf.zzXWJ(certPath, zz5v2, n, publicKey, bl, x500Principal, x509Certificate, this.zzWkS);
            zzYqf.zzXWJ(certPath, n, zzO82);
            zzX8q2 = zzYqf.zzXWJ(certPath, n, hashSet3, zzX8q2, listArray, n4);
            zzX8q2 = zzYqf.zzXWJ(certPath, n, zzX8q2);
            zzYqf.zzXWJ(certPath, n, zzX8q2, n3);
            if (n7 == n2) continue;
            if (x509Certificate2.getVersion() == 1) {
                throw new CertPathValidatorException("Version 1 certificates can't be used as CA ones.", null, certPath, n);
            }
            zzYqf.zzXWJ(certPath, n);
            zzX8q2 = zzYqf.zzXWJ(certPath, n, listArray, zzX8q2, n5);
            zzYqf.zzVOH(certPath, n, zzO82);
            n3 = zzYqf.zzqi(certPath, n, n3);
            n5 = zzYqf.zzXNS(certPath, n, n5);
            n4 = zzYqf.zzYGR(certPath, n, n4);
            n3 = zzYqf.zzXWJ(certPath, n, n3);
            n5 = zzYqf.zzVOH(certPath, n, n5);
            n4 = zzYqf.zzYUy(certPath, n, n4);
            zzYqf.zzVOH(certPath, n);
            n6 = zzYqf.zzuE(certPath, n, n6);
            n6 = zzYqf.zzWOu(certPath, n, n6);
            zzYqf.zzYUy(certPath, n);
            hashSet = x509Certificate2.getCriticalExtensionOIDs();
            if (hashSet != null) {
                hashSet = new HashSet(hashSet);
                hashSet.removeAll(zzYqf.zzj9);
            } else {
                hashSet = new HashSet();
            }
            zzYqf.zzXWJ(certPath, n, hashSet, list3);
            x509Certificate = x509Certificate2;
            x500Principal = zzZ97.zzVOH(x509Certificate);
            try {
                publicKey = zzZ97.zzXWJ(certPath.getCertificates(), n, this.zzWkS);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException("Next working key could not be retrieved.", (Throwable)certPathValidatorException, certPath, n);
            }
            zzWb22 = zzZ97.zzXWJ(publicKey);
            zzWb22.zzZ6Z();
            zzWb22.zzWMM();
        }
        n3 = zzYqf.zzXWJ(n3, x509Certificate2);
        n3 = zzYqf.zzZPF(certPath, n + 1, n3);
        Set<String> set2 = x509Certificate2.getCriticalExtensionOIDs();
        if (set2 != null) {
            set2 = new HashSet<String>(set2);
            set2.removeAll(zzYqf.zzj9);
            set2.remove(zzX9K.zzVPt.getId());
        } else {
            set2 = new HashSet<String>();
        }
        zzYqf.zzXWJ(certPath, n + 1, list3, set2);
        hashSet = zzYqf.zzXWJ(certPath, zz5v2, set, n + 1, listArray, zzX8q2, hashSet3);
        if (n3 > 0 || hashSet != null) {
            return new PKIXCertPathValidatorResult(trustAnchor, (PolicyNode)((Object)hashSet), x509Certificate2.getPublicKey());
        }
        throw new CertPathValidatorException("Path processing failed on policy.", null, certPath, n);
    }
}

