/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzWoi;
import com.aspose.words.zzYh8;
import com.aspose.words.zzZF2;
import com.aspose.words.zzZXa;
import com.aspose.words.zzbx;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzZF2,
Iterable<T> {
    private Node zzfy;
    private CompositeNode zzZlv;
    private DocumentBase zzXdH;
    private boolean zzZAE;
    private int zzm3;
    private int zzY5W;
    private Node zzWk0;
    private int zzim;
    private zzZXa zzXjH;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zzbx.zzCG(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzbx(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzZXa matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzZlv = container;
        this.zzXdH = container.getDocument();
        this.zzXjH = matcher;
        this.zzZAE = isDeep;
        this.zzXzQ();
    }

    public Node get(int index) {
        try {
            this.zzWN8();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzY5W == index) {
                return this.zzWk0;
            }
            int n = index - this.zzY5W;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzZEj(nodeCollection.zzWk0, n);
            if (node != null) {
                this.zzY5W = index;
                this.zzWk0 = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzZAE) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzZlv.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzZAE) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzZlv.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzY1C();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzYh8(this);
    }

    final <TNode extends Node> zzYh8<TNode> zzXSo() {
        return new zzYh8(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzY1C() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzWoi.zzXWJ(arrayList, node);
        }
        return arrayList;
    }

    private Node zzZEj(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzZHT(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzZ60(curNode, true);
    }

    private Node zzZ60(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzfy = node;
        do {
            node2 = this.zzfy;
            Node node3 = this.zzZAE ? this.zzXWJ(true, this.zzfy) : (this.zzfy = this.zzXjH.zzWz0() ? this.zzYUy(true, this.zzfy) : this.zzVOH(true, this.zzfy));
        } while (this.zzfy != null && !this.zzXjH.zzXPQ(this.zzfy));
        return node2;
    }

    private Node zzZHT(Node node, boolean bl) throws Exception {
        while ((this.zzZAE ? this.zzXWJ(bl, node) : (node = this.zzXjH.zzWz0() ? this.zzYUy(bl, node) : this.zzVOH(bl, node))) != null && !this.zzXjH.zzXPQ(node)) {
        }
        return node;
    }

    private Node zzXWJ(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzZlv);
        }
        return node.previousPreOrder(this.zzZlv);
    }

    private Node zzVOH(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzZlv) {
                return this.zzZlv.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzZlv) {
            return this.zzZlv.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzYUy(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzZlv ? this.zzZlv.zzYJV() : node.zzWkR();
        } else {
            Node node3 = node2 = node == this.zzZlv ? this.zzZlv.zz7a() : node.zzWcV();
        }
        if (node2 == this.zzZlv.getNextSibling() || node2 == this.zzZlv.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzWN8() {
        if (this.zzm3 != this.zzEA()) {
            this.zzXzQ();
        }
    }

    private void zzXzQ() {
        this.zzm3 = this.zzEA();
        this.zzY5W = -1;
        this.zzWk0 = this.zzZlv;
        this.zzim = -1;
    }

    private int zzEA() {
        if (this.zzXdH != null) {
            return this.zzXdH.zzWHy();
        }
        return 0;
    }

    public int getCount() {
        this.zzWN8();
        if (this.zzim == -1) {
            this.zzim = zzYh8.zzXWJ(this);
        }
        return this.zzim;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzfy;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzZlv;
    }
}

