/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzNM;
import com.aspose.words.internal.zzWML;
import com.aspose.words.internal.zzWoi;
import com.aspose.words.internal.zzYFS;
import com.aspose.words.internal.zzZno;
import com.aspose.words.internal.zzZpv;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzZ1J;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzoK = new HashMap();
    private static HashMap<Integer, Integer> zzVWn = new HashMap();
    private static HashMap<Integer, Integer> zzYfd = new HashMap();
    private static HashMap<Integer, Integer> zzX3i = new HashMap();
    private static HashMap<Integer, Integer> zzYnq = new HashMap();
    private static HashMap<Integer, Integer> zzX8K = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzYFS.zzVOH(fileName, "fileName");
        try (zzZpv zzZpv2 = zzYFS.zzWWC(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzYWy(zzZpv2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzYWy(zzWoi.zzXWJ(stream));
    }

    static FileFormatInfo zzYWy(zzNM zzNM2) throws Exception {
        if (zzNM2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zzZ1J zzZ1J2 = new zzZ1J();
            zzNM zzNM3 = zzNM2;
            zzZ1J zzZ1J3 = zzZ1J2;
            return zzZ1J2.zzVOH(zzNM3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzYUy(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzWqD(zzZno.zzWiu(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzW4v(zzZno.zzWiu(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzWML.zzXNo(string = zzZno.zzX4i(FileFormatUtil.zzYwM(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzWqD(FileFormatUtil.zzVYG(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzW4v(FileFormatUtil.zzYwM(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzZno.zzX4i(FileFormatUtil.zzVYG(saveFormat));
        if (zzWML.zzXNo(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzW4v(zzZno.zzYar(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzZno.zzX4i(FileFormatUtil.zzXU0(imageType));
    }

    static Exception zzYUy(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzWHW(int n) {
        return zzZno.toString(FileFormatUtil.zzVYG(n));
    }

    static int zzW4v(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzYFS.zzXWJ(zzYnq, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzWQE(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzYFS.zzXWJ(zzX8K, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzWSq(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzYwM(int n) {
        return zzYFS.zzXWJ(zzoK, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzVYG(int n) {
        return zzYFS.zzXWJ(zzVWn, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzXU0(int n) {
        return zzYFS.zzXWJ(zzYfd, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzWqD(int n) {
        return zzYFS.zzXWJ(zzX3i, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzXMa(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzYFS.zzVOH(zzYnq, Integer.valueOf(n), Integer.valueOf(n2));
            zzYFS.zzVOH(zzVWn, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzX3i.containsKey(n)) {
                zzYFS.zzVOH(zzX3i, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzYFS.zzVOH(zzoK, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzYFS.zzVOH(zzX8K, Integer.valueOf(n), Integer.valueOf(n4));
            zzYFS.zzVOH(zzYfd, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzXMa(11, 10, 10, 1);
        FileFormatUtil.zzXMa(11, 0, 0, 1);
        FileFormatUtil.zzXMa(12, 11, 11, 1);
        FileFormatUtil.zzXMa(13, 20, 20, 1);
        FileFormatUtil.zzXMa(13, 0, 254, 1);
        FileFormatUtil.zzXMa(14, 21, 21, 1);
        FileFormatUtil.zzXMa(15, 22, 22, 1);
        FileFormatUtil.zzXMa(16, 23, 23, 1);
        FileFormatUtil.zzXMa(18, 24, 24, 1);
        FileFormatUtil.zzXMa(19, 25, 25, 1);
        FileFormatUtil.zzXMa(20, 26, 26, 1);
        FileFormatUtil.zzXMa(21, 27, 27, 1);
        FileFormatUtil.zzXMa(24, 30, 30, 1);
        FileFormatUtil.zzXMa(17, 31, 31, 1);
        FileFormatUtil.zzXMa(25, 50, 50, 1);
        FileFormatUtil.zzXMa(26, 45, 255, 1);
        FileFormatUtil.zzXMa(27, 51, 51, 1);
        FileFormatUtil.zzXMa(28, 0, 52, 1);
        FileFormatUtil.zzXMa(29, 0, 53, 1);
        FileFormatUtil.zzXMa(31, 0, 54, 1);
        FileFormatUtil.zzXMa(22, 60, 60, 1);
        FileFormatUtil.zzXMa(23, 61, 61, 1);
        FileFormatUtil.zzXMa(34, 40, 64, 1);
        FileFormatUtil.zzXMa(41, 47, 255, 1);
        FileFormatUtil.zzXMa(42, 48, 255, 1);
        FileFormatUtil.zzXMa(35, 41, 255, 1);
        FileFormatUtil.zzXMa(36, 46, 255, 1);
        FileFormatUtil.zzXMa(38, 42, 255, 1);
        FileFormatUtil.zzXMa(37, 44, 255, 1);
        FileFormatUtil.zzXMa(30, 52, 255, 1);
        FileFormatUtil.zzXMa(32, 70, 62, 1);
        FileFormatUtil.zzXMa(33, 73, 63, 1);
        FileFormatUtil.zzXMa(39, 71, 255, 1);
        FileFormatUtil.zzXMa(8, 100, 255, 1);
        FileFormatUtil.zzXMa(9, 105, 255, 1);
        FileFormatUtil.zzXMa(6, 101, 255, 6);
        FileFormatUtil.zzXMa(7, 102, 255, 7);
        FileFormatUtil.zzXMa(5, 104, 255, 5);
        FileFormatUtil.zzXMa(4, 0, 255, 4);
        FileFormatUtil.zzXMa(3, 0, 255, 3);
        FileFormatUtil.zzXMa(40, 72, 255, 1);
        FileFormatUtil.zzXMa(2, 103, 255, 2);
    }
}

