/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Border;
import com.aspose.words.internal.zzYFS;
import com.aspose.words.internal.zzYVV;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zz4d;
import java.awt.Color;
import java.util.Iterator;

public final class BorderCollection
implements Iterable<Border> {
    private zz4d zzXTN;

    BorderCollection(zz4d parent) {
        this.zzXTN = parent;
    }

    public final boolean equals(BorderCollection brColl) throws Exception {
        if (zzYFS.zzXYg(this, brColl)) {
            return true;
        }
        return this.getLeft().equals(brColl.getLeft()) && this.getRight().equals(brColl.getRight()) && this.getTop().equals(brColl.getTop()) && this.getBottom().equals(brColl.getBottom()) && this.getHorizontal().equals(brColl.getHorizontal()) && this.getVertical().equals(brColl.getVertical()) && this.getColor().equals(brColl.getColor()) && this.zzEv().equals(brColl.zzEv()) && this.getDistanceFromText() == brColl.getDistanceFromText() && this.getLineWidth() == brColl.getLineWidth() && this.getLineStyle() == brColl.getLineStyle() && this.getCount() == brColl.getCount() && this.getShadow() == brColl.getShadow() && this.isVisible() == brColl.isVisible();
    }

    public final Border getByBorderType(int borderType) throws Exception {
        RefInt refInt = new RefInt(0);
        boolean bl = !this.zzXTN.getPossibleBorderKeys().zzXWJ(borderType, refInt);
        int borderKey = refInt.get();
        if (bl) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        Border border = (Border)this.zzXTN.getDirectBorderAttr(borderKey);
        if (border == null) {
            border = new Border(this.zzXTN, borderKey);
            this.zzXTN.setBorderAttr(borderKey, border);
        }
        return border;
    }

    public final Border get(int index) throws Exception {
        int n = this.zzXTN.getPossibleBorderKeys().zzZyn().get(index);
        return this.getByBorderType(n);
    }

    public final Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public final Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public final Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public final Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public final Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public final Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public final int getCount() {
        return this.zzXTN.getPossibleBorderKeys().getCount();
    }

    public final double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public final void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zzXTN.getPossibleBorderKeys().zzZyn().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzW7v(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public final int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public final void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zzXTN.getPossibleBorderKeys().zzZyn().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzW7v(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public final Color getColor() throws Exception {
        return this.zzEv().zzWsS();
    }

    public final void setColor(Color value) throws Exception {
        this.zzZWT(zzYVV.zzVOH(value));
    }

    private zzYVV zzEv() throws Exception {
        return this.get(0).zzEv();
    }

    private void zzZWT(zzYVV zzYVV2) throws Exception {
        Iterator iterator = this.zzXTN.getPossibleBorderKeys().zzZyn().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzW7v(n)) continue;
            this.getByBorderType(n).zzZWT(zzYVV2);
        }
    }

    public final double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public final void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zzXTN.getPossibleBorderKeys().zzZyn().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzW7v(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public final boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public final void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zzXTN.getPossibleBorderKeys().zzZyn().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzW7v(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public final void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public final Iterator<Border> iterator() {
        return new zzXWJ(this);
    }

    final boolean isVisible() {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzW7v(int n) {
        return n != 6 && n != 7;
    }

    static final class zzXWJ
    implements Iterator<Border> {
        private BorderCollection zzZtS;
        private int zzHy;

        zzXWJ(BorderCollection borderCollection) {
            this.zzZtS = borderCollection;
            this.zzHy = -1;
        }

        @Override
        public final boolean hasNext() {
            if (this.zzHy >= this.zzZtS.getCount() - 1) {
                return false;
            }
            ++this.zzHy;
            return true;
        }

        private Border zz1A() {
            try {
                return this.zzZtS.get(this.zzHy);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            return this.zz1A();
        }
    }
}

