--V001代表核心模块,前缀不能更改,后面20241001可以修改

-- "ac_app" definition

-- Drop table

-- DROP TABLE "ac_app";

create table if not exists "ac_app" (
                                        "app_id" varchar(64) NOT NULL,
    "app_code" varchar(64) NULL,
    "app_name" varchar(64) NULL,
    "app_icon" varchar(64) NULL,
    "home_page" varchar(64) NULL,
    "ref_apps" varchar(64) NULL,
    "status" varchar(64) NULL,
    "order_no" integer NULL,
    "description" varchar(64) NULL,
    "tenant_id" varchar(64) NULL,
    "deleted" integer NULL,
    "create_by" varchar(64) NULL,
    "create_time" timestamp NULL,
    "modify_by" varchar(64) NULL,
    "modify_time" timestamp NULL,
    CONSTRAINT "ac_app_pkey" PRIMARY KEY ("app_id")
    );
COMMENT ON TABLE "ac_app" IS '应用管理';

-- Column comments

COMMENT ON COLUMN "ac_app"."app_id" IS '主键';
COMMENT ON COLUMN "ac_app"."app_code" IS '应用编码';
COMMENT ON COLUMN "ac_app"."app_name" IS '应用名称';
COMMENT ON COLUMN "ac_app"."app_icon" IS '应用图标';
COMMENT ON COLUMN "ac_app"."home_page" IS '应用主页';
COMMENT ON COLUMN "ac_app"."ref_apps" IS '关联应用';
COMMENT ON COLUMN "ac_app"."status" IS '应用状态';
COMMENT ON COLUMN "ac_app"."order_no" IS '序号';
COMMENT ON COLUMN "ac_app"."description" IS '应用描述';
COMMENT ON COLUMN "ac_app"."tenant_id" IS '租户号';
COMMENT ON COLUMN "ac_app"."deleted" IS '逻辑删除';
COMMENT ON COLUMN "ac_app"."create_by" IS '创建人';
COMMENT ON COLUMN "ac_app"."create_time" IS '创建时间';
COMMENT ON COLUMN "ac_app"."modify_by" IS '更新人';
COMMENT ON COLUMN "ac_app"."modify_time" IS '更新时间';


-- "ac_dataset" definition

-- Drop table

-- DROP TABLE "ac_dataset";

create table if not exists "ac_dataset" (
                                            "dataset_id" varchar(64) NOT NULL,
    "app_code" varchar(64) NULL,
    "dataset_code" varchar(64) NULL,
    "dataset_name" varchar(64) NULL,
    "dataset_config" text NULL,
    "tenant_id" varchar(64) NULL,
    "deleted" integer NULL,
    "create_by" varchar(64) NULL,
    "create_time" timestamp NULL,
    "modify_by" varchar(64) NULL,
    "modify_time" timestamp NULL,
    "query_type" varchar(64) NULL,
    "tree_fields" text NULL,
    "dataset_fields" text NULL,
    CONSTRAINT "ac_dataset_pkey" PRIMARY KEY ("dataset_id")
    );
COMMENT ON TABLE "ac_dataset" IS '数据集';

-- Column comments

COMMENT ON COLUMN "ac_dataset"."dataset_id" IS '主键';
COMMENT ON COLUMN "ac_dataset"."app_code" IS '所属应用';
COMMENT ON COLUMN "ac_dataset"."dataset_code" IS '数据集编码';
COMMENT ON COLUMN "ac_dataset"."dataset_name" IS '数据集名称';
COMMENT ON COLUMN "ac_dataset"."dataset_config" IS '数据集配置';
COMMENT ON COLUMN "ac_dataset"."tenant_id" IS '租户号';
COMMENT ON COLUMN "ac_dataset"."deleted" IS '逻辑删除';
COMMENT ON COLUMN "ac_dataset"."create_by" IS '创建人';
COMMENT ON COLUMN "ac_dataset"."create_time" IS '创建时间';
COMMENT ON COLUMN "ac_dataset"."modify_by" IS '更新人';
COMMENT ON COLUMN "ac_dataset"."modify_time" IS '更新时间';
COMMENT ON COLUMN "ac_dataset"."query_type" IS '查询类型';
COMMENT ON COLUMN "ac_dataset"."tree_fields" IS '树字段配置';


-- "ac_flow" definition

-- Drop table

-- DROP TABLE "ac_flow";

create table if not exists "ac_flow" (
                                         "flow_id" varchar(64) NOT NULL,
    "flow_name" varchar(64) NULL,
    "flow_code" varchar(64) NULL,
    "app_code" varchar(64) NULL,
    "form_code" varchar(64) NULL,
    "version_code" varchar(64) NULL,
    "mobile_approval" varchar(64) NULL,
    "enabled" varchar(64) NULL,
    "flow_schema" text NULL,
    "flow_manager" varchar(64) NULL,
    "definition_id" varchar(64) NULL,
    "deployment_id" varchar(64) NULL,
    "tenant_id" varchar(64) NULL,
    "deleted" integer NULL,
    "create_by" varchar(64) NULL,
    "create_time" timestamp NULL,
    "modify_by" varchar(64) NULL,
    "modify_time" timestamp NULL,
    CONSTRAINT "ac_flow_pkey" PRIMARY KEY ("flow_id")
    );
COMMENT ON TABLE "ac_flow" IS '流程';

-- Column comments

COMMENT ON COLUMN "ac_flow"."flow_id" IS '主键';
COMMENT ON COLUMN "ac_flow"."flow_name" IS '流程名称';
COMMENT ON COLUMN "ac_flow"."flow_code" IS '流程编码';
COMMENT ON COLUMN "ac_flow"."app_code" IS '应用编码';
COMMENT ON COLUMN "ac_flow"."form_code" IS '表单编码';
COMMENT ON COLUMN "ac_flow"."version_code" IS '版本号';
COMMENT ON COLUMN "ac_flow"."mobile_approval" IS '移动审批';
COMMENT ON COLUMN "ac_flow"."enabled" IS '启用';
COMMENT ON COLUMN "ac_flow"."flow_schema" IS '流程定义内容';
COMMENT ON COLUMN "ac_flow"."flow_manager" IS '流程管理员';
COMMENT ON COLUMN "ac_flow"."definition_id" IS '流程定义ID';
COMMENT ON COLUMN "ac_flow"."deployment_id" IS '流程部署ID';
COMMENT ON COLUMN "ac_flow"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "ac_flow"."deleted" IS '逻辑删除';
COMMENT ON COLUMN "ac_flow"."create_by" IS '创建人';
COMMENT ON COLUMN "ac_flow"."create_time" IS '创建时间';
COMMENT ON COLUMN "ac_flow"."modify_by" IS '更新人';
COMMENT ON COLUMN "ac_flow"."modify_time" IS '更新时间';


-- "ac_form" definition

-- Drop table

-- DROP TABLE "ac_form";

create table if not exists "ac_form" (
                                         "form_id" varchar(64) NOT NULL,
    "form_name" varchar(64) NULL,
    "form_code" varchar(64) NULL,
    "app_code" varchar(64) NULL,
    "model_code" varchar(64) NULL,
    "form_config" text NULL,
    "tenant_id" varchar(64) NULL,
    "deleted" integer NULL,
    "create_by" varchar(64) NULL,
    "create_time" timestamp NULL,
    "modify_by" varchar(64) NULL,
    "modify_time" timestamp NULL,
    "custom" varchar(64) NULL,
    "custom_url" varchar(200) NULL,
    CONSTRAINT "ac_form_pkey" PRIMARY KEY ("form_id")
    );
COMMENT ON TABLE "ac_form" IS '表单';

-- Column comments

COMMENT ON COLUMN "ac_form"."form_id" IS '主键';
COMMENT ON COLUMN "ac_form"."form_name" IS '表单名称';
COMMENT ON COLUMN "ac_form"."form_code" IS '表单编码';
COMMENT ON COLUMN "ac_form"."app_code" IS '应用编码';
COMMENT ON COLUMN "ac_form"."model_code" IS '模型编码';
COMMENT ON COLUMN "ac_form"."form_config" IS '表单配置';
COMMENT ON COLUMN "ac_form"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "ac_form"."deleted" IS '逻辑删除';
COMMENT ON COLUMN "ac_form"."create_by" IS '创建人';
COMMENT ON COLUMN "ac_form"."create_time" IS '创建时间';
COMMENT ON COLUMN "ac_form"."modify_by" IS '更新人';
COMMENT ON COLUMN "ac_form"."modify_time" IS '更新时间';


-- "ac_model" definition

-- Drop table

-- DROP TABLE "ac_model";

create table if not exists "ac_model" (
                                          "model_id" varchar(64) NOT NULL,
    "app_code" varchar(64) NULL,
    "model_code" varchar(64) NOT NULL,
    "model_name" varchar(64) NOT NULL,
    "table_name" varchar(64) NOT NULL,
    "last_db_name" varchar(64) NULL,
    "model_type" varchar(64) NOT NULL,
    "embed" varchar(64) NULL,
    "sync_status" varchar(64) NOT NULL,
    "data_type" varchar(64) NULL,
    "tree_fields" text NULL,
    "sub_models" text NULL,
    "pro_config" text NULL,
    "model_handler" varchar(500) NULL,
    "description" varchar(800) NULL,
    "tenant_id" varchar(64) NULL,
    "deleted" integer NULL,
    "create_by" varchar(64) NULL,
    "create_time" timestamp NULL,
    "modify_by" varchar(64) NULL,
    "modify_time" timestamp NULL,
    CONSTRAINT "ac_model_pkey" PRIMARY KEY ("model_id")
    );
COMMENT ON TABLE "ac_model" IS '数据模型';

-- Column comments

COMMENT ON COLUMN "ac_model"."model_id" IS '模型ID';
COMMENT ON COLUMN "ac_model"."app_code" IS '所属应用';
COMMENT ON COLUMN "ac_model"."model_code" IS '模型编码';
COMMENT ON COLUMN "ac_model"."model_name" IS '模型名称';
COMMENT ON COLUMN "ac_model"."table_name" IS '数据库表名';
COMMENT ON COLUMN "ac_model"."last_db_name" IS '最后一次同步的数据库名';
COMMENT ON COLUMN "ac_model"."model_type" IS '模型类型';
COMMENT ON COLUMN "ac_model"."embed" IS '内置模型';
COMMENT ON COLUMN "ac_model"."sync_status" IS '数据库同步状态';
COMMENT ON COLUMN "ac_model"."data_type" IS '模型数据类型';
COMMENT ON COLUMN "ac_model"."tree_fields" IS '树形字段配置';
COMMENT ON COLUMN "ac_model"."sub_models" IS '关联模型';
COMMENT ON COLUMN "ac_model"."pro_config" IS '高级配置';
COMMENT ON COLUMN "ac_model"."model_handler" IS '数据处理器';
COMMENT ON COLUMN "ac_model"."description" IS '描述';
COMMENT ON COLUMN "ac_model"."tenant_id" IS '租户号';
COMMENT ON COLUMN "ac_model"."deleted" IS '逻辑删除';
COMMENT ON COLUMN "ac_model"."create_by" IS '创建人';
COMMENT ON COLUMN "ac_model"."create_time" IS '创建时间';
COMMENT ON COLUMN "ac_model"."modify_by" IS '更新人';
COMMENT ON COLUMN "ac_model"."modify_time" IS '更新时间';


-- "ac_model_field" definition

-- Drop table

-- DROP TABLE "ac_model_field";

create table if not exists "ac_model_field" (
                                                "field_id" varchar(64) NOT NULL,
    "model_code" varchar(64) NOT NULL,
    "field_key" varchar(64) NULL,
    "field_code" varchar(64) NOT NULL,
    "field_name" varchar(64) NOT NULL,
    "col_name" varchar(64) NOT NULL,
    "last_db_name" varchar(64) NULL,
    "field_type" varchar(64) NOT NULL,
    "field_size" integer NULL,
    "field_scale" integer NULL,
    "is_unique" varchar(64) NULL,
    "is_pk" varchar(64) NOT NULL,
    "not_null" varchar(64) NOT NULL,
    "def_value" varchar(64) NULL,
    "order_no" integer NULL,
    "rmk" varchar(64) NULL,
    "embed" varchar(64) NOT NULL,
    "tenant_id" varchar(64) NULL,
    "deleted" integer NULL,
    "create_by" varchar(64) NULL,
    "create_time" timestamp NULL,
    "modify_by" varchar(64) NULL,
    "modify_time" timestamp NULL,
    "ui_config" text NULL,
    CONSTRAINT "ac_model_field_pkey" PRIMARY KEY ("field_id")
    );
COMMENT ON TABLE "ac_model_field" IS '数据模型字段';

-- Column comments

COMMENT ON COLUMN "ac_model_field"."field_id" IS '字段ID';
COMMENT ON COLUMN "ac_model_field"."model_code" IS '模型编码';
COMMENT ON COLUMN "ac_model_field"."field_key" IS '字段唯一key';
COMMENT ON COLUMN "ac_model_field"."field_code" IS '字段编码';
COMMENT ON COLUMN "ac_model_field"."field_name" IS '字段名称';
COMMENT ON COLUMN "ac_model_field"."col_name" IS '数据库列名';
COMMENT ON COLUMN "ac_model_field"."last_db_name" IS '最后一次同步的数据库名';
COMMENT ON COLUMN "ac_model_field"."field_type" IS '字段类型';
COMMENT ON COLUMN "ac_model_field"."field_size" IS '字段长度';
COMMENT ON COLUMN "ac_model_field"."field_scale" IS '字段精度';
COMMENT ON COLUMN "ac_model_field"."is_unique" IS '唯一性校验';
COMMENT ON COLUMN "ac_model_field"."is_pk" IS '是否主键';
COMMENT ON COLUMN "ac_model_field"."not_null" IS '必填';
COMMENT ON COLUMN "ac_model_field"."def_value" IS '默认值';
COMMENT ON COLUMN "ac_model_field"."order_no" IS '排序';
COMMENT ON COLUMN "ac_model_field"."rmk" IS '备注';
COMMENT ON COLUMN "ac_model_field"."embed" IS '内置字段';
COMMENT ON COLUMN "ac_model_field"."tenant_id" IS '租户号';
COMMENT ON COLUMN "ac_model_field"."deleted" IS '逻辑删除';
COMMENT ON COLUMN "ac_model_field"."create_by" IS '创建人';
COMMENT ON COLUMN "ac_model_field"."create_time" IS '创建时间';
COMMENT ON COLUMN "ac_model_field"."modify_by" IS '更新人';
COMMENT ON COLUMN "ac_model_field"."modify_time" IS '更新时间';


-- "ac_model_sync_his" definition

-- Drop table

-- DROP TABLE "ac_model_sync_his";

create table if not exists "ac_model_sync_his" (
                                                   "sync_id" varchar(64) NULL,
    "model_code" varchar(64) NULL,
    "sync_log" text NULL,
    "sync_success" varchar(64) NULL,
    "sync_time" varchar(64) NULL,
    "tenant_id" varchar(64) NULL,
    "deleted" integer NULL,
    "create_by" varchar(64) NULL,
    "create_time" timestamp NULL,
    "modify_by" varchar(64) NULL,
    "modify_time" timestamp NULL
    );
COMMENT ON TABLE "ac_model_sync_his" IS '模型同步记录表';

-- Column comments

COMMENT ON COLUMN "ac_model_sync_his"."sync_id" IS '主键';
COMMENT ON COLUMN "ac_model_sync_his"."model_code" IS '模型编码';
COMMENT ON COLUMN "ac_model_sync_his"."sync_log" IS '同步记录sql';
COMMENT ON COLUMN "ac_model_sync_his"."sync_success" IS '同步是否成功';
COMMENT ON COLUMN "ac_model_sync_his"."sync_time" IS '同步时间';
COMMENT ON COLUMN "ac_model_sync_his"."tenant_id" IS '租户号';
COMMENT ON COLUMN "ac_model_sync_his"."deleted" IS '逻辑删除';
COMMENT ON COLUMN "ac_model_sync_his"."create_by" IS '创建人';
COMMENT ON COLUMN "ac_model_sync_his"."create_time" IS '创建时间';
COMMENT ON COLUMN "ac_model_sync_his"."modify_by" IS '更新人';
COMMENT ON COLUMN "ac_model_sync_his"."modify_time" IS '更新时间';


-- "ac_report" definition

-- Drop table

-- DROP TABLE "ac_report";

create table if not exists "ac_report" (
                                           "report_id" varchar(64) NOT NULL,
    "app_code" varchar(64) NULL,
    "report_type" varchar(64) NULL,
    "report_name" varchar(64) NULL,
    "jimu_report_id" varchar(64) NULL,
    "share_url" varchar(1000) NULL,
    "tenant_id" varchar(64) NULL,
    "deleted" integer NULL,
    "create_by" varchar(64) NULL,
    "create_time" timestamp(6) without time zone NULL,
    "modify_by" varchar(64) NULL,
    "modify_time" timestamp(6) without time zone NULL,
    CONSTRAINT "ac_report_pkey" PRIMARY KEY ("report_id")
    );
COMMENT ON TABLE "ac_report" IS '报表管理';

-- Column comments

COMMENT ON COLUMN "ac_report"."report_id" IS '主键';
COMMENT ON COLUMN "ac_report"."app_code" IS '所属应用编码';
COMMENT ON COLUMN "ac_report"."report_type" IS '报表类型';
COMMENT ON COLUMN "ac_report"."report_name" IS '报表名称';
COMMENT ON COLUMN "ac_report"."jimu_report_id" IS '积木报表ID';
COMMENT ON COLUMN "ac_report"."share_url" IS '分享链接';
COMMENT ON COLUMN "ac_report"."tenant_id" IS '租户号';
COMMENT ON COLUMN "ac_report"."deleted" IS '逻辑删除';
COMMENT ON COLUMN "ac_report"."create_by" IS '创建人';
COMMENT ON COLUMN "ac_report"."create_time" IS '创建时间';
COMMENT ON COLUMN "ac_report"."modify_by" IS '更新人';
COMMENT ON COLUMN "ac_report"."modify_time" IS '更新时间';


-- "ac_view" definition

-- Drop table

-- DROP TABLE "ac_view";

create table if not exists "ac_view" (
                                         "view_id" varchar(64) NOT NULL,
    "app_code" varchar(64) NULL,
    "view_code" varchar(64) NULL,
    "view_name" varchar(64) NOT NULL,
    "custom" varchar(64) NULL,
    "custom_url" varchar(500) NULL,
    "view_type" varchar(64) NULL,
    "view_schema" text NULL,
    "tenant_id" varchar(64) NULL,
    "deleted" integer NULL,
    "create_by" varchar(64) NULL,
    "create_time" timestamp NULL,
    "modify_by" varchar(64) NULL,
    "modify_time" timestamp NULL,
    CONSTRAINT "ac_view_pkey" PRIMARY KEY ("view_id")
    );
COMMENT ON TABLE "ac_view" IS '应用视图';

-- Column comments

COMMENT ON COLUMN "ac_view"."view_id" IS '主键';
COMMENT ON COLUMN "ac_view"."app_code" IS '应用编码';
COMMENT ON COLUMN "ac_view"."view_code" IS '视图编码';
COMMENT ON COLUMN "ac_view"."view_name" IS '视图名称';
COMMENT ON COLUMN "ac_view"."custom" IS '自定义视图';
COMMENT ON COLUMN "ac_view"."custom_url" IS '自定义视图的路径';
COMMENT ON COLUMN "ac_view"."view_type" IS '视图类型';
COMMENT ON COLUMN "ac_view"."view_schema" IS '视图json结构';
COMMENT ON COLUMN "ac_view"."tenant_id" IS '租户ID';
COMMENT ON COLUMN "ac_view"."deleted" IS '逻辑删除';
COMMENT ON COLUMN "ac_view"."create_by" IS '创建人';
COMMENT ON COLUMN "ac_view"."create_time" IS '创建时间';
COMMENT ON COLUMN "ac_view"."modify_by" IS '更新人';
COMMENT ON COLUMN "ac_view"."modify_time" IS '更新时间';


-- "base_audit_log" definition

-- Drop table

-- DROP TABLE "base_audit_log";

create table if not exists "base_audit_log" (
                                                "id" varchar(64) NOT NULL,
    "user_id" varchar(64) NULL,
    "title" varchar(200) NULL,
    "log_type" varchar(64) NULL,
    "request_url" varchar(200) NULL,
    "http_method" varchar(64) NULL,
    "java_method" varchar(200) NULL,
    "log_ip" varchar(64) NULL,
    "log_time" timestamp NULL,
    "time_cost" integer NULL,
    "success" varchar(64) NULL,
    "request_content" text NULL,
    "response_content" text NULL,
    CONSTRAINT "base_audit_log_pkey" PRIMARY KEY ("id")
    );
COMMENT ON TABLE "base_audit_log" IS '操作审计日志';

-- Column comments

COMMENT ON COLUMN "base_audit_log"."id" IS '主键';
COMMENT ON COLUMN "base_audit_log"."user_id" IS '用户ID';
COMMENT ON COLUMN "base_audit_log"."title" IS '标题';
COMMENT ON COLUMN "base_audit_log"."log_type" IS '日志类型';
COMMENT ON COLUMN "base_audit_log"."request_url" IS '请求地址';
COMMENT ON COLUMN "base_audit_log"."http_method" IS '请求方式';
COMMENT ON COLUMN "base_audit_log"."java_method" IS 'java请求方法';
COMMENT ON COLUMN "base_audit_log"."log_ip" IS '请求IP';
COMMENT ON COLUMN "base_audit_log"."log_time" IS '请求时间';
COMMENT ON COLUMN "base_audit_log"."time_cost" IS '耗时';
COMMENT ON COLUMN "base_audit_log"."success" IS '成功';
COMMENT ON COLUMN "base_audit_log"."request_content" IS '请求内容';
COMMENT ON COLUMN "base_audit_log"."response_content" IS '响应内容';


-- "base_dept" definition

-- Drop table

-- DROP TABLE "base_dept";

create table if not exists "base_dept" (
                                           "dept_id" varchar(64) NOT NULL,
    "org_id" varchar(64) NOT NULL,
    "dept_pid" varchar(64) NOT NULL,
    "dept_code" varchar(64) NULL,
    "dept_name" varchar(64) NOT NULL,
    "dept_full_name" varchar(64) NULL,
    "manager_id" varchar(64) NULL,
    "virtual" varchar(64) NULL,
    "enabled" varchar(64) NULL,
    "order_no" varchar(64) NULL,
    "rmk" varchar(64) NULL,
    "tenant_id" varchar(64) NULL,
    "deleted" integer NULL,
    "create_by" varchar(64) NULL,
    "create_time" timestamp NULL,
    "modify_by" varchar(64) NULL,
    "modify_time" timestamp NULL,
    CONSTRAINT "base_dept_pkey" PRIMARY KEY ("dept_id")
    );
COMMENT ON TABLE "base_dept" IS '部门';

-- Column comments

COMMENT ON COLUMN "base_dept"."dept_id" IS '部门ID';
COMMENT ON COLUMN "base_dept"."org_id" IS '机构ID';
COMMENT ON COLUMN "base_dept"."dept_pid" IS '上级部门D';
COMMENT ON COLUMN "base_dept"."dept_code" IS '部门编码';
COMMENT ON COLUMN "base_dept"."dept_name" IS '部门名称';
COMMENT ON COLUMN "base_dept"."dept_full_name" IS '部门全称';
COMMENT ON COLUMN "base_dept"."manager_id" IS '部门主管ID';
COMMENT ON COLUMN "base_dept"."virtual" IS '虚拟部门';
COMMENT ON COLUMN "base_dept"."enabled" IS '启用';
COMMENT ON COLUMN "base_dept"."order_no" IS '排序';
COMMENT ON COLUMN "base_dept"."rmk" IS '备注';
COMMENT ON COLUMN "base_dept"."tenant_id" IS '租户号';
COMMENT ON COLUMN "base_dept"."deleted" IS '逻辑删除';
COMMENT ON COLUMN "base_dept"."create_by" IS '创建人';
COMMENT ON COLUMN "base_dept"."create_time" IS '创建时间';
COMMENT ON COLUMN "base_dept"."modify_by" IS '更新人';
COMMENT ON COLUMN "base_dept"."modify_time" IS '更新时间';


-- "base_dict" definition

-- Drop table

-- DROP TABLE "base_dict";

create table if not exists "base_dict" (
                                           "id" varchar(64) NOT NULL,
    "dict_code" varchar(64) NULL,
    "dict_name" varchar(64) NULL,
    "dict_type" varchar(64) NULL,
    "embed" varchar(64) NULL,
    "description" varchar(800) NULL,
    "tenant_id" varchar(64) NULL,
    "deleted" integer NULL,
    "create_by" varchar(64) NULL,
    "create_time" date NULL,
    "modify_by" varchar(64) NULL,
    "modify_time" date NULL,
    CONSTRAINT "base_dict_pkey" PRIMARY KEY ("id")
    );
COMMENT ON TABLE "base_dict" IS '字典';

-- Column comments

COMMENT ON COLUMN "base_dict"."id" IS '主键';
COMMENT ON COLUMN "base_dict"."dict_code" IS '字典编码';
COMMENT ON COLUMN "base_dict"."dict_name" IS '字典名称';
COMMENT ON COLUMN "base_dict"."dict_type" IS '字典类型';
COMMENT ON COLUMN "base_dict"."embed" IS '内置字典';
COMMENT ON COLUMN "base_dict"."description" IS '描述信息';
COMMENT ON COLUMN "base_dict"."tenant_id" IS '租户号';
COMMENT ON COLUMN "base_dict"."deleted" IS '逻辑删除';
COMMENT ON COLUMN "base_dict"."create_by" IS '创建人';
COMMENT ON COLUMN "base_dict"."create_time" IS '创建时间';
COMMENT ON COLUMN "base_dict"."modify_by" IS '更新人';
COMMENT ON COLUMN "base_dict"."modify_time" IS '更新时间';


-- "base_dict_item" definition

-- Drop table

-- DROP TABLE "base_dict_item";

create table if not exists "base_dict_item" (
                                                "id" varchar(64) NOT NULL,
    "pid" varchar(64) NULL,
    "dict_code" varchar(64) NOT NULL,
    "value" varchar(64) NULL,
    "label" varchar(64) NULL,
    "order_no" integer NULL,
    CONSTRAINT "base_dict_item_pkey" PRIMARY KEY ("id")
    );
COMMENT ON TABLE "base_dict_item" IS '字典项';

-- Column comments

COMMENT ON COLUMN "base_dict_item"."id" IS '主键';
COMMENT ON COLUMN "base_dict_item"."pid" IS '上级ID';
COMMENT ON COLUMN "base_dict_item"."dict_code" IS '字典编码';
COMMENT ON COLUMN "base_dict_item"."value" IS '字典值';
COMMENT ON COLUMN "base_dict_item"."label" IS '字典文字';
COMMENT ON COLUMN "base_dict_item"."order_no" IS '排序';


-- "base_file" definition

-- Drop table

-- DROP TABLE "base_file";

create table if not exists "base_file" (
                                           "id" varchar(64) NOT NULL,
    "url" varchar(512) NULL,
    "dir_id" varchar(64) NULL,
    "size" integer NULL,
    "file_name" varchar(256) NULL,
    "original_file_name" varchar(256) NULL,
    "base_path" varchar(256) NULL,
    "path" varchar(256) NULL,
    "ext" varchar(64) NULL,
    "content_type" varchar(256) NULL,
    "platform" varchar(64) NULL,
    "hashcode" text NULL,
    "metadata" text NULL,
    "upload_time" timestamp NULL,
    "upload_by" varchar(64) NULL,
    "deleted" integer NULL,
    "create_by" varchar(64) NULL,
    "create_time" timestamp NULL,
    "modify_by" varchar(64) NULL,
    "modify_time" timestamp NULL,
    "model_code" varchar(64) NULL,
    "model_pk" varchar(64) NULL,
    "group" varchar(64) NULL,
    "tenant_id" varchar(64) NULL,
    CONSTRAINT "base_file_pkey" PRIMARY KEY ("id")
    );
COMMENT ON TABLE "base_file" IS '文件表';

-- Column comments

COMMENT ON COLUMN "base_file"."id" IS '文件ID';
COMMENT ON COLUMN "base_file"."url" IS '文件访问地址';
COMMENT ON COLUMN "base_file"."dir_id" IS '文件目录ID';
COMMENT ON COLUMN "base_file"."size" IS '文件大小(字节)';
COMMENT ON COLUMN "base_file"."file_name" IS '文件名';
COMMENT ON COLUMN "base_file"."original_file_name" IS '原始文件名';
COMMENT ON COLUMN "base_file"."base_path" IS '基础存储路径';
COMMENT ON COLUMN "base_file"."path" IS '存储路径';
COMMENT ON COLUMN "base_file"."ext" IS '扩展名';
COMMENT ON COLUMN "base_file"."content_type" IS 'mime类型';
COMMENT ON COLUMN "base_file"."platform" IS '存储平台';
COMMENT ON COLUMN "base_file"."hashcode" IS '文件哈希码';
COMMENT ON COLUMN "base_file"."metadata" IS '文件元数据';
COMMENT ON COLUMN "base_file"."upload_time" IS '上传时间';
COMMENT ON COLUMN "base_file"."upload_by" IS '上传人';
COMMENT ON COLUMN "base_file"."deleted" IS '逻辑删除';
COMMENT ON COLUMN "base_file"."create_by" IS '创建人';
COMMENT ON COLUMN "base_file"."create_time" IS '创建时间';
COMMENT ON COLUMN "base_file"."modify_by" IS '更新人';
COMMENT ON COLUMN "base_file"."modify_time" IS '更新时间';
COMMENT ON COLUMN "base_file"."model_code" IS '模型编码';
COMMENT ON COLUMN "base_file"."model_pk" IS '模型主键';
COMMENT ON COLUMN "base_file"."group" IS '文件分组';


-- "base_menu" definition

-- Drop table

-- DROP TABLE "base_menu";

create table if not exists "base_menu" (
                                           "menu_id" varchar(64) NOT NULL,
    "menu_pid" varchar(64) NULL,
    "menu_code" varchar(64) NOT NULL,
    "menu_name" varchar(64) NOT NULL,
    "menu_icon" varchar(64) NULL,
    "menu_type" varchar(64) NULL,
    "menu_path" varchar(256) NULL,
    "enabled" varchar(64) NULL,
    "order_no" integer NULL,
    "rmk" varchar(500) NULL,
    "tenant_id" varchar(64) NULL,
    "deleted" integer NULL,
    "create_by" varchar(64) NULL,
    "create_time" date NULL,
    "modify_by" varchar(64) NULL,
    "modify_time" date NULL,
    "view_code" varchar(64) NULL,
    CONSTRAINT "base_menu_pkey" PRIMARY KEY ("menu_id")
    );
COMMENT ON TABLE "base_menu" IS '菜单';

-- Column comments

COMMENT ON COLUMN "base_menu"."menu_id" IS '菜单ID';
COMMENT ON COLUMN "base_menu"."menu_pid" IS '上级菜单ID';
COMMENT ON COLUMN "base_menu"."menu_code" IS '菜单编码';
COMMENT ON COLUMN "base_menu"."menu_name" IS '菜单名称';
COMMENT ON COLUMN "base_menu"."menu_icon" IS '菜单图标';
COMMENT ON COLUMN "base_menu"."menu_type" IS '菜单类型';
COMMENT ON COLUMN "base_menu"."menu_path" IS '菜单路径';
COMMENT ON COLUMN "base_menu"."enabled" IS '启用';
COMMENT ON COLUMN "base_menu"."order_no" IS '排序';
COMMENT ON COLUMN "base_menu"."rmk" IS '备注';
COMMENT ON COLUMN "base_menu"."tenant_id" IS '租户号';
COMMENT ON COLUMN "base_menu"."deleted" IS '逻辑删除';
COMMENT ON COLUMN "base_menu"."create_by" IS '创建人';
COMMENT ON COLUMN "base_menu"."create_time" IS '创建时间';
COMMENT ON COLUMN "base_menu"."modify_by" IS '更新人';
COMMENT ON COLUMN "base_menu"."modify_time" IS '更新时间';
COMMENT ON COLUMN "base_menu"."view_code" IS '视图编码';


-- "base_menu_auth" definition

-- Drop table

-- DROP TABLE "base_menu_auth";

create table if not exists "base_menu_auth" (
                                                "auth_id" varchar(64) NOT NULL,
    "menu_id" varchar(64) NOT NULL,
    "auth_code" varchar(64) NULL,
    "auth_name" varchar(64) NULL,
    "auth_type" varchar(64) NULL,
    "auth_rmk" varchar(128) NULL,
    "enabled" varchar(64) NULL,
    "order_no" integer NULL,
    "deleted" integer NULL,
    "create_by" varchar(64) NULL,
    "create_time" timestamp NULL,
    "modify_by" varchar(64) NULL,
    "modify_time" timestamp NULL,
    CONSTRAINT "base_menu_auth_pk" PRIMARY KEY ("auth_id")
    );
COMMENT ON TABLE "base_menu_auth" IS '菜单权限';

-- Column comments

COMMENT ON COLUMN "base_menu_auth"."auth_id" IS '权限ID';
COMMENT ON COLUMN "base_menu_auth"."menu_id" IS '菜单ID';
COMMENT ON COLUMN "base_menu_auth"."auth_code" IS '权限编码';
COMMENT ON COLUMN "base_menu_auth"."auth_name" IS '权限名称';
COMMENT ON COLUMN "base_menu_auth"."auth_type" IS '权限类型';
COMMENT ON COLUMN "base_menu_auth"."auth_rmk" IS '权限说明';
COMMENT ON COLUMN "base_menu_auth"."enabled" IS '启用';
COMMENT ON COLUMN "base_menu_auth"."order_no" IS '排序';
COMMENT ON COLUMN "base_menu_auth"."deleted" IS '逻辑删除';
COMMENT ON COLUMN "base_menu_auth"."create_by" IS '创建人';
COMMENT ON COLUMN "base_menu_auth"."create_time" IS '创建时间';
COMMENT ON COLUMN "base_menu_auth"."modify_by" IS '更新人';
COMMENT ON COLUMN "base_menu_auth"."modify_time" IS '更新时间';


-- "base_org" definition

-- Drop table

-- DROP TABLE "base_org";

create table if not exists "base_org" (
                                          "org_id" varchar(64) NOT NULL,
    "org_pid" varchar(64) NULL,
    "org_code" varchar(64) NULL,
    "org_name" varchar(64) NULL,
    "org_full_name" varchar(64) NULL,
    "enabled" varchar(64) NULL,
    "order_no" integer NULL,
    "rmk" varchar(64) NULL,
    "tenant_id" varchar(64) NULL,
    "deleted" integer NULL,
    "create_by" varchar(64) NULL,
    "create_time" timestamp NULL,
    "modify_by" varchar(64) NULL,
    "modify_time" timestamp NULL,
    CONSTRAINT "base_org_pkey" PRIMARY KEY ("org_id")
    );
COMMENT ON TABLE "base_org" IS '机构';

-- Column comments

COMMENT ON COLUMN "base_org"."org_id" IS '组织机构ID';
COMMENT ON COLUMN "base_org"."org_pid" IS '上级机构ID';
COMMENT ON COLUMN "base_org"."org_code" IS '组织机构编码';
COMMENT ON COLUMN "base_org"."org_name" IS '组织机构名称';
COMMENT ON COLUMN "base_org"."org_full_name" IS '组织机构全称';
COMMENT ON COLUMN "base_org"."enabled" IS '启用';
COMMENT ON COLUMN "base_org"."order_no" IS '排序';
COMMENT ON COLUMN "base_org"."rmk" IS '备注';
COMMENT ON COLUMN "base_org"."tenant_id" IS '租户号';
COMMENT ON COLUMN "base_org"."deleted" IS '逻辑删除';
COMMENT ON COLUMN "base_org"."create_by" IS '创建人';
COMMENT ON COLUMN "base_org"."create_time" IS '创建时间';
COMMENT ON COLUMN "base_org"."modify_by" IS '更新人';
COMMENT ON COLUMN "base_org"."modify_time" IS '更新时间';


-- "base_param" definition

-- Drop table

-- DROP TABLE "base_param";

create table if not exists "base_param" (
                                            "id" varchar(64) NOT NULL,
    "param_code" varchar(64) NOT NULL,
    "param_name" varchar(64) NOT NULL,
    "param_type" varchar(64) NOT NULL,
    "group_type" varchar(64) NULL,
    "group_name" varchar(64) NULL,
    "param_value" varchar(800) NULL,
    "def_value" varchar(800) NULL,
    "auth_ignore" varchar(64) NOT NULL,
    "param_options" text NULL,
    "order_no" integer NULL,
    "description" varchar(800) NULL,
    "embed" varchar(64) NULL,
    "tenant_id" varchar(64) NULL,
    "deleted" integer NULL,
    "create_by" varchar(64) NULL,
    "create_time" date NULL,
    "modify_by" varchar(64) NULL,
    "modify_time" date NULL,
    CONSTRAINT "base_param_pkey" PRIMARY KEY ("id")
    );
COMMENT ON TABLE "base_param" IS '系统参数';

-- Column comments

COMMENT ON COLUMN "base_param"."id" IS '主键';
COMMENT ON COLUMN "base_param"."param_code" IS '参数编码';
COMMENT ON COLUMN "base_param"."param_name" IS '参数名称';
COMMENT ON COLUMN "base_param"."param_type" IS '参数类型';
COMMENT ON COLUMN "base_param"."group_type" IS '参数分组类型';
COMMENT ON COLUMN "base_param"."group_name" IS '分组名称';
COMMENT ON COLUMN "base_param"."param_value" IS '参数值';
COMMENT ON COLUMN "base_param"."def_value" IS '默认值';
COMMENT ON COLUMN "base_param"."auth_ignore" IS '忽略权限校验';
COMMENT ON COLUMN "base_param"."param_options" IS '参数的可选项son';
COMMENT ON COLUMN "base_param"."order_no" IS '顺序号';
COMMENT ON COLUMN "base_param"."description" IS '描述信息';
COMMENT ON COLUMN "base_param"."embed" IS '内置字典';
COMMENT ON COLUMN "base_param"."tenant_id" IS '租户号';
COMMENT ON COLUMN "base_param"."deleted" IS '逻辑删除';
COMMENT ON COLUMN "base_param"."create_by" IS '创建人';
COMMENT ON COLUMN "base_param"."create_time" IS '创建时间';
COMMENT ON COLUMN "base_param"."modify_by" IS '更新人';
COMMENT ON COLUMN "base_param"."modify_time" IS '更新时间';


-- "base_position" definition

-- Drop table

-- DROP TABLE "base_position";

create table if not exists "base_position" (
                                               "position_id" varchar(64) NOT NULL,
    "org_id" varchar(64) NULL,
    "position_name" varchar(64) NULL,
    "position_code" varchar(64) NULL,
    "headcount" varchar(64) NULL,
    "toxic_harmful" varchar(64) NULL,
    "enabled" varchar(64) NULL,
    "order_no" integer NULL,
    "rmk" varchar(500) NULL,
    "tenant_id" varchar(64) NULL,
    "deleted" integer NULL,
    "create_by" varchar(64) NULL,
    "create_time" date NULL,
    "modify_by" varchar(64) NULL,
    "modify_time" date NULL,
    CONSTRAINT "base_position_pkey" PRIMARY KEY ("position_id")
    );
COMMENT ON TABLE "base_position" IS '岗位';

-- Column comments

COMMENT ON COLUMN "base_position"."position_id" IS '岗位ID';
COMMENT ON COLUMN "base_position"."org_id" IS '组织机构ID';
COMMENT ON COLUMN "base_position"."position_name" IS '岗位名称';
COMMENT ON COLUMN "base_position"."position_code" IS '岗位编码';
COMMENT ON COLUMN "base_position"."headcount" IS '编制人数';
COMMENT ON COLUMN "base_position"."toxic_harmful" IS '有毒有害工种';
COMMENT ON COLUMN "base_position"."enabled" IS '启用';
COMMENT ON COLUMN "base_position"."order_no" IS '排序';
COMMENT ON COLUMN "base_position"."rmk" IS '备注';
COMMENT ON COLUMN "base_position"."tenant_id" IS '租户号';
COMMENT ON COLUMN "base_position"."deleted" IS '逻辑删除';
COMMENT ON COLUMN "base_position"."create_by" IS '创建人';
COMMENT ON COLUMN "base_position"."create_time" IS '创建时间';
COMMENT ON COLUMN "base_position"."modify_by" IS '更新人';
COMMENT ON COLUMN "base_position"."modify_time" IS '更新时间';


-- "base_position_user" definition

-- Drop table

-- DROP TABLE "base_position_user";

create table if not exists "base_position_user" (
                                                    "id" varchar(64) NOT NULL,
    "position_id" varchar(64) NULL,
    "user_id" varchar(64) NULL,
    "tenant_id" varchar(64) NULL,
    CONSTRAINT "base_position_user_pk" PRIMARY KEY ("id")
    );
COMMENT ON TABLE "base_position_user" IS '岗位用户';

-- Column comments

COMMENT ON COLUMN "base_position_user"."id" IS '主键ID';
COMMENT ON COLUMN "base_position_user"."position_id" IS '岗位ID';
COMMENT ON COLUMN "base_position_user"."user_id" IS '用户ID';
COMMENT ON COLUMN "base_position_user"."tenant_id" IS '租户号';


-- "base_role" definition

-- Drop table

-- DROP TABLE "base_role";

create table if not exists "base_role" (
                                           "role_id" varchar(64) NOT NULL,
    "org_id" varchar(64) NULL,
    "role_name" varchar(64) NULL,
    "role_type" varchar(64) NULL,
    "order_no" integer NULL,
    "enabled" varchar(64) NULL,
    "tenant_id" varchar(64) NULL,
    "deleted" integer NULL,
    "create_by" varchar(64) NULL,
    "create_time" date NULL,
    "modify_by" varchar(64) NULL,
    "modify_time" date NULL,
    CONSTRAINT "base_role_pkey" PRIMARY KEY ("role_id")
    );
COMMENT ON TABLE "base_role" IS '角色';

-- Column comments

COMMENT ON COLUMN "base_role"."role_id" IS '角色ID';
COMMENT ON COLUMN "base_role"."org_id" IS '组织机构ID';
COMMENT ON COLUMN "base_role"."role_name" IS '角色名称';
COMMENT ON COLUMN "base_role"."role_type" IS '角色类型';
COMMENT ON COLUMN "base_role"."order_no" IS '排序';
COMMENT ON COLUMN "base_role"."enabled" IS '启用';
COMMENT ON COLUMN "base_role"."tenant_id" IS '租户号';
COMMENT ON COLUMN "base_role"."deleted" IS '逻辑删除';
COMMENT ON COLUMN "base_role"."create_by" IS '创建人';
COMMENT ON COLUMN "base_role"."create_time" IS '创建时间';
COMMENT ON COLUMN "base_role"."modify_by" IS '更新人';
COMMENT ON COLUMN "base_role"."modify_time" IS '更新时间';


-- "base_role_auth" definition

-- Drop table

-- DROP TABLE "base_role_auth";

create table if not exists "base_role_auth" (
                                                "id" varchar(64) NOT NULL,
    "role_id" varchar(64) NULL,
    "auth_id" varchar(64) NULL,
    "auth_code" varchar(64) NULL,
    "auth_type" varchar(64) NULL,
    "tenant_id" varchar(64) NULL,
    CONSTRAINT "base_role_auth_pk" PRIMARY KEY ("id")
    );
COMMENT ON TABLE "base_role_auth" IS '角色权限';

-- Column comments

COMMENT ON COLUMN "base_role_auth"."id" IS '主键ID';
COMMENT ON COLUMN "base_role_auth"."role_id" IS '角色ID';
COMMENT ON COLUMN "base_role_auth"."auth_id" IS '权限ID';
COMMENT ON COLUMN "base_role_auth"."auth_code" IS '权限编码';
COMMENT ON COLUMN "base_role_auth"."auth_type" IS '权限类型';
COMMENT ON COLUMN "base_role_auth"."tenant_id" IS '租户号';


-- "base_role_user" definition

-- Drop table

-- DROP TABLE "base_role_user";

create table if not exists "base_role_user" (
                                                "id" varchar(64) NOT NULL,
    "role_id" varchar(64) NULL,
    "user_id" varchar(64) NULL,
    "tenant_id" varchar(64) NULL,
    CONSTRAINT "base_role_user_pk" PRIMARY KEY ("id")
    );
COMMENT ON TABLE "base_role_user" IS '角色用户';

-- Column comments

COMMENT ON COLUMN "base_role_user"."id" IS '主键ID';
COMMENT ON COLUMN "base_role_user"."role_id" IS '角色ID';
COMMENT ON COLUMN "base_role_user"."user_id" IS '用户ID';
COMMENT ON COLUMN "base_role_user"."tenant_id" IS '租户号';


-- "base_user" definition

-- Drop table

-- DROP TABLE "base_user";

create table if not exists "base_user" (
                                           "user_id" varchar(64) NOT NULL,
    "account" varchar(64) NOT NULL,
    "user_name" varchar(64) NOT NULL,
    "org_id" varchar(64) NOT NULL,
    "dept_id" varchar(64) NOT NULL,
    "emp_no" varchar(64) NULL,
    "user_type" varchar(64) NULL,
    "credential" text NULL,
    "avatar" varchar(64) NULL,
    "nick_name" varchar(64) NULL,
    "birthday" timestamp(0) without time zone NULL,
    "gender" varchar(64) NULL,
    "leader_id" varchar(64) NULL,
    "phone_number" varchar(64) NULL,
    "email" varchar(64) NULL,
    "account_status" varchar(64) NULL,
    "tenant_id" varchar(64) NULL,
    "deleted" integer NULL,
    "create_by" varchar(64) NULL,
    "create_time" timestamp NULL,
    "modify_by" varchar(64) NULL,
    "modify_time" timestamp NULL,
    CONSTRAINT "base_user_pkey" PRIMARY KEY ("user_id")
    );
COMMENT ON TABLE "base_user" IS '账号';

-- Column comments

COMMENT ON COLUMN "base_user"."user_id" IS '用户ID';
COMMENT ON COLUMN "base_user"."account" IS '账号';
COMMENT ON COLUMN "base_user"."user_name" IS '姓名';
COMMENT ON COLUMN "base_user"."org_id" IS '组织机构ID';
COMMENT ON COLUMN "base_user"."dept_id" IS '部门ID';
COMMENT ON COLUMN "base_user"."emp_no" IS '工号';
COMMENT ON COLUMN "base_user"."user_type" IS '用户类型';
COMMENT ON COLUMN "base_user"."credential" IS '密码';
COMMENT ON COLUMN "base_user"."avatar" IS '头像';
COMMENT ON COLUMN "base_user"."nick_name" IS '昵称';
COMMENT ON COLUMN "base_user"."birthday" IS '生日';
COMMENT ON COLUMN "base_user"."gender" IS '性别';
COMMENT ON COLUMN "base_user"."leader_id" IS '直属领导ID';
COMMENT ON COLUMN "base_user"."phone_number" IS '手机号';
COMMENT ON COLUMN "base_user"."email" IS '邮箱';
COMMENT ON COLUMN "base_user"."account_status" IS '账号状态';
COMMENT ON COLUMN "base_user"."tenant_id" IS '租户号';
COMMENT ON COLUMN "base_user"."deleted" IS '逻辑删除';
COMMENT ON COLUMN "base_user"."create_by" IS '创建人';
COMMENT ON COLUMN "base_user"."create_time" IS '创建时间';
COMMENT ON COLUMN "base_user"."modify_by" IS '更新人';
COMMENT ON COLUMN "base_user"."modify_time" IS '更新时间';

