/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.process;

import com.kdgcsoft.web.common.process.interfaces.IProcessSelectorProvider;
import com.kdgcsoft.web.common.process.pojo.ProcessDept;
import com.kdgcsoft.web.common.process.pojo.ProcessOrg;
import com.kdgcsoft.web.common.process.pojo.ProcessPosition;
import com.kdgcsoft.web.common.process.pojo.ProcessRole;
import com.kdgcsoft.web.common.process.pojo.ProcessUser;
import com.kdgcsoft.web.config.BootProperties;
import com.kdgcsoft.web.core.entity.BaseDept;
import com.kdgcsoft.web.core.entity.BaseOrg;
import com.kdgcsoft.web.core.entity.BasePosition;
import com.kdgcsoft.web.core.entity.BasePositionUser;
import com.kdgcsoft.web.core.entity.BaseRole;
import com.kdgcsoft.web.core.entity.BaseRoleUser;
import com.kdgcsoft.web.core.entity.BaseUser;
import com.kdgcsoft.web.core.enums.YesNo;
import com.kdgcsoft.web.core.service.BaseDeptService;
import com.kdgcsoft.web.core.service.BaseOrgService;
import com.kdgcsoft.web.core.service.BasePositionService;
import com.kdgcsoft.web.core.service.BasePositionUserService;
import com.kdgcsoft.web.core.service.BaseRoleService;
import com.kdgcsoft.web.core.service.BaseRoleUserService;
import com.kdgcsoft.web.core.service.BaseUserService;
import com.mybatisflex.core.query.QueryWrapper;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SystemProcessSelectorProvider
implements IProcessSelectorProvider {
    @Autowired
    private BaseOrgService baseOrgService;
    @Autowired
    private BaseDeptService baseDeptService;
    @Autowired
    private BaseRoleService baseRoleService;
    @Autowired
    private BaseRoleUserService baseRoleUserService;
    @Autowired
    private BasePositionService basePositionService;
    @Autowired
    private BasePositionUserService basePositionUserService;
    @Autowired
    private BaseUserService baseUserService;
    @Resource
    BootProperties bootProperties;

    public List<ProcessUser> userList() {
        List userList = this.baseUserService.list(QueryWrapper.create().orderBy(BaseUser::getOrderNo, (Boolean)true));
        List<ProcessUser> list = userList.stream().map(BaseUser::toProcessUser).collect(Collectors.toList());
        ProcessUser root = new ProcessUser().setUserId(this.bootProperties.getRootAccountId()).setUserName(this.bootProperties.getRootName()).setOrgId(this.bootProperties.getRootOrgId()).setDeptId(this.bootProperties.getRootDeptId());
        list.add(root);
        return list;
    }

    public List<ProcessOrg> orgList() {
        List baseOrgs = this.baseOrgService.list(QueryWrapper.create().eq(BaseOrg::getEnabled, (Object)YesNo.Y).orderBy(BaseOrg::getOrderNo, (Boolean)true));
        return baseOrgs.stream().map(BaseOrg::toProcessOrg).collect(Collectors.toList());
    }

    public List<ProcessDept> deptList() {
        List baseDepts = this.baseDeptService.list(QueryWrapper.create().eq(BaseDept::getEnabled, (Object)YesNo.Y).orderBy(BaseDept::getOrderNo, (Boolean)true));
        return baseDepts.stream().map(BaseDept::toProcessDept).collect(Collectors.toList());
    }

    public List<ProcessRole> roleList() {
        List roleList = this.baseRoleService.list(QueryWrapper.create().eq(BaseRole::getEnabled, (Object)YesNo.Y).orderBy(BaseRole::getOrderNo, (Boolean)true));
        List roleUserList = this.baseRoleUserService.list();
        return roleList.stream().map(role -> {
            ProcessRole processRole = new ProcessRole();
            processRole.setOrgId(role.getOrgId()).setRoleId(role.getRoleId()).setRoleName(role.getRoleName()).setOrderNo(String.valueOf(role.getOrderNo()));
            processRole.setUserIds(roleUserList.stream().filter(roleUser -> roleUser.getRoleId().equals(role.getRoleId())).map(BaseRoleUser::getUserId).collect(Collectors.toList()));
            return processRole;
        }).collect(Collectors.toList());
    }

    public List<ProcessPosition> postList() {
        List positionList = this.basePositionService.list(QueryWrapper.create().eq(BasePosition::getEnabled, (Object)YesNo.Y).orderBy(BasePosition::getOrderNo, (Boolean)true));
        List positionUserList = this.basePositionUserService.list();
        return positionList.stream().map(position -> {
            ProcessPosition wfPost = new ProcessPosition();
            wfPost.setPostId(position.getPositionId()).setPostName(position.getPositionName()).setOrgId(position.getOrgId()).setOrderNo(String.valueOf(position.getOrderNo()));
            wfPost.setUserIds(positionUserList.stream().filter(positionUser -> positionUser.getPositionId().equals(position.getPositionId())).map(BasePositionUser::getUserId).collect(Collectors.toList()));
            return wfPost;
        }).collect(Collectors.toList());
    }
}

