/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.kdgcsoft.web.core.interfaces.ITreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TreeUtil {
    public static <T extends ITreeNode> List<T> buildTree(List<? extends ITreeNode> nodeList) {
        return TreeUtil.buildTree(nodeList, false);
    }

    public static <T extends ITreeNode> List<T> buildTree(List<? extends ITreeNode> nodeList, boolean cascade) {
        ArrayList<ITreeNode> tree = new ArrayList<ITreeNode>();
        if (CollUtil.isNotEmpty(nodeList)) {
            for (ITreeNode iTreeNode : nodeList) {
                ITreeNode pnode = (ITreeNode)CollUtil.findOne(nodeList, n -> ObjectUtil.equals(n.id(), node2.pid()));
                if (pnode != null || iTreeNode.pid() != null && !iTreeNode.pid().toString().equals("0") && cascade) continue;
                tree.add(iTreeNode);
            }
        }
        ArrayList todoList = CollUtil.newArrayList(tree);
        while (!todoList.isEmpty()) {
            ITreeNode iTreeNode = (ITreeNode)todoList.get(0);
            todoList.remove(0);
            nodeList.forEach(node -> {
                if (ObjectUtil.equals(todoNode.id(), node.pid())) {
                    todoNode.getChildren().add(node);
                    todoList.add(node);
                }
            });
        }
        return tree;
    }

    public static <E> List<E> getChildIds(List<? extends ITreeNode<? extends ITreeNode, E>> nodeList, E startId, boolean include) {
        ArrayList<Object> ids = new ArrayList<Object>();
        if (CollUtil.isNotEmpty(nodeList)) {
            ArrayList todoList = CollUtil.newArrayList((Object[])new Object[]{startId});
            if (include) {
                ids.add(startId);
            }
            while (!todoList.isEmpty()) {
                Object pId = todoList.get(0);
                todoList.remove(0);
                List childIds = nodeList.stream().filter(iTreeNode -> ObjectUtil.equals(iTreeNode.pid(), (Object)pId)).map(ITreeNode::id).collect(Collectors.toList());
                todoList.addAll(childIds);
                ids.addAll(childIds);
            }
        }
        return ids;
    }
}

