/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.util;

import com.kdgcsoft.web.core.entity.BaseJob;
import com.kdgcsoft.web.core.enums.JobStatus;
import com.kdgcsoft.web.core.exception.BusinessException;
import com.kdgcsoft.web.core.util.ScheduleJob;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class ScheduleUtils {
    private static final String JOB_NAME = "TASK_";

    public static TriggerKey getTriggerKey(String jobId) {
        return TriggerKey.triggerKey((String)(JOB_NAME + jobId));
    }

    public static JobKey getJobKey(String jobId) {
        return JobKey.jobKey((String)(JOB_NAME + jobId));
    }

    public static CronTrigger getCronTrigger(Scheduler scheduler, String jobId) {
        try {
            return (CronTrigger)scheduler.getTrigger(ScheduleUtils.getTriggerKey(jobId));
        }
        catch (SchedulerException e) {
            throw new BusinessException("\u83b7\u53d6\u5b9a\u65f6\u4efb\u52a1CronTrigger\u51fa\u73b0\u5f02\u5e38", (Throwable)e, new Object[0]);
        }
    }

    public static void createScheduleJob(Scheduler scheduler, BaseJob baseJob) {
        try {
            JobDetail jobDetail = JobBuilder.newJob(ScheduleJob.class).withIdentity(ScheduleUtils.getJobKey(baseJob.getJobId())).build();
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)baseJob.getJobCron()).withMisfireHandlingInstructionDoNothing();
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(ScheduleUtils.getTriggerKey(baseJob.getJobId())).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            jobDetail.getJobDataMap().put("JOB_PARAM_KEY", (Object)baseJob);
            scheduler.scheduleJob(jobDetail, trigger);
            if (baseJob.getJobStatus() == JobStatus.PAUSE) {
                ScheduleUtils.pauseJob(scheduler, baseJob.getJobId());
            }
        }
        catch (SchedulerException e) {
            throw new BusinessException("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e, new Object[0]);
        }
    }

    public static void updateScheduleJob(Scheduler scheduler, BaseJob baseJob) {
        try {
            TriggerKey triggerKey = ScheduleUtils.getTriggerKey(baseJob.getJobId());
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)baseJob.getJobCron()).withMisfireHandlingInstructionDoNothing();
            CronTrigger trigger = ScheduleUtils.getCronTrigger(scheduler, baseJob.getJobId());
            trigger = (CronTrigger)trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            trigger.getJobDataMap().put("JOB_PARAM_KEY", (Object)baseJob);
            scheduler.rescheduleJob(triggerKey, (Trigger)trigger);
            if (baseJob.getJobStatus() == JobStatus.PAUSE) {
                ScheduleUtils.pauseJob(scheduler, baseJob.getJobId());
            }
        }
        catch (SchedulerException e) {
            throw new BusinessException("\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e, new Object[0]);
        }
    }

    public static void run(Scheduler scheduler, BaseJob baseJob) {
        try {
            JobDataMap dataMap = new JobDataMap();
            dataMap.put("JOB_PARAM_KEY", (Object)baseJob);
            scheduler.triggerJob(ScheduleUtils.getJobKey(baseJob.getJobId()), dataMap);
        }
        catch (SchedulerException e) {
            throw new BusinessException("\u7acb\u5373\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e, new Object[0]);
        }
    }

    public static void pauseJob(Scheduler scheduler, String jobId) {
        try {
            scheduler.pauseJob(ScheduleUtils.getJobKey(jobId));
        }
        catch (SchedulerException e) {
            throw new BusinessException("\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e, new Object[0]);
        }
    }

    public static void resumeJob(Scheduler scheduler, String jobId) {
        try {
            scheduler.resumeJob(ScheduleUtils.getJobKey(jobId));
        }
        catch (SchedulerException e) {
            throw new BusinessException("\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e, new Object[0]);
        }
    }

    public static void deleteScheduleJob(Scheduler scheduler, String jobId) {
        try {
            scheduler.deleteJob(ScheduleUtils.getJobKey(jobId));
        }
        catch (SchedulerException e) {
            throw new BusinessException("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e, new Object[0]);
        }
    }
}

