/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.ac.interfaces.ModelHandler;
import com.kdgcsoft.web.config.mvc.resolver.PageRequest;
import com.kdgcsoft.web.core.entity.BaseUser;
import com.kdgcsoft.web.core.entity.table.BaseDeptTableDef;
import com.kdgcsoft.web.core.entity.table.BaseOrgTableDef;
import com.kdgcsoft.web.core.entity.table.BasePositionUserTableDef;
import com.kdgcsoft.web.core.entity.table.BaseRoleUserTableDef;
import com.kdgcsoft.web.core.entity.table.BaseUserTableDef;
import com.kdgcsoft.web.core.enums.AccountStatus;
import com.kdgcsoft.web.core.enums.SysEnumParams;
import com.kdgcsoft.web.core.mapper.BaseUserMapper;
import com.kdgcsoft.web.core.pojo.Result;
import com.kdgcsoft.web.core.service.BaseDeptService;
import com.kdgcsoft.web.core.service.BaseOrgService;
import com.kdgcsoft.web.core.service.BaseParamService;
import com.kdgcsoft.web.core.util.CryptoUtil;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.If;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.row.Db;
import com.mybatisflex.core.update.UpdateChain;
import com.mybatisflex.spring.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BaseUserService
extends ServiceImpl<BaseUserMapper, BaseUser>
implements ModelHandler<BaseUser> {
    @Autowired
    private BaseDeptService deptService;
    @Autowired
    private BaseOrgService orgService;
    @Autowired
    private BaseParamService baseParamService;

    public List<BaseUser> listByAccount(String account) {
        QueryWrapper queryWrapper = QueryWrapper.create().select(BaseUserTableDef.BASE_USER.ALL_COLUMNS, BaseOrgTableDef.BASE_ORG.ORG_NAME).from(new QueryTable[]{BaseUserTableDef.BASE_USER}).leftJoin((QueryTable)BaseOrgTableDef.BASE_ORG).on(BaseUserTableDef.BASE_USER.ORG_ID.eq((Object)BaseOrgTableDef.BASE_ORG.ORG_ID).and(BaseOrgTableDef.BASE_ORG.DELETED.eq((Object)0))).where(BaseUserTableDef.BASE_USER.ACCOUNT.eq((Object)account).and(BaseUserTableDef.BASE_USER.DELETED.eq((Object)0)));
        return Db.selectListByQueryAs(queryWrapper, BaseUser.class);
    }

    public BaseUser findByUserId(String userId) {
        QueryWrapper wrapper = QueryWrapper.create().select(BaseUserTableDef.BASE_USER.ALL_COLUMNS, BaseOrgTableDef.BASE_ORG.ORG_NAME, BaseDeptTableDef.BASE_DEPT.DEPT_NAME).from(new QueryTable[]{BaseUserTableDef.BASE_USER}).leftJoin((QueryTable)BaseOrgTableDef.BASE_ORG).on(BaseUserTableDef.BASE_USER.ORG_ID.eq((Object)BaseOrgTableDef.BASE_ORG.ORG_ID)).leftJoin((QueryTable)BaseDeptTableDef.BASE_DEPT).on(BaseUserTableDef.BASE_USER.DEPT_ID.eq((Object)BaseDeptTableDef.BASE_DEPT.DEPT_ID)).where(BaseUserTableDef.BASE_USER.USER_ID.eq((Object)userId).and(BaseUserTableDef.BASE_USER.DELETED.eq((Object)0)));
        return (BaseUser)this.getOne(wrapper);
    }

    public List<BaseUser> listByEmpNo(String empNo) {
        return this.list(QueryWrapper.create().select(BaseUserTableDef.BASE_USER.ALL_COLUMNS, BaseOrgTableDef.BASE_ORG.ORG_NAME).from(new QueryTable[]{BaseUserTableDef.BASE_USER}).leftJoin((QueryTable)BaseOrgTableDef.BASE_ORG).on(BaseUserTableDef.BASE_USER.ORG_ID.eq((Object)BaseOrgTableDef.BASE_ORG.ORG_ID).and(BaseOrgTableDef.BASE_ORG.DELETED.eq((Object)0))).where(BaseUserTableDef.BASE_USER.EMP_NO.eq((Object)empNo).and(BaseUserTableDef.BASE_USER.DELETED.eq((Object)0))));
    }

    public Page<BaseUser> pageBaseUser(PageRequest<BaseUser> page, String orgId, String deptId, String searchKey) {
        List<Object> deptIds = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)deptId)) {
            deptIds = this.deptService.getChildIds(deptId, true);
        }
        QueryWrapper queryWrapper = QueryWrapper.create().select(BaseUserTableDef.BASE_USER.ALL_COLUMNS, BaseOrgTableDef.BASE_ORG.ORG_NAME, BaseDeptTableDef.BASE_DEPT.DEPT_NAME).from(new QueryTable[]{BaseUserTableDef.BASE_USER}).leftJoin((QueryTable)BaseOrgTableDef.BASE_ORG).on(BaseUserTableDef.BASE_USER.ORG_ID.eq((Object)BaseOrgTableDef.BASE_ORG.ORG_ID)).leftJoin((QueryTable)BaseDeptTableDef.BASE_DEPT).on(BaseUserTableDef.BASE_USER.DEPT_ID.eq((Object)BaseDeptTableDef.BASE_DEPT.DEPT_ID)).where(BaseUserTableDef.BASE_USER.ORG_ID.eq((Object)orgId).and(BaseUserTableDef.BASE_USER.DEPT_ID.in(deptIds, CollUtil::isNotEmpty))).and(BaseUserTableDef.BASE_USER.EMP_NO.like((Object)searchKey, If::hasText).or(BaseUserTableDef.BASE_USER.USER_NAME.like((Object)searchKey, If::hasText))).orderBy(BaseUserTableDef.BASE_USER.ACCOUNT, (Boolean)true);
        page.appendSortsToWrapper(queryWrapper);
        return this.page(page, queryWrapper);
    }

    public Page<BaseUser> pageByRole(PageRequest<BaseUser> page, String roleId, String searchKey) {
        QueryWrapper queryWrapper = QueryWrapper.create().select(BaseUserTableDef.BASE_USER.ALL_COLUMNS, BaseDeptTableDef.BASE_DEPT.DEPT_NAME).from(new QueryTable[]{BaseUserTableDef.BASE_USER}).leftJoin((QueryTable)BaseDeptTableDef.BASE_DEPT).on(BaseUserTableDef.BASE_USER.DEPT_ID.eq((Object)BaseDeptTableDef.BASE_DEPT.DEPT_ID)).leftJoin((QueryTable)BaseRoleUserTableDef.BASE_ROLE_USER).on(BaseRoleUserTableDef.BASE_ROLE_USER.USER_ID.eq((Object)BaseUserTableDef.BASE_USER.USER_ID)).where(BaseRoleUserTableDef.BASE_ROLE_USER.ROLE_ID.eq((Object)roleId, If::hasText)).and(BaseUserTableDef.BASE_USER.EMP_NO.like((Object)searchKey, If::hasText).or(BaseUserTableDef.BASE_USER.USER_NAME.like((Object)searchKey, If::hasText)));
        page.appendSortsToWrapper(queryWrapper);
        return this.page(page, queryWrapper);
    }

    public Page<BaseUser> pageByPosition(PageRequest<BaseUser> page, String positionId, String searchKey) {
        QueryWrapper queryWrapper = QueryWrapper.create().select(BaseUserTableDef.BASE_USER.ALL_COLUMNS, BaseDeptTableDef.BASE_DEPT.DEPT_NAME).from(new QueryTable[]{BaseUserTableDef.BASE_USER}).leftJoin((QueryTable)BaseDeptTableDef.BASE_DEPT).on(BaseUserTableDef.BASE_USER.DEPT_ID.eq((Object)BaseDeptTableDef.BASE_DEPT.DEPT_ID)).leftJoin((QueryTable)BasePositionUserTableDef.BASE_POSITION_USER).on(BasePositionUserTableDef.BASE_POSITION_USER.USER_ID.eq((Object)BaseUserTableDef.BASE_USER.USER_ID)).where(BasePositionUserTableDef.BASE_POSITION_USER.POSITION_ID.eq((Object)positionId, If::hasText)).and(BaseUserTableDef.BASE_USER.EMP_NO.like((Object)searchKey, If::hasText).or(BaseUserTableDef.BASE_USER.USER_NAME.like((Object)searchKey, If::hasText)));
        page.appendSortsToWrapper(queryWrapper);
        return this.page(page, queryWrapper);
    }

    public Page<BaseUser> pageNotIn(PageRequest<BaseUser> page, String orgId, List<String> userIds, String searchKey) {
        QueryWrapper queryWrapper = QueryWrapper.create().select(BaseUserTableDef.BASE_USER.ALL_COLUMNS, BaseDeptTableDef.BASE_DEPT.DEPT_NAME).from(new QueryTable[]{BaseUserTableDef.BASE_USER}).leftJoin((QueryTable)BaseDeptTableDef.BASE_DEPT).on(BaseUserTableDef.BASE_USER.DEPT_ID.eq((Object)BaseDeptTableDef.BASE_DEPT.DEPT_ID)).where(BaseUserTableDef.BASE_USER.USER_ID.notIn(userIds, CollUtil::isNotEmpty)).and(BaseUserTableDef.BASE_USER.ORG_ID.eq((Object)orgId, If::hasText)).and(BaseUserTableDef.BASE_USER.ACCOUNT.like((Object)searchKey, If::hasText).or(BaseUserTableDef.BASE_USER.USER_NAME.like((Object)searchKey, If::hasText)));
        page.appendSortsToWrapper(queryWrapper);
        return this.page(page, queryWrapper);
    }

    public Page<BaseUser> pageNotExistRole(PageRequest<BaseUser> page, String orgId, String roleId, String searchKey) {
        List<String> userIds = this.list(QueryWrapper.create().select(BaseRoleUserTableDef.BASE_ROLE_USER.USER_ID).from(new QueryTable[]{BaseRoleUserTableDef.BASE_ROLE_USER}).where(BaseRoleUserTableDef.BASE_ROLE_USER.ROLE_ID.eq((Object)roleId, If::hasText))).stream().map(BaseUser::getUserId).collect(Collectors.toList());
        return this.pageNotIn(page, orgId, userIds, searchKey);
    }

    public Page<BaseUser> pageNotExistPosition(PageRequest<BaseUser> page, String orgId, String positionId, String searchKey) {
        List<String> userIds = this.list(QueryWrapper.create().select(BasePositionUserTableDef.BASE_POSITION_USER.USER_ID).from(new QueryTable[]{BasePositionUserTableDef.BASE_POSITION_USER}).where(BasePositionUserTableDef.BASE_POSITION_USER.POSITION_ID.eq((Object)positionId, If::hasText))).stream().map(BaseUser::getUserId).collect(Collectors.toList());
        return this.pageNotIn(page, orgId, userIds, searchKey);
    }

    @Override
    public boolean beforeSave(BaseUser entity, boolean isNew) {
        String defaultPassword = this.baseParamService.getParamValue(SysEnumParams.SYS_DEF_PASSWORD.name());
        if (isNew) {
            entity.setCredential(CryptoUtil.encryptPassword(defaultPassword));
        }
        return true;
    }

    @Override
    public Result afterSave(BaseUser entity, boolean isNew) {
        String defaultPassword = this.baseParamService.getParamValue(SysEnumParams.SYS_DEF_PASSWORD.name());
        if (isNew) {
            return Result.OK("\u7528\u6237\u521b\u5efa\u5b8c\u6210,\u9ed8\u8ba4\u5bc6\u7801\u4e3a:" + defaultPassword);
        }
        return null;
    }

    public List<BaseUser> listByDeptId(String deptId) {
        QueryWrapper w = QueryWrapper.create().select(BaseUserTableDef.BASE_USER.ALL_COLUMNS, BaseDeptTableDef.BASE_DEPT.DEPT_CODE, BaseOrgTableDef.BASE_ORG.ORG_CODE).leftJoin((QueryTable)BaseDeptTableDef.BASE_DEPT).on(BaseUserTableDef.BASE_USER.DEPT_ID.eq((Object)BaseDeptTableDef.BASE_DEPT.DEPT_ID)).leftJoin((QueryTable)BaseOrgTableDef.BASE_ORG).on(BaseUserTableDef.BASE_USER.ORG_ID.eq((Object)BaseOrgTableDef.BASE_ORG.ORG_ID)).where(BaseUserTableDef.BASE_USER.ACCOUNT_STATUS.eq((Object)AccountStatus.NORMAL));
        if (StrUtil.isNotEmpty((CharSequence)deptId)) {
            w.and(BaseUserTableDef.BASE_USER.DEPT_ID.eq((Object)deptId));
        }
        return this.list(w);
    }

    public boolean resetPassword(String userId) {
        return ((UpdateChain)((UpdateChain)this.updateChain().set(BaseUserTableDef.BASE_USER.CREDENTIAL, (Object)CryptoUtil.encryptPassword(this.baseParamService.getParamValue(SysEnumParams.SYS_DEF_PASSWORD.name())))).where(BaseUserTableDef.BASE_USER.USER_ID.eq((Object)userId))).update();
    }

    public Result updatePassword(String userId, String oldPwd, String newPwd) throws Exception {
        BaseUser baseUser = (BaseUser)this.getById((Serializable)((Object)userId));
        if (CryptoUtil.encryptPassword(oldPwd).equals(baseUser.getCredential())) {
            this.resetPassword(userId, newPwd);
            return Result.OK("\u6210\u529f\u4fee\u6539\u5bc6\u7801,\u8bf7\u91cd\u65b0\u767b\u5f55\uff01");
        }
        return Result.ERROR("\u539f\u5bc6\u7801\u8f93\u5165\u9519\u8bef\uff01");
    }

    public void resetPassword(String id, String password) throws Exception {
        BaseUser baseUser = (BaseUser)this.getById((Serializable)((Object)id));
        if (baseUser == null) {
            throw new Exception("\u8be5\u7528\u6237\u4e0d\u5b58\u5728");
        }
        ((UpdateChain)((UpdateChain)this.updateChain().set(BaseUserTableDef.BASE_USER.CREDENTIAL, (Object)CryptoUtil.encryptPassword(password))).where(BaseUserTableDef.BASE_USER.USER_ID.eq((Object)id))).update();
    }
}

