/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.config.mvc.resolver.PageRequest;
import com.kdgcsoft.web.config.security.SecurityUtil;
import com.kdgcsoft.web.core.entity.BaseRole;
import com.kdgcsoft.web.core.entity.BaseRoleUser;
import com.kdgcsoft.web.core.entity.table.BaseRoleTableDef;
import com.kdgcsoft.web.core.entity.table.BaseRoleUserTableDef;
import com.kdgcsoft.web.core.entity.table.BaseUserTableDef;
import com.kdgcsoft.web.core.enums.RoleType;
import com.kdgcsoft.web.core.mapper.BaseRoleMapper;
import com.kdgcsoft.web.core.service.BaseOrgService;
import com.kdgcsoft.web.core.service.BaseRoleUserService;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.DistinctQueryColumn;
import com.mybatisflex.core.query.If;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.spring.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BaseRoleService
extends ServiceImpl<BaseRoleMapper, BaseRole> {
    public static final String CACHE_NAME = "BaseRole";
    @Autowired
    BaseOrgService orgService;
    @Resource
    BaseRoleUserService baseRoleUserService;

    public Page<BaseRole> pageRole(PageRequest<BaseRole> page, String orgId, String roleName) {
        List<Object> orgIds = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)orgId)) {
            orgIds = this.orgService.getChildIds(orgId, true);
        }
        QueryWrapper queryWrapper = QueryWrapper.create().where(BaseRoleTableDef.BASE_ROLE.ORG_ID.in(orgIds, CollUtil::isNotEmpty)).and(BaseRoleTableDef.BASE_ROLE.ROLE_NAME.like((Object)roleName, If::hasText)).orderBy(BaseRoleTableDef.BASE_ROLE.ORDER_NO.asc());
        return ((BaseRoleMapper)this.getMapper()).paginate(page, queryWrapper);
    }

    public boolean loginUserRoleTypeIsAdmin() {
        String userId = SecurityUtil.getUserId();
        if (StrUtil.isEmpty((CharSequence)userId)) {
            return false;
        }
        QueryWrapper queryWrapper = QueryWrapper.create().select(BaseRoleUserTableDef.BASE_ROLE_USER.ROLE_ID).from(new QueryTable[]{BaseRoleUserTableDef.BASE_ROLE_USER}).where(BaseRoleUserTableDef.BASE_ROLE_USER.USER_ID.eq((Object)userId));
        List roles = this.baseRoleUserService.list(queryWrapper).stream().map(BaseRoleUser::getRoleId).collect(Collectors.toList());
        if (CollUtil.isEmpty(roles)) {
            return false;
        }
        QueryWrapper queryWrapper2 = QueryWrapper.create().select(BaseRoleTableDef.BASE_ROLE.ALL_COLUMNS).from(new QueryTable[]{BaseRoleTableDef.BASE_ROLE}).where(BaseRoleTableDef.BASE_ROLE.ROLE_ID.in(roles));
        return this.list(queryWrapper2).stream().anyMatch(role -> role.getRoleType() == RoleType.ADMIN);
    }

    public List<String> getUserIdsWhenRoleTypeIsAdmin() {
        QueryWrapper queryWrapper = QueryWrapper.create().select(BaseRoleTableDef.BASE_ROLE.ROLE_ID).from(new QueryTable[]{BaseRoleTableDef.BASE_ROLE}).where(BaseRoleTableDef.BASE_ROLE.ROLE_TYPE.eq((Object)RoleType.ADMIN));
        QueryWrapper queryWrapper1 = QueryWrapper.create().select(BaseUserTableDef.BASE_USER.USER_ID).from(new QueryTable[]{BaseUserTableDef.BASE_USER});
        DistinctQueryColumn queryColumn = new DistinctQueryColumn(new QueryColumn[]{BaseRoleUserTableDef.BASE_ROLE_USER.USER_ID});
        QueryWrapper queryWrapper2 = QueryWrapper.create().select(new QueryColumn[]{queryColumn}).from(new QueryTable[]{BaseRoleUserTableDef.BASE_ROLE_USER}).where(BaseRoleUserTableDef.BASE_ROLE_USER.ROLE_ID.in(queryWrapper).and(BaseRoleUserTableDef.BASE_ROLE_USER.USER_ID.in(queryWrapper1)));
        return this.baseRoleUserService.list(queryWrapper2).stream().map(BaseRoleUser::getUserId).distinct().collect(Collectors.toList());
    }
}

