/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.service;

import cn.hutool.core.collection.CollUtil;
import com.kdgcsoft.web.config.security.interfaces.AuthUser;
import com.kdgcsoft.web.core.entity.BaseMenu;
import com.kdgcsoft.web.core.entity.BaseMenuAuth;
import com.kdgcsoft.web.core.entity.BaseRoleAuth;
import com.kdgcsoft.web.core.entity.BaseRoleUser;
import com.kdgcsoft.web.core.entity.table.BaseMenuAuthTableDef;
import com.kdgcsoft.web.core.entity.table.BaseMenuTableDef;
import com.kdgcsoft.web.core.entity.table.BaseRoleAuthTableDef;
import com.kdgcsoft.web.core.entity.table.BaseRoleUserTableDef;
import com.kdgcsoft.web.core.enums.YesNo;
import com.kdgcsoft.web.core.mapper.BaseMenuMapper;
import com.kdgcsoft.web.core.pojo.BaseAuthTreeNode;
import com.kdgcsoft.web.core.util.TreeUtil;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.row.Db;
import com.mybatisflex.spring.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class BaseMenuService
extends ServiceImpl<BaseMenuMapper, BaseMenu> {
    public static final String CACHE_NAME = "BaseMenu";

    public List<BaseMenu> allMenuList() {
        return Db.selectListByQueryAs(BaseMenuTableDef.BASE_MENU.getTableName(), QueryWrapper.create().where(BaseMenuTableDef.BASE_MENU.ENABLED.eq((Object)YesNo.Y).and(BaseMenuTableDef.BASE_MENU.DELETED.eq((Object)0))).orderBy(BaseMenuTableDef.BASE_MENU.ORDER_NO.getName()), BaseMenu.class);
    }

    public List<BaseMenu> allMenuTree() {
        return TreeUtil.buildTree(this.allMenuList());
    }

    public List<BaseMenu> userMenuTree(AuthUser authUser) {
        List<BaseMenu> menus;
        if (AuthUser.AccountType.ROOT.equals((Object)authUser.getAccountType())) {
            menus = this.allMenuTree();
        } else {
            String loginUserId = authUser.getUserId();
            menus = TreeUtil.buildTree(this.getMenuListByLoginUserId(loginUserId));
        }
        return menus;
    }

    public List<BaseMenu> getMenuListByLoginUserId(String loginUserId) {
        List<BaseMenu> menuList = new ArrayList<BaseMenu>();
        List<BaseRoleUser> roleList = Db.selectListByQueryAs(BaseRoleUserTableDef.BASE_ROLE_USER.getTableName(), QueryWrapper.create().select(BaseRoleUserTableDef.BASE_ROLE_USER.ROLE_ID).where(BaseRoleUserTableDef.BASE_ROLE_USER.USER_ID.eq((Object)loginUserId)), BaseRoleUser.class);
        List roleIds = roleList.stream().map(BaseRoleUser::getRoleId).collect(Collectors.toList());
        if (CollUtil.isEmpty(roleIds)) {
            return menuList;
        }
        List<BaseRoleAuth> authList = Db.selectListByQueryAs(BaseRoleAuthTableDef.BASE_ROLE_AUTH.getTableName(), QueryWrapper.create().select(BaseRoleAuthTableDef.BASE_ROLE_AUTH.ALL_COLUMNS).where(BaseRoleAuthTableDef.BASE_ROLE_AUTH.ROLE_ID.in(roleIds)), BaseRoleAuth.class);
        List menuCodeList = authList.stream().map(BaseRoleAuth::getAuthCode).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(menuCodeList)) {
            menuList = Db.selectListByQueryAs(BaseMenuTableDef.BASE_MENU.getTableName(), QueryWrapper.create().select(BaseMenuTableDef.BASE_MENU.ALL_COLUMNS).where(BaseMenuTableDef.BASE_MENU.DELETED.eq((Object)0)).and(BaseMenuTableDef.BASE_MENU.ENABLED.eq((Object)YesNo.Y)).and(BaseMenuTableDef.BASE_MENU.MENU_CODE.in(menuCodeList)).orderBy(BaseMenuTableDef.BASE_MENU.ORDER_NO.asc()), BaseMenu.class);
        }
        return menuList;
    }

    public List<BaseAuthTreeNode> treeWithAuth() {
        List<BaseMenu> menuList = Db.selectListByQueryAs(BaseMenuTableDef.BASE_MENU.getTableName(), QueryWrapper.create().select(BaseMenuTableDef.BASE_MENU.ALL_COLUMNS).where(BaseMenuTableDef.BASE_MENU.DELETED.eq((Object)0)).and(BaseMenuTableDef.BASE_MENU.ENABLED.eq((Object)YesNo.Y)).orderBy(BaseMenuTableDef.BASE_MENU.ORDER_NO.getName()), BaseMenu.class);
        List<BaseMenuAuth> menuAuthList = Db.selectListByQueryAs(BaseMenuAuthTableDef.BASE_MENU_AUTH.getTableName(), QueryWrapper.create().select(BaseMenuAuthTableDef.BASE_MENU_AUTH.ALL_COLUMNS).where(BaseMenuAuthTableDef.BASE_MENU_AUTH.DELETED.eq((Object)0)).and(BaseMenuAuthTableDef.BASE_MENU_AUTH.ENABLED.eq((Object)YesNo.Y)).orderBy(BaseMenuAuthTableDef.BASE_MENU_AUTH.ORDER_NO.getName()), BaseMenuAuth.class);
        return BaseAuthTreeNode.treeMenuAuth(menuList, menuAuthList);
    }

    public List<BaseMenu> listInIds(List<String> menuIds) {
        return Db.selectListByQueryAs(BaseMenuTableDef.BASE_MENU.getTableName(), QueryWrapper.create().select(BaseMenuTableDef.BASE_MENU.ALL_COLUMNS).where(BaseMenuTableDef.BASE_MENU.DELETED.eq((Object)0)).and(BaseMenuTableDef.BASE_MENU.ENABLED.eq((Object)YesNo.Y)).and(BaseMenuTableDef.BASE_MENU.MENU_ID.in(menuIds)).orderBy(BaseMenuTableDef.BASE_MENU.ORDER_NO.getName()), BaseMenu.class);
    }
}

