/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.kdgcsoft.web.core.pojo.CacheTreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.cache.concurrent.ConcurrentMapCache;
import org.springframework.stereotype.Service;

@Service
public class BaseCacheMonitorService {
    @Resource
    private CacheManager cacheManager;

    public List<CacheTreeNode> treeCache() {
        ArrayList<CacheTreeNode> cacheList = new ArrayList<CacheTreeNode>();
        this.cacheManager.getCacheNames().forEach(cacheName -> {
            CacheTreeNode node = CacheTreeNode.of(IdUtil.fastSimpleUUID(), cacheName, null);
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache instanceof ConcurrentMapCache) {
                ConcurrentMapCache mapCache = (ConcurrentMapCache)cache;
                mapCache.getNativeCache().keySet().forEach(key -> {
                    String cacheKey = key.toString();
                    node.addChild(CacheTreeNode.of(IdUtil.fastSimpleUUID(), cacheName, cacheKey));
                });
            } else if (cache instanceof CaffeineCache) {
                CaffeineCache caffeineCache = (CaffeineCache)cache;
                caffeineCache.getNativeCache().asMap().keySet().forEach(key -> {
                    String cacheKey = key.toString();
                    node.addChild(CacheTreeNode.of(IdUtil.fastSimpleUUID(), cacheName, cacheKey));
                });
            } else {
                node.addChild(CacheTreeNode.of(IdUtil.fastSimpleUUID(), cacheName, "\u6682\u4e0d\u652f\u6301\u7684\u7f13\u5b58\u7c7b\u578b"));
            }
            if (CollUtil.isNotEmpty(node.getChildren())) {
                cacheList.add(node);
            }
        });
        return cacheList;
    }

    public Object getCacheInfo(String cacheName, String cacheKey) {
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache == null || cacheKey == null) {
            return null;
        }
        Cache.ValueWrapper wrapper = cache.get((Object)cacheKey);
        if (wrapper == null) {
            throw new RuntimeException("\u7f13\u5b58key\u4e0d\u5b58\u5728\uff01\u8bf7\u5237\u65b0\u7f13\u5b58\u5217\u8868\uff01");
        }
        Object o = wrapper.get();
        if (o instanceof List) {
            if (((List)o).isEmpty() || ClassUtil.isSimpleTypeOrArray(o.getClass())) {
                return o;
            }
            return ((List)o).stream().map(item -> JSON.toJSONString((Object)item, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.ReferenceDetection})).map(JSONObject::new).collect(Collectors.toList());
        }
        if (o == null || ClassUtil.isSimpleValueType(o.getClass())) {
            return o;
        }
        String jsonString = JSON.toJSONString((Object)o, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.ReferenceDetection});
        return new JSONObject((Object)jsonString);
    }

    public void clearCache(String cacheName, String cacheKey) {
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache != null) {
            if (StrUtil.isNotBlank((CharSequence)cacheKey)) {
                cache.evict((Object)cacheKey);
            } else {
                cache.clear();
            }
        } else {
            throw new RuntimeException("\u6e05\u9664\u7f13\u5b58\u5931\u8d25\uff01\u8bf7\u5237\u65b0\u7f13\u5b58\u5217\u8868\uff01");
        }
    }

    public void clearAllCache() {
        this.cacheManager.getCacheNames().forEach(name -> {
            Cache cache = this.cacheManager.getCache(name);
            if (cache != null) {
                cache.clear();
            }
        });
    }
}

