/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.pojo;

import com.kdgcsoft.web.core.entity.BaseMenu;
import com.kdgcsoft.web.core.entity.BaseMenuAuth;
import com.kdgcsoft.web.core.enums.AuthType;
import com.kdgcsoft.web.core.enums.MenuType;
import com.kdgcsoft.web.core.interfaces.ITreeNode;
import com.kdgcsoft.web.core.util.TreeUtil;
import java.util.ArrayList;
import java.util.List;

public class BaseAuthTreeNode
implements ITreeNode<BaseAuthTreeNode, String> {
    private String id;
    private String pid;
    private String authName;
    private String authType;
    private String authCode;
    private List<BaseAuthTreeNode> children = new ArrayList<BaseAuthTreeNode>();

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String pid() {
        return this.pid;
    }

    @Override
    public List<BaseAuthTreeNode> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<BaseAuthTreeNode>();
        }
        return this.children;
    }

    public BaseAuthTreeNode() {
    }

    public BaseAuthTreeNode(String authName, String authType, String authCode) {
        this.authName = authName;
        this.authType = authType;
        this.authCode = authCode;
    }

    public static List<BaseAuthTreeNode> treeMenuAuth(List<BaseMenu> menuList, List<BaseMenuAuth> menuAuthList) {
        ArrayList authTreeNodes = new ArrayList();
        menuList.forEach(menu -> {
            BaseAuthTreeNode authTreeNode = new BaseAuthTreeNode();
            authTreeNode.setId(menu.getMenuId());
            authTreeNode.setPid(menu.getMenuPid());
            authTreeNode.setAuthName(menu.getMenuName());
            authTreeNode.setAuthType(MenuType.MENU.name());
            authTreeNode.setAuthCode(menu.getMenuCode());
            authTreeNodes.add(authTreeNode);
        });
        ArrayList ids = new ArrayList();
        menuAuthList.forEach(menuAuth -> {
            BaseAuthTreeNode authTreeNode = new BaseAuthTreeNode();
            BaseAuthTreeNode virtually = new BaseAuthTreeNode();
            String menuId = menuAuth.getMenuId();
            String virtuallyId = "VIRTUALLY" + menuId;
            if (!ids.contains(virtuallyId)) {
                ids.add(virtuallyId);
                virtually.setId(virtuallyId);
                virtually.setPid(menuId);
                virtually.setAuthName("\u7cfb\u7edf\u6743\u9650");
                virtually.setAuthType(AuthType.VIRTUALLY.name());
                virtually.setAuthCode("VIRTUALLY");
                authTreeNodes.add(virtually);
            }
            authTreeNode.setId(menuAuth.getAuthId());
            authTreeNode.setPid(virtuallyId);
            authTreeNode.setAuthName(menuAuth.getAuthName());
            authTreeNode.setAuthType(AuthType.BUTTON.name());
            authTreeNode.setAuthCode(menuAuth.getAuthCode());
            authTreeNodes.add(authTreeNode);
        });
        return TreeUtil.buildTree(authTreeNodes, false);
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public void setAuthName(String authName) {
        this.authName = authName;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public void setChildren(List<BaseAuthTreeNode> children) {
        this.children = children;
    }

    public String getId() {
        return this.id;
    }

    public String getPid() {
        return this.pid;
    }

    public String getAuthName() {
        return this.authName;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getAuthCode() {
        return this.authCode;
    }
}

