/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.exception;

import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.core.enums.ErrorLevel;

public class BusinessException
extends RuntimeException {
    private ErrorLevel errorLevel;
    private Object data;

    public BusinessException(String message, Object ... params) {
        super(StrUtil.format((CharSequence)message, (Object[])params));
        this.errorLevel = ErrorLevel.ERROR;
    }

    public BusinessException(String message, Throwable cause, Object ... params) {
        super(StrUtil.format((CharSequence)message, (Object[])params), cause);
        this.errorLevel = ErrorLevel.ERROR;
    }

    public BusinessException(ErrorLevel errorLevel, String message, Object ... params) {
        super(StrUtil.format((CharSequence)message, (Object[])params));
        this.errorLevel = errorLevel;
    }

    public BusinessException(ErrorLevel errorLevel, String message, Throwable cause, Object ... params) {
        super(StrUtil.format((CharSequence)message, (Object[])params), cause);
        this.errorLevel = errorLevel;
    }

    public static BusinessException INFO(String message, Object ... params) {
        return new BusinessException(ErrorLevel.INFO, message, params);
    }

    public static BusinessException ERROR(String message, Object ... params) {
        return new BusinessException(ErrorLevel.ERROR, message, params);
    }

    public static BusinessException CONFIRM(String message, Object ... params) {
        return new BusinessException(ErrorLevel.CONFIRM, message, params);
    }

    public static BusinessException WARN(String message, Object ... params) {
        return new BusinessException(ErrorLevel.WARN, message, params);
    }

    public ErrorLevel getErrorLevel() {
        return this.errorLevel;
    }

    public Object getData() {
        return this.data;
    }

    public BusinessException setErrorLevel(ErrorLevel errorLevel) {
        this.errorLevel = errorLevel;
        return this;
    }

    public BusinessException setData(Object data) {
        this.data = data;
        return this;
    }
}

