/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.fhs.core.trans.anno.Trans;
import com.kdgcsoft.web.core.anno.EnumParam;
import com.kdgcsoft.web.core.anno.EnumParamGroup;
import com.kdgcsoft.web.core.entity.base.AuditEntity;
import com.kdgcsoft.web.core.enums.ParamGroupType;
import com.kdgcsoft.web.core.enums.ParamType;
import com.kdgcsoft.web.core.enums.YesNo;
import com.mybatisflex.annotation.Column;
import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.Table;
import com.mybatisflex.core.handler.Fastjson2TypeHandler;

@Table(value="base_param")
public class BaseParam
extends AuditEntity {
    @Id
    private String id;
    private String paramCode;
    private String paramName;
    private String groupName;
    private ParamGroupType groupType;
    private ParamType paramType;
    private YesNo authIgnore;
    @Trans(type="dictionary", key="YesNo")
    private YesNo embed;
    private String paramValue;
    private String defValue;
    @Column(typeHandler=Fastjson2TypeHandler.class)
    private JSONArray paramOptions;
    private String description;
    private Integer orderNo;

    public static BaseParam buildByAnno(EnumParamGroup group, EnumParam param, String code) {
        return new BaseParam().setGroupName(group.name()).setGroupType(group.group()).setOrderNo(group.order()).setEmbed(YesNo.Y).setParamCode(code).setParamName(param.label()).setParamType(param.type()).setAuthIgnore(param.authIgnore() ? YesNo.Y : YesNo.N).setDefValue(param.defValue()).setParamOptions(JSON.parseArray((String)param.options())).setDescription(param.description());
    }

    public boolean equalToScanned(BaseParam scanParam) {
        return ObjectUtil.equals((Object)this.paramCode, (Object)scanParam.getParamCode()) && ObjectUtil.equals((Object)this.paramName, (Object)scanParam.getParamName()) && ObjectUtil.equals((Object)((Object)this.groupType), (Object)((Object)scanParam.getGroupType())) && ObjectUtil.equals((Object)this.groupName, (Object)scanParam.getGroupName()) && ObjectUtil.equals((Object)this.defValue, (Object)scanParam.getDefValue()) && ObjectUtil.equals((Object)((Object)this.paramType), (Object)((Object)scanParam.getParamType())) && ObjectUtil.equals((Object)this.paramOptions, (Object)scanParam.getParamOptions()) && ObjectUtil.equals((Object)((Object)this.authIgnore), (Object)((Object)scanParam.getAuthIgnore())) && ObjectUtil.equals((Object)this.description, (Object)scanParam.getDescription());
    }

    public void updateByScanned(BaseParam scanParam) {
        BeanUtil.copyProperties((Object)scanParam, (Object)this, (String[])new String[]{"id", "paramValue"});
    }

    public String getId() {
        return this.id;
    }

    public String getParamCode() {
        return this.paramCode;
    }

    public String getParamName() {
        return this.paramName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public ParamGroupType getGroupType() {
        return this.groupType;
    }

    public ParamType getParamType() {
        return this.paramType;
    }

    public YesNo getAuthIgnore() {
        return this.authIgnore;
    }

    public YesNo getEmbed() {
        return this.embed;
    }

    public String getParamValue() {
        return this.paramValue;
    }

    public String getDefValue() {
        return this.defValue;
    }

    public JSONArray getParamOptions() {
        return this.paramOptions;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getOrderNo() {
        return this.orderNo;
    }

    public BaseParam setId(String id) {
        this.id = id;
        return this;
    }

    public BaseParam setParamCode(String paramCode) {
        this.paramCode = paramCode;
        return this;
    }

    public BaseParam setParamName(String paramName) {
        this.paramName = paramName;
        return this;
    }

    public BaseParam setGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public BaseParam setGroupType(ParamGroupType groupType) {
        this.groupType = groupType;
        return this;
    }

    public BaseParam setParamType(ParamType paramType) {
        this.paramType = paramType;
        return this;
    }

    public BaseParam setAuthIgnore(YesNo authIgnore) {
        this.authIgnore = authIgnore;
        return this;
    }

    public BaseParam setEmbed(YesNo embed) {
        this.embed = embed;
        return this;
    }

    public BaseParam setParamValue(String paramValue) {
        this.paramValue = paramValue;
        return this;
    }

    public BaseParam setDefValue(String defValue) {
        this.defValue = defValue;
        return this;
    }

    public BaseParam setParamOptions(JSONArray paramOptions) {
        this.paramOptions = paramOptions;
        return this;
    }

    public BaseParam setDescription(String description) {
        this.description = description;
        return this;
    }

    public BaseParam setOrderNo(Integer orderNo) {
        this.orderNo = orderNo;
        return this;
    }

    public static final class Fields {
        public static final String id = "id";
        public static final String paramCode = "paramCode";
        public static final String paramName = "paramName";
        public static final String groupName = "groupName";
        public static final String groupType = "groupType";
        public static final String paramType = "paramType";
        public static final String authIgnore = "authIgnore";
        public static final String embed = "embed";
        public static final String paramValue = "paramValue";
        public static final String defValue = "defValue";
        public static final String paramOptions = "paramOptions";
        public static final String description = "description";
        public static final String orderNo = "orderNo";
    }
}

